/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.lqpt;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import org.apache.commons.lang3.StringUtils;

public class SimLqptSummaryTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(SimLqptSummaryTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int dayOfMonth;
        String summaryDay;
        DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "number", "enterpriserole"), (QFilter[])new QFilter("issuechannel", "in", (Object)EnterPriseBaseInfoConstant.LQPT_CHANNEL).toArray());
        if (epInfos.length == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("\u672a\u67e5\u8be2\u5230\u5f00\u7968\u901a\u9053\u4e3a\u4e50\u4f01\u7684\u4f01\u4e1a\uff0c\u65e0\u9700\u6c47\u603b\u8ba1\u7b97");
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("\u5f00\u59cb\u6267\u884c\u4e50\u4f01\u6c47\u603b\u5b9a\u65f6\u4efb\u52a1");
        }
        Date today = StringUtils.isNotBlank((CharSequence)(summaryDay = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"summary_day"))) ? DateUtils.handleDate((String)summaryDay) : new Date();
        logger.info(String.format("\u5f00\u59cb\u67e5\u8be2%s\u7684\u6c47\u603b\u6570\u636e", DateUtils.format((Date)today, (String)"yyyy-MM")));
        Date firstDayOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.addDay((Date)today, (int)-1));
        QFilter summaryQfilter = new QFilter("issuetime", ">=", (Object)firstDayOfMonth).and("issuetime", "<", (Object)DateUtils.trunc((Date)today)).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode()).and("issuesource", "=", (Object)"13");
        String selectField = String.join((CharSequence)",", "invoiceamount", "totaltax");
        HashMap<Object, DynamicObject> summaryMap = new HashMap<Object, DynamicObject>(epInfos.length);
        for (DynamicObject epInfo : epInfos) {
            DynamicObject org;
            String taxNo = epInfo.getString("number");
            QFilter qFilter = new QFilter("epinfo", "=", epInfo.getPkValue()).and("summarymonth", ">=", (Object)firstDayOfMonth).and("summarymonth", "<", (Object)DateUtils.trunc((Date)today)).and("summarystatus", "=", (Object)"1");
            if (QueryServiceHelper.exists((String)"sim_lqpt_summary", (QFilter[])qFilter.toArray())) {
                logger.info(String.format("\u7a0e\u53f7%s\u5b58\u5728\u5df2\u786e\u8ba4\u7684\u6c47\u603b\u6570\u636e", epInfo.getString("number")));
                continue;
            }
            try {
                org = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
            }
            catch (Exception e) {
                logger.info(String.format("\u7a0e\u53f7%s\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u4fe1\u606f\uff0c\u9519\u8bef\u4fe1\u606f[%s]", epInfo.getString("number"), e.getMessage()));
                continue;
            }
            qFilter = new QFilter("salertaxno", "=", (Object)taxNo).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(SimLqptSummaryTask.class + taxNo), (String)"sim_vatinvoice", (String)selectField, (QFilter[])new QFilter[]{qFilter, summaryQfilter}, null);){
                int blueNum = 0;
                int redNum = 0;
                BigDecimal blueAmount = BigDecimal.ZERO;
                BigDecimal blueTax = BigDecimal.ZERO;
                BigDecimal redAmount = BigDecimal.ZERO;
                BigDecimal redTax = BigDecimal.ZERO;
                if (!dataSet.isEmpty()) {
                    for (Row row : dataSet) {
                        BigDecimal invoiceAmount = row.getBigDecimal("invoiceamount").setScale(2, 4);
                        BigDecimal totalTax = row.getBigDecimal("totaltax").setScale(2, 4);
                        if (invoiceAmount.compareTo(BigDecimal.ZERO) > 0) {
                            ++blueNum;
                            blueAmount = blueAmount.add(invoiceAmount);
                            blueTax = blueTax.add(totalTax);
                            continue;
                        }
                        ++redNum;
                        redAmount = redAmount.add(invoiceAmount);
                        redTax = redTax.add(totalTax);
                    }
                }
                DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)"sim_lqpt_summary");
                summary.set("epinfo", epInfo.getPkValue());
                summary.set("summarymonth", (Object)firstDayOfMonth);
                summary.set("org", org.getPkValue());
                summary.set("enterpriserole", (Object)epInfo.getString("enterpriserole"));
                summary.set("bluenum", (Object)blueNum);
                summary.set("blueamount", (Object)blueAmount);
                summary.set("bluetax", (Object)blueTax);
                summary.set("rednum", (Object)redNum);
                summary.set("redamount", (Object)redAmount);
                summary.set("redtax", (Object)redTax);
                summary.set("summarystatus", (Object)"0");
                summaryMap.put(epInfo.getPkValue(), summary);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("\u4e50\u4f01\u6c47\u603b\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff0c\u7edf\u8ba1\u4f01\u4e1a\u6570\u91cf:" + summaryMap.size());
        }
        if (!summaryMap.isEmpty()) {
            QFilter qFilter = new QFilter("summarymonth", ">=", (Object)firstDayOfMonth).and("summarymonth", "<", (Object)DateUtils.trunc((Date)today)).and("epinfo", "in", summaryMap.keySet()).and("summarystatus", "!=", (Object)"1");
            DeleteServiceHelper.delete((String)"sim_lqpt_summary", (QFilter[])qFilter.toArray());
            ImcSaveServiceHelper.save((DynamicObject[])summaryMap.values().toArray(new DynamicObject[0]));
        }
        if ((dayOfMonth = LocalDate.now().getDayOfMonth()) < 13) {
            Date preMonth = DateUtils.addMonth((Date)new Date(), (int)-1);
            Date preMonthFirstDay = DateUtils.getFirstDateOfMonth((Date)preMonth);
            Date preMonthLastDay = DateUtils.getLastDateOfMonth((Date)preMonth);
            QFilter qFilter = new QFilter("summarymonth", ">=", (Object)preMonthFirstDay).and("summarymonth", "<", (Object)preMonthLastDay).and("summarystatus", "!=", (Object)"1");
            DynamicObject[] summaryArr = BusinessDataServiceHelper.load((String)"sim_lqpt_summary", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_lqpt_summary"), (QFilter[])qFilter.toArray());
            OperationServiceHelper.executeOperate((String)"summary_confirm", (String)"sim_lqpt_summary", (DynamicObject[])summaryArr, null);
        }
    }
}

