/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.utils.DateUtils;
import kd.imc.sim.formplugin.issuing.dataimport.HistoryInvoiceDataImportService;
import kd.imc.sim.schedule.service.BusinessAutoHandle;

public class AbstractInvoiceSyncHandle
implements BusinessAutoHandle {
    private static final Log LOGGER = LogFactory.getLog(AbstractInvoiceSyncHandle.class);
    private static final String CACHE_KEY = "AbstractInvoiceSyncHandle:%s:%s";
    private static final String CONFIG_TYPE = "sim_his_inv_data_imp";
    private static final String CONFIG_KEY = "task_date";
    private static final int EXEC_DAY = 5;

    @Override
    public boolean supportTask(DynamicObject autoTaskObj) {
        return false;
    }

    @Override
    public void handleTask(DynamicObject autoTaskObj) {
    }

    protected boolean checkData(DynamicObject autoTaskObj) {
        String taskDateStr = ImcConfigUtil.getValue((String)CONFIG_TYPE, (String)CONFIG_KEY);
        int taskDate = 5;
        if (StringUtils.isNotEmpty((CharSequence)taskDateStr)) {
            taskDate = Integer.parseInt(taskDateStr);
        }
        if (!this.checkTaskDate(taskDate)) {
            LOGGER.info("AbstractInvoiceSyncHandle \u672a\u5230\u6267\u884c\u4efb\u52a1\u7684\u65e5\u671f\uff0c\u8df3\u8fc7");
            return Boolean.FALSE;
        }
        String orgId = autoTaskObj.getDynamicObject("org").getString("id");
        String taskType = autoTaskObj.getString("type");
        return this.checkRepeatTask(orgId, taskType);
    }

    private boolean checkTaskDate(int day) {
        LocalDate now = LocalDate.now();
        return now.getDayOfMonth() == day;
    }

    private boolean checkRepeatTask(String orgId, String taskType) {
        String cacheKey = String.format(CACHE_KEY, taskType, orgId);
        if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)cacheKey))) {
            LOGGER.info("AbstractInvoiceSyncHandle is Running,this task is stopped:{}", (Object)cacheKey);
            return Boolean.FALSE;
        }
        CacheHelper.put((String)cacheKey, (String)"id", (int)3600);
        return Boolean.TRUE;
    }

    protected void saveImportTaskData(DynamicObject autoTaskObj, String dataType) {
        DynamicObject orgInfo = BusinessDataServiceHelper.loadSingle((Object)autoTaskObj.getDynamicObject("org").getPkValue(), (String)"bdm_org");
        DynamicObject epInfo = orgInfo.getDynamicObject("epinfo");
        if (epInfo == null) {
            LOGGER.info("AbstractInvoiceSyncHandle \u901a\u8fc7\u7ec4\u7ec7:{}\u83b7\u53d6\u4f01\u4e1a\u4e3a\u7a7a\uff0c\u8df3\u8fc7", autoTaskObj.getDynamicObject("org").getPkValue());
            return;
        }
        epInfo = BusinessDataServiceHelper.loadSingle((Object)epInfo.getPkValue(), (String)"bdm_enterprise_baseinfo");
        String invoiceType = autoTaskObj.getString("invoicetype");
        List<String> dateRangeList = Collections.singletonList(DateUtils.getLastMonth());
        String issueChannel = epInfo.getString("issuechannel");
        boolean rpaChannel = "0".equals(issueChannel);
        String downloadChannel = rpaChannel ? "2" : "1";
        DynamicObject historyImportTaskData = HistoryInvoiceDataImportService.getHistoryImportTaskData((DynamicObject)epInfo, (String)dataType, (String)invoiceType, (String)downloadChannel, null, dateRangeList);
        historyImportTaskData.set("org", (Object)orgInfo);
        ImcSaveServiceHelper.save((DynamicObject)historyImportTaskData);
    }
}

