/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.schedule.service.BusinessAutoHandle;

public class AbstractRedConfirmBillHandle
implements BusinessAutoHandle {
    private static final Log LOGGER = LogFactory.getLog(AbstractRedConfirmBillHandle.class);
    private Set<Long> allEleOrgs = new HashSet<Long>();
    private static final String[] issueChannelArray = new String[]{"0", "2", "1"};

    @Override
    public boolean supportTask(DynamicObject autoTaskObj) {
        return false;
    }

    @Override
    public void handleTask(DynamicObject autoTaskObj) {
    }

    private void initAllEleOrgs() {
        DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"id", null);
        Set epPks = Arrays.stream(epInfos).map(o -> o.getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("authstate", "=", (Object)"1").and("epinfo", "in", epPks).and("servergroup", "=", (Object)"0");
        DynamicObject[] permissions = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)"epinfo", (QFilter[])filter.toArray());
        epPks = Arrays.stream(permissions).map(o -> DynamicObjectUtil.getDynamicObjectLongValue((Object)o.getDynamicObject("epinfo"))).collect(Collectors.toSet());
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])new QFilter("epinfo", "in", epPks).toArray());
        Set allEleOrgPks = Arrays.stream(orgs).map(o -> o.getLong("id")).collect(Collectors.toSet());
        this.allEleOrgs.addAll(allEleOrgPks);
    }

    protected List<Long> filterAllEleOrgs(Set<Long> orgPks, DynamicObject autoTaskObj) {
        if (this.allEleOrgs.size() == 0) {
            this.initAllEleOrgs();
        }
        if (null == orgPks) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (Long allEleOrg : this.allEleOrgs) {
                QFilter filter = ImcBaseDataHelper.getAutoTaskFilter((Object)allEleOrg).and("id", "=", (Object)autoTaskObj.getLong("id"));
                if (!QueryServiceHelper.exists((String)"bdm_auto_task", (QFilter[])filter.toArray())) continue;
                list.add(allEleOrg);
            }
            return list;
        }
        if (this.allEleOrgs.size() > 0) {
            return orgPks.stream().filter(o -> this.allEleOrgs.contains(o)).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    protected Set<Long> getUsedOrgSet(DynamicObject autoTaskObj) {
        List<Long> usedOrgs = this.getUsedOrgs(autoTaskObj);
        if (null == usedOrgs) {
            return null;
        }
        return new HashSet<Long>(usedOrgs);
    }

    protected List<Long> getUsedOrgs(DynamicObject autoTaskObj) {
        try {
            HashSet<Long> orgIdSet = new HashSet<Long>();
            orgIdSet.add(autoTaskObj.getDynamicObject("org").getLong("id"));
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(autoTaskObj.getLong("id"));
            try {
                String strategy = autoTaskObj.getString("ctrlstrategy");
                if ("5".equals(strategy)) {
                    if (this.allEleOrgs.size() == 0) {
                        this.initAllEleOrgs();
                    }
                    list.addAll(this.allEleOrgs);
                    LOGGER.info("fromAllOrg");
                    return list;
                }
                if ("7".equals(strategy)) {
                    LOGGER.info("fromPrivateOrg");
                    return new ArrayList<Long>(orgIdSet);
                }
                if ("6".equals(strategy)) {
                    // empty if block
                }
                LOGGER.info("fromOtherOrg");
                AssignQueryResponse assignQueryResponse = BaseDataServiceHelper.assignQueryByData(list, (String)"bdm_auto_task", (Long)autoTaskObj.getDynamicObject("org").getLong("id"), (String)"sim");
                String errorMsg = assignQueryResponse.getErrorMsg();
                if ("\u624b\u5de5\u5904\u7406".equals(errorMsg)) {
                    return new ArrayList<Long>(orgIdSet);
                }
                if (assignQueryResponse.getData() == null) {
                    return new ArrayList<Long>(orgIdSet);
                }
                List orgPks = (List)assignQueryResponse.getData().get(autoTaskObj.getLong("id"));
                if (null == orgPks) {
                    return new ArrayList<Long>(orgIdSet);
                }
                Collections.addAll(orgIdSet, orgPks.toArray(new Long[0]));
                return new ArrayList<Long>(orgIdSet);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return new ArrayList<Long>(orgIdSet);
            }
        }
        catch (Throwable t) {
            LOGGER.info("getUsedOrgs" + t.getMessage(), (Object)t);
            return null;
        }
    }

    protected Date getStartTime(String timePeriod) {
        Calendar calendar = Calendar.getInstance();
        if ("0".equals(timePeriod)) {
            calendar.add(2, -1);
        } else if ("1".equals(timePeriod)) {
            calendar.add(2, -3);
        } else if ("2".equals(timePeriod)) {
            calendar.add(2, -6);
        } else if ("7".equals(timePeriod)) {
            calendar.add(10, -24);
        } else if ("8".equals(timePeriod)) {
            calendar.add(10, -48);
        } else {
            calendar.add(10, -72);
        }
        return calendar.getTime();
    }

    protected HashSet<Long> getLongs(List<Long> orgPks) {
        HashSet<Long> orgSet = null == orgPks ? null : new HashSet<Long>(orgPks);
        return orgSet;
    }
}

