/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadResponseDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmItemDownLoadRequestDTO;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.schedule.service.AbstractRedConfirmBillHandle;

public class RedConfirmBillUpdateImpl
extends AbstractRedConfirmBillHandle {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillUpdateImpl.class);

    @Override
    public boolean supportTask(DynamicObject autoTaskObj) {
        return "1".equals(autoTaskObj.getString("type"));
    }

    @Override
    public void handleTask(DynamicObject autoTaskObj) {
        String timePeriod = autoTaskObj.getString("timeperiod");
        Date timeStart = this.getStartTime(timePeriod);
        String taskNos = autoTaskObj.getString("taxnos");
        String[] taxNoArray = taskNos.split(",");
        taxNoArray = Arrays.stream(taxNoArray).filter(StringUtils::isNotBlank).collect(Collectors.toList()).toArray(new String[0]);
        List<Long> orgPks = this.getUsedOrgs(autoTaskObj);
        LOGGER.info("UpdateRedConfirmControlStrategyOrgs" + JSONObject.toJSONString(orgPks));
        HashSet<Long> orgSet = this.getLongs(orgPks);
        orgPks = this.filterAllEleOrgs(orgSet, autoTaskObj);
        LOGGER.info("UpdateRedConfirmOrgs:" + JSONObject.toJSONString(orgPks));
        Date now = new Date();
        for (Long orgPk : orgPks) {
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgPk);
            try {
                if (taxNoArray.length != 0) {
                    for (String s : taxNoArray) {
                        AllEleRedConfirmDownLoadRequestDTO request = this.getAllEleRedConfirmDownLoadRequestDTO(autoTaskObj, timeStart, now, orgPk, saleInfo, s);
                        this.downloadRedConfirmBill(request, saleInfo);
                    }
                    continue;
                }
                AllEleRedConfirmDownLoadRequestDTO request = this.getAllEleRedConfirmDownLoadRequestDTO(autoTaskObj, timeStart, now, orgPk, saleInfo, null);
                this.downloadRedConfirmBill(request, saleInfo);
            }
            catch (Exception e) {
                LOGGER.error("RedConfirmBillUpdateImplError:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private AllEleRedConfirmDownLoadRequestDTO getAllEleRedConfirmDownLoadRequestDTO(DynamicObject autoTaskObj, Date timeStart, Date now, Long orgPk, SaleInfo saleInfo, String s) {
        String account = AllEleAuthHelper.getEleAccount((String)saleInfo.getSaleTaxNo(), (boolean)true);
        AllEleRedConfirmDownLoadRequestDTO request = new AllEleRedConfirmDownLoadRequestDTO();
        request.setAccount(account);
        request.setIdentity(autoTaskObj.getString("appliertype"));
        request.setStartDate(DateUtils.format((Date)timeStart));
        request.setEndDate(DateUtils.format((Date)now));
        request.setOrgId(orgPk.longValue());
        request.setUpdateHead(Boolean.valueOf(true));
        request.setOtherSideTaxNo(s);
        request.setOtherSideName(null);
        return request;
    }

    private void downloadRedConfirmBill(AllEleRedConfirmDownLoadRequestDTO request, SaleInfo saleInfo) {
        int totalPage;
        request.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_QUERY.getRequestPath());
        request.setPageSize(50);
        boolean isLqpt = EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo());
        AllEleRedConfirmItemDownLoadRequestDTO itemRequest = new AllEleRedConfirmItemDownLoadRequestDTO();
        itemRequest.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_DETAIL_QUERY.getRequestPath());
        int pageNo = 1;
        ArrayList responseLists = new ArrayList();
        RedConfirmBillHelper updateRedConfirmService = new RedConfirmBillHelper();
        do {
            request.setPage(pageNo);
            AllEleResponseListDTO response = isLqpt ? RedConfirmBillHelper.downloadRedConfirmHeadFromLq((AllEleRedConfirmDownLoadRequestDTO)request, (SaleInfo)saleInfo) : AllEleServiceHelper.doPostList((String)saleInfo.getSaleTaxNo(), (AllEleRequestDTO)request, AllEleRedConfirmDownLoadResponseDTO.class);
            if (!response.getSuccess().booleanValue() && pageNo == 1) {
                return;
            }
            totalPage = (response.getTotalElement() + 50 - 1) / 50;
            List responseList = response.getData();
            this.addTempLog(responseList);
            if (CollectionUtils.isEmpty((Collection)responseList)) {
                return;
            }
            responseLists.addAll(response.getData());
            if (responseLists.size() < 500) continue;
            updateRedConfirmService.download(request, responseLists);
            responseLists.clear();
        } while (++pageNo <= totalPage);
        if (!responseLists.isEmpty()) {
            updateRedConfirmService.download(request, responseLists);
        }
    }

    private void addTempLog(List<AllEleRedConfirmDownLoadResponseDTO> responseList) {
        if (!"1".equals(ImcConfigUtil.getValue((String)"RedConfirmBillUpdateImpl", (String)"addTempLog"))) {
            return;
        }
        ArrayList<AllEleRedConfirmDownLoadResponseDTO> logList = new ArrayList<AllEleRedConfirmDownLoadResponseDTO>();
        for (AllEleRedConfirmDownLoadResponseDTO dto : responseList) {
            logList.add(dto);
            if (logList.size() <= 10) continue;
            this.addTempLoggs(logList);
            logList.clear();
        }
        if (logList.size() > 0) {
            this.addTempLoggs(logList);
        }
    }

    private void addTempLoggs(ArrayList<AllEleRedConfirmDownLoadResponseDTO> logList) {
        LOGGER.info(String.format("Temp10Logs:%s", JSONObject.toJSONString(logList)));
    }
}

