/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.bill.service;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.UpdateBillItemVo;
import kd.imc.bdm.common.dto.UpdateBillVo;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;

public class BillUpdateServiceImpl {
    private static Log LOGGER = LogFactory.getLog(BillUpdateServiceImpl.class);

    public JSONObject updateBills(String param) {
        List updateBillVos;
        LOGGER.info(String.format("BillUpdateServiceImplParam:%s", param));
        JSONObject result = new JSONObject();
        if (StringUtils.isBlank((CharSequence)param)) {
            result.put("errCode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("message", (Object)ErrorType.EMPTY_PARAM.getName());
            return result;
        }
        try {
            updateBillVos = JSONObject.parseArray((String)param, UpdateBillVo.class);
        }
        catch (Exception e) {
            result.put("errCode", (Object)ErrorType.FI_PARAM_ERROR.getCode());
            result.put("message", (Object)ErrorType.FI_PARAM_ERROR.getName());
            return result;
        }
        Set billPkSet = updateBillVos.stream().map(o -> o.getPk()).collect(Collectors.toSet());
        String fields = String.join((CharSequence)",", "pushamount", "unpushamount", "pushlocalamount", "unpushlocalamount", "sim_original_bill_item.pushamt", "sim_original_bill_item.unpushamt", "sim_original_bill_item.pushlocalamt", "sim_original_bill_item.unpushlocalamt", "sim_original_bill_item.pushnum", "sim_original_bill_item.unpushnum");
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)billPkSet.toArray()).toArray());
        if (bills.length == 0) {
            result.put("errCode", (Object)ErrorType.FI_QUEYR_NO_BILL.getCode());
            result.put("message", (Object)ErrorType.FI_QUEYR_NO_BILL.getName());
            return result;
        }
        if (bills.length != billPkSet.size()) {
            result.put("errCode", (Object)ErrorType.FI_QUERY_NUM_NOT_EQUALS.getCode());
            result.put("message", (Object)ErrorType.FI_QUERY_NUM_NOT_EQUALS.getName());
            return result;
        }
        HashMap<Object, DynamicObject> billPkMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> billItemPkMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject bill : bills) {
            billPkMap.put(bill.getPkValue(), bill);
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                billItemPkMap.put(item.getPkValue(), item);
            }
        }
        try {
            for (UpdateBillVo billVo : updateBillVos) {
                DynamicObject bill = (DynamicObject)billPkMap.get(billVo.getPk());
                if (null == bill) {
                    result.put("errCode", (Object)ErrorType.FI_BILL_PK_WITHOUT_BILL.getCode());
                    result.put("message", (Object)String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230pk\u4e3a%s\u7684\u5f00\u7968\u7533\u8bf7\u5355", (String)"BillUpdateServiceImpl_0", (String)"imc-sim-mservice", (Object[])new Object[0]), billVo.getPk()));
                    return result;
                }
                bill.set("pushamount", (Object)billVo.getPushAmount());
                bill.set("unpushamount", (Object)billVo.getUnPushAmount());
                bill.set("pushlocalamount", (Object)billVo.getPushLocalAmount());
                bill.set("unpushlocalamount", (Object)billVo.getUnPushLocalAmount());
                if (null == billVo.getItems()) {
                    result.put("errCode", (Object)ErrorType.FI_BILL_WITHOUT_BILL_ITEMS.getCode());
                    result.put("message", (Object)String.format(ResManager.loadKDString((String)"pk\u4e3a%s\u7684\u5f00\u7968\u7533\u8bf7\u5355\u6ca1\u6709\u660e\u7ec6\u4fe1\u606f", (String)"BillUpdateServiceImpl_1", (String)"imc-sim-mservice", (Object[])new Object[0]), billVo.getPk()));
                    return result;
                }
                for (UpdateBillItemVo itemVo : billVo.getItems()) {
                    DynamicObject item;
                    Long pk = itemVo.getPk();
                    item = (DynamicObject)billItemPkMap.get(pk);
                    if (null == item) {
                        result.put("errCode", (Object)ErrorType.FI_BILL_PK_WITHOUT_BILL_ENTRY.getCode());
                        result.put("message", (Object)String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230pk\u4e3a%s\u7684\u5f00\u7968\u7533\u8bf7\u5355\u660e\u7ec6", (String)"BillUpdateServiceImpl_2", (String)"imc-sim-mservice", (Object[])new Object[0]), pk));
                        return result;
                    }
                    item.set("pushamt", (Object)itemVo.getPushAmt());
                    item.set("unpushamt", (Object)itemVo.getUnPushAmt());
                    item.set("pushlocalamt", (Object)itemVo.getPushLocalAmt());
                    item.set("unpushlocalamt", (Object)itemVo.getUnPushLocalAmt());
                    item.set("pushnum", (Object)itemVo.getPushNum());
                    item.set("unpushnum", (Object)itemVo.getUnPushNum());
                }
            }
            ImcSaveServiceHelper.save((DynamicObject[])bills);
            result.put("errCode", (Object)ErrorType.SUCCESS.getCode());
            result.put("message", (Object)ErrorType.SUCCESS.getName());
        }
        catch (Exception e) {
            LOGGER.error(String.format("updateBillsError:%s", e.getMessage()), (Throwable)e);
            result.put("errCode", (Object)ErrorType.FAIL.getCode());
            result.put("message", (Object)ErrorType.FAIL.getName());
        }
        return result;
    }
}

