/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.bill.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;

public class OriginalBillServiceImpl {
    private static Log LOGGER = LogFactory.getLog(OriginalBillServiceImpl.class);
    private static String failedMessage = OriginalBillServiceImpl.failedMessage();

    private static String failedMessage() {
        return ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"OriginalBillServiceImpl_0", (String)"imc-sim-mservice", (Object[])new Object[0]);
    }

    public List<Map<String, Object>> getInvsByOriginalBillNo(Object[] originalBillNos) {
        DynamicObject[] originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"", (QFilter[])new QFilter("billno", "in", (Object)originalBillNos).toArray());
        if (originalBills.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        QFilter qFilter = new QFilter("tbillid", "in", Stream.of(originalBills).map(a -> Long.valueOf(String.valueOf(a))).toArray(Long[]::new)).and("isdelete", "!=", (Object)"Y");
        DynamicObject[] billInvRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])qFilter.toArray());
        Object[] vatInvoiceBillNos = Stream.of(billInvRelations).map(relation -> relation.getString("tbillno")).toArray();
        if (vatInvoiceBillNos.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        DynamicObject[] vatInvocies = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])new QFilter("billno", "in", (Object)vatInvoiceBillNos).toArray());
        return DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])vatInvocies, (boolean)false);
    }

    public JSONObject billIssuePush(List<String> billNos, Long orgId) {
        return this.billIssuePush(billNos, orgId, false, false);
    }

    public JSONObject billIssuePush(List<String> billNos, Long orgId, boolean mergeBill, boolean mergeBillDetail) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("OriginalBillServiceImpl billIssuePush billNos:%s orgId:%s", billNos, orgId));
        }
        JSONObject result = new JSONObject();
        DynamicObject[] bills = this.loadBill(billNos, orgId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("OriginalBillServiceImpl billIssuePush bills.size:%s", bills.length));
        }
        if (bills.length == 0) {
            result.put("message", (Object)ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f", (String)"OriginalBillServiceImpl_1", (String)"imc-sim-mservice", (Object[])new Object[0]));
            return result;
        }
        ArrayList verificationBills = Lists.newArrayList();
        JSONArray failedList = new JSONArray();
        HashSet<String> taxNoDevNoSet = new HashSet<String>();
        for (DynamicObject bill : bills) {
            String invoiceType = bill.getString("invoicetype");
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) continue;
            String deviceNo = bill.getString("jqbh");
            String terminalNo = bill.getString("terminalno");
            String taxNo = bill.getString("salertaxno");
            String divideNo = deviceNo + terminalNo + taxNo + invoiceType;
            if (taxNoDevNoSet.contains(divideNo)) continue;
            EquipmentHelper.checkTerminalNo((String)deviceNo, (String)taxNo, (String)terminalNo, (String)invoiceType);
            taxNoDevNoSet.add(divideNo);
        }
        for (DynamicObject bill : bills) {
            JSONObject temp = new JSONObject();
            if (!"0".equals(bill.getString("confirmstate"))) {
                temp.put("billno", (Object)bill.getString("billno"));
                temp.put("message", (Object)ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u53ea\u80fd\u63d0\u4ea4\u672a\u7533\u8bf7\u5355\u636e", (String)"OriginalBillServiceImpl_2", (String)"imc-sim-mservice", (Object[])new Object[0]));
                failedList.add((Object)temp);
                continue;
            }
            ApiResult apiResult = BillValidaterHelper.validBillInvoice((DynamicObject)bill, (boolean)false, (BillCheckProcessDto)new BillCheckProcessDto(Boolean.TRUE));
            if (!apiResult.getSuccess()) {
                temp.put("billno", (Object)bill.getString("billno"));
                temp.put("message", (Object)apiResult.getMessage());
                failedList.add((Object)temp);
                continue;
            }
            verificationBills.add(bill);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("billIssuePush verificationBills %s", SerializationUtils.toJsonString((Object)verificationBills)));
        }
        if (verificationBills.size() > 0) {
            DynamicObject[] billArr = verificationBills.toArray(new DynamicObject[0]);
            List<List<DynamicObject>> divideList = this.divideGroup(billArr);
            try {
                for (List<DynamicObject> list : divideList) {
                    DynamicObject[] billArray = list.toArray(new DynamicObject[0]);
                    DynamicObject bill = list.get(0);
                    String deviceNo = bill.getString("jqbh");
                    String terminalNo = bill.getString("terminalno");
                    this.issueInvoice(failedList, deviceNo, terminalNo, billArray, mergeBill, mergeBillDetail);
                }
            }
            catch (MsgException e) {
                LOGGER.error(String.format("\u5355\u636e\u7684\u660e\u7ec6\u5408\u5e76\u540e\u8d85\u8fc7\u7a0e\u63a7\u5141\u8bb8\u7684\u5c3e\u5dee\uff0c\u65e0\u6cd5\u5408\u5e76\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u5355\u636e\u6216\u5728\u3010\u53d1\u7968\u62c6\u5408\u8bbe\u7f6e\u3011\u4e2d\u91cd\u65b0\u914d\u7f6e\u5408\u5e76\u89c4\u5219\u3002\uff1a%s", new Object[]{e}));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7684\u660e\u7ec6\u5408\u5e76\u540e\u8d85\u8fc7\u7a0e\u63a7\u5141\u8bb8\u7684\u5c3e\u5dee\uff0c\u65e0\u6cd5\u5408\u5e76\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u5355\u636e\u6216\u5728\u3010\u53d1\u7968\u62c6\u5408\u8bbe\u7f6e\u3011\u4e2d\u91cd\u65b0\u914d\u7f6e\u5408\u5e76\u89c4\u5219\u3002\uff1a%S", (String)"OriginalBillServiceImpl_3", (String)"imc-sim-mservice", (Object[])new Object[0]), new Object[]{e}));
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u63d0\u4ea4\u5931\u8d25\uff1a%s", e));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25,%s", (String)"OriginalBillServiceImpl_4", (String)"imc-sim-mservice", (Object[])new Object[0]), e.getMessage()));
            }
        }
        String message = "";
        if (!CollectionUtils.isEmpty((Collection)failedList)) {
            message = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u63d0\u4ea4%1$s\u5f20\u5355\u636e\uff0c\u63d0\u4ea4\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"OriginalBillServiceImpl_5", (String)"imc-sim-mservice", (Object[])new Object[0]), billNos.size(), billNos.size() - failedList.size(), failedList.size());
        }
        result.put("message", (Object)message);
        result.put("failedList", (Object)failedList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(SerializationUtils.toJsonString((Object)result));
        }
        return result;
    }

    private List<List<DynamicObject>> divideGroup(DynamicObject[] billArr) {
        ArrayList<List<DynamicObject>> result = new ArrayList<List<DynamicObject>>();
        Map map = ImcConfigUtil.getValue((String)"issue_speed_config");
        String size = (String)map.get("max_mq_message_size");
        int consumeSize = StringUtils.isEmpty((Object)size) ? 5 : Integer.parseInt(size);
        Map<String, List<DynamicObject>> batchDynamicObjectMap = Stream.of(billArr).collect(Collectors.groupingBy(this::getIssueInvoiceLockKey));
        for (Map.Entry<String, List<DynamicObject>> entry : batchDynamicObjectMap.entrySet()) {
            List<DynamicObject> billList = entry.getValue();
            ArrayList<DynamicObject> container = new ArrayList<DynamicObject>();
            result.add(container);
            for (DynamicObject bill : billList) {
                if (InvoiceUtils.isPaperInvoice((String)bill.getString("invoicetype"))) {
                    container.add(bill);
                    continue;
                }
                if (container.size() > consumeSize) {
                    container = new ArrayList();
                    result.add(container);
                }
                container.add(bill);
            }
        }
        return result;
    }

    private String getIssueInvoiceLockKey(DynamicObject bill) {
        return bill.getString("invoicetype") + bill.getDynamicObject("orgid").getPkValue() + bill.getString("jqbh") + bill.getString("terminalno");
    }

    private void issueInvoice(JSONArray failedList, String deviceNo, String terminalNo, DynamicObject[] billArr, boolean mergeBill, boolean mergeBillDetail) {
        Map resultMap = IssueInvoiceControlHelper.issueInvoice((DynamicObject[])billArr, (String)deviceNo, (String)terminalNo, (String)"", (Integer)1, (boolean)mergeBill, (boolean)mergeBillDetail);
        Map failedInfo = (Map)resultMap.get("failedInfo");
        for (DynamicObject bill : billArr) {
            JSONObject temp = new JSONObject();
            Object message = failedInfo.get(bill.getPkValue().toString());
            if (null == message) {
                message = failedInfo.get(bill.getString("billno"));
            }
            String billNo = bill.getString("billno");
            if (failedInfo.containsKey(bill.getPkValue().toString())) {
                temp.put("billno", (Object)billNo);
                temp.put("message", (Object)String.format(failedMessage, message));
                failedList.add((Object)temp);
                continue;
            }
            if (!failedInfo.containsKey(bill.getString("billno"))) continue;
            temp.put("billno", (Object)billNo);
            temp.put("message", (Object)String.format(failedMessage, message));
            failedList.add((Object)temp);
        }
    }

    private DynamicObject[] loadBill(List<String> billNos, Long orgId) {
        QFilter qFilter = new QFilter("billno", "in", billNos);
        qFilter.and("orgid", "=", (Object)orgId);
        return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])qFilter.toArray(), (String)"originbillseq desc");
    }
}

