/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.issuing;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.service.ElectInvoiceUploadService;
import kd.imc.bdm.lqpt.service.InvoiceNoService;
import kd.imc.sim.async.LqAsyncIssueHandlerImpl;
import kd.imc.sim.async.RpaAsyncIssueHandlerImpl;

public class AsyncIssueInvoiceQueryImpl {
    private static final Log LOG = LogFactory.getLog(AsyncIssueInvoiceQueryImpl.class);
    private long[] lqSleepTimes = new long[]{1000L, 2000L, 4000L, 8000L, 15000L};
    private long[] rpaSleepTimes = new long[]{5000L, 10000L, 15000L};

    public void queryAsyncIssueResult(String orderNo) {
        DynamicObject syncIssue = BusinessDataServiceHelper.loadSingle((String)"sim_async_issue_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_async_issue_invoice"), (QFilter[])new QFilter("orderno", "=", (Object)orderNo).toArray());
        if (syncIssue == null) {
            return;
        }
        RequestContext context = RequestContext.get();
        if ("rpa".equals(syncIssue.getString("issuechannel"))) {
            ThreadPoolsHelper.queryRpaAsyncIssueResultThreadPool.execute(() -> {
                RequestContext.copyAndSet((RequestContext)context);
                this.queryAsyncIssueResult(syncIssue, 1);
            });
        } else {
            ThreadPoolsHelper.queryLqAsyncIssueResultThreadPool.execute(() -> {
                RequestContext.copyAndSet((RequestContext)context);
                this.queryAsyncIssueResult(syncIssue, 1);
            });
        }
    }

    private void queryAsyncIssueResult(DynamicObject syncIssue, int time) {
        boolean queryFlag = true;
        try {
            String issueChannel = syncIssue.getString("issuechannel");
            boolean isRpa = "rpa".equals(issueChannel);
            if (time > (isRpa ? this.rpaSleepTimes.length : this.lqSleepTimes.length)) {
                return;
            }
            Thread.sleep(isRpa ? this.rpaSleepTimes[time - 1] : this.lqSleepTimes[time - 1]);
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u5f02\u6b65\u5f00\u7968\u6570\u7535\u7968\u7acb\u5373\u67e5\u8be2\uff0c\u6d41\u6c34\u53f7\u662f[%s],\u67e5\u8be2\u6b21\u6570[%s]", syncIssue.getString("orderno"), time));
            }
            if (isRpa) {
                ArrayList updateList = new ArrayList(4);
                queryFlag = new RpaAsyncIssueHandlerImpl().handlerOneInvoice(updateList, syncIssue);
                if (!CollectionUtils.isEmpty(updateList)) {
                    ImcSaveServiceHelper.save(updateList);
                }
            } else if ("lqpt".equals(issueChannel)) {
                queryFlag = new LqAsyncIssueHandlerImpl().handOneleLqptInvoice(new ElectInvoiceUploadService(), new InvoiceNoService(), syncIssue);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("\u67e5\u8be2\u5f02\u6b65\u5f00\u7968\u7ed3\u679c\u5931\u8d25\uff0c\u67e5\u8be2\u6b21\u6570[%s],\u6d41\u6c34\u53f7\u4e3a[%s],\u5f02\u5e38\u4fe1\u606f[%s]", time, syncIssue.getString("orderno"), e.getMessage()), (Throwable)e);
        }
        if (!queryFlag) {
            this.queryAsyncIssueResult(syncIssue, ++time);
        }
    }
}

