/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;

public class BillCenterPrintPlugin
extends AbstractPrintPlugin {
    private static final Log LOG = LogFactory.getLog(BillCenterPrintPlugin.class);

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        DynamicObject billCenterDO = BusinessDataServiceHelper.loadSingle((Object)dataSource.getPkId(), (String)dataSource.getFormId());
        List customDataRows = evt.getCustomDataRows();
        DataRowSet dataRowSet = new DataRowSet();
        String qrCode = this.getQrCode(billCenterDO);
        dataRowSet.put("qrcode", (Field)new TextField(qrCode));
        customDataRows.add(dataRowSet);
    }

    private String getQrCode(DynamicObject billCenterDO) {
        String billNo = billCenterDO.getString("billno");
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        String systemCode = billCenterDO.getString("system_code");
        DynamicObject dynamicObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        if (dynamicObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801%s\u672a\u5339\u914d\u5230\u914d\u7f6e\u6570\u636e\uff01", (String)"BillCenterPrintPlugin_1", (String)"imc-sim-webapi", (Object[])new Object[0]), systemCode));
        }
        String print_qr_code = dynamicObject.getString("print_qr_code");
        LOG.info("BillCenterPrintPlugin, print_qr_code:{}", (Object)print_qr_code);
        if ("1".equals(print_qr_code)) {
            ExternalSystemDataHandler externalSystemDataHandler = new ExternalSystemDataHandler();
            JSONObject paramObject = new JSONObject();
            paramObject.put("billNo", (Object)billNo);
            paramObject.put("systemCode", (Object)systemCode);
            return externalSystemDataHandler.dealGetQrCodeMethod(paramObject);
        }
        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7684\u8ba2\u5355\u6570\u636e\uff0c\u4e0d\u80fd\u591f\u751f\u6210\u5c0f\u7968\u7801\uff01", (String)"BillCenterPrintPlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]);
        throw new KDBizException(errorMsg);
    }
}

