/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.ScanApiErrCodeEnum;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.constant.BillCenterSystemEnum;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.impl.bill.BillPushServiceImpl;

public class SimCommonGetDataLogic {
    private static Log logger = LogFactory.getLog(SimCommonGetDataLogic.class);

    public String dealSpecialSystemCodeMethod(String systemCode) {
        if (org.apache.commons.lang3.StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_JIE_SHUN_GZPK.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN_ZHPK.getCode()})) {
            systemCode = "JieShun";
        } else if (org.apache.commons.lang3.StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_GALA_GZPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHPW.getCode(), BillCenterSystemEnum.SYSTEM_NEW_TAX.getCode()})) {
            systemCode = "PW";
        }
        return systemCode;
    }

    public ApiResult dealPushGenerateBillMethod(List<BillVo> list, String userId, String systemCode) {
        try {
            if (list == null || list.isEmpty()) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"SimCommonPushBillLogic_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            for (BillVo billVo : list) {
                BillErrorVo billErrorVo;
                if (!(billVo instanceof BillErrorVo) || (billErrorVo = (BillErrorVo)billVo) == null || !StringUtils.isNotEmpty((CharSequence)billErrorVo.getErrorMsg())) continue;
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)billErrorVo.getErrorMsg());
            }
            ArrayList<String> queryNos = new ArrayList<String>(8);
            for (BillVo vo : list) {
                vo.setBillSource("2");
                vo.setWxId(userId);
                queryNos.add(vo.getBillNo());
            }
            QFilter qFilter = new QFilter("billno", "in", queryNos);
            QFilter filter2 = new QFilter("systemsource", "=", (Object)systemCode);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_original_bill", (String)"id,confirmstate,billno", (QFilter[])new QFilter[]{qFilter, filter2});
            HashMap<String, String> statusMap = new HashMap<String, String>(collect.size());
            for (DynamicObject billObj : collect) {
                statusMap.put(billObj.getString("billno"), billObj.getString("confirmstate"));
            }
            ArrayList<BillVo> newList = new ArrayList<BillVo>(8);
            ArrayList<String> newNoList = new ArrayList<String>(8);
            for (String billNo : queryNos) {
                String status = (String)statusMap.get(billNo);
                if (status != null) continue;
                newNoList.add(billNo);
            }
            for (BillVo vo : list) {
                if (statusMap.get(vo.getBillNo()) != null) continue;
                newList.add(vo);
            }
            if (!newList.isEmpty()) {
                BillPushServiceImpl impl = new BillPushServiceImpl();
                RequestVo request = new RequestVo();
                request.setBusinessSystemCode(systemCode);
                request.setData(JSONArray.toJSONString(newList));
                ApiResult result = impl.processer(request);
                if (!"0".equals(result.getErrorCode())) {
                    return result;
                }
            }
            ArrayList<Long> billIdList = new ArrayList<Long>(collect.size());
            collect = QueryServiceHelper.query((String)"sim_original_bill", (String)"id,confirmstate,billno", (QFilter[])new QFilter[]{qFilter, filter2});
            for (DynamicObject billObj : collect) {
                billIdList.add(billObj.getLong("id"));
            }
            if (!billIdList.isEmpty()) {
                DynamicObject[] allList = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
                JSONArray array = new JSONArray();
                for (DynamicObject originalBill : allList) {
                    if (!"0".equals(originalBill.getString("confirmstate"))) continue;
                    BillVo billVo = (BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)originalBill);
                    billVo.setSystemSource(systemCode);
                    billVo.setCreator("");
                    String invoiceType = originalBill.getString("invoicetype");
                    billVo.setInvoiceTypes(invoiceType, originalBill.getString("salertaxno"), originalBill.getString("jqbh"));
                    billVo.setBillDate(DateUtils.format((Date)originalBill.getDate("billdate"), (String)"yyyy-MM-dd HH:mm:ss"));
                    array.add((Object)billVo);
                }
                return ResponseVo.success((String)array.toJSONString());
            }
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"SimCommonPushBillLogic_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        catch (KDBizException e) {
            return ResponseVo.fail((String)ScanApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("QRGetBill Exception ", (Throwable)e);
            return ResponseVo.fail((String)ScanApiErrCodeEnum.ERROR.getCode(), (String)ScanApiErrCodeEnum.ERROR.getMsg());
        }
    }
}

