/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;

public class SimIsomerismBillDataFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(SimIsomerismBillDataFormPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("push".equals(operate.getOperateKey())) {
            this.dealCheckPushDataMethod(operate);
        }
    }

    private void dealCheckPushDataMethod(FormOperate operate) {
        DynamicObject dynamicObject = operate.getView().getModel().getDataEntity();
        if (dynamicObject != null) {
            String billNo = dynamicObject.getString("billno");
            String pushstatus = dynamicObject.getString("pushstatus");
            String invoice_status = dynamicObject.getString("invoice_status");
            if ("-2".equals(pushstatus) && "-1".equals(invoice_status)) {
                String tipMsg = String.format(ResManager.loadKDString((String)"\u6b64\u8d26\u5355\u7f16\u53f7\uff1a%1$s\uff0c\u5bf9\u5e94\u7684\u8d26\u5355\u53ef\u5f00\u7968\u603b\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u64cd\u4f5c\uff01", (String)"SimIsomerismBillData_7", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo);
                throw new KDBizException(tipMsg);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("update_match_goods".equals(opKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("sim_isomerism_item_data");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u52fe\u9009\u5546\u54c1\u660e\u7ec6\u4f53\u6570\u636e\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u66f4\u65b0\u5f00\u7968\u9879\uff01", (String)"SimIsomerismBillData_24", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return;
            }
            DynamicObject billCenterObject = this.getModel().getDataEntity();
            String systemCode = billCenterObject.getString("system_code");
            String orgCode = billCenterObject.getString("org_code");
            logger.info("update_match_goods, systemCode:{}, orgCode:{}", (Object)systemCode, (Object)orgCode);
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            DynamicObjectCollection itemObjectCollection = this.getModel().getEntryEntity("sim_isomerism_item_data");
            int count = 0;
            for (int selectRow : selectRows) {
                DynamicObject itemObject = (DynamicObject)itemObjectCollection.get(selectRow);
                String productCode = itemObject.getString("product_code");
                DynamicObject bdmGoodsInfoObject = billCenterInvoiceCommonService.getBdmGoodsInfoObject(systemCode, orgCode, productCode);
                if (bdmGoodsInfoObject == null) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u7f16\u7801:%s\uff0c\u672a\u5339\u914d\u5230\u5f00\u7968\u9879\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e", (String)"SimIsomerismBillData_25", (String)"imc-sim-webapi", (Object[])new Object[0]), productCode);
                    throw new KDBizException(errorMsg);
                }
                itemObject.set("product_name", (Object)bdmGoodsInfoObject.getString("name"));
                itemObject.set("specification", (Object)bdmGoodsInfoObject.getString("specifications"));
                itemObject.set("product_unit", (Object)bdmGoodsInfoObject.getString("unit"));
                ++count;
            }
            if (count > 0) {
                String tipMsg = String.format(ResManager.loadKDString((String)"%s\u6761\u660e\u7ec6\u884c\u7684\u4fe1\u606f\u66f4\u65b0\u6210\u529f", (String)"SimIsomerismBillData_26", (String)"imc-sim-webapi", (Object[])new Object[0]), count);
                this.getView().showSuccessNotification(tipMsg);
                SaveServiceHelper.update((DynamicObject)billCenterObject);
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

