/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.sim.formplugin.invoice.ItemSeqThread;
import org.apache.commons.lang3.StringUtils;

public class ItemSeqUpdateListPlugin
extends AbstractListPlugin
implements UploadListener {
    private static Log LOGGER = LogFactory.getLog(ItemSeqUpdateListPlugin.class);
    private static ThreadPool itemSeqUpdateThreadPool = ThreadPools.newFixedThreadPool((String)"ItemSeqUpdateListPlugin", (int)6);
    private static String tabId = "sim_itemseq_update";

    public void afterCreateNewData(EventObject e) {
    }

    public void registerListener(EventObject e) {
        Toolbar functionToolBarLeft = (Toolbar)this.getControl("toolbarap");
        functionToolBarLeft.addUploadListener((UploadListener)this);
        functionToolBarLeft.addItemClickListener((ItemClickListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getAttachmentByte(String savePath) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream bos = service.getInputStream(savePath);){
            byte[] byArray = ItemSeqUpdateListPlugin.getByte(bos);
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getByte(InputStream inputStream) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        byte[] byt = ItemSeqUpdateListPlugin.getAttachmentByte(urls[0].toString());
        String json = null;
        try {
            json = new String(byt, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        JSONArray array = JSONArray.parseArray(json);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1000);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            String taxno = obj.getString("taxno");
            Long startid = obj.getLong("startid");
            String condition = obj.getString("condition");
            if (StringUtils.isEmpty((CharSequence)taxno)) continue;
            DynamicObject dobject = BusinessDataServiceHelper.newDynamicObject((String)tabId);
            dobject.set("taxno", (Object)taxno);
            dobject.set("startid", (Object)startid);
            dobject.set("condition", (Object)condition);
            dobject.set("status", (Object)"0");
            dobject.set("updatetime", (Object)new Date());
            list.add(dobject);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        FileService service = FileServiceFactory.getAttachmentFileService();
        service.delete(urls[0].toString());
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"ItemSeqUpdateListPlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    public void itemClick(ItemClickEvent evt) {
        if ("start".startsWith(evt.getItemKey())) {
            CacheHelper.remove((String)"ItemSeqUpdateListPlugin");
            ListSelectedRowCollection selectCollection = ((IListView)this.getView()).getSelectedRows();
            Object[] pkList = selectCollection.getPrimaryKeyValues();
            this.update(pkList);
        }
        if ("stop".startsWith(evt.getItemKey())) {
            CacheHelper.put((String)"ItemSeqUpdateListPlugin", (String)"stop", (int)600);
        }
        if ("showmsg".equals(evt.getItemKey())) {
            this.getView().showTipNotification(CacheHelper.get((String)"ItemSeqUpdateListPluginId"), Integer.valueOf(5000));
        }
    }

    private void update(Object[] pkList) {
        QFilter filter = new QFilter("status", "=", (Object)"0");
        if (pkList == null || pkList.length > 0) {
            filter = filter.and(new QFilter("id", "in", (Object)pkList));
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)tabId, (String)"id,status,updatetime,taxno,condition,startid", (QFilter[])filter.toArray());
        ArrayList<Future<JSONObject>> futureList = new ArrayList<Future<JSONObject>>();
        for (DynamicObject obj : objs) {
            Long maxPk = obj.getLong("startid");
            int times = 0;
            while (true) {
                ++times;
                try {
                    LOGGER.info("\u66f4\u65b0\u5e8f\u53f7\u5f00\u59cb{},{}" + obj.getString("taxno"), (Object)times);
                    if ("stop".equals(CacheHelper.get((String)"ItemSeqUpdateListPlugin"))) {
                        LOGGER.info("\u66f4\u65b0\u5e8f\u53f7\u505c\u6b62{}" + obj.getString("taxno"));
                        break;
                    }
                    List<Long> list = this.getInvoiceId(obj.getString("taxno"), maxPk, obj.getString("condition"));
                    if (list.isEmpty()) {
                        LOGGER.info("\u66f4\u65b0\u5e8f\u53f7\u7ed3\u675f{}" + obj.getString("taxno"));
                        obj.set("status", (Object)"1");
                        obj.set("updatetime", (Object)new Date());
                        break;
                    }
                    if (list == null || list.size() <= 0) continue;
                    int i = 0;
                    for (Long pk : list) {
                        CacheHelper.put((String)"ItemSeqUpdateListPluginId", (String)(obj.getString("taxno") + "-" + pk), (int)30);
                        Future updateFuture = itemSeqUpdateThreadPool.submit((Callable)new ItemSeqThread(pk));
                        futureList.add(updateFuture);
                        Long id = this.wait(futureList, i++);
                        maxPk = Math.max(maxPk, id);
                    }
                    Long id = this.wait(futureList, 6);
                    maxPk = Math.max(maxPk, id);
                    obj.set("startid", (Object)maxPk);
                    obj.set("updatetime", (Object)new Date());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    private Long wait(List<Future<JSONObject>> futureList, int index) {
        Long pk = 0L;
        if (index > 0 && index % 6 == 0 && !futureList.isEmpty()) {
            for (Future<JSONObject> future : futureList) {
                try {
                    JSONObject result = future.get();
                    Long id = result.getLong("invoiceId");
                    if (id <= pk) continue;
                    pk = id;
                }
                catch (Exception exception) {}
            }
            futureList.clear();
        }
        return pk;
    }

    private List<Long> getInvoiceId(String taxNo, Long startId, String condition) {
        ArrayList<Long> list = new ArrayList<Long>(500);
        QFilter filter = new QFilter("id", ">", (Object)startId);
        filter = filter.and(new QFilter("salertaxno", "=", (Object)taxNo));
        if (!StringUtils.isEmpty((CharSequence)condition)) {
            JSONArray json = JSONArray.parseArray((String)condition);
            for (int i = 0; i < json.size(); ++i) {
                JSONObject obj = json.getJSONObject(i);
                if (!StringUtils.isNotEmpty((CharSequence)obj.getString("property"))) continue;
                filter = filter.and(obj.getString("property"), obj.getString("cp"), obj.get((Object)"value"));
            }
        } else {
            filter = filter.and(new QFilter("buyertype", "=", (Object)"15"));
        }
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id", (QFilter[])filter.toArray(), (String)"id", (int)1000);
        for (JSONObject obj : collect) {
            list.add(obj.getLong("id"));
        }
        return list;
    }
}

