/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.check;

import com.google.common.collect.ImmutableSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import org.apache.commons.lang3.StringUtils;

public class BaseCheckService {
    private static final String ZORE = "0";
    private static final int CODE_LIMIT = 32;

    public static boolean checkStringNotZore(String num) {
        return StringUtils.isNotEmpty((CharSequence)num) && !ZORE.equals(num);
    }

    public static boolean checkCodeLen(String code) {
        return StringUtils.isNotEmpty((CharSequence)code) && code.length() <= 32;
    }

    public static boolean checkLength(int len) {
        return len > 50;
    }

    public static boolean isNotOneOrZore(int num) {
        return num != 0 && num != 1;
    }

    public static boolean checkNotContainsValue(int value) {
        return !BaseCheckService.checkContainsValue(value);
    }

    private static boolean checkContainsValue(int value) {
        ImmutableSet buyerPropertySet = ImmutableSet.of((Object)ZORE, (Object)"1", (Object)"2");
        return buyerPropertySet.contains((Object)String.valueOf(value));
    }

    public static boolean checkInvoiceType(String type) {
        return StringUtils.isNotEmpty((CharSequence)type) && ("004".equals(type) || "007".equals(type) || "026".equals(type) || "028".equals(type) || "08xdp".equals(type) || "10xdp".equals(type));
    }

    public static boolean checkNameLen(String name) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            return name.length() > 16;
        }
        return false;
    }

    public static boolean isPerson(int type, String invoiceType) {
        return 1 == type && ("004".equals(invoiceType) || "028".equals(invoiceType));
    }

    public static VerifyResult checkDevNo(String deviceNo, String taxNo) {
        if (deviceNo.length() != 12 && deviceNo.length() != 20 && deviceNo.length() != 14 && deviceNo.length() != 10) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_DEVLEN.getCode(), ApiErrCodeEnum.INVOICE_OPEN_DEVLEN.getMsg());
        }
        QFilter filter = new QFilter("equipmentno", "=", (Object)deviceNo);
        filter.and("epinfo.number", "=", (Object)taxNo);
        filter.and("authstatus", "=", (Object)"1");
        DynamicObject dev = QueryServiceHelper.queryOne((String)"bdm_tax_equipment", (String)"id,disen", (QFilter[])filter.toArray());
        if (null == dev) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_DEV_NOTFIND.getCode(), ApiErrCodeEnum.INVOICE_DEV_NOTFIND.getMsg());
        }
        if (ZORE.equalsIgnoreCase(dev.getString("disen"))) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_DEV_DISABLE.getCode(), ApiErrCodeEnum.INVOICE_DEV_DISABLE.getMsg());
        }
        return VerifyResult.succeed();
    }
}

