/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.lang3.StringUtils;

public class BillHelper {
    public static List<DynamicObject> getInvoiceListByBillNo(String billNo, String orgCode) {
        DynamicObject[] invObjList;
        QFilter filter = new QFilter("sbillno", "=", (Object)billNo);
        DynamicObject[] relationObjs = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])filter.toArray());
        if (relationObjs.length == 0) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u65e0\u5df2\u5f00\u5177\u53d1\u7968", (String)"BillHelper_0", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo));
        }
        List invIdList = Stream.of(relationObjs).map(o -> o.getLong("tbillid")).distinct().collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", invIdList);
        if (!StringUtils.isBlank((CharSequence)orgCode)) {
            QFilter orgQFilter = new QFilter("number", "=", (Object)orgCode);
            DynamicObject orgDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org"), (QFilter[])orgQFilter.toArray());
            if (orgDynamicObject == null) {
                throw new MsgException(ResManager.loadKDString((String)"orgCode\u4e0d\u5b58\u5728\u7ec4\u7ec7\u4fe1\u606f", (String)"BillHelper_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            qFilter.and("orgid", "=", orgDynamicObject.get("id"));
        }
        if ((invObjList = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])qFilter.toArray())).length == 0 && !StringUtils.isBlank((CharSequence)orgCode)) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff0c\u5728 orgCode %2$s\u4e2d\u4e0d\u5b58\u5728", (String)"BillHelper_2", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo, orgCode));
        }
        return Arrays.asList(invObjList);
    }
}

