/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.ShowTipsConstant;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceRequestDTO;
import kd.imc.bdm.common.openapi.helper.AllEApiHelper;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class AllEInvoiceQueryServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(AllEInvoiceQueryServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"AllEInvoiceQueryServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject jsonObject = JSON.parseObject((String)requestVo.getData());
        String serialNo = jsonObject.getString("serialNo");
        String taxNo = jsonObject.getString("sellerTaxpayerId");
        String invoiceNum = jsonObject.getString("invoiceNum");
        if (StringUtils.isEmpty((CharSequence)serialNo) && StringUtils.isEmpty((CharSequence)invoiceNum)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u548c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"AllEInvoiceQueryServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEInvoiceQueryServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        try {
            DynamicObject epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
            boolean isExist = ApiAllEHelper.checkIssueInvoicePermission((DynamicObject)epInfo);
            if (!isExist) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ShowTipsConstant.getTAXNO_UN_AUTH(), taxNo));
            }
            QFilter qFilter = null;
            if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
                qFilter = new QFilter("billno", "=", (Object)serialNo);
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceNum)) {
                if (qFilter == null) {
                    qFilter = new QFilter("invoiceno", "=", (Object)invoiceNum);
                } else {
                    qFilter.and("invoiceno", "=", (Object)invoiceNum);
                }
            }
            if (qFilter == null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"AllEInvoiceQueryServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            DynamicObject invoiceDO = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "salertaxno", "buyertaxno", "specialtype", "issuestatus"), (QFilter[])qFilter.toArray());
            if (invoiceDO == null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"AllEInvoiceQueryServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (IssueStatusEnum.ok.getCode().equals(invoiceDO.getString("issuestatus")) && "02".equals(invoiceDO.getString("specialtype")) && !taxNo.equals(invoiceDO.getString("buyertaxno"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"AllEInvoiceQueryServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (!"02".equals(invoiceDO.getString("specialtype")) && !taxNo.equals(invoiceDO.getString("salertaxno"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"AllEInvoiceQueryServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            invoiceDO = BusinessDataServiceHelper.loadSingle((Object)invoiceDO.getPkValue(), (String)"sim_vatinvoice");
            AllEInvoiceRequestDTO invoiceVo = new AllEApiHelper().transferAllEInvoiceVO(invoiceDO);
            return ResponseVo.success((String)SerializationUtils.toJsonString((Object)invoiceVo));
        }
        catch (MsgException e) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"AllEInvoiceQueryServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getErrorMsg()));
        }
        catch (Exception e) {
            log.error("\u6570\u7535api\u67e5\u8be2\u6388\u4fe1\u989d\u5ea6\u5931\u8d25", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6388\u4fe1\u989d\u5ea6\u5931\u8d25", (String)"AllEInvoiceQueryServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
    }
}

