/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.ShowTipsConstant;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceBuildInfo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceCoBuyerInfo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceDetailDTO;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceEstateLeaseInfo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceEstateSaleInfo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceRequestDTO;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleLqIssueInvoiceImpl;
import kd.imc.sim.common.utils.AllEleLqAddressSplitUtil;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.invoicebatch.control.WaitInvoiceControl;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import org.apache.commons.lang3.StringUtils;

public class InvoiceOpenAllEServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(InvoiceOpenAllEServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"InvoiceOpenAllEServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        AllEInvoiceRequestDTO invoiceDTO = (AllEInvoiceRequestDTO)JSON.parseObject((String)requestVo.getData(), AllEInvoiceRequestDTO.class);
        if (StringUtils.isEmpty((CharSequence)invoiceDTO.getSerialNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_ORDER_NO_NULL.getCode(), (String)ApiErrCodeEnum.ALLE_ORDER_NO_NULL.getMsg());
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("\u6570\u7535api\u5f00\u7968\u63a5\u53e3\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a%s", invoiceDTO.getSerialNo()));
        }
        this.clearDiscountRowInfo(invoiceDTO);
        boolean isDeleteDbWaitInvoice = false;
        DLock lock = null;
        try {
            ApiResult result;
            String errorMsg;
            String businessSystemCode;
            String taxNo;
            lock = DLock.create((String)(invoiceDTO.getSerialNo() + '_' + "alle_invoice_open"));
            if (!lock.tryLock()) {
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.BILL_HANDLER_ING.getCode(), (String)ApiErrCodeEnum.BILL_HANDLER_ING.getMsg());
                return apiResult;
            }
            if (StringUtils.isEmpty((CharSequence)invoiceDTO.getSellerBankAccount())) {
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ALLE_SELLER_BANK_ACCOUNT_NULL.getCode(), (String)ApiErrCodeEnum.ALLE_SELLER_BANK_ACCOUNT_NULL.getMsg());
                return apiResult;
            }
            DynamicObject epInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)invoiceDTO.getSellerTaxpayerId()).toArray());
            boolean isExist = ApiAllEHelper.checkIssueInvoicePermission((DynamicObject)epInfo);
            if (!isExist) {
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ShowTipsConstant.getTAXNO_UN_AUTH(), invoiceDTO.getSellerTaxpayerId()));
                return apiResult;
            }
            if (StringUtils.isNotBlank((CharSequence)invoiceDTO.getAccount())) {
                taxNo = invoiceDTO.getSellerTaxpayerId();
                String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)invoiceDTO.getAccount());
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                    return apiResult;
                }
                if (!EnterpriseHelper.isLqptChannel((String)taxNo)) {
                    invoiceDTO.setDrawer(AllEleAuthHelper.getDrawerByAccount((String)taxNo, (String)invoiceDTO.getAccount()));
                }
            }
            if (StringUtils.isEmpty((CharSequence)invoiceDTO.getDrawer())) {
                taxNo = ResponseVo.fail((String)ApiErrCodeEnum.ALLE_DRAWER_NULL.getCode(), (String)ApiErrCodeEnum.ALLE_DRAWER_NULL.getMsg());
                return taxNo;
            }
            DynamicObject invoiceDO = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "orderno", "issuestatus", "invoiceno", "result", "salertaxno", "jqbh", "invoicetype", "iselepaper", "govorderno", "systemsource", "buyertype", "issuesource", "orgid", "totalamount", "billno"), (QFilter[])new QFilter("billno", "=", (Object)invoiceDTO.getSerialNo()).toArray());
            if (invoiceDO != null) {
                businessSystemCode = requestVo.getBusinessSystemCode();
                if (!Objects.equals(businessSystemCode, invoiceDO.getString("systemsource"))) {
                    ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_ORDERNO_REPEAT.getCode(), (String)ApiErrCodeEnum.INVOICE_ORDERNO_REPEAT.getMsg());
                    return apiResult;
                }
                if (IssueStatusEnum.ok.getCode().equals(invoiceDO.getString("issuestatus"))) {
                    ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ALLE_SERIALNO_EXIST.getCode(), (String)ApiErrCodeEnum.ALLE_SERIALNO_EXIST.getMsg());
                    return apiResult;
                }
                if (IssueStatusEnum.none.getCode().equals(invoiceDO.getString("issuestatus"))) {
                    isDeleteDbWaitInvoice = true;
                } else {
                    if (IssueStatusEnum.failed.getCode().equalsIgnoreCase(invoiceDO.getString("issuestatus"))) {
                        block64: {
                            block65: {
                                ApiResult riskControlResult;
                                try {
                                    JSONArray jsonArray = new WaitInvoiceControl().checkAllEInvoiceIssue(new DynamicObject[]{invoiceDO});
                                    if (jsonArray.size() <= 0) break block64;
                                    riskControlResult = BillRiskControlService.riskControlSingleOpenApi((DynamicObject)invoiceDO, (String)"sim_vatinvoice", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ISSUE);
                                    if (riskControlResult == null) break block65;
                                    ApiResult apiResult = riskControlResult;
                                    return apiResult;
                                }
                                catch (KDBizException e) {
                                    riskControlResult = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
                                    return riskControlResult;
                                }
                            }
                            ApiResult result2 = ApiAllEHelper.alleLoginCheck((String)invoiceDTO.getSellerTaxpayerId(), (String)invoiceDTO.getAccount());
                            if (result2 != null) {
                                ApiResult apiResult = result2;
                                return apiResult;
                            }
                            IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{invoiceDO});
                            ApiResult apiResult = ResponseVo.success((String)invoiceDTO.getSerialNo());
                            return apiResult;
                        }
                        isDeleteDbWaitInvoice = true;
                    }
                    ApiResult e = ResponseVo.fail((String)ApiErrCodeEnum.BILL_HANDLER_ING.getCode(), (String)ApiErrCodeEnum.BILL_HANDLER_ING.getMsg());
                    return e;
                }
            }
            invoiceDTO.setBatch(requestVo.getBusinessSystemCode() + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + InvoiceOpenAllEServiceImpl.getCacheId("simInvoiceOpenForApi"));
            invoiceDTO.setBillDate(new Date());
            invoiceDTO.setOrderNo(UUID.next());
            invoiceDTO.setSystemSource(requestVo.getBusinessSystemCode());
            invoiceDTO.setBuyerTaxpayerId(invoiceDTO.getBuyerTaxpayerId().replaceAll(" ", "").toUpperCase());
            if (invoiceDTO.getBuyerTaxpayerId().length() > 20) {
                businessSystemCode = ResponseVo.fail((String)ApiErrCodeEnum.ALLE_BUYER_TAXNO_LIMIT.getCode(), (String)ApiErrCodeEnum.ALLE_BUYER_TAXNO_LIMIT.getMsg());
                return businessSystemCode;
            }
            ImmutableSet invoiceTypeSet = ImmutableSet.of((Object)"01", (Object)"02");
            if (!invoiceTypeSet.contains((Object)invoiceDTO.getInvoiceType())) {
                ApiResult e = ResponseVo.fail((String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_ERROR.getCode(), (String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_ERROR.getMsg());
                return e;
            }
            QFilter filter = new QFilter("epinfo.number", "=", (Object)invoiceDTO.getSellerTaxpayerId());
            if (StringUtils.isNotEmpty((CharSequence)invoiceDTO.getOrgCode())) {
                filter.and("number", "=", (Object)invoiceDTO.getOrgCode());
            } else {
                filter.and("enterprisemainorg", "=", (Object)"1");
            }
            DynamicObject orgDO = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"id,number", (QFilter[])filter.toArray());
            if (orgDO == null) {
                ApiResult result2 = ResponseVo.fail((String)ApiErrCodeEnum.ALLE_SELLER_TAX_NOT_FOUND.getCode(), (String)ApiErrCodeEnum.ALLE_SELLER_TAX_NOT_FOUND.getMsg());
                return result2;
            }
            this.buildItemData(invoiceDTO);
            ApiErrCodeEnum error = this.checkBlueInvoice(invoiceDTO);
            if (null != error) {
                ApiResult apiResult = ResponseVo.fail((String)error.getCode(), (String)error.getMsg());
                return apiResult;
            }
            invoiceDTO.setOriginalInvoiceNumber(null);
            invoiceDTO.setRedInfoBillNo(null);
            invoiceDTO.setGovRedConfirmBillUuid(null);
            invoiceDTO.setRedReason(null);
            DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            DynamicObjectUtil.bean2DynamicObject((Object)invoiceDTO, (DynamicObject)invoiceDynamicObject);
            invoiceDynamicObject.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            invoiceDynamicObject.set("datahash", (Object)requestVo.getInterfaceCode());
            invoiceDynamicObject.set("orgid", orgDO.getPkValue());
            invoiceDynamicObject.set("orderno", (Object)UUID.next());
            invoiceDynamicObject.set("showbuyerbank", (Object)invoiceDTO.getShowBuyerBank());
            invoiceDynamicObject.set("showsalerbank", (Object)invoiceDTO.getShowSalerBank());
            invoiceDynamicObject.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
            invoiceDynamicObject.set("invoicestatus", (Object)"");
            invoiceDynamicObject.set("inventorymark", (Object)"0");
            invoiceDynamicObject.set("specialtype", (Object)"00");
            invoiceDynamicObject.set("hsbz", (Object)"0");
            invoiceDynamicObject.set("createtime", (Object)new Date());
            if (!StringUtils.isEmpty((CharSequence)invoiceDTO.getNaturalPersonFlag())) {
                invoiceDynamicObject.set("buyerproperty", (Object)("Y".equals(invoiceDTO.getNaturalPersonFlag()) ? "1" : "0"));
            }
            if ("01".equals(invoiceDTO.getInvoiceType())) {
                invoiceDynamicObject.set("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
            } else if ("02".equals(invoiceDTO.getInvoiceType())) {
                invoiceDynamicObject.set("invoicetype", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
            }
            this.wrapSpecialTypeData(invoiceDTO, invoiceDynamicObject);
            this.wrapAgentUser(invoiceDTO, invoiceDynamicObject);
            this.dealClearSpecialTypeItemsMethod(invoiceDynamicObject);
            this.dealSetSpecialTypePeriodMethod(invoiceDynamicObject, requestVo.getInterfaceCode(), requestVo.getData());
            this.warpItemPrivilegeType(invoiceDTO, invoiceDynamicObject);
            IssuePolicyHelper.setBizControl((String)invoiceDTO.getIssueBizType(), (DynamicObject)invoiceDynamicObject);
            if (GBKUtils.getGBKLength((String)invoiceDynamicObject.getString("buyerphone")) > 80) {
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYERRPHONE_ERROR_LEN.getCode(), (String)ApiErrCodeEnum.BILL_PUSH_BUYERRPHONE_ERROR_LEN.getMsg());
                return apiResult;
            }
            String oriBuyerPhone = invoiceDynamicObject.getString("buyerphone");
            if (StringUtils.isNotBlank((CharSequence)oriBuyerPhone)) {
                invoiceDynamicObject.set("buyerphone", (Object)"16688888888");
            }
            if (!StringUtils.isEmpty((CharSequence)(errorMsg = InvoiceCheckService.checkParams((DynamicObject)invoiceDynamicObject, (boolean)true, (boolean)false)))) {
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
                return apiResult;
            }
            invoiceDynamicObject.set("buyerphone", (Object)oriBuyerPhone);
            if (StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((String)"hw_config", (String)"commit_mq")) && (result = ApiAllEHelper.alleLoginCheck((String)invoiceDTO.getSellerTaxpayerId(), (String)invoiceDTO.getAccount())) != null) {
                ApiResult apiResult = result;
                return apiResult;
            }
            this.deleteAndAddNewWaitInvoice(invoiceDynamicObject, isDeleteDbWaitInvoice, new QFilter("billno", "=", (Object)invoiceDTO.getSerialNo()));
            ApiResult riskControlResult = BillRiskControlService.riskControlSingleOpenApi((DynamicObject)invoiceDynamicObject, (String)"sim_vatinvoice", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ISSUE);
            if (riskControlResult != null) {
                ApiResult apiResult = riskControlResult;
                return apiResult;
            }
            IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{invoiceDynamicObject});
        }
        catch (MsgException msgException) {
            ApiResult isExist = ResponseVo.fail((String)msgException.getErrorCode(), (String)msgException.getErrorMsg());
            return isExist;
        }
        catch (Exception e) {
            log.error("\u6570\u7535api\u5f00\u7968\u63a5\u53e3\u63a8\u5165mq\u5f02\u5e38", (Throwable)e);
            String errorMsg = e.getMessage();
            if (e instanceof JSONException) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u63a5\u6536\u7684\u6570\u636e\u8f6c\u6362\u5f02\u5e38:%s", (String)"BillPushServiceImpl_46", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
            }
            ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
            return apiResult;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return ResponseVo.success((String)invoiceDTO.getSerialNo());
    }

    private void dealSetSpecialTypePeriodMethod(DynamicObject invoiceDynamicObject, String interfaceCode, String data) {
        String specialType = invoiceDynamicObject.getString("specialtype");
        if ("E07".equals(specialType)) {
            BillValidaterHelper.dealCheckVessalShipPeriodMethod((String)interfaceCode, (String)data);
            DynamicObjectCollection vesselShipCollection = invoiceDynamicObject.getDynamicObjectCollection("vehichevesselships");
            for (DynamicObject vesselShipItem : vesselShipCollection) {
                Date periodStartDate = vesselShipItem.getDate("periodstartdate");
                Date periodEndDate = vesselShipItem.getDate("periodenddate");
                String periodDate = DateUtils.format((Date)periodStartDate, (String)"yyyy-MM") + " " + DateUtils.format((Date)periodEndDate, (String)"yyyy-MM");
                vesselShipItem.set("perioddate", (Object)periodDate);
            }
        }
    }

    private void dealClearSpecialTypeItemsMethod(DynamicObject invoiceDynamicObject) {
        String specialType = invoiceDynamicObject.getString("specialtype");
        if (!"E09".equals(specialType)) {
            DynamicObjectCollection travelerItems = invoiceDynamicObject.getDynamicObjectCollection("travelers");
            travelerItems.clear();
            invoiceDynamicObject.set("travelers", null);
        }
        if (!"E07".equals(specialType)) {
            DynamicObjectCollection vesselVehicheItems = invoiceDynamicObject.getDynamicObjectCollection("vehichevesselships");
            vesselVehicheItems.clear();
            invoiceDynamicObject.set("vehichevesselships", null);
        }
        if (!"E05".equals(specialType)) {
            DynamicObjectCollection saleItems = invoiceDynamicObject.getDynamicObjectCollection("estatesales");
            saleItems.clear();
            invoiceDynamicObject.set("estatesales", null);
            invoiceDynamicObject.set("cobuyerflag", null);
            DynamicObjectCollection cobuyerItems = invoiceDynamicObject.getDynamicObjectCollection("cobuyers");
            cobuyerItems.clear();
            invoiceDynamicObject.set("cobuyers", null);
        }
    }

    private void warpItemPrivilegeType(AllEInvoiceRequestDTO invoiceDTO, DynamicObject invoiceDynamicObject) {
        DynamicObjectCollection items = invoiceDynamicObject.getDynamicObjectCollection("items");
        boolean isRpa = true;
        if (EnterpriseHelper.isLqptChannel((String)invoiceDynamicObject.getString("salertaxno"))) {
            isRpa = false;
        } else {
            this.checkReductionTaxType(invoiceDTO);
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceDTO.getReductionTaxType())) {
            invoiceDynamicObject.set("taxedtype", (Object)TaxedTypeEnum.all_e_reduced_tax.getValue());
        }
        for (DynamicObject itemDO : items) {
            String privilegeType = itemDO.getString("zzstsgl");
            if (StringUtils.isNotEmpty((CharSequence)invoiceDTO.getReductionTaxType())) {
                if (!"10".equals(privilegeType)) {
                    throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u51cf\u6309\u5f81\u7a0e\u5f00\u7968\u65f6\uff0c\u660e\u7ec6privilegeType\u9700\u4f2010", (String)"InvoiceOpenAllEServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (!"0.015".equals(itemDO.getString("taxrate"))) {
                    throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u660e\u7ec6\u4f18\u60e0\u653f\u7b56\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81\u65f6\uff0c\u7a0e\u7387\u9700\u4f200.015", (String)"InvoiceOpenAllEServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
            }
            if (StringUtils.isEmpty((CharSequence)privilegeType)) continue;
            itemDO.set("taxpremark", (Object)"1");
            if ("03".equals(privilegeType)) {
                if (!MathUtils.isZero((BigDecimal)new BigDecimal(itemDO.getString("taxrate")))) {
                    throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u514d\u7a0e\u6216\u4e0d\u5f81\u7a0e\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceOpenAllEServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                itemDO.set("zerotaxmark", (Object)"1");
                itemDO.set("zzstsgl", (Object)ResManager.loadKDString((String)"\u514d\u7a0e", (String)"InvoiceOpenAllEServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
                continue;
            }
            if ("04".equals(privilegeType)) {
                if (!MathUtils.isZero((BigDecimal)new BigDecimal(itemDO.getString("taxrate")))) {
                    throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u514d\u7a0e\u6216\u4e0d\u5f81\u7a0e\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceOpenAllEServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                itemDO.set("zerotaxmark", (Object)"2");
                itemDO.set("zzstsgl", (Object)ResManager.loadKDString((String)"\u4e0d\u5f81\u7a0e", (String)"InvoiceOpenAllEServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
                continue;
            }
            if (!"10".equals(privilegeType) || !isRpa || !StringUtils.isEmpty((CharSequence)invoiceDTO.getReductionTaxType())) continue;
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u660e\u7ec6\u4f18\u60e0\u653f\u7b56\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81\u65f6\uff0c\u9700\u8981\u4f20\u51cf\u6309\u5f81\u7a0e\u7c7b\u578b", (String)"InvoiceOpenAllEServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
    }

    private void checkReductionTaxType(AllEInvoiceRequestDTO invoiceDTO) {
        if (StringUtils.isNotEmpty((CharSequence)invoiceDTO.getReductionTaxType())) {
            ImmutableSet stringSet = ImmutableSet.of((Object)"01", (Object)"02", (Object)"03", (Object)"04", (Object)"05", (Object)"51", (Object[])new String[]{"52", "53"});
            if (!stringSet.contains(invoiceDTO.getReductionTaxType())) {
                throw new MsgException(ApiErrCodeEnum.REDUCTIONTAXTYPE_ERROR.getCode(), ApiErrCodeEnum.REDUCTIONTAXTYPE_ERROR.getMsg());
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceDTO.getSpecialType()) && !"06".equals(invoiceDTO.getSpecialType())) {
                throw new MsgException(ApiErrCodeEnum.REDUCTIONTAXTYPE_ERROR2.getCode(), ApiErrCodeEnum.REDUCTIONTAXTYPE_ERROR2.getMsg());
            }
        }
    }

    private void clearDiscountRowInfo(AllEInvoiceRequestDTO dto) {
        List items = dto.getInvoiceDetail();
        if (null != items && items.size() > 0) {
            for (AllEInvoiceDetailDTO item : items) {
                int lineProperty = item.getLineProperty();
                if (!"1".equals(String.valueOf(lineProperty))) continue;
                item.setPrice(null);
                item.setTaxUnitPrice(null);
                item.setQuantity(null);
                item.setSpecification(null);
                item.setUnits(null);
            }
        }
    }

    private void deleteAndAddNewWaitInvoice(DynamicObject invoiceDynamicObject, boolean isDeleteDbWaitInvoice, QFilter filter) {
        try (TXHandle tx = TX.required();){
            try {
                if (isDeleteDbWaitInvoice) {
                    DeleteServiceHelper.delete((String)"sim_vatinvoice", (QFilter[])filter.toArray());
                }
                ImcSaveServiceHelper.save((DynamicObject)invoiceDynamicObject);
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                tx.markRollback();
                throw t;
            }
        }
    }

    private ApiErrCodeEnum checkBlueInvoice(AllEInvoiceRequestDTO invoice) {
        BigDecimal totalAmount = invoice.getTotalAmount();
        String issueType = String.valueOf(invoice.getInvoiceProperty());
        if (!IssueType.BLUE_INVOICE.getTypeCode().equals(issueType)) {
            return ApiErrCodeEnum.AllE_BLUE_INVOICE_ISSUE_TYPE_ERROR;
        }
        if (BigDecimalUtil.lessZero((BigDecimal)totalAmount)) {
            return ApiErrCodeEnum.AllE_BLUE_TOTAL_AMOUNT_ERROR;
        }
        BigDecimal totalTax = invoice.getTotalTaxAmount();
        if (BigDecimalUtil.lessZero((BigDecimal)totalTax)) {
            return ApiErrCodeEnum.AllE_BLUE_TOTAL_TAX_ERROR;
        }
        return null;
    }

    private void wrapAgentUser(AllEInvoiceRequestDTO invoiceDTO, DynamicObject invoiceDynamicObject) {
        if (!StringUtils.isEmpty((CharSequence)invoiceDTO.getAgentUser())) {
            DynamicObject operatorDynamicObject;
            QFilter baseDataFilter = ImcBaseDataHelper.getOperatorFilter((Object)invoiceDynamicObject.getLong("orgid"));
            baseDataFilter.and("name", "=", (Object)invoiceDTO.getAgentUser());
            if (!StringUtils.isEmpty((CharSequence)invoiceDTO.getAgentCardNo())) {
                baseDataFilter.and("certificatenumber", "=", (Object)invoiceDTO.getAgentCardNo());
            }
            if (!StringUtils.isEmpty((CharSequence)invoiceDTO.getAgentTaxNo())) {
                baseDataFilter.and("taxno", "=", (Object)invoiceDTO.getAgentTaxNo());
            }
            if ((operatorDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_operator_info", (String)"id,number", (QFilter[])baseDataFilter.toArray())) == null) {
                operatorDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_operator_info");
                operatorDynamicObject.set("number", (Object)UUID.next());
                operatorDynamicObject.set("name", (Object)invoiceDTO.getAgentUser());
                if (!StringUtils.isEmpty((CharSequence)invoiceDTO.getAgentTaxNo())) {
                    operatorDynamicObject.set("taxno", (Object)invoiceDTO.getAgentTaxNo());
                }
                if (!StringUtils.isEmpty((CharSequence)invoiceDTO.getAgentCardNo())) {
                    operatorDynamicObject.set("certificatenumber", (Object)invoiceDTO.getAgentCardNo());
                }
                if (!StringUtils.isEmpty((CharSequence)invoiceDTO.getAgentCardType())) {
                    operatorDynamicObject.set("certificatetype", (Object)invoiceDTO.getAgentCardType());
                }
                if (!StringUtils.isEmpty((CharSequence)invoiceDTO.getAgentCountry())) {
                    operatorDynamicObject.set("county", (Object)invoiceDTO.getAgentCountry());
                }
                ImcSaveServiceHelper.save((DynamicObject)operatorDynamicObject);
            }
            invoiceDynamicObject.set("operator", operatorDynamicObject.getPkValue());
        }
    }

    private void buildItemData(AllEInvoiceRequestDTO invoiceDTO) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        int lineProperty = 0;
        if (null == invoiceDTO.getInvoiceDetail()) {
            throw new MsgException(ResManager.loadKDString((String)"\u6ca1\u6709\u4f20\u5165\u660e\u7ec6\u6216\u5219\u660e\u7ec6\u7684key\u4e0d\u5bf9", (String)"InvoiceOpenAllEServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        for (int j = 0; j < invoiceDTO.getInvoiceDetail().size(); ++j) {
            BigDecimal amount;
            BigDecimal num;
            int itemIndex = j + 1;
            AllEInvoiceDetailDTO detailDTO = (AllEInvoiceDetailDTO)invoiceDTO.getInvoiceDetail().get(j);
            detailDTO.setSeq(Integer.valueOf(j));
            String taxRateStr = detailDTO.getTaxRate();
            BigDecimal taxRateDecimalValue = null;
            try {
                taxRateDecimalValue = new BigDecimal(taxRateStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String standardTaxRate = ApiVerifyUtil.getStandardTaxRate(taxRateDecimalValue);
            if (null == standardTaxRate) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7a0e\u7387\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"InvoiceOpenAllEServiceImpl_16", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1));
            }
            detailDTO.setTaxRate(standardTaxRate);
            if (lineProperty == 2 && detailDTO.getLineProperty() != 1) {
                throw new MsgException(ApiErrCodeEnum.LINE_PROPERTY_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c%s", (String)"InvoiceOpenAllEServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.LINE_PROPERTY_ERROR.getMsg()));
            }
            if (lineProperty != 2 && detailDTO.getLineProperty() == 1) {
                throw new MsgException(ApiErrCodeEnum.LINE_PROPERTY_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c%s", (String)"InvoiceOpenAllEServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.LINE_PROPERTY_ERROR.getMsg()));
            }
            lineProperty = detailDTO.getLineProperty();
            if (!StringUtils.isEmpty((CharSequence)detailDTO.getGoodsCode())) {
                QFilter qFilter = new QFilter("number", "=", (Object)detailDTO.getGoodsCode());
                DynamicObject goodsInfoDO = BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (String)GoodsInfoConstant.SELECT_PROPERTIES, (QFilter[])qFilter.toArray());
                if (goodsInfoDO == null) {
                    throw new MsgException(ApiErrCodeEnum.ALLE_ITEM_GOODS_CODE_NOT_FOUND.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"InvoiceOpenAllEServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.ALLE_ITEM_GOODS_CODE_NOT_FOUND.getMsg()));
                }
                detailDTO.setRevenueCode(goodsInfoDO.getDynamicObject("taxcode").getString("mergecode"));
                detailDTO.setGoodsName(goodsInfoDO.getString("name"));
                detailDTO.setTaxRate(goodsInfoDO.getString("taxrate"));
                detailDTO.setSpecification(goodsInfoDO.getString("specifications"));
                detailDTO.setUnits(goodsInfoDO.getString("unit"));
                if (!StringUtils.isEmpty((CharSequence)goodsInfoDO.getString("privilegetype"))) {
                    detailDTO.setPrivilegeType((String)AllEleLqIssueInvoiceImpl.PRIVILEGE_TYPE_MAP.get(goodsInfoDO.getString("privilegetype")));
                }
            }
            if (StringUtils.isEmpty((CharSequence)detailDTO.getTaxRate())) {
                throw new MsgException(ApiErrCodeEnum.ALLE_ITEM_TAXRATE_NULL.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"InvoiceOpenAllEServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.ALLE_ITEM_TAXRATE_NULL.getMsg()));
            }
            try {
                new BigDecimal(detailDTO.getTaxRate());
            }
            catch (Exception e) {
                throw new MsgException(ApiErrCodeEnum.ALLE_ITEM_TAXRATE_FORMAT_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"InvoiceOpenAllEServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.ALLE_ITEM_TAXRATE_FORMAT_ERROR.getMsg()));
            }
            if (MathUtils.isZero((BigDecimal)detailDTO.getAmount())) {
                throw new MsgException(ApiErrCodeEnum.ALLE_ITEM_AMOUNT_ZERO.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"InvoiceOpenAllEServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.ALLE_ITEM_AMOUNT_ZERO.getMsg()));
            }
            detailDTO.setAmount(detailDTO.getAmount().setScale(2, RoundingMode.HALF_UP));
            if (StringUtils.isEmpty((CharSequence)detailDTO.getRevenueCode()) && StringUtils.isEmpty((CharSequence)detailDTO.getGoodsCode())) {
                throw new MsgException(ApiErrCodeEnum.ALLE_ITEM_TAXRATE_CODE_NULL.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"InvoiceOpenAllEServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.ALLE_ITEM_TAXRATE_CODE_NULL.getMsg()));
            }
            DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)detailDTO.getRevenueCode());
            if (taxClassCode == null) {
                throw new MsgException(ApiErrCodeEnum.ALLE_ITEM_TAXRATE_CODE_NOT_FOUND.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"InvoiceOpenAllEServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.ALLE_ITEM_TAXRATE_CODE_NOT_FOUND.getMsg()));
            }
            detailDTO.setGoodsName(String.format("*%s*%s", taxClassCode.getString("simplename"), detailDTO.getGoodsName()));
            BigDecimal taxRate = new BigDecimal(detailDTO.getTaxRate());
            if (detailDTO.getTaxAmount() == null) {
                detailDTO.setTaxAmount(detailDTO.getAmount().multiply(taxRate).setScale(2, RoundingMode.HALF_UP));
            } else {
                detailDTO.setTaxAmount(detailDTO.getTaxAmount().setScale(2, RoundingMode.HALF_UP));
                if ((detailDTO.getLineProperty() == 0 || detailDTO.getLineProperty() == 2) && detailDTO.getAmount().multiply(taxRate).setScale(2, RoundingMode.HALF_UP).abs().subtract(detailDTO.getTaxAmount().setScale(2, RoundingMode.HALF_UP).abs()).abs().compareTo(new BigDecimal("0.06")) > 0) {
                    throw new MsgException(ApiErrCodeEnum.TAX_AMOUNT_OVER_LIMIT.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c%s", (String)"InvoiceOpenAllEServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.TAX_AMOUNT_OVER_LIMIT.getMsg()));
                }
                if (detailDTO.getLineProperty() == 1 && detailDTO.getAmount().multiply(taxRate).setScale(2, RoundingMode.HALF_UP).abs().subtract(detailDTO.getTaxAmount().setScale(2, RoundingMode.HALF_UP).abs()).abs().compareTo(new BigDecimal("0.01")) > 0) {
                    throw new MsgException(ApiErrCodeEnum.TAX_DIS_AMOUNT_OVER_LIMIT.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c%s", (String)"InvoiceOpenAllEServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.TAX_DIS_AMOUNT_OVER_LIMIT.getMsg()));
                }
            }
            detailDTO.setIncludeTaxAmount(detailDTO.getAmount().add(detailDTO.getTaxAmount()));
            if (!(StringUtils.isEmpty((CharSequence)detailDTO.getQuantity()) || StringUtils.isEmpty((CharSequence)detailDTO.getPrice()) || MathUtils.isZero((BigDecimal)(num = new BigDecimal(detailDTO.getQuantity()))) || (amount = num.multiply(new BigDecimal(detailDTO.getPrice())).setScale(2, RoundingMode.HALF_UP)).abs().subtract(detailDTO.getAmount().abs()).abs().compareTo(new BigDecimal("0.01")) <= 0)) {
                throw new MsgException(ApiErrCodeEnum.AMOUNT_OVER_LIMIT.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c%s", (String)"InvoiceOpenAllEServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.AMOUNT_OVER_LIMIT.getMsg()));
            }
            if (!StringUtils.isEmpty((CharSequence)detailDTO.getQuantity())) {
                BigDecimal taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)detailDTO.getIncludeTaxAmount(), (BigDecimal)new BigDecimal(detailDTO.getQuantity()), (boolean)Boolean.TRUE);
                detailDTO.setTaxUnitPrice(taxUnitPrice);
            }
            if (detailDTO.getLineProperty() == 1) {
                detailDTO.setPrice("0");
                detailDTO.setQuantity("0");
                ((AllEInvoiceDetailDTO)invoiceDTO.getInvoiceDetail().get(j - 1)).setLineProperty(2);
                if (!((AllEInvoiceDetailDTO)invoiceDTO.getInvoiceDetail().get(j - 1)).getTaxRate().equals(detailDTO.getTaxRate())) {
                    throw new MsgException(ApiErrCodeEnum.ALLE_TAXRATE_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c%s", (String)"InvoiceOpenAllEServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), itemIndex, ApiErrCodeEnum.ALLE_TAXRATE_ERROR.getMsg()));
                }
                if (!MathUtils.bigDecimalIsNegativeValue((BigDecimal)detailDTO.getAmount())) {
                    throw new MsgException("20019", String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a\u6b63\u6570", (String)"InvoiceOpenAllEServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1));
                }
                if (!MathUtils.bigDecimalIsNegativeValue((BigDecimal)detailDTO.getTaxAmount()) && !MathUtils.isZero((BigDecimal)detailDTO.getTaxAmount())) {
                    throw new MsgException("20019", String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c\u6298\u6263\u7a0e\u989d\u4e0d\u80fd\u4e3a\u6b63\u6570", (String)"InvoiceOpenAllEServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1));
                }
            }
            totalAmount = totalAmount.add(detailDTO.getAmount());
            totalTaxAmount = totalTaxAmount.add(detailDTO.getTaxAmount());
        }
        invoiceDTO.setTotalAmount(totalAmount);
        invoiceDTO.setTotalTaxAmount(totalTaxAmount);
        invoiceDTO.setIncludeTaxAmount(totalAmount.add(totalTaxAmount));
    }

    private void wrapSpecialTypeData(AllEInvoiceRequestDTO invoiceDTO, DynamicObject invoiceDynamicObject) {
        DynamicObject adminDivision;
        if ("05".equals(invoiceDTO.getSpecialType())) {
            AllEInvoiceEstateSaleInfo estateSaleInfo;
            ArrayList<AllEInvoiceEstateSaleInfo> saleInfoList = invoiceDTO.getEstateSaleItems();
            if (CollectionUtils.isEmpty((Collection)invoiceDTO.getEstateSaleItems())) {
                saleInfoList = new ArrayList<AllEInvoiceEstateSaleInfo>(1);
                estateSaleInfo = invoiceDTO.getEstateSaleInfo();
                if (estateSaleInfo == null) {
                    throw new MsgException(ApiErrCodeEnum.ALLE_ESTATE_SALE_NULL.getCode(), ApiErrCodeEnum.ALLE_ESTATE_SALE_NULL.getMsg());
                }
                DynamicObject adminDivision2 = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_admindivision", (QFilter[])new QFilter("name", "like", (Object)(estateSaleInfo.getSimpleAddress() + "%")).toArray());
                if (adminDivision2 == null) {
                    throw new MsgException(ApiErrCodeEnum.ALLE_BUILD_INFO_NULL.getCode(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u7684\u3010\u4e0d\u52a8\u4ea7\u5730\u5740\u3011\u672a\u5339\u914d\u5230\u5bf9\u5e94\u3010\u7701\u5e02\u533a\u53bf\u3011\u57fa\u7840\u8d44\u6599\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"InvoiceOpenAllEServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                Map adrressMap = AllEleLqAddressSplitUtil.split((String)estateSaleInfo.getSimpleAddress());
                estateSaleInfo.setProvinceAdress((String)adrressMap.get("province"));
                estateSaleInfo.setCityAdreess((String)adrressMap.get("city"));
                saleInfoList.add(estateSaleInfo);
                invoiceDTO.setCoBuyerFlag("0");
                invoiceDTO.setCoBuyerItems(null);
                invoiceDTO.setEstateSaleItems(saleInfoList);
            }
            DynamicObjectCollection estatesales = invoiceDynamicObject.getDynamicObjectCollection("estatesales");
            estatesales.clear();
            DynamicObjectCollection cobuyers = invoiceDynamicObject.getDynamicObjectCollection("cobuyers");
            cobuyers.clear();
            for (int i = 0; i < saleInfoList.size(); ++i) {
                estateSaleInfo = (AllEInvoiceEstateSaleInfo)saleInfoList.get(i);
                DynamicObject estatesaleDynamicObject = estatesales.addNew();
                estatesaleDynamicObject.set("seq", (Object)(i + 1));
                estatesaleDynamicObject.set("saleestatecode", (Object)estateSaleInfo.getEstateCode());
                estatesaleDynamicObject.set("onlinecontracteno", (Object)estateSaleInfo.getOnLineContracteNo());
                estatesaleDynamicObject.set("saleestateid", (Object)estateSaleInfo.getEstateId());
                estatesaleDynamicObject.set("saleprincename", (Object)estateSaleInfo.getProvinceAdress());
                estatesaleDynamicObject.set("salecityname", (Object)estateSaleInfo.getCityAdreess());
                estatesaleDynamicObject.set("saledetailaddress", (Object)estateSaleInfo.getDetailAddress());
                estatesaleDynamicObject.set("salecrosscitysign", (Object)estateSaleInfo.getCrossCitySign());
                estatesaleDynamicObject.set("saleunit", (Object)estateSaleInfo.getAreaUnit());
                estatesaleDynamicObject.set("salelandtaxno", (Object)estateSaleInfo.getLandTaxNo());
                try {
                    estatesaleDynamicObject.set("assessmenttaxamount", (Object)estateSaleInfo.getApprovedPrice());
                    estatesaleDynamicObject.set("actualtotalamount", (Object)estateSaleInfo.getActualTurnover());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String coBuyerFlag = invoiceDTO.getCoBuyerFlag();
            if (StringUtils.isNotEmpty((CharSequence)coBuyerFlag) && "1".equals(coBuyerFlag)) {
                invoiceDynamicObject.set("cobuyerflag", (Object)"1");
                List coBuyerInfoList = invoiceDTO.getCoBuyerItems();
                if (!CollectionUtils.isEmpty((Collection)coBuyerInfoList)) {
                    for (int i = 0; i < coBuyerInfoList.size(); ++i) {
                        AllEInvoiceCoBuyerInfo coBuyerInfo = (AllEInvoiceCoBuyerInfo)coBuyerInfoList.get(i);
                        DynamicObject cobuyerDynamicObject = cobuyers.addNew();
                        cobuyerDynamicObject.set("seq", (Object)(i + 1));
                        cobuyerDynamicObject.set("cobuyer", (Object)coBuyerInfo.getCoBuyer());
                        cobuyerDynamicObject.set("cobuyercardtype", (Object)coBuyerInfo.getCardType());
                        cobuyerDynamicObject.set("cobuyercardno", (Object)coBuyerInfo.getCardNo());
                    }
                }
            } else {
                invoiceDynamicObject.set("cobuyerflag", (Object)"0");
            }
            invoiceDynamicObject.set("specialtype", (Object)"E05");
        } else if ("06".equals(invoiceDTO.getSpecialType())) {
            AllEInvoiceEstateLeaseInfo estateLeaseInfo = invoiceDTO.getEstateLeaseInfo();
            if (estateLeaseInfo == null) {
                throw new MsgException(ApiErrCodeEnum.ALLE_ESTATE_LEASE_NULL.getCode(), ApiErrCodeEnum.ALLE_ESTATE_LEASE_NULL.getMsg());
            }
            adminDivision = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_admindivision", (QFilter[])new QFilter("name", "like", (Object)(estateLeaseInfo.getSimpleAddress() + "%")).toArray());
            if (adminDivision == null) {
                throw new MsgException(ApiErrCodeEnum.ALLE_BUILD_INFO_NULL.getCode(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\u7684\u3010\u4e0d\u52a8\u4ea7\u5730\u5740\u3011\u672a\u5339\u914d\u5230\u5bf9\u5e94\u3010\u7701\u5e02\u533a\u53bf\u3011\u57fa\u7840\u8d44\u6599\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"InvoiceOpenAllEServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            invoiceDynamicObject.set("estateid", (Object)estateLeaseInfo.getEstateId());
            invoiceDynamicObject.set("simpleaddress", adminDivision.getPkValue());
            invoiceDynamicObject.set("detailaddress", (Object)estateLeaseInfo.getDetailAddress());
            invoiceDynamicObject.set("crosscitysign", (Object)estateLeaseInfo.getCrossCitySign());
            invoiceDynamicObject.set("areaunit", (Object)estateLeaseInfo.getAreaUnit());
            invoiceDynamicObject.set("startleasedate", (Object)DateUtils.handleDate((String)estateLeaseInfo.getStartLeaseDate()));
            invoiceDynamicObject.set("endleasedate", (Object)DateUtils.handleDate((String)estateLeaseInfo.getEndLeaseDate()));
            invoiceDynamicObject.set("specialtype", (Object)"E06");
        } else if ("03".equals(invoiceDTO.getSpecialType())) {
            AllEInvoiceBuildInfo buildInfo = invoiceDTO.getBuildInfo();
            if (buildInfo == null) {
                throw new MsgException(ApiErrCodeEnum.ALLE_BUILD_NULL.getCode(), ApiErrCodeEnum.ALLE_BUILD_NULL.getMsg());
            }
            adminDivision = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_admindivision", (QFilter[])new QFilter("name", "like", (Object)(buildInfo.getSimpleAddress() + "%")).toArray());
            if (adminDivision == null) {
                throw new MsgException(ApiErrCodeEnum.ALLE_BUILD_INFO_NULL.getCode(), ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u7684\u3010\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730\u3011\u672a\u5339\u914d\u5230\u5bf9\u5e94\u3010\u7701\u5e02\u533a\u53bf\u3011\u57fa\u7840\u8d44\u6599\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"InvoiceOpenAllEServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            invoiceDynamicObject.set("buildingname", (Object)buildInfo.getBuildingName());
            invoiceDynamicObject.set("simpleaddress", adminDivision.getPkValue());
            invoiceDynamicObject.set("detailaddress", (Object)buildInfo.getDetailAddress());
            invoiceDynamicObject.set("crosscitysign", (Object)buildInfo.getCrossCitySign());
            invoiceDynamicObject.set("landtaxno", (Object)buildInfo.getLandTaxNo());
            invoiceDynamicObject.set("specialtype", (Object)"E03");
        } else if ("02".equals(invoiceDTO.getSpecialType())) {
            invoiceDynamicObject.set("specialtype", (Object)"02");
        } else if ("12".equals(invoiceDTO.getSpecialType())) {
            invoiceDynamicObject.set("specialtype", (Object)"E12");
            this.checkFarmProduceSaleItems(invoiceDTO);
        } else if ("09".equals(invoiceDTO.getSpecialType())) {
            invoiceDynamicObject.set("specialtype", (Object)"E09");
        } else if ("14".equals(invoiceDTO.getSpecialType())) {
            invoiceDynamicObject.set("specialtype", (Object)"E14");
        } else if ("07".equals(invoiceDTO.getSpecialType())) {
            invoiceDynamicObject.set("specialtype", (Object)"E07");
        }
        if (InvoiceSpecialType.allEleSpecialType((String)invoiceDynamicObject.getString("specialtype"))) {
            DynamicObject adminDivision3;
            BaseInvoice baseInvoice = InvoiceCheckService.invoiceDynamicObject2Invoice((DynamicObject)invoiceDynamicObject);
            long simpleAddressPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDynamicObject.get("simpleaddress"));
            if (simpleAddressPk != 0L && (adminDivision3 = BusinessDataServiceHelper.loadSingleFromCache((Object)simpleAddressPk, (String)"bdm_admindivision", (String)"name")) != null) {
                baseInvoice.setSimpleaddress(adminDivision3.getString("name"));
            }
            InvoiceCheckService.checkEleSpecialType((BaseInvoice)baseInvoice);
        }
    }

    private void checkFarmProduceSaleItems(AllEInvoiceRequestDTO invoiceDTO) {
        if (!"02".equals(invoiceDTO.getInvoiceType())) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u5f00\u5177\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968", (String)"InvoiceOpenAllEServiceImpl_17", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        List items = invoiceDTO.getInvoiceDetail();
        for (int i = 0; i < items.size(); ++i) {
            AllEInvoiceDetailDTO item = (AllEInvoiceDetailDTO)items.get(i);
            String taxRate = item.getTaxRate();
            String privilegeType = item.getPrivilegeType();
            BigDecimal taxRateDecimalValue = BigDecimal.TEN;
            try {
                taxRateDecimalValue = new BigDecimal(taxRate);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ("03".equals(privilegeType) && taxRateDecimalValue.compareTo(BigDecimal.ZERO) == 0) continue;
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u660e\u7ec6\u7a0e\u7387\u5fc5\u987b\u4e3a\uff1a0,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\uff1a\u514d\u7a0e\uff08\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u660e\u7ec6\u7a0e\u7387\u8981\u6c42\u5fc5\u987b\u4e3a\u514d\u7a0e\uff09", (String)"InvoiceOpenAllEServiceImpl_18", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1));
        }
    }

    public static String getCacheId(String key) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
        long id = cache.inc(key);
        return id + "";
    }
}

