/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.TaxAccountCheckVo;
import kd.imc.bdm.common.dto.allele.AllEleTaxAccountDto;
import kd.imc.bdm.common.dto.allele.CheckTaxAccountResponseDTO;
import kd.imc.bdm.common.dto.aws.AwsConfigDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.AES128;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class RpaCheckTaxAccountImpl
implements OpenApiService {
    protected static final Log LOGGER = LogFactory.getLog(RpaCheckTaxAccountImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        TaxAccountCheckVo taxAccountCheckVo = (TaxAccountCheckVo)JSON.parseObject((String)requestVo.getData(), TaxAccountCheckVo.class);
        if ("1".equals(taxAccountCheckVo.getIsXKData())) {
            return this.checkTaxAccountInTable(taxAccountCheckVo.getTaxNo());
        }
        return this.checkTaxAccountByTaxNo(taxAccountCheckVo.getTaxNo());
    }

    private ApiResult checkTaxAccountByTaxNo(String taxNo) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u7a0e\u53f7:[%s]\u67e5\u8be2\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4fe1\u606f", taxNo));
            }
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("taxNo", taxNo);
            AwsConfigDTO awsConfig = AllEleServiceHelper.getAwsConfig((String)taxNo);
            JSONObject retJson = AwsFpyService.newInstance().getAppJson("account_check", taxNo, param);
            LOGGER.info(String.format("\u89e3\u5bc6\u524d:[%s]\u4fe1\u606f", retJson));
            CheckTaxAccountResponseDTO checkTaxAccountResponseDTO = (CheckTaxAccountResponseDTO)JSON.parseObject((String)retJson.toJSONString(), CheckTaxAccountResponseDTO.class);
            LOGGER.info(String.format("\u89e3\u5bc6KEY:[%s]", awsConfig.getEncryptKey()));
            for (AllEleTaxAccountDto data : checkTaxAccountResponseDTO.getData()) {
                try {
                    JSONObject jsonObject = JSON.parseObject((String)AES128.ECBDecrypt((String)data.getEtaxAccount(), (String)awsConfig.getEncryptKey()));
                    data.setEtaxAccount(jsonObject.getString("account"));
                }
                catch (Exception e) {
                    LOGGER.info(String.format("\u89e3\u5bc6\u5931\u8d25:[%s]", e));
                    return ResponseVo.fail((String)ApiErrCodeEnum.ACCOUNT_CHECK_FAIL.getCode(), (String)ResManager.loadKDString((String)"\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bc6\u94a5\u914d\u7f6e", (String)"RpaCheckTaxAccountImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
            }
            if ("0000".equals(retJson.getString("errcode"))) {
                return ResponseVo.success((String)SerializationUtils.toJsonString((Object)checkTaxAccountResponseDTO.getData()));
            }
            LOGGER.error(String.format("\u7a0e\u53f7:[%s]\u67e5\u8be2\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4fe1\u606f\u5931\u8d25", taxNo));
            return ResponseVo.fail((String)ApiErrCodeEnum.ACCOUNT_CHECK_FAIL.getCode(), (String)checkTaxAccountResponseDTO.getDescription());
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u7a0e\u53f7:[%s]\u67e5\u8be2\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4fe1\u606f\u5931\u8d25", taxNo), (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ACCOUNT_CHECK_FAIL.getCode(), (String)e.getMessage());
        }
    }

    private ApiResult checkTaxAccountInTable(String taxNo) {
        try {
            QFilter filter = new QFilter("taxno", "=", (Object)taxNo);
            DynamicObject accountObject = BusinessDataServiceHelper.loadSingle((String)"bdm_einvoice_account", (String)String.join((CharSequence)",", "account", "accounttype", "isenable", "defaultbusiness", "isdefault"), (QFilter[])filter.toArray());
            if (accountObject == null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ACCOUNT_CHECK_NULL.getCode(), (String)ApiErrCodeEnum.ACCOUNT_CHECK_NULL.getMsg());
            }
            CheckTaxAccountResponseDTO checkTaxAccountResponseDTO = new CheckTaxAccountResponseDTO();
            ArrayList accountLists = Lists.newArrayListWithCapacity((int)0);
            DynamicObjectCollection dynamicObjectCollection = accountObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                AllEleTaxAccountDto account = new AllEleTaxAccountDto();
                account.setDefaultFlag(dynamicObject.getString("isdefault"));
                account.setDefaultType(StringUtils.isEmpty((CharSequence)dynamicObject.getString("defaultbusiness")) ? "0" : dynamicObject.getString("defaultbusiness"));
                account.setEtaxAccount(dynamicObject.getString("account"));
                account.setEtaxAccountType(dynamicObject.getString("accounttype"));
                account.setIsEnable(dynamicObject.getString("isenable"));
                accountLists.add(account);
            }
            checkTaxAccountResponseDTO.setData((List)accountLists);
            return ResponseVo.success((String)SerializationUtils.toJsonString((Object)checkTaxAccountResponseDTO.getData()));
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u7a0e\u53f7:[%s]\u67e5\u8be2\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4fe1\u606f\u5931\u8d25", taxNo), (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ACCOUNT_CHECK_FAIL.getCode(), (String)e.getMessage());
        }
    }
}

