/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.ShowTipsConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.ZzstsglEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.dto.AllEQuickRedRequestDTO;
import kd.imc.sim.formplugin.openapi.dto.AllEQuickRedRequestItemsDTO;
import kd.imc.sim.formplugin.openapi.service.impl.alle.constant.EInvoiceErrCodeEnum;
import kd.imc.sim.formplugin.openapi.service.impl.alle.constant.PartRedBlueItem;
import kd.imc.sim.formplugin.openapi.service.impl.alle.service.ApiRedService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public class PartRedService {
    private final Log log = LogFactory.getLog(PartRedService.class);

    public static void setAddrBankInfo(DynamicObject redConfirm, AllEQuickRedRequestDTO quickRequest) {
        String bueyerAddr = quickRequest.getBuyerAddress();
        String bueryTel = quickRequest.getBuyerTel();
        String buyerBank = quickRequest.getBuyerBank();
        String account = quickRequest.getBuyerBankAccount();
        String sellerAddress = quickRequest.getSellerAddress();
        String sellerTel = quickRequest.getSellerTel();
        String sellerBank = quickRequest.getSellerBank();
        String sellerAccount = quickRequest.getSellerBankAccount();
        if (StringUtils.isNotBlank((CharSequence)(bueyerAddr + bueryTel))) {
            redConfirm.set("buyeraddr", (Object)(bueyerAddr + bueryTel));
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerBank + account))) {
            redConfirm.set("buyerbank", (Object)(buyerBank + account));
        }
        if (StringUtils.isNotBlank((CharSequence)(sellerAddress + sellerTel))) {
            redConfirm.set("saleraddr", (Object)(sellerAddress + sellerTel));
        }
        if (StringUtils.isNotBlank((CharSequence)(sellerBank + sellerAccount))) {
            redConfirm.set("salerbank", (Object)(sellerBank + sellerAccount));
        }
    }

    public ApiResult doPartRed(DynamicObject blueInvoiceDO, String systemCode, AllEQuickRedRequestDTO quickRequest, SaleInfo saleInfo) {
        DynamicObject redConfirm;
        if ("01".equals(quickRequest.getRedReason())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0\u4e3a\u5f00\u7968\u6709\u8bef\u65f6\uff0c\u4e0d\u80fd\u90e8\u5206\u7ea2\u51b2", (String)"PartRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String errorMsg = this.dealCheckVessuelShipItemMethod(quickRequest, blueInvoiceDO);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
        }
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"", (QFilter[])new QFilter("billno", "=", (Object)quickRequest.getSerialNo()).toArray());
        if (redConfirms != null && redConfirms.length > 1) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_MORE_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_MORE_FAIL.getMsg(), quickRequest.getSerialNo()));
        }
        if (redConfirms != null && redConfirms.length == 1) {
            String totalRemark;
            redConfirm = redConfirms[0];
            redConfirm = BusinessDataServiceHelper.loadSingle((Object)redConfirm.getPkValue(), (String)"sim_red_confirm_bill");
            if (StringUtils.isNotBlank((CharSequence)quickRequest.getAccount())) {
                redConfirm.set("account", (Object)quickRequest.getAccount());
            }
            if (StringUtils.isNotBlank((CharSequence)(totalRemark = quickRequest.getRemark()))) {
                redConfirm.set("remark", (Object)totalRemark);
            }
            PartRedService.setAddrBankInfo(redConfirm, quickRequest);
            String redConfirmBillNo = redConfirm.getString("billno");
            if (StringUtils.isEmpty((CharSequence)redConfirmBillNo)) {
                redConfirm.set("billno", (Object)quickRequest.getSerialNo());
            } else if (!redConfirmBillNo.equals(quickRequest.getSerialNo()) && !"4".equals(redConfirm.getString("source"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_FAIL.getMsg(), redConfirmBillNo));
            }
        } else {
            quickRequest.setOriginalIssueTime(blueInvoiceDO.getString("issuetime"));
            quickRequest.setOriginalInvoiceAmount(blueInvoiceDO.getBigDecimal("invoiceamount"));
            quickRequest.setOriginalTotalTaxAmount(blueInvoiceDO.getBigDecimal("totaltax"));
            redConfirm = DynamicObjectUtil.bean2DynamicObject((Object)quickRequest, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill"));
            redConfirm.set("billno", (Object)quickRequest.getSerialNo());
            DynamicObjectCollection items = redConfirm.getDynamicObjectCollection("items");
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject item = (DynamicObject)items.get(i);
                String privilegeType = item.getString("zzstsgl");
                if (StringUtils.isEmpty((CharSequence)privilegeType)) continue;
                item.set("taxpremark", (Object)"1");
                String descriptionByCode = ZzstsglEnum.getDescriptionByCode((String)privilegeType);
                if (descriptionByCode.contains("\u6709\u8bef")) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"PartRedService_6", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, descriptionByCode));
                }
                item.set("zzstsgl", (Object)descriptionByCode);
            }
            PartRedService.setAddrBankInfo(redConfirm, quickRequest);
            DynamicObject org = TaxUtils.getOrgDynamicObject((Long)saleInfo.getOrgId());
            this.buildRedConfirmMain(systemCode, quickRequest, saleInfo, redConfirm, org, blueInvoiceDO);
            this.buildRedConfirmTravelerItem(redConfirm, blueInvoiceDO);
            this.buildRedConfirmVesselShipItem(redConfirm, blueInvoiceDO);
            if (StringUtils.isBlank((CharSequence)redConfirm.getString("drawer"))) {
                redConfirm.set("drawer", (Object)blueInvoiceDO.getString("drawer"));
            }
            if (StringUtils.isBlank((CharSequence)redConfirm.getString("buyername"))) {
                redConfirm.set("buyername", (Object)blueInvoiceDO.getString("buyername"));
            }
            if (StringUtils.isBlank((CharSequence)redConfirm.getString("buyertaxno"))) {
                redConfirm.set("buyertaxno", (Object)blueInvoiceDO.getString("buyertaxno"));
            }
            redConfirm.set("buyerproperty", (Object)blueInvoiceDO.getString("buyerproperty"));
            this.buildRedConfirmItem(blueInvoiceDO, quickRequest.getInvoiceDetail(), quickRequest.getRedReason(), redConfirm);
        }
        return this.commitRedConfirmAndIssueInvoice(blueInvoiceDO, quickRequest, redConfirm, redConfirm.getDynamicObject("org"));
    }

    private String dealCheckVessuelShipItemMethod(AllEQuickRedRequestDTO quickRequest, DynamicObject blueInvoiceDO) {
        String specialType = quickRequest.getSpecialType();
        if (this.log.isInfoEnabled()) {
            this.log.info("dealCheckVessuelShipItemMethod, specialType:{}", (Object)specialType);
        }
        boolean isMatch = false;
        if (StringUtils.isBlank((CharSequence)specialType)) {
            specialType = blueInvoiceDO.getString("specialtype");
            if ("E07".equals(specialType)) {
                isMatch = true;
            }
        } else if (InvoiceSpecialType.InvoiceSpecialTypeEnum.VESSEL_VEHICHE.getLqCode().equals(specialType)) {
            isMatch = true;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("dealCheckVessuelShipItemMethod, isMatch:{}, specialType:{}", (Object)isMatch, (Object)specialType);
        }
        if (isMatch) {
            boolean flag = false;
            List<AllEQuickRedRequestItemsDTO> invoiceDetailList = quickRequest.getInvoiceDetail();
            for (AllEQuickRedRequestItemsDTO redRequestItemsDTO : invoiceDetailList) {
                String unit = redRequestItemsDTO.getUnits();
                int lineProperty = redRequestItemsDTO.getLineProperty();
                this.log.info("dealCheckVessuelShipItemMethod, unit:{}, lineProperty:{}", (Object)unit, (Object)lineProperty);
                if (0 != lineProperty && 2 != lineProperty || "\u8f86".equals(unit)) continue;
                flag = true;
                break;
            }
            if (flag) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"PartRedService_5", (String)"imc-sim-webapi", (Object[])new Object[0]), quickRequest.getSerialNo());
                return errorMsg;
            }
        }
        return null;
    }

    private void buildRedConfirmTravelerItem(DynamicObject redConfirm, DynamicObject blueInvoiceDo) {
        Long pkId = blueInvoiceDo.getLong("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_vatinvoice");
        DynamicObjectCollection travelerCollection = dynamicObject.getDynamicObjectCollection("travelers");
        if (travelerCollection == null || travelerCollection.isEmpty()) {
            return;
        }
        DynamicObjectCollection redConfirmTravelerCollection = redConfirm.getDynamicObjectCollection("travelers");
        redConfirmTravelerCollection.clear();
        for (DynamicObject travelerObject : travelerCollection) {
            DynamicObject travelerItem = redConfirmTravelerCollection.addNew();
            travelerItem.set("traveler", (Object)travelerObject.getString("traveler"));
            travelerItem.set("travelercardtype", (Object)travelerObject.getString("travelercardtype"));
            travelerItem.set("travelercardno", (Object)travelerObject.getString("travelercardno"));
            travelerItem.set("traveldate", (Object)travelerObject.getDate("traveldate"));
            travelerItem.set("travelerstartplace", (Object)travelerObject.getString("travelerstartplace"));
            travelerItem.set("travelerendplace", (Object)travelerObject.getString("travelerendplace"));
            travelerItem.set("travelertransporttype", (Object)travelerObject.getString("travelertransporttype"));
            travelerItem.set("travelerseatclass", (Object)travelerObject.getString("travelerseatclass"));
        }
    }

    private void buildRedConfirmVesselShipItem(DynamicObject redConfirm, DynamicObject blueInvoiceDo) {
        Long pkId = blueInvoiceDo.getLong("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_vatinvoice");
        DynamicObjectCollection vesselShipCollection = dynamicObject.getDynamicObjectCollection("vehichevesselships");
        if (vesselShipCollection == null || vesselShipCollection.isEmpty()) {
            return;
        }
        DynamicObjectCollection redConfirmVesselShipCollection = redConfirm.getDynamicObjectCollection("vehichevesselships");
        redConfirmVesselShipCollection.clear();
        for (DynamicObject vesselShipObject : vesselShipCollection) {
            DynamicObject vesselShipItem = redConfirmVesselShipCollection.addNew();
            vesselShipItem.set("policyno", (Object)vesselShipObject.getString("policyno"));
            vesselShipItem.set("shipsno", (Object)vesselShipObject.getString("shipsno"));
            vesselShipItem.set("vehiclecode", (Object)vesselShipObject.getString("vehiclecode"));
            vesselShipItem.set("perioddate", (Object)vesselShipObject.getString("perioddate"));
            vesselShipItem.set("periodstartdate", (Object)vesselShipObject.getDate("periodstartdate"));
            vesselShipItem.set("periodenddate", (Object)vesselShipObject.getDate("periodenddate"));
            vesselShipItem.set("vehiclevesselamount", (Object)vesselShipObject.getBigDecimal("vehiclevesselamount"));
            vesselShipItem.set("vehiclelateamount", (Object)vesselShipObject.getBigDecimal("vehiclelateamount"));
            vesselShipItem.set("vehicletotalamount", (Object)vesselShipObject.getBigDecimal("vehicletotalamount"));
        }
    }

    public void buildRedConfirmItem(DynamicObject blueInvoiceDO, List<AllEQuickRedRequestItemsDTO> requestItemsDTOS, String redReason, DynamicObject redConfirm) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        DynamicObjectCollection blueInvoiceItems = blueInvoiceDO.getDynamicObjectCollection("items");
        DynamicObjectCollection redConfirmBillItems = redConfirm.getDynamicObjectCollection("items");
        redConfirmBillItems.clear();
        boolean blueItemStartZero = blueInvoiceItems.stream().anyMatch(item -> 0 == item.getInt("seq"));
        HashMap<Object, BigDecimal> remainAmountMap = new HashMap<Object, BigDecimal>();
        for (int j = 0; j < requestItemsDTOS.size(); ++j) {
            AllEQuickRedRequestItemsDTO redItemDto = requestItemsDTOS.get(j);
            String redTaxRate = redItemDto.getTaxRate();
            String redGoodsName = redItemDto.getGoodsName();
            String redRevenueCode = redItemDto.getRevenueCode();
            BigDecimal redAmount = redItemDto.getAmount();
            BigDecimal redTax = redItemDto.getTaxAmount();
            BigDecimal redPrice = BigDecimal.ZERO;
            BigDecimal redNum = BigDecimal.ZERO;
            boolean isSellerReason = false;
            if ("04".equals(redReason)) {
                isSellerReason = true;
            }
            if (!StringUtils.isEmpty((CharSequence)redItemDto.getPrice())) {
                redPrice = new BigDecimal(redItemDto.getPrice());
            }
            if (!StringUtils.isEmpty((CharSequence)redItemDto.getQuantity())) {
                redNum = new BigDecimal(redItemDto.getQuantity());
            }
            ApiRedService.checkRedItem(j, redItemDto);
            redTax = MathUtils.isZero((BigDecimal)redTax) ? redAmount.multiply(new BigDecimal(redTaxRate)).setScale(2, RoundingMode.HALF_UP) : redTax.setScale(2, RoundingMode.HALF_UP);
            ArrayList<PartRedBlueItem> partRedBlueItemList = new ArrayList<PartRedBlueItem>();
            ArrayList<PartRedBlueItem> partRedBlueItemListSellerReason = new ArrayList<PartRedBlueItem>();
            for (int i = 0; i < blueInvoiceItems.size(); ++i) {
                DynamicObject blueInvoiceItem = (DynamicObject)blueInvoiceItems.get(i);
                BigDecimal itemRemainRedAmount = blueInvoiceItem.getBigDecimal("itemremainredamount");
                if (MathUtils.isZero((BigDecimal)itemRemainRedAmount) || redAmount.abs().compareTo(blueInvoiceItem.getBigDecimal("itemremainredamount")) > 0) continue;
                if (remainAmountMap.containsKey(blueInvoiceItem.get("id"))) {
                    if (MathUtils.isZero((BigDecimal)remainAmountMap.get(blueInvoiceItem.get("id")))) {
                        continue;
                    }
                } else {
                    remainAmountMap.put(blueInvoiceItem.get("id"), itemRemainRedAmount);
                }
                BigDecimal blueItemNum = blueInvoiceItem.getBigDecimal("num");
                String blueItemGoodsName = blueInvoiceItem.getString("goodsname");
                String blueItemGoodsNameRight = blueItemGoodsName.substring(blueItemGoodsName.indexOf(42, 2) + 1);
                String blueItemTaxRate = blueInvoiceItem.getString("taxrate");
                String blueItemGoodsCode = blueInvoiceItem.getString("goodscode");
                BigDecimal blueItemUnitPrice = blueInvoiceItem.getBigDecimal("unitprice");
                if ("2".equals(blueInvoiceItem.getString("rowtype")) && !MathUtils.isZero((BigDecimal)blueItemUnitPrice)) {
                    DynamicObject zkItem = (DynamicObject)blueInvoiceItems.get(i + 1);
                    BigDecimal amount = blueInvoiceItem.getBigDecimal("amount").add(zkItem.getBigDecimal("amount"));
                    blueItemUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)blueItemNum, (boolean)Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((CharSequence)redItemDto.getOriginalSeq())) {
                    int seq = blueInvoiceItem.getInt("seq");
                    if (!blueItemStartZero) {
                        --seq;
                    }
                    if (!String.valueOf(seq).equals(redItemDto.getOriginalSeq())) continue;
                    if ("1".equals(blueInvoiceItem.getString("rowtype"))) {
                        throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20040.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"PartRedService_1", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, EInvoiceErrCodeEnum.AllE_RED_20040.getMsg()));
                    }
                    if (!blueItemTaxRate.equals(redTaxRate)) {
                        throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20038.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"PartRedService_1", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, EInvoiceErrCodeEnum.AllE_RED_20038.getMsg()));
                    }
                    this.addMatchBlueItem(redAmount, partRedBlueItemList, blueInvoiceItem, blueItemUnitPrice);
                    break;
                }
                if (isSellerReason) {
                    if (!MathUtils.isZero((BigDecimal)redPrice)) {
                        if (blueItemGoodsNameRight.equals(redGoodsName) && blueItemTaxRate.equals(redTaxRate) && blueItemGoodsCode.equals(redRevenueCode) && blueItemUnitPrice.compareTo(redPrice) == 0) {
                            this.addMatchBlueItem(redAmount, partRedBlueItemList, blueInvoiceItem, blueItemUnitPrice);
                            continue;
                        }
                        if (!blueItemGoodsNameRight.equals(redGoodsName) || !blueItemTaxRate.equals(redTaxRate) || !blueItemGoodsCode.equals(redRevenueCode)) continue;
                        this.addMatchBlueItem(redAmount, partRedBlueItemListSellerReason, blueInvoiceItem, blueItemUnitPrice);
                        continue;
                    }
                    if (!blueItemGoodsNameRight.equals(redGoodsName) || !blueItemTaxRate.equals(redTaxRate) || !blueItemGoodsCode.equals(redRevenueCode)) continue;
                    this.addMatchBlueItem(redAmount, partRedBlueItemList, blueInvoiceItem, BigDecimal.ZERO);
                    continue;
                }
                if (!blueItemGoodsNameRight.equals(redGoodsName) || !blueItemTaxRate.equals(redTaxRate) || !blueItemGoodsCode.equals(redRevenueCode) || blueItemUnitPrice.compareTo(redPrice) != 0) continue;
                this.addMatchBlueItem(redAmount, partRedBlueItemList, blueInvoiceItem, blueItemUnitPrice);
            }
            if (isSellerReason) {
                if (partRedBlueItemList.isEmpty()) {
                    partRedBlueItemList.addAll(partRedBlueItemListSellerReason);
                }
                redItemDto.setPrice("");
                redItemDto.setQuantity("");
                redPrice = BigDecimal.ZERO;
                redNum = BigDecimal.ZERO;
            }
            if (partRedBlueItemList.isEmpty()) {
                throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20023.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"PartRedService_1", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, EInvoiceErrCodeEnum.AllE_RED_20023.getMsg()));
            }
            PartRedBlueItem matchBlueItem = this.getMatchBlueItem(remainAmountMap, redAmount, partRedBlueItemList, j);
            if (redAmount.abs().compareTo(matchBlueItem.getBlueItem().getBigDecimal("itemremainredamount")) > 0) {
                throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20027.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"PartRedService_1", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, EInvoiceErrCodeEnum.AllE_RED_20027.getMsg()));
            }
            if (StringUtils.isNotEmpty((CharSequence)redItemDto.getOriginalSeq()) && MathUtils.isZero((BigDecimal)redPrice) && !MathUtils.isZero((BigDecimal)redNum)) {
                redPrice = matchBlueItem.getBlueItemUnitPrice();
            }
            this.buildRedItem(blueInvoiceDO, redConfirmBillItems.addNew(), redItemDto, matchBlueItem.getBlueItemUnitPrice(), redAmount, redPrice, redNum, redTax, matchBlueItem.getBlueItem());
            Object minBlueId = matchBlueItem.getBlueItem().get("id");
            remainAmountMap.put(minBlueId, remainAmountMap.get(minBlueId).add(redAmount));
            totalAmount = totalAmount.add(redAmount);
            totalTax = totalTax.add(redTax);
        }
        this.mergeRedItem(redConfirmBillItems);
        redConfirm.set("originalissuetime", blueInvoiceDO.get("issuetime"));
        redConfirm.set("originalinvoicetype", (Object)blueInvoiceDO.getString("invoicetype"));
        redConfirm.set("originalinvoiceamount", blueInvoiceDO.get("invoiceamount"));
        redConfirm.set("originaltotaltax", blueInvoiceDO.get("totaltax"));
        redConfirm.set("invoiceamount", (Object)totalAmount);
        redConfirm.set("totalamount", (Object)totalAmount.add(totalTax));
        redConfirm.set("totaltax", (Object)totalTax);
    }

    private PartRedBlueItem getMatchBlueItem(HashMap<Object, BigDecimal> remainAmountMap, BigDecimal redAmount, ArrayList<PartRedBlueItem> partRedBlueItemList, int j) {
        if (partRedBlueItemList.isEmpty()) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20042.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"PartRedService_1", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, EInvoiceErrCodeEnum.AllE_RED_20042.getMsg()));
        }
        PartRedBlueItem max = Collections.max(partRedBlueItemList, Comparator.comparing(PartRedBlueItem::getItemRemainAmount));
        BigDecimal realBlueItemRemainAmount = remainAmountMap.get(max.getBlueItem().get("id"));
        if (realBlueItemRemainAmount.add(redAmount).compareTo(BigDecimal.ZERO) < 0) {
            partRedBlueItemList.remove(max);
            max = this.getMatchBlueItem(remainAmountMap, redAmount, partRedBlueItemList, j);
        }
        return max;
    }

    public void addMatchBlueItem(BigDecimal redAmount, ArrayList<PartRedBlueItem> partRedBlueItemList, DynamicObject blueInvoiceItem, BigDecimal blueItemUnitPrice) {
        PartRedBlueItem partRedBlueItem = new PartRedBlueItem();
        partRedBlueItem.setRedAmount(redAmount);
        partRedBlueItem.setBlueItem(blueInvoiceItem);
        partRedBlueItem.setBlueItemUnitPrice(blueItemUnitPrice);
        partRedBlueItem.setItemRemainAmount(blueInvoiceItem.getBigDecimal("itemremainredamount"));
        partRedBlueItem.setBlueItemNum(blueInvoiceItem.getBigDecimal("num"));
        partRedBlueItemList.add(partRedBlueItem);
    }

    private void buildRedItem(DynamicObject blueInvoice, DynamicObject redConfirmBillItem, AllEQuickRedRequestItemsDTO redItemDto, BigDecimal blueUnitPrice, BigDecimal redAmount, BigDecimal redPrice, BigDecimal redNum, BigDecimal redTax, DynamicObject blueInvoiceItem) {
        boolean startZero = blueInvoice.getDynamicObjectCollection("items").stream().anyMatch(item -> 0 == item.getInt("seq"));
        redConfirmBillItem.set("originseq", (Object)(startZero ? blueInvoiceItem.getInt("seq") + 1 : blueInvoiceItem.getInt("seq")));
        redConfirmBillItem.set("originalinvoiceitemid", blueInvoiceItem.getPkValue());
        redConfirmBillItem.set("rowtype", (Object)"0");
        redConfirmBillItem.set("goodscode", (Object)redItemDto.getRevenueCode());
        redConfirmBillItem.set("goodsname", (Object)blueInvoiceItem.getString("goodsname"));
        redConfirmBillItem.set("specification", (Object)redItemDto.getSpecification());
        redConfirmBillItem.set("unit", (Object)redItemDto.getUnits());
        redConfirmBillItem.set("taxpremark", (Object)blueInvoiceItem.getString("taxpremark"));
        redConfirmBillItem.set("zzstsgl", (Object)blueInvoiceItem.getString("zzstsgl"));
        redConfirmBillItem.set("amount", (Object)redAmount.setScale(2, RoundingMode.HALF_UP));
        redConfirmBillItem.set("tax", (Object)redTax);
        redConfirmBillItem.set("taxrate", (Object)redItemDto.getTaxRate());
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)blueInvoice.getString("invoicetype")) || "1".equals(blueInvoice.getString("iselepaper"));
        this.updateBlueItemRemainAmount(blueInvoiceItem, blueUnitPrice, redPrice, redAmount, redNum, redTax, redConfirmBillItem, isAllEle);
    }

    private void updateBlueItemRemainAmount(DynamicObject blueInvoiceItem, BigDecimal blueUnitPrice, BigDecimal redPrice, BigDecimal redAmount, BigDecimal redNum, BigDecimal redTax, DynamicObject redConfirmBillItem, boolean isAllEle) {
        if (!MathUtils.isZero((BigDecimal)blueUnitPrice) && !MathUtils.isZero((BigDecimal)redPrice)) {
            BigDecimal itemRemainRedNum = blueInvoiceItem.getBigDecimal("itemremainrednum");
            BigDecimal itemRemainRedAmount = blueInvoiceItem.getBigDecimal("itemremainredamount");
            BigDecimal blueRemainAmount = blueUnitPrice.multiply(itemRemainRedNum).setScale(2, RoundingMode.HALF_UP);
            BigDecimal amountDiffer = blueRemainAmount.subtract(itemRemainRedAmount).abs();
            if (amountDiffer.compareTo(InvoiceConstant.DIFF_01) > 0) {
                redPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemRemainRedAmount, (BigDecimal)itemRemainRedNum, (boolean)isAllEle);
                redNum = UnitPriceHelper.calcNum((BigDecimal)redAmount, (BigDecimal)redPrice);
            }
        }
        BigDecimal redIncludeTaxAmount = redAmount.add(redTax);
        redConfirmBillItem.set("taxamount", (Object)redIncludeTaxAmount);
        redConfirmBillItem.set("unitprice", (Object)redPrice);
        redConfirmBillItem.set("num", (Object)redNum);
        if (!MathUtils.isZero((BigDecimal)redNum) && !MathUtils.isZero((BigDecimal)redPrice)) {
            BigDecimal taxUnitPrice = redPrice.multiply(BigDecimal.ONE.add(new BigDecimal(redConfirmBillItem.getString("taxrate")))).setScale(8, 4);
            redConfirmBillItem.set("taxunitprice", (Object)taxUnitPrice);
        }
    }

    private void buildRedConfirmMain(String systemCode, AllEQuickRedRequestDTO quickRequest, SaleInfo saleInfo, DynamicObject redConfirm, DynamicObject org, DynamicObject blueInvoiceDO) {
        redConfirm.set("orderno", (Object)UUID.randomUUID());
        redConfirm.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
        redConfirm.set("systemsource", (Object)systemCode);
        redConfirm.set("source", (Object)"4");
        redConfirm.set("enteridentity", (Object)"0");
        redConfirm.set("applicant", (Object)"2");
        if (StringUtils.isNotBlank((CharSequence)quickRequest.getRemark())) {
            redConfirm.set("remark", (Object)quickRequest.getRemark());
        }
        if (StringUtils.isEmpty((CharSequence)quickRequest.getSellerTaxpayerId())) {
            redConfirm.set("salername", (Object)saleInfo.getSaleName());
            redConfirm.set("salertaxno", (Object)saleInfo.getSaleTaxNo());
        } else if (StringUtils.isEmpty((CharSequence)quickRequest.getSellerName())) {
            redConfirm.set("salername", (Object)saleInfo.getSaleName());
        }
        if (StringUtils.isNotBlank((CharSequence)quickRequest.getBuyerRecipientPhone()) || StringUtils.isNotBlank((CharSequence)quickRequest.getBuyerRecipientMail())) {
            redConfirm.set("buyerphone", (Object)quickRequest.getBuyerRecipientPhone());
            redConfirm.set("buyeremail", (Object)quickRequest.getBuyerRecipientMail());
        }
        redConfirm.set("enable", (Object)"1");
        redConfirm.set("status", (Object)"D");
        redConfirm.set("creator", (Object)RequestContext.get().getUserId());
        redConfirm.set("org", (Object)org);
        redConfirm.set("useorg", (Object)org);
        redConfirm.set("createorg", (Object)org);
        redConfirm.set("ctrlstrategy", (Object)"7");
        redConfirm.set("originalinvoicecode", (Object)quickRequest.getInvoiceCode());
        redConfirm.set("originalinvoiceno", (Object)quickRequest.getInvoiceNo());
        redConfirm.set("invoiceno", (Object)"");
        redConfirm.set("hsbz", (Object)"0");
        redConfirm.set("issuestatus", (Object)"2");
        redConfirm.set("uploadstatus", (Object)"0");
        redConfirm.set("redreason", (Object)quickRequest.getRedReason());
        if (StringUtils.equals((CharSequence)quickRequest.getInvoiceType(), (CharSequence)InvoiceType.ALL_E_SPECIAL.getLqptCode())) {
            redConfirm.set("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
        } else if (StringUtils.equals((CharSequence)quickRequest.getInvoiceType(), (CharSequence)InvoiceType.ALL_E_NORMAL.getLqptCode())) {
            redConfirm.set("invoicetype", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
        }
        String specialType = StringUtils.isEmpty((CharSequence)quickRequest.getSpecialType()) ? "00" : quickRequest.getSpecialType();
        redConfirm.set("specialtype", (Object)blueInvoiceDO.getString("specialtype"));
        this.log.info("buildRedConfirmMain, quickRequest-specialType:{}, lqCode:{}", (Object)quickRequest.getSpecialType(), (Object)InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeByLqCode((String)quickRequest.getSpecialType()));
        redConfirm.set("originalspecialtype", (Object)(StringUtils.isEmpty((CharSequence)specialType) ? "00" : specialType));
        if (StringUtils.isEmpty((CharSequence)quickRequest.getOriginalIssueTime())) {
            throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"PartRedService_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        try {
            Date originalIssueTime = DateUtils.stringToDate((String)quickRequest.getOriginalIssueTime(), (String)"yyyy-MM-dd HH:mm:ss");
            redConfirm.set("originalissuetime", (Object)originalIssueTime);
        }
        catch (Exception e) {
            this.log.error("\u6570\u7535\u90e8\u5206\u7ea2\u51b2\uff0c\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f\u7684\u65f6\u95f4\u683c\u5f0f\u5fc5\u987b\u4e3a\u201cYYYY-MM-DD HH:MM:SS\u201d", (String)"PartRedService_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        switch (specialType) {
            case "06": {
                break;
            }
            case "03": {
                break;
            }
            case "05": {
                break;
            }
        }
        redConfirm.set("interfacecode", (Object)OpenApiInterfaceCodeEnum.ALLE_INVOICE_RED.getCode());
    }

    private ApiResult commitRedConfirmAndIssueInvoice(DynamicObject blueInvoiceDO, AllEQuickRedRequestDTO quickRequest, DynamicObject redConfirm, DynamicObject org) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirm}, null);
        if (!operationResult.isSuccess()) {
            throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
        }
        if (!"1".equals(redConfirm.getString("uploadstatus")) || RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirm.getString("confirmstatus"))) {
            try {
                ApiResult result = RedConfirmBillHelper.submit((DynamicObject)redConfirm);
                if (result != null) {
                    this.log.info("\u90e8\u5206\u7ea2\u51b2\uff0c\u5220\u9664\u7ea2\u5b57\u786e\u8ba4\u5355\uff1a" + redConfirm.getPkValue());
                    return result;
                }
            }
            catch (MsgException e) {
                this.log.info("\u90e8\u5206\u7ea2\u51b2\uff0c\u5220\u9664\u7ea2\u5b57\u786e\u8ba4\u5355\uff1a" + redConfirm.getPkValue());
                throw e;
            }
        }
        String confirmStatus = redConfirm.getString("confirmstatus");
        if (!RedConfirmStatusEnum.NO_CONFIRM.getBillCode().equals(confirmStatus) && !RedConfirmStatusEnum.ALL_CONFIRM.getBillCode().equals(confirmStatus)) {
            return ApiRedService.createReturnFail(redConfirm);
        }
        this.log.info("\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u5e76\u4e14\u7a0e\u5c40\u8fd4\u56de\u65e0\u9700\u786e\u8ba4\uff1a{}", (Object)redConfirm.getString("number"));
        DynamicObject redDynamicObject = this.redConfirmToInvoice(org, redConfirm, quickRequest);
        DynamicObject epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)redDynamicObject.getString("salertaxno")).toArray());
        boolean isExist = ApiAllEHelper.checkIssueInvoicePermission((DynamicObject)epInfo);
        if (!isExist) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), String.format(ShowTipsConstant.getTAXNO_UN_AUTH(), redDynamicObject.getString("salertaxno")));
        }
        ApiResult loginResult = ApiAllEHelper.alleLoginCheck((String)redDynamicObject.getString("salertaxno"), (String)"");
        if (loginResult != null) {
            throw new MsgException(loginResult.getErrorCode(), loginResult.getMessage());
        }
        redDynamicObject.set("redreason", redConfirm.get("redreason"));
        redDynamicObject.set("infocode", redConfirm.get("number"));
        redDynamicObject.set("govuuid", redConfirm.get("govuuid"));
        redDynamicObject.set("buyertype", (Object)"3");
        redDynamicObject.set("cardtype", blueInvoiceDO.get("cardtype"));
        ImcSaveServiceHelper.save((DynamicObject)redDynamicObject);
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{redDynamicObject});
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ea2\u51b2\u6210\u529f", (String)"PartRedService_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    public DynamicObject redConfirmToInvoice(DynamicObject org, DynamicObject redConfirm, AllEQuickRedRequestDTO requestDTO) {
        DynamicObject redDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)redConfirm, (DynamicObject)redDynamicObject);
        redDynamicObject.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        redDynamicObject.set("orgid", (Object)org);
        redDynamicObject.set("thirdserialno", redConfirm.get("govuuid"));
        redDynamicObject.set("govuuid", redConfirm.get("govuuid"));
        redDynamicObject.set("infocode", (Object)redConfirm.getString("number"));
        redDynamicObject.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
        redDynamicObject.set("createtime", (Object)new Date());
        redDynamicObject.set("invoicecode", (Object)"");
        redDynamicObject.set("invoiceno", (Object)"");
        redDynamicObject.set("checkcode", (Object)"");
        redDynamicObject.set("skm", (Object)"");
        redDynamicObject.set("issuetime", null);
        redDynamicObject.set("taxedtype", (Object)"0");
        redDynamicObject.set("invoicestatus", null);
        redDynamicObject.set("issuewritebackstatus", (Object)"0");
        redDynamicObject.set("issuewritebackreason", (Object)"");
        redDynamicObject.set("abolishwritebackstatus", (Object)"2");
        redDynamicObject.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        redDynamicObject.set("invoicestatus", null);
        redDynamicObject.set("saleraddr", (Object)redConfirm.getString("saleraddr"));
        redDynamicObject.set("salerbank", (Object)redConfirm.getString("salerbank"));
        redDynamicObject.set("buyeraddr", (Object)redConfirm.getString("buyeraddr"));
        redDynamicObject.set("buyerbank", (Object)redConfirm.getString("buyerbank"));
        if (StringUtils.isNotBlank((CharSequence)requestDTO.getBuyerRecipientPhone()) || StringUtils.isNotBlank((CharSequence)requestDTO.getBuyerRecipientMail())) {
            redDynamicObject.set("buyerphone", (Object)StringUtils.trimToEmpty((String)requestDTO.getBuyerRecipientPhone()));
            redDynamicObject.set("buyeremail", (Object)StringUtils.trimToEmpty((String)requestDTO.getBuyerRecipientMail()));
        }
        if (StringUtils.isEmpty((CharSequence)requestDTO.getBuyerProperty())) {
            redDynamicObject.set("buyerproperty", (Object)"0");
        } else {
            redDynamicObject.set("buyerproperty", (Object)requestDTO.getBuyerProperty());
        }
        redDynamicObject.set("datahash", (Object)OpenApiInterfaceCodeEnum.ALLE_INVOICE_RED.getCode());
        redDynamicObject.set("remainredamount", (Object)BigDecimal.ZERO);
        redDynamicObject.set("canredtaxamount", (Object)BigDecimal.ZERO);
        redDynamicObject.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        return redDynamicObject;
    }

    public void mergeRedItem(DynamicObjectCollection redConfirmBillItems) {
        boolean hasRepeatItem = false;
        HashMap<String, DynamicObject> mergeHashMap = new HashMap<String, DynamicObject>();
        for (int i = 0; i < redConfirmBillItems.size(); ++i) {
            DynamicObject redConfirmBillItem = (DynamicObject)redConfirmBillItems.get(i);
            redConfirmBillItem.set("seq", (Object)(i + 1));
            String blueItemId = redConfirmBillItem.get("originalinvoiceitemid") + "";
            if (mergeHashMap.containsKey(blueItemId)) {
                DynamicObject mapRedItem = (DynamicObject)mergeHashMap.get(blueItemId);
                mapRedItem.set("amount", (Object)mapRedItem.getBigDecimal("amount").add(redConfirmBillItem.getBigDecimal("amount")));
                mapRedItem.set("tax", (Object)mapRedItem.getBigDecimal("tax").add(redConfirmBillItem.getBigDecimal("tax")));
                mapRedItem.set("taxamount", (Object)mapRedItem.getBigDecimal("taxamount").add(redConfirmBillItem.getBigDecimal("taxamount")));
                mapRedItem.set("num", (Object)mapRedItem.getBigDecimal("num").add(redConfirmBillItem.getBigDecimal("num")));
                hasRepeatItem = true;
                continue;
            }
            mergeHashMap.put(blueItemId, redConfirmBillItem);
        }
        if (hasRepeatItem) {
            redConfirmBillItems.clear();
            for (Map.Entry entry : mergeHashMap.entrySet()) {
                redConfirmBillItems.add(entry.getValue());
            }
            for (int i = 0; i < redConfirmBillItems.size(); ++i) {
                ((DynamicObject)redConfirmBillItems.get(i)).set("seq", (Object)(i + 1));
            }
        }
    }
}

