/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class BillCheckServiceImpl
implements OpenApiService {
    private static final Log LOG = LogFactory.getLog(BillCheckServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject paramObject = JSONObject.parseObject((String)requestVo.getData());
        LOG.info("\u7edf\u8ba1\u5f00\u666e\u7968\u4e0e\u4e13\u7968\u7684\u5904\u7406\u8bf7\u6c42\u53c2\u6570:{}", (Object)paramObject);
        JSONArray billNos = paramObject.getJSONArray("billNos");
        if (billNos == null || billNos.isEmpty()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ArrayList<String> billList = new ArrayList<String>(billNos.size());
        for (int i = 0; i < billNos.size(); ++i) {
            billList.add(billNos.getString(i));
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        QFilter qFilter = new QFilter("billno", "in", billList);
        DynamicObject[] dynamicObjects = billCenterInvoiceCommonService.getBillCenterData(qFilter);
        if (dynamicObjects.length < 1) {
            String errorMsg = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u8d26\u5355\u4e2d\u5fc3\u6570\u636e\uff01", (String)"BillCreateServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
        }
        HashMap errorMsgMap = new HashMap(16);
        HashMap groupAmountMap = new HashMap(16);
        billCenterInvoiceCommonService.dealGruopItemAmountMethod(dynamicObjects, errorMsgMap, groupAmountMap);
        if (!errorMsgMap.isEmpty()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)((String)errorMsgMap.get("errorMsg")));
        }
        JSONObject returnObject = new JSONObject();
        returnObject.put("totalAmount", groupAmountMap.get("totalAmount"));
        BigDecimal normalInvoiceAmount = groupAmountMap.containsKey(InvoiceType.ALL_E_NORMAL.getTypeCode()) ? (BigDecimal)groupAmountMap.get(InvoiceType.ALL_E_NORMAL.getTypeCode()) : BigDecimal.ZERO;
        returnObject.put("normalInvoiceAmount", (Object)normalInvoiceAmount);
        BigDecimal specialInvoiceAmount = groupAmountMap.containsKey(InvoiceType.ALL_E_SPECIAL.getTypeCode()) ? (BigDecimal)groupAmountMap.get(InvoiceType.ALL_E_SPECIAL.getTypeCode()) : BigDecimal.ZERO;
        returnObject.put("specialInvoiceAmount", (Object)specialInvoiceAmount);
        String resultData = returnObject.toJSONString();
        LOG.info("BillCheckServiceImpl, resultData:{}", (Object)resultData);
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u6210\u529f", (String)"BillCreateServiceImpl_16", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)returnObject);
    }
}

