/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.constant.ApiConfig;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceTypeNewEnum;
import kd.imc.bdm.common.dto.AgriculGoodsInfoVo;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.dto.BillDetailNewVo;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillNewVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.dto.EstateSaleCoBuyer;
import kd.imc.bdm.common.dto.EstateSaleInfo;
import kd.imc.bdm.common.dto.OriginInvoiceInfoVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleInfoVo;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.InvItemConfigHelper;
import kd.imc.bdm.common.helper.InvTitleSettingHelper;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.constant.ValidTypeEnum;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.InvTitleMatchHelper;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp;
import kd.imc.sim.common.helper.OriginalBillValidateHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillValidResultController;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.formplugin.openapi.service.impl.bill.BillPushServiceImpl;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import kd.imc.sim.scan.ImacScanService;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BillPushNewServiceImpl
extends BillPushServiceImpl {
    private static final Log LOGGER = LogFactory.getLog(BillPushNewServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult processer(RequestVo requestVo) {
        String errorMsg;
        DLock lock = null;
        long startTime = System.currentTimeMillis();
        try {
            ApiResult apiResult;
            List billNewVos = JSON.parseArray((String)requestVo.getData(), BillNewVo.class);
            if (CollectionUtils.isEmpty((Collection)billNewVos)) {
                ApiResult apiResult2 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u6570\u636e\u672a\u4f20\u5165", (String)"BillPushServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return apiResult2;
            }
            LOGGER.info("BillPushNewServiceImpl, \u63a5\u6536\u5230\u8ba2\u5355\u6570\u91cf:{}", (Object)billNewVos.size());
            ApiResult errorResult = OriginalBillValidateHelper.dealValidateBillNewVoMethod((List)billNewVos);
            if (errorResult != null) {
                ApiResult apiResult3 = errorResult;
                return apiResult3;
            }
            ArrayList<BillVo> bills = new ArrayList<BillVo>(billNewVos.size());
            this.dealConvertBillVoMethod(bills, billNewVos);
            HashMap<String, BillNewVo> billNewVoMap = new HashMap<String, BillNewVo>(billNewVos.size());
            this.dealGroupBillNewVoMethod(billNewVoMap, billNewVos);
            DynamicObject sellerInvoiceSetting = null;
            HashSet<Object> autoInvoice = new HashSet<Object>(bills.size());
            HashSet<Object> autoMerge = new HashSet<Object>(bills.size());
            HashSet<String> billNos = new HashSet<String>(bills.size());
            ArrayList updateList = Lists.newArrayList();
            ArrayList saveList = Lists.newArrayList();
            ArrayList updateNo = Lists.newArrayList();
            ArrayList alreadyPushNo = Lists.newArrayList();
            Map pushGoodsInfoData = Maps.newHashMapWithExpectedSize((int)bills.size());
            BillVo billVo = (BillVo)bills.get(0);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billVo.getBillNo())) {
                ApiResult apiResult4 = ResponseVo.fail((String)ApiErrCodeEnum.FIND_ORDER_NO.getCode(), (String)ApiErrCodeEnum.FIND_ORDER_NO.getMsg());
                return apiResult4;
            }
            HashSet<Long> hasPermOrgs = new HashSet<Long>(bills.size());
            lock = DLock.create((String)("BILL_PUSH_" + billVo.getSellerTaxpayerId() + billVo.getBillNo()));
            if (!lock.tryLock(1000L)) {
                ApiResult apiResult5 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_HANDLER_ING.getCode(), (String)ApiErrCodeEnum.BILL_HANDLER_ING.getMsg());
                return apiResult5;
            }
            for (BillVo bill2 : bills) {
                ApiResult apiResult6;
                Pair pairMap;
                String buyerBankNo;
                bill2.setBuyerTaxpayerId(bill2.getBuyerTaxpayerId().replaceAll(" ", "").toUpperCase());
                if (bill2.getBuyerTaxpayerId().length() > 20) {
                    ApiResult apiResult7 = ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getMsg());
                    return apiResult7;
                }
                String buyerBankAndAccount = bill2.getBuyerBankAndAccount();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)buyerBankAndAccount) && StringUtils.isNotBlank((CharSequence)(buyerBankNo = (String)(pairMap = AddressSplitHelper.splitBankAndName((String)buyerBankAndAccount)).getValue())) && buyerBankNo.length() > 50) {
                    ApiResult apiResult8 = ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getMsg());
                    return apiResult8;
                }
                if (bill2.getBillDetail() == null) {
                    pairMap = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_ITEM_DATA.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u660e\u7ec6\u4e3a\u7a7a\u6216\u660e\u7ec6\u683c\u5f0f\u4e0d\u662fbillDetail", (String)"BillPushServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    return pairMap;
                }
                if (!ApiConfig.checkDetailLimit((int)bill2.getBillDetail().size())) {
                    pairMap = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_DETAIL_LIMIT.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s \u660e\u7ec6\u63a8\u9001\u8d85\u8fc7\u5904\u7406\u6700\u5927\u503c\uff0c\u5f53\u524d\u6700\u5927\u503c\uff1a%2$s\u3002\u5982\u9700\u8c03\u6574\u8bf7\uff0c\u524d\u5f80\u53d1\u7968\u4e91\u5f00\u7968\u8bbe\u7f6e\u9875\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"BillPushServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), bill2.getBillNo(), ApiConfig.getDetailLimit()));
                    return pairMap;
                }
                this.warpOrgId(bill2, requestVo.getBusinessSystemCode());
                try {
                    if (!hasPermOrgs.contains(bill2.getOrgId()) && SystemParameterHelper.getSimParameterBoolean((long)bill2.getOrgId(), (String)"billpush_check_perm")) {
                        PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)bill2.getOrgId(), (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
                    }
                }
                catch (KDBizException e) {
                    buyerBankNo = ResponseVo.fail((String)"19999", (String)e.getMessage());
                    if (lock != null) {
                        lock.unlock();
                    }
                    return buyerBankNo;
                }
                hasPermOrgs.add(bill2.getOrgId());
                String sellerTaxNo = bill2.getSellerTaxpayerId();
                String invoiceType = bill2.getInvoiceType();
                if (AllEleAuthHelper.elePaperSetValue((Object)sellerTaxNo, (Object)invoiceType)) {
                    bill2.setIsElePaper("1");
                }
                if (!(apiResult6 = BillValidResultController.handleValidResult((BillVo)bill2)).getSuccess()) {
                    ApiResult apiResult9 = apiResult6;
                    return apiResult9;
                }
                String msg = ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillValidResultController_3", (String)"imc-sim-service", (Object[])new Object[0]);
                if (msg.equals(apiResult6.getMessage())) {
                    alreadyPushNo.add(bill2.getBillNo());
                }
                if (apiResult6.getData() == null || !StringUtils.isNotBlank((Object)apiResult6.getData())) continue;
                updateList.add((DynamicObject)apiResult6.getData());
                updateNo.add(bill2.getBillNo());
            }
            try {
                DynamicObject invTitleSetting = InvTitleSettingHelper.getInvTitleSetting((Long)billVo.getOrgId());
                boolean isOpenTitleMapping = invTitleSetting != null && invTitleSetting.getBoolean(InvTitleSettingHelper.InvTitleMappingEnum.TIT_MAPP_BILL_PUSH.getCode());
                InvTitleMatchHelper.setAsstactInfo(bills, (boolean)isOpenTitleMapping);
                InvTitleMatchHelper.matchInvTitle(bills, (boolean)isOpenTitleMapping, (DynamicObject)invTitleSetting);
                BillValidaterHelper.setSaleInfoByTaxNo(bills);
                if (billVo.getCondition().booleanValue()) {
                    MaterialToGoodsInfoHelp.instanceMaterialInfoUtilByBillList(bills, (long)((BillVo)bills.get(0)).getOrgId(), (boolean)false);
                } else {
                    boolean isLoad = MaterialToGoodsInfoHelp.getLoadTag(bills);
                    if (isLoad) {
                        pushGoodsInfoData = MaterialToGoodsInfoHelp.loadPushGoodsInfoData((long)((BillVo)bills.get(0)).getOrgId(), bills);
                    }
                }
                Map invItemConfig = InvItemConfigHelper.getInvItemConfig((Long)((BillVo)bills.get(0)).getOrgId());
                BillPushNewServiceImpl.goodsMapping(bills, billNos, pushGoodsInfoData, billVo.getCondition(), ((BillVo)bills.get(0)).getOrgId(), invItemConfig);
                bills.stream().flatMap(bill -> bill.getBillDetail().stream()).forEach(detailVo -> {
                    if (StringUtils.isBlank((Object)detailVo.getPrivilegeFlag())) {
                        detailVo.setPrivilegeFlag(Integer.valueOf("0"));
                    }
                });
            }
            finally {
                MaterialInfoUtil.clear();
            }
            long goodsMatchTime = System.currentTimeMillis();
            LOGGER.info("goodsMatchTime " + (goodsMatchTime - startTime));
            boolean billFromScan = false;
            BillMatchHelper billMatchHelper = new BillMatchHelper();
            QFilter qFilter = ImcBaseDataHelper.getInvoiceTypeManage((Object)billVo.getOrgId()).and("sourcetype", "=", (Object)"0");
            DynamicObject[] invoiceTypeManage = BusinessDataServiceHelper.load((String)"bdm_invoicetype_manage", (String)String.join((CharSequence)",", "filter_tag", "invoicetype"), (QFilter[])qFilter.toArray(), (String)String.format("%s asc, %s desc", "priority", "ctrlstrategy"));
            DynamicObject[] drawerStrategyArr = DrawerStrategyHelper.queryDrawerStrategyByOrg((Long)billVo.getOrgId());
            DynamicObject defaultDrawerStrategy = BusinessDataServiceHelper.newDynamicObject((String)"bdm_drawer_strategy");
            defaultDrawerStrategy.set("drawerstrategy", (Object)"1,1,1");
            HashMap infoCodeMap = Maps.newHashMapWithExpectedSize((int)bills.size());
            for (BillVo bill3 : bills) {
                QFilter blueInvoiceFilter;
                DynamicObject invoice;
                ApiResult details;
                ApiResult apiResult10;
                boolean isEtaxInvoice;
                if (alreadyPushNo.contains(bill3.getBillNo())) continue;
                bill3.setOriBuyerName(bill3.getBuyerName());
                bill3.setOriBuyerAddr(bill3.getBuyerAddressAndTel());
                bill3.setOriBuyerBank(bill3.getBuyerBankAndAccount());
                bill3.setSystemSource(requestVo.getBusinessSystemCode());
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bill3.getBillSource())) {
                    bill3.setBillSource("2");
                } else if ("5".equals(bill3.getBillSource()) || "7".equals(bill3.getBillSource())) {
                    bill3.setAutoInvoice(0);
                    billFromScan = true;
                }
                this.saveOriginalItemData(bill3);
                if (updateNo.contains(bill3.getBillNo())) {
                    for (DynamicObject dynamicObject : updateList) {
                        if (!dynamicObject.getString("billno").equals(bill3.getBillNo())) continue;
                        this.warpDataByAutoInvoice(autoInvoice, autoMerge, bill3, dynamicObject);
                    }
                    continue;
                }
                DynamicObject enterpriseBaseInfoDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_enterprise_baseinfo"), (QFilter[])new QFilter("number", "=", (Object)bill3.getSellerTaxpayerId()).toArray());
                if (null == enterpriseBaseInfoDynamicObject) {
                    ApiResult apiResult11 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[%2$s]\u672a\u5728\u5e73\u53f0\u7ef4\u62a4", (String)"BillPushServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), bill3.getBillNo(), bill3.getSellerTaxpayerId()));
                    return apiResult11;
                }
                String originalDrawer = bill3.getDrawer();
                DynamicObject originalBill = DynamicObjectUtil.bean2DynamicObject((Object)billVo, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
                boolean bl = isEtaxInvoice = InvoiceUtils.isAllEInvoice((Object)bill3.getInvoiceType()) || "1".equals(bill3.getIsElePaper());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bill3.getAccount()) && isEtaxInvoice && !EnterpriseHelper.isLqptChannel((String)bill3.getSellerTaxpayerId())) {
                    bill3.setDrawer(AllEleAuthHelper.getDrawerByAccount((String)bill3.getSellerTaxpayerId(), (String)bill3.getAccount()));
                } else {
                    billMatchHelper.matchDrawer(originalBill, drawerStrategyArr, defaultDrawerStrategy);
                    bill3.setDrawer(originalBill.getString("drawer"));
                }
                bill3.setPayee(originalBill.getString("payee"));
                bill3.setReviewer(originalBill.getString("reviewer"));
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bill3.getDrawer())) {
                    LOGGER.info("drawerMatchNobody\u672a\u5339\u914d\u5230\u5f00\u7968\u4eba\u7528\u63a5\u53e3\u63a8\u5165\u7684\u5f00\u7968\u4eba");
                    bill3.setDrawer(originalDrawer);
                }
                billMatchHelper.matchInvoiceType(bill3, invoiceTypeManage);
                BillCheckProcessDto process = new BillCheckProcessDto(Boolean.valueOf(bill3.getAutoInvoice() == 1));
                ApiResult validResult = BillValidaterHelper.validBillCommon((BillVo)bill3, billNos, (ValidTypeEnum)ValidTypeEnum.BILL, (boolean)true, (BillCheckProcessDto)process);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                validResult = BillValidaterHelper.validAllEDeduction((BillVo)bill3, (ValidTypeEnum)ValidTypeEnum.BILL);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                BillValidaterHelper.validSpecialType((BillVo)bill3);
                BillValidaterHelper.checkReductionTaxType((BillVo)bill3);
                validResult = BillValidaterHelper.validBillBuyer((BillVo)bill3, (ValidTypeEnum)ValidTypeEnum.BILL);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                validResult = BillValidaterHelper.validBillSeller((BillVo)bill3, (DynamicObject)enterpriseBaseInfoDynamicObject, sellerInvoiceSetting, (ValidTypeEnum)ValidTypeEnum.BILL);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                validResult = BillValidaterHelper.validBillDetailEntrance((BillVo)bill3, (ValidTypeEnum)ValidTypeEnum.BILL);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                if (bill3.getDeduction().compareTo(BigDecimal.ZERO) != 0) {
                    if (bill3.getTotalAmount().abs().compareTo(bill3.getDeduction().abs()) < 0) {
                        apiResult10 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5dee\u989d\u5927\u4e8e\u53d1\u7968\u91d1\u989d", (String)"BillPushServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), bill3.getBillNo()));
                        return apiResult10;
                    }
                    details = bill3.getBillDetail().stream().filter(detail -> Integer.parseInt("1") != detail.getLineProperty()).collect(Collectors.toList());
                    if (details.stream().anyMatch(detail -> MathUtils.isNullOrZero((BigDecimal)detail.getDeduction())) && details.stream().anyMatch(detail -> !MathUtils.isNullOrZero((BigDecimal)detail.getDeduction()))) {
                        Object object = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u591a\u884c\u660e\u7ec6\u6263\u9664\u989d\u65f6\uff0c\u5fc5\u987b\u6bcf\u884c\u90fd\u586b\u5199\u6263\u9664\u989d", (String)"BillPushServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), bill3.getBillNo()));
                        return object;
                    }
                }
                if (bill3.getTotalAmount().compareTo(BigDecimal.ZERO) >= 0) {
                    bill3.setBillProperty(1);
                } else {
                    bill3.setBillProperty(-1);
                }
                this.processBillAllDiscount(bill3);
                bill3.setTaxRate(((BillDetailVo)bill3.getBillDetail().get(0)).getTaxRate());
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bill3.getSpecialType())) {
                    bill3.setSpecialType("00");
                }
                if (!(validResult = BillValidaterHelper.validAllESpecial((BillVo)bill3)).getSuccess()) {
                    details = validResult;
                    return details;
                }
                DynamicObject dynamicBill = DynamicObjectUtil.bean2DynamicObject((Object)bill3, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
                dynamicBill.set("itemcount", (Object)dynamicBill.getDynamicObjectCollection("sim_original_bill_item").size());
                dynamicBill.set("id", (Object)DBServiceHelper.genGlobalLongId());
                this.setExtJsonData(bill3, dynamicBill);
                switch (dynamicBill.getString("specialtype")) {
                    case "E06": {
                        DynamicObjectUtil.bean2DynamicObject((Object)bill3.getEstateLeaseInfo(), (DynamicObject)dynamicBill);
                        break;
                    }
                    case "E03": {
                        DynamicObjectUtil.bean2DynamicObject((Object)bill3.getBuildInfo(), (DynamicObject)dynamicBill);
                        break;
                    }
                    case "E05": {
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dynamicBill.getString("cobuyerflag"))) {
                            dynamicBill.getDynamicObjectCollection("cobuyers").clear();
                            dynamicBill.set("cobuyerflag", (Object)"0");
                        }
                        DynamicObjectCollection saleses = dynamicBill.getDynamicObjectCollection("estatesales");
                        for (int i = 0; i < saleses.size(); ++i) {
                            ((DynamicObject)saleses.get(i)).set("seq", (Object)(i + 1));
                        }
                        DynamicObjectCollection cobuyers = dynamicBill.getDynamicObjectCollection("cobuyers");
                        for (int i = 0; i < cobuyers.size(); ++i) {
                            ((DynamicObject)cobuyers.get(i)).set("seq", (Object)(i + 1));
                        }
                        break;
                    }
                    case "E04": {
                        dynamicBill.getDynamicObjectCollection("travelers").clear();
                        dynamicBill.getDynamicObjectCollection("vehichevesselships").clear();
                        break;
                    }
                    case "E09": {
                        break;
                    }
                    case "E07": {
                        BillValidaterHelper.dealCheckVessalShipPeriodMethod((String)requestVo.getInterfaceCode(), (String)requestVo.getData());
                        BillValidaterHelper.dealSetPeriodDateMethod((DynamicObject)dynamicBill);
                        dynamicBill.getDynamicObjectCollection("travelers").clear();
                        dynamicBill.getDynamicObjectCollection("freights").clear();
                        break;
                    }
                    default: {
                        dynamicBill.getDynamicObjectCollection("vehichevesselships").clear();
                        dynamicBill.getDynamicObjectCollection("travelers").clear();
                        dynamicBill.getDynamicObjectCollection("freights").clear();
                    }
                }
                this.dealClearSpecialItemsMethod(dynamicBill);
                ApiResult errorResult2 = this.checkBillDate(bill3, dynamicBill);
                if (errorResult2 != null) {
                    ApiResult apiResult12 = errorResult2;
                    return apiResult12;
                }
                String tipMsg1 = ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"BillPushNewServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]);
                String tipMsg2 = ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868", (String)"BillPushNewServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]);
                String billName = InvoiceUtils.isEtcInvoice((String)bill3.getInvoiceType()) || AllEleAuthHelper.isElePaper((Object)bill3.getIsElePaper()) ? tipMsg1 : tipMsg2;
                this.setInfoCode(bill3);
                DynamicObject redInfoOrRedConfirmBill = RedInfoHelper.checkInfoCode((BillVo)bill3, (long)bill3.getOrgId(), (HashMap)infoCodeMap, (String)billName);
                if (null != redInfoOrRedConfirmBill && InvoiceUtils.isAllEInvoice((Object)bill3.getInvoiceType())) {
                    dynamicBill.set("salerorbuyer", (Object)this.getSalerOrBuyer(redInfoOrRedConfirmBill));
                    String originalinvoiceno = redInfoOrRedConfirmBill.getString("originalinvoiceno");
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bill3.getBlueinvoiceNo()) && !originalinvoiceno.equals(bill3.getBlueinvoiceNo())) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u5f85\u7ea2\u51b2\u53d1\u7968\u53f7\u7801\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868%2$s\u7684\u5f85\u7ea2\u51b2\u53d1\u7968\u53f7\u7801\u4e0d\u4e00\u81f4", (String)"BillPushServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), bill3.getBillNo(), bill3.getInfoCode()));
                    }
                    dynamicBill.set("blueinvoiceno", (Object)originalinvoiceno);
                    dynamicBill.set("originalissuetime", redInfoOrRedConfirmBill.get("originalissuetime"));
                    dynamicBill.set("blueinvoicetype", (Object)redInfoOrRedConfirmBill.getString("originalinvoicetype"));
                    String redReason = redInfoOrRedConfirmBill.getString("redreason");
                    dynamicBill.set("redreason", (Object)RedConfirmBillRedReasonEnum.getBillCodeByCode((String)redReason));
                    dynamicBill.set("infocode", (Object)bill3.getInfoCode());
                } else {
                    dynamicBill.set("blueinvoicecode", (Object)bill3.getBlueinvoiceCode());
                    dynamicBill.set("blueinvoiceno", (Object)bill3.getBlueinvoiceNo());
                    if (InvoiceUtils.isAllEInvoice((Object)bill3.getInvoiceType())) {
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dynamicBill.getString("salerorbuyer"))) {
                            dynamicBill.set("salerorbuyer", (Object)"0");
                        }
                        if (bill3.getBillProperty() == Integer.parseInt("-1") && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dynamicBill.getString("redreason"))) {
                            dynamicBill.set("redreason", (Object)RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode());
                        }
                    }
                }
                String blueInvoiceCode = org.apache.commons.lang3.StringUtils.trimToEmpty((String)dynamicBill.getString("blueinvoicecode"));
                String blueInvoiceNo = org.apache.commons.lang3.StringUtils.trimToEmpty((String)dynamicBill.getString("blueinvoiceno"));
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)blueInvoiceNo) && (invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"invoicetype,issuetime,buyeraddr,buyerbank", (QFilter[])(blueInvoiceFilter = InvoiceUtils.getInvoiceFilter((Object)blueInvoiceCode, (Object)blueInvoiceNo)).toArray())) != null) {
                    if (StringUtils.isBlank((Object)dynamicBill.get("blueinvoicetype"))) {
                        dynamicBill.set("blueinvoicetype", invoice.get("invoicetype"));
                    }
                    if (StringUtils.isBlank((Object)dynamicBill.get("originalissuetime"))) {
                        dynamicBill.set("originalissuetime", invoice.get("issuetime"));
                    }
                    if (StringUtils.isBlank((Object)dynamicBill.get("buyeraddr"))) {
                        dynamicBill.set("buyeraddr", invoice.get("buyeraddr"));
                    }
                    if (StringUtils.isBlank((Object)dynamicBill.get("buyerbank"))) {
                        dynamicBill.set("buyerbank", invoice.get("buyerbank"));
                    }
                }
                CacheHelper.remove((String)("sim_repeat_push_bill_id_" + bill3.getBillNo()));
                BillValidResultController.setOldPk((DynamicObject)dynamicBill);
                IssuePolicyHelper.setBizControl((String)bill3.getIssueBizType(), (DynamicObject)dynamicBill);
                errorResult2 = this.warpDataByAutoInvoice(autoInvoice, autoMerge, bill3, dynamicBill);
                if (errorResult2 != null) {
                    blueInvoiceFilter = errorResult2;
                    return blueInvoiceFilter;
                }
                dynamicBill.set("createdate", (Object)new Date());
                dynamicBill.set("surplusamount", dynamicBill.get("invoiceamount"));
                dynamicBill.set("surplustax", dynamicBill.get("totaltax"));
                dynamicBill.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_original_bill", (String)"2"));
                dynamicBill.set("billsourcetype", (Object)"A");
                dynamicBill.set("showbuyerbank", (Object)BillPushNewServiceImpl.getShowBank(bill3.getOrgId(), bill3.getShowBuyerBank(), "showbuyerbank"));
                dynamicBill.set("showsalerbank", (Object)BillPushNewServiceImpl.getShowBank(bill3.getOrgId(), bill3.getShowSalerBank(), "showsalerbank"));
                String productType = dynamicBill.getString("producttype");
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)productType)) {
                    dynamicBill.set("producttype", (Object)"1");
                }
                this.setMatchStatus(dynamicBill);
                this.setCreator(bill3, dynamicBill);
                IssueInvoiceService.updateTaxOrg((DynamicObject)dynamicBill);
                this.dealSetFieldValueMethod(dynamicBill, billNewVoMap);
                saveList.add(dynamicBill);
                billNos.add(bill3.getBillNo());
            }
            autoInvoice.removeIf(Objects::isNull);
            autoMerge.removeIf(Objects::isNull);
            BotpHelper.dealPushArFields((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            if (CollectionUtils.isNotEmpty((Collection)saveList)) {
                billMatchHelper.matchAll((List)saveList, "0");
                ImcSaveServiceHelper.save((List)saveList);
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                ImcSaveServiceHelper.update((List)updateList);
            }
            Set dataBizKeySet = null;
            JSONObject dataBizJson = null;
            try {
                ArrayList dataList = new ArrayList(saveList);
                dataList.addAll(updateList);
                JSONObject riskResult = BillRiskControlService.riskControl(dataList, (String)"sim_original_bill", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ISSUE);
                dataBizJson = riskResult.getJSONObject("DATA_BIZ_NO_MAP");
                dataBizKeySet = (Set)riskResult.get((Object)"DATA_BIZ_KEY_ARR");
            }
            catch (Exception e) {
                LOGGER.error("risk control exception", (Throwable)e);
            }
            if (CollectionUtils.isNotEmpty(dataBizKeySet)) {
                autoInvoice.removeAll(dataBizKeySet);
            }
            LOGGER.info("autoInvoice size:" + autoInvoice.size());
            if (billFromScan) {
                MsgResponse msgResponse = ImacScanService.getWeChatScanUrl(saveList.toArray(new DynamicObject[0]), requestVo);
                if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
                    JSONObject jsonObject = JSON.parseObject((String)msgResponse.getRespData());
                    if ("2".equals(requestVo.getVersion())) {
                        ApiResult apiResult13 = ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillPushServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)jsonObject.toJSONString());
                        return apiResult13;
                    }
                    ApiResult apiResult14 = ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillPushServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)jsonObject.getString("url_link"));
                    return apiResult14;
                }
            } else {
                this.executeAutoIssueInvoice(autoInvoice, autoMerge);
            }
            ApiResult riskControlResult = BillRiskControlService.getApiResult((JSONObject)dataBizJson);
            if (riskControlResult != null) {
                apiResult = riskControlResult;
                return apiResult;
            }
            billNewVoMap.clear();
            LOGGER.info("\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f");
            apiResult = ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillPushServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), null);
            return apiResult;
        }
        catch (KDBizException bizException) {
            errorMsg = bizException.getMessage();
        }
        catch (Exception e) {
            LOGGER.error("\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u5f02\u5e38Exception ", (Throwable)e);
            errorMsg = String.format(ResManager.loadKDString((String)"\u63a8\u9001\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5 %s", (String)"BillPushServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
            if (e instanceof JSONException) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u63a5\u6536\u7684\u6570\u636e\u8f6c\u6362\u5f02\u5e38:%s", (String)"BillPushServiceImpl_46", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
            } else if (e instanceof NumberFormatException) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u63a5\u6536\u7684\u6570\u636e\u8f6c\u6362\u5f02\u5e38:%s", (String)"BillPushServiceImpl_46", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
    }

    private void dealGroupBillNewVoMethod(Map<String, BillNewVo> billNewVoMap, List<BillNewVo> billNewVos) {
        for (BillNewVo billNewVo : billNewVos) {
            billNewVoMap.put(billNewVo.getBillNo(), billNewVo);
        }
    }

    private void dealSetFieldValueMethod(DynamicObject dynamicBill, Map<String, BillNewVo> billNewVoMap) {
        String billNo = dynamicBill.getString("billno");
        BillNewVo billNewVo = billNewVoMap.get(billNo);
        if (billNewVo == null) {
            LOGGER.error("dealSetFieldValueMethod, billNo:{}, \u5bf9\u5e94\u7684billNewVo\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (Object)billNo);
            return;
        }
        this.dealOriginalBillInfo(dynamicBill, billNewVo);
        this.dealOriginalItemInfo(dynamicBill, billNewVo);
        this.dealOriginalAgriculGoodsConfirm(dynamicBill, billNewVo);
        this.dealOriginalEstateSaleInfo(dynamicBill, billNewVo);
        LOGGER.info("\u8bbe\u7f6e\u5b57\u6bb5\u5185\u5bb9\u5b8c\u6210\uff01");
    }

    private void dealOriginalBillInfo(DynamicObject dynamicBill, BillNewVo billNewVo) {
        String showSellerAddressTel;
        dynamicBill.set("systemsource", (Object)billNewVo.getBusinessSystemCode());
        dynamicBill.set("batchbelong", (Object)billNewVo.getBatchNo());
        String applyOrgCode = billNewVo.getApplyOrgCode();
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((String)"bos_org", (QFilter[])new QFilter("number", "=", (Object)applyOrgCode).toArray());
        dynamicBill.set("applyorgid", (Object)orgObject);
        dynamicBill.set("itemcount", (Object)billNewVo.getTotalRows());
        String billCurrency = billNewVo.getBillCurrency();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)billCurrency)) {
            billCurrency = "CNY";
        }
        DynamicObject currencyObject = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (QFilter[])new QFilter("number", "=", (Object)billCurrency).toArray());
        dynamicBill.set("fromcurr", (Object)currencyObject);
        String audiType = billNewVo.getAuditType();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)audiType) || "0".equals(audiType)) {
            dynamicBill.set("billstatus", (Object)"D");
        } else {
            dynamicBill.set("billstatus", (Object)"A");
        }
        OriginInvoiceInfoVo originInvoiceInfo = billNewVo.getOriginInvoiceInfo();
        if (originInvoiceInfo != null) {
            dynamicBill.set("redconfirmuuid", (Object)originInvoiceInfo.getRedConfirmNo());
            dynamicBill.set("redconfirmdate", (Object)originInvoiceInfo.getRedConfirmDate());
        }
        showSellerAddressTel = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(showSellerAddressTel = billNewVo.getShowSellerAddressTel())) || "N".equals(showSellerAddressTel) ? "0" : "1";
        dynamicBill.set("showsaleraddrtel", (Object)showSellerAddressTel);
        dynamicBill.set("showsalerbank", (Object)billNewVo.getShowSalerBank());
        String showBuyerAddressTel = billNewVo.getShowBuyerAddressTel();
        showBuyerAddressTel = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)showBuyerAddressTel) || "N".equals(showBuyerAddressTel) ? "0" : "1";
        dynamicBill.set("showbuyeraddrtel", (Object)showBuyerAddressTel);
        dynamicBill.set("showbuyerbank", (Object)billNewVo.getShowBuyerCard());
    }

    private void dealOriginalItemInfo(DynamicObject dynamicBill, BillNewVo billNewVo) {
        DynamicObjectCollection itemObjectCollection = dynamicBill.getDynamicObjectCollection("sim_original_bill_item");
        if (itemObjectCollection == null || itemObjectCollection.size() == 0) {
            return;
        }
        List billDetailNewVoList = billNewVo.getBillLineDetail();
        if (billDetailNewVoList == null || billDetailNewVoList.size() == 0) {
            return;
        }
        for (int i = 0; i < itemObjectCollection.size(); ++i) {
            DynamicObject itemObject = (DynamicObject)itemObjectCollection.get(i);
            BillDetailNewVo billDetailNewVo = (BillDetailNewVo)billDetailNewVoList.get(i);
            itemObject.set("seq", (Object)billDetailNewVo.getLineid());
            itemObject.set("taxfreetype", (Object)billDetailNewVo.getTaxFreeType());
            itemObject.set("originalinvoicecode", (Object)billDetailNewVo.getOriginalInvoiceCode());
            itemObject.set("originalinvoiceno", (Object)billDetailNewVo.getOriginalInvoiceNo());
            itemObject.set("originalinvoicedate", (Object)billDetailNewVo.getOriginalInvoiceDate());
            itemObject.set("originalinvoicetype", (Object)billDetailNewVo.getOriginalInvoiceType());
            itemObject.set("itemredreason", (Object)billDetailNewVo.getRedReason());
            itemObject.set("itemapplicant", (Object)billDetailNewVo.getApplicant());
            itemObject.set("itemredconfirmno", (Object)billDetailNewVo.getRedConfirmNo());
            itemObject.set("itemredconfirmuuid", (Object)billDetailNewVo.getRedConfirmUUID());
            itemObject.set("itemredconfirmdate", (Object)billDetailNewVo.getRedConfirmDate());
        }
    }

    private void dealOriginalAgriculGoodsConfirm(DynamicObject dynamicBill, BillNewVo billNewVo) {
        if (billNewVo.getAgriculGoodsInfo() != null) {
            dynamicBill.set("agriculgoodsconfirm", (Object)billNewVo.getAgriculGoodsInfo().getAgriculGoodsConfirm());
        }
    }

    private void dealOriginalEstateSaleInfo(DynamicObject dynamicBill, BillNewVo billNewVo) {
        if (billNewVo.getEstateSaleInfoV2() != null) {
            dynamicBill.set("cobuyerflag", (Object)billNewVo.getEstateSaleInfoV2().getEstateSaleCoFlag());
            List estateSaleCoBuyerList = billNewVo.getEstateSaleInfoV2().getEstateSaleCoBuyer();
            if (CollectionUtils.isNotEmpty((Collection)estateSaleCoBuyerList)) {
                DynamicObjectCollection saleCoBuyerCollection = dynamicBill.getDynamicObjectCollection("cobuyers");
                for (EstateSaleCoBuyer estateSaleCoBuyer : estateSaleCoBuyerList) {
                    DynamicObject saleCoBuyerItem = saleCoBuyerCollection.addNew();
                    saleCoBuyerItem.set("cobuyer", (Object)estateSaleCoBuyer.getCoBuyerName());
                    saleCoBuyerItem.set("cobuyercardtype", (Object)estateSaleCoBuyer.getIdCardType());
                    saleCoBuyerItem.set("cobuyercardno", (Object)estateSaleCoBuyer.getIdCardNumber());
                }
            }
        }
    }

    private void dealConvertBillVoMethod(List<BillVo> bills, List<BillNewVo> billNewVos) throws Exception {
        for (BillNewVo billNewVo : billNewVos) {
            BillVo billVo = new BillVo();
            this.dealConvertBillInfoMethod(billVo, billNewVo);
            this.dealConvertBillDetailMethod(billVo, billNewVo);
            this.dealConvertAgriculGoodsInfoMethod(billVo, billNewVo);
            this.dealConvertEstateSaleInfoV2Method(billVo, billNewVo);
            bills.add(billVo);
        }
    }

    private void dealConvertBillInfoMethod(BillVo billVo, BillNewVo billNewVo) throws Exception {
        BeanUtils.copyProperties((Object)billVo, (Object)billNewVo);
        billVo.setOrgCode(billNewVo.getInvoiceOrgCode());
        billVo.setSellerTaxpayerId(billNewVo.getSellerTaxNo());
        billVo.setBuyerTaxpayerId(billNewVo.getBuyerTaxNo());
        billVo.setBuyerProperty(billNewVo.getPersonFlag());
        billVo.setDrawer(billNewVo.getIssuer());
        billVo.setPayee(billNewVo.getCashier());
        billVo.setDeduction(billNewVo.getTotalDeduction());
        billVo.setSpecialType(billNewVo.getSpecialBussinessFlag());
        billVo.setTaxationStyle(billNewVo.getTaxMethod());
        billVo.setAccount(billNewVo.getEtaxationIssueInvAccount());
        int autoIssue = billNewVo.getAutoIssue();
        if (autoIssue == 2) {
            autoIssue = 0;
        }
        billVo.setAutoInvoice(autoIssue);
        billVo.setPushMatchRules(billNewVo.getTaxcodeMatchRules());
        billVo.setFillValueRule(billNewVo.getGoodsDiscriptMatchRules());
        this.dealSetSellerBuyerFieldMethod(billVo, billNewVo);
        this.dealSetOriginInvoiceFiledMethod(billVo, billNewVo);
        String invoiceType = InvoiceTypeNewEnum.getInvoiceTypeOldCode((String)billNewVo.getInvoiceType());
        billVo.setInvoiceType(invoiceType);
    }

    private void dealConvertBillDetailMethod(BillVo billVo, BillNewVo billNewVo) throws Exception {
        List billLineDetail = billNewVo.getBillLineDetail();
        ArrayList<BillDetailVo> billDetailVoList = new ArrayList<BillDetailVo>(billLineDetail.size());
        for (BillDetailNewVo billDetailNewVo : billLineDetail) {
            BillDetailVo billDetailVo = new BillDetailVo();
            BeanUtils.copyProperties((Object)billDetailVo, (Object)billDetailNewVo);
            billDetailVo.setGoodsCode(billDetailNewVo.getGoodsDiscriptCode());
            billDetailVo.setGoodsName(billDetailNewVo.getGoodsDiscript());
            billDetailVo.setRevenueCode(billDetailNewVo.getTaxCode());
            billDetailVo.setAmount(billDetailNewVo.getLineAmount());
            billDetailVoList.add(billDetailVo);
        }
        billVo.setBillDetail(billDetailVoList);
    }

    private void dealConvertEstateSaleInfoV2Method(BillVo billVo, BillNewVo billNewVo) {
        List detailList;
        EstateSaleInfo estateSaleInfoV2 = billNewVo.getEstateSaleInfoV2();
        if (estateSaleInfoV2 != null && CollectionUtils.isNotEmpty((Collection)(detailList = estateSaleInfoV2.getDetailList()))) {
            billVo.setEstateSaleInfo((BillEstateSaleInfoVo)detailList.get(0));
        }
    }

    private void dealConvertAgriculGoodsInfoMethod(BillVo billVo, BillNewVo billNewVo) {
        AgriculGoodsInfoVo agriculGoodsInfoVo = billNewVo.getAgriculGoodsInfo();
        if (agriculGoodsInfoVo != null) {
            billVo.setCardType(billNewVo.getAgriculGoodsInfo().getCardType());
        }
    }

    private void dealSetOriginInvoiceFiledMethod(BillVo billVo, BillNewVo billNewVo) {
        OriginInvoiceInfoVo originInvoiceInfo = billNewVo.getOriginInvoiceInfo();
        if (originInvoiceInfo != null) {
            billVo.setBlueinvoiceCode(originInvoiceInfo.getOriginalInvoiceCode());
            billVo.setBlueinvoiceNo(originInvoiceInfo.getOriginalInvoiceNo());
            billVo.setBlueInvoiceType(InvoiceTypeNewEnum.getInvoiceTypeOldCode((String)originInvoiceInfo.getOriginalInvoiceType()));
            billVo.setOriginalIssueTime(originInvoiceInfo.getOriginalInvoiceDate());
            String originalEtaxInvoiceNo = originInvoiceInfo.getOriginalEtaxInvoiceNo();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)originalEtaxInvoiceNo)) {
                billVo.setBlueinvoiceNo(originalEtaxInvoiceNo);
            }
            billVo.setInfoCode(originInvoiceInfo.getRedConfirmNo());
            billVo.setRedReason(originInvoiceInfo.getRedReason());
            billVo.setApplicant(originInvoiceInfo.getApplicant());
        }
    }

    private void dealSetSellerBuyerFieldMethod(BillVo billVo, BillNewVo billNewVo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getSellerAddress()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getSellerTelephone())) {
            billVo.setSellerAddressAndTel(billNewVo.getSellerAddress() + ", " + billNewVo.getSellerTelephone());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getSellerAddress())) {
            billVo.setSellerAddressAndTel(billNewVo.getSellerAddress());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getSellerTelephone())) {
            billVo.setSellerAddressAndTel(billNewVo.getSellerTelephone());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getSellerBankAccount()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getSellerAccountNumber())) {
            billVo.setSellerBankAndAccount(billNewVo.getSellerBankAccount() + billNewVo.getSellerAccountNumber());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getSellerBankAccount())) {
            billVo.setSellerBankAndAccount(billNewVo.getSellerBankAccount());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getSellerAccountNumber())) {
            billVo.setSellerBankAndAccount(billNewVo.getSellerAccountNumber());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getBuyerAddress()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getBuyerTelephone())) {
            billVo.setBuyerAddressAndTel(billNewVo.getBuyerAddress() + ", " + billNewVo.getBuyerTelephone());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getBuyerAddress())) {
            billVo.setBuyerAddressAndTel(billNewVo.getBuyerAddress());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getBuyerTelephone())) {
            billVo.setBuyerAddressAndTel(billNewVo.getBuyerTelephone());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getBuyerBankAccount()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getBuyerAccountNumber())) {
            billVo.setBuyerBankAndAccount(billNewVo.getBuyerBankAccount() + billNewVo.getBuyerAccountNumber());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getBuyerBankAccount())) {
            billVo.setBuyerBankAndAccount(billNewVo.getBuyerBankAccount());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNewVo.getBuyerAccountNumber())) {
            billVo.setBuyerBankAndAccount(billNewVo.getBuyerAccountNumber());
        }
    }
}

