/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.MultiSendResponseDTO;
import kd.imc.bdm.common.enums.PushStatusEnum;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.moduleservice.ResultResponse;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.SendMsgEmailService;
import kd.imc.sim.common.constant.EmailAndMsgErrorType;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class EmailAndMsgResendServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(EmailAndMsgResendServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        return EmailAndMsgResendServiceImpl.processStatic(requestVo);
    }

    public static ApiResult processStatic(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"EmailAndMsgResendServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject params = JSONObject.parseObject((String)requestVo.getData());
        ApiResult result = EmailAndMsgResendServiceImpl.requestParamDataCheck(params);
        if (!result.getErrorCode().equals(EmailAndMsgErrorType.SUCCESS.getCode())) {
            return result;
        }
        try {
            JSONArray invoiceArray = JSONArray.parseArray((String)JSONUtils.toString((Object)params.get((Object)"params")));
            Object resendtype = params.get((Object)"resendtype");
            JSONObject errJSON = new JSONObject();
            for (Object json : invoiceArray) {
                JSONObject invoice = JSONObject.parseObject((String)json.toString());
                QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoice.getString("invoicecode")).and("invoiceno", "=", (Object)invoice.getString("invoiceno"));
                DynamicObject invoiceDy = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])qFilter.toArray());
                if (null != invoiceDy) {
                    ResultResponse checkResp = EmailAndMsgResendServiceImpl.invoiceCheck(invoiceDy);
                    if (!checkResp.getResultCode().equals(EmailAndMsgErrorType.SUCCESS.getCode())) {
                        errJSON.put(invoice.getString("invoicecode") + "_" + invoice.getString("invoiceno"), checkResp.getResultData());
                        continue;
                    }
                    String errMsg = EmailAndMsgResendServiceImpl.doResend(invoiceDy, resendtype, invoice);
                    errJSON.put(invoice.getString("invoicecode") + "_" + invoice.getString("invoiceno"), (Object)errMsg);
                    continue;
                }
                errJSON.put(invoice.getString("invoicecode") + "_" + invoice.getString("invoiceno"), (Object)EmailAndMsgErrorType.NOTFINDIMCINOVICE.getName());
            }
            result.setData((Object)errJSON);
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff1a", (Throwable)e);
            result.setData((Object)EmailAndMsgErrorType.DEFEAT.getCode());
            result.setData((Object)String.format(ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u6362\u5931\u8d25:%s", (String)"EmailAndMsgResendServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), e));
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doResend(DynamicObject invoice, Object resendtype, JSONObject json) {
        String result = "";
        String str = resendtype.toString();
        String pushStatus = "";
        String email = StringUtils.isEmpty((CharSequence)json.getString("email")) ? invoice.getString("buyeremail") : json.getString("email");
        String phone = StringUtils.isEmpty((CharSequence)json.getString("phone")) ? invoice.getString("buyerphone") : json.getString("phone");
        String[] emails = email.split(";");
        if (emails.length > 3) {
            return EmailAndMsgErrorType.EMAILNUMOUT.getName();
        }
        if (!StringUtils.isEmpty((CharSequence)phone) && !StringUtils.isPhoneNumberValid((String)phone)) {
            return EmailAndMsgErrorType.PHONENUMOUT.getName();
        }
        for (String s : emails) {
            if (StringUtils.isEmpty((CharSequence)s) || StringUtils.isEmail((String)s)) continue;
            return EmailAndMsgErrorType.EMAILSTYLEERROR.getName();
        }
        String phoneFlag = "-1";
        String emailFlag = "-1";
        MultiSendResponseDTO emailResponse = new MultiSendResponseDTO();
        MultiSendResponseDTO phoneResponse = new MultiSendResponseDTO();
        try {
            switch (str) {
                case "null": 
                case "": 
                case "0": {
                    emailResponse = SendMsgEmailService.sendMultiEmail((DynamicObject)invoice, (String)"", (String)email);
                    break;
                }
                case "1": {
                    phoneResponse = SendMsgEmailService.sendMultiPhone((DynamicObject)invoice, (String)phone);
                    break;
                }
                case "2": {
                    emailResponse = SendMsgEmailService.sendMultiEmail((DynamicObject)invoice, (String)"", (String)email);
                    phoneResponse = SendMsgEmailService.sendMultiPhone((DynamicObject)invoice, (String)phone);
                    break;
                }
            }
            String flag = phoneResponse.getFlag() + emailResponse.getFlag();
            result = EmailAndMsgErrorType.getName((String)flag);
            pushStatus = SendMsgEmailService.getPushStatus((MultiSendResponseDTO)phoneResponse, (MultiSendResponseDTO)emailResponse, (JSONObject)new JSONObject());
        }
        catch (MsgException e) {
            try {
                LOGGER.error("sendMsg_\u63a5\u53e3\u63a8\u9001\u77ed\u4fe1\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
                pushStatus = PushStatusEnum.failed.getCode();
            }
            catch (Throwable throwable) {
                invoice.set("pushstatus", (Object)pushStatus);
                invoice.set("buyerphone", (Object)phone);
                invoice.set("buyeremail", (Object)email);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
                throw throwable;
            }
            invoice.set("pushstatus", (Object)pushStatus);
            invoice.set("buyerphone", (Object)phone);
            invoice.set("buyeremail", (Object)email);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
        }
        invoice.set("pushstatus", (Object)pushStatus);
        invoice.set("buyerphone", (Object)phone);
        invoice.set("buyeremail", (Object)email);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
        return result;
    }

    public static ResultResponse invoiceCheck(DynamicObject invoice) {
        ResultResponse result = new ResultResponse();
        result.setResultCode(EmailAndMsgErrorType.DEFEAT.getCode());
        result.setResultMsg(EmailAndMsgErrorType.DEFEAT.getName());
        if (!InvoiceUtils.isEtcInvoice((String)invoice.getString("invoicetype"))) {
            result.setResultData((Object)EmailAndMsgErrorType.UNELCINVOICE.getName());
            return result;
        }
        String issuetype = invoice.getString("issuetype");
        if ("1".equals(issuetype)) {
            result.setResultData((Object)EmailAndMsgErrorType.UNBLUEINVOICE.getName());
            return result;
        }
        String invoiceStatus = invoice.getString("invoicestatus");
        if (!"0".equals(invoiceStatus)) {
            result.setResultData((Object)EmailAndMsgErrorType.UNNORINVOICE.getName());
            return result;
        }
        String buyerType = invoice.getString("buyertype");
        if ("8".equals(buyerType)) {
            result.setResultData((Object)EmailAndMsgErrorType.ISIMPORTEXCEL.getName());
            return result;
        }
        if ("9".equals(buyerType)) {
            result.setResultData((Object)EmailAndMsgErrorType.ISDOWNLOAD.getName());
            return result;
        }
        if ("10".equals(buyerType)) {
            result.setResultData((Object)EmailAndMsgErrorType.ISFROMAWS.getName());
            return result;
        }
        if ("2".equals(buyerType)) {
            result.setResultData((Object)EmailAndMsgErrorType.ISDATASYNC.getName());
            return result;
        }
        if (StringUtils.isBlank((CharSequence)invoice.getString("fileurl"))) {
            result.setResultData((Object)EmailAndMsgErrorType.NOURLINOVICE.getName());
            return result;
        }
        result.setResultCode(EmailAndMsgErrorType.SUCCESS.getCode());
        return result;
    }

    public static ApiResult requestParamDataCheck(JSONObject params) {
        String str;
        ApiResult result = new ApiResult();
        result.setErrorCode(EmailAndMsgErrorType.ERRORREQUESTPARAMS.getCode());
        result.setMessage(EmailAndMsgErrorType.ERRORREQUESTPARAMS.getName());
        if (null == params) {
            result.setData((Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"EmailAndMsgResendServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
            return result;
        }
        Object resendtype = params.get((Object)"resendtype");
        if (null != resendtype && StringUtils.isNotBlank((Object)resendtype) && ((str = resendtype.toString()).length() != 1 || !"012".contains(str))) {
            result.setData((Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570'resendtype'\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a0:\u53ea\u91cd\u53d1\u90ae\u4ef6\uff1b1\uff1a\u53ea\u91cd\u53d1\u77ed\u4fe1\uff1b2\uff1a\u90fd\u91cd\u53d1\uff1b  \u7a7a\uff1a\u9ed8\u8ba4\u53ea\u91cd\u53d1\u90ae\u4ef6", (String)"EmailAndMsgResendServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            return result;
        }
        Object requestdata = params.get((Object)"params");
        if (null == requestdata) {
            result.setData((Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570'params'\u4e0d\u80fd\u4e3a\u7a7a", (String)"EmailAndMsgResendServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
            return result;
        }
        try {
            JSONArray jArray = JSONArray.parseArray((String)JSONUtils.toString((Object)params.get((Object)"params")));
            if (jArray.size() == 0) {
                result.setData((Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570'params'\u4e0d\u80fd\u4e3a\u7a7a", (String)"EmailAndMsgResendServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return result;
            }
        }
        catch (Exception e) {
            result.setData((Object)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570'params'\u4e0d\u6b63\u786e\uff1a%s", (String)"EmailAndMsgResendServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), e));
            return result;
        }
        result.setErrorCode(EmailAndMsgErrorType.SUCCESS.getCode());
        result.setMessage(EmailAndMsgErrorType.SUCCESS.getName());
        return result;
    }
}

