/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.qr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.ScanApiErrCodeEnum;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.SendMsg2Erp;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.constant.ValidTypeEnum;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.openapi.ScanInvoiceVo;
import kd.imc.sim.common.vo.openapi.SendErpVo;
import kd.imc.sim.formplugin.openapi.check.BaseCheckService;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.helper.ScanApiHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.qr.BillScanErpVo;
import org.apache.commons.beanutils.BeanUtils;

public class QRGetBillServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(QRGetBillServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRGetBillServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ScanInvoiceVo scanInvoiceVo = null;
        if (StringUtils.isNotEmpty((CharSequence)requestVo.getData())) {
            scanInvoiceVo = (ScanInvoiceVo)JSON.parseObject((String)requestVo.getData(), ScanInvoiceVo.class);
        }
        if (scanInvoiceVo == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRGetBillServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        LOGGER.info("QRGetBill \u5165\u53c2\uff1a" + requestVo.getData());
        try {
            if (MathUtils.isZero((BigDecimal)scanInvoiceVo.getAmount())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u626b\u7801\u5f00\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"QRGetBillServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if ("giftReceipt".equals(scanInvoiceVo.getBillSource())) {
                return this.queryGiftReceipt(scanInvoiceVo);
            }
            DynamicObject qrKeyDO = ScanApiHelper.getQrKeyDynamicObject(scanInvoiceVo.getQrKey());
            if ("0".equals(qrKeyDO.getString("scantype"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u626b\u7801\u63d0\u4ea4\u62ac\u5934\u7684qrKey\u4e0d\u652f\u6301\u67e5\u8be2\u8ba2\u5355", (String)"QRGetBillServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            JSONObject qrJSON = this.getQrViewSetting(qrKeyDO);
            DynamicObject originalBill = ScanApiHelper.getOriginalBillDynamicObject(scanInvoiceVo.getBillNo());
            if (originalBill != null) {
                if (scanInvoiceVo.getAmount().compareTo(originalBill.getBigDecimal("totalamount")) != 0) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4e8c\u7ef4\u7801\u91d1\u989d\u4e0e\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"QRGetBillServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                BillVo billVo = (BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)originalBill);
                billVo.setSystemSource(qrKeyDO.getString("systemcode"));
                billVo.setCreator("");
                String invoiceType = originalBill.getString("invoicetype");
                if (StringUtils.isEmpty((CharSequence)invoiceType)) {
                    invoiceType = qrKeyDO.getString("invoicetype");
                }
                billVo.setInvoiceTypes(invoiceType, qrKeyDO.getString("eqinfotaxno"), qrKeyDO.getString("eqinfono"));
                LOGGER.info("QRGetBill \u5f00\u7968\u7533\u8bf7\u5355\u6570\u636e " + JSON.toJSONString((Object)billVo));
                JSONObject billJSON = JSONObject.parseObject((String)JSON.toJSONString((Object)billVo));
                billJSON.put("qrViewSetting", (Object)qrJSON);
                return ResponseVo.success((String)billJSON.toJSONString());
            }
            ApiResult result = this.oldScan(scanInvoiceVo, qrKeyDO);
            if (result.getSuccess()) {
                JSONObject resultJSON = JSONObject.parseObject((String)result.getData().toString());
                resultJSON.put("qrViewSetting", (Object)qrJSON);
                return ResponseVo.success((String)resultJSON.toString());
            }
            return ResponseVo.fail((String)result.getErrorCode(), (String)result.getMessage());
        }
        catch (KDBizException e) {
            return ResponseVo.fail((String)ScanApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("QRGetBill Exception ", (Throwable)e);
            return ResponseVo.fail((String)ScanApiErrCodeEnum.ERROR.getCode(), (String)ScanApiErrCodeEnum.ERROR.getMsg());
        }
    }

    private JSONObject getQrViewSetting(DynamicObject qrKeyDO) {
        JSONObject qrJSON = new JSONObject();
        qrJSON.put("phonedisplayflag", (Object)qrKeyDO.getString("phonedisplayflag"));
        qrJSON.put("phonerequiredflag", (Object)qrKeyDO.getString("phonerequiredflag"));
        qrJSON.put("emaildisplayflag", (Object)qrKeyDO.getString("emaildisplayflag"));
        qrJSON.put("emailrequiredflag", (Object)qrKeyDO.getString("emailrequiredflag"));
        qrJSON.put("remarkdisplayflag", (Object)qrKeyDO.getString("remarkdisplayflag"));
        qrJSON.put("remarktips", (Object)qrKeyDO.getString("remarktips"));
        String buyerinfoabled = qrKeyDO.getString("buyerinfoabled");
        qrJSON.put("buyerinfoabled", (Object)buyerinfoabled);
        if ("false".equals(buyerinfoabled)) {
            qrJSON.put("buyerinfodisabled", (Object)"true");
        } else {
            qrJSON.put("buyerinfodisabled", (Object)"false");
        }
        return qrJSON;
    }

    private ApiResult queryGiftReceipt(ScanInvoiceVo scanInvoiceVo) {
        DynamicObject giftReceipt = BusinessDataServiceHelper.loadSingle((String)"sim_gift_receipt", (String)"", (QFilter[])new QFilter("billno", "=", (Object)scanInvoiceVo.getBillNo()).toArray());
        if (giftReceipt == null) {
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5c0f\u7968\u7801\u8ba2\u5355", (String)"QRGetBillServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String receiptState = (giftReceipt = BusinessDataServiceHelper.loadSingle((Object)giftReceipt.getPkValue(), (String)"sim_gift_receipt")).getString("receiptstate");
        if ("3".equals(receiptState)) {
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u8be5\u5c0f\u7968\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u54a8\u8be2\u5546\u5bb6", (String)"QRGetBillServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if ("4".equals(receiptState)) {
            DynamicObject bill;
            if ("billcenter".equals(giftReceipt.getString("source")) && (bill = BusinessDataServiceHelper.loadSingle((String)"sim_isomerism_bill_data", (String)String.join((CharSequence)",", "giftbillno", "giftstatus"), (QFilter[])new QFilter("id", "=", (Object)giftReceipt.getLong("billcenterid")).toArray())) != null) {
                bill.set("giftbillno", (Object)"");
                bill.set("giftstatus", (Object)"");
                ImcSaveServiceHelper.update((DynamicObject)bill);
            }
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u8be5\u5c0f\u7968\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u54a8\u8be2\u5546\u5bb6", (String)"QRGetBillServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        Date expiringDate = giftReceipt.getDate("expiringdate");
        if (expiringDate != null && new Date().after(expiringDate) && !"2".equals(receiptState)) {
            giftReceipt.set("receiptstate", (Object)"4");
            ImcSaveServiceHelper.save((DynamicObject)giftReceipt);
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u8be5\u5c0f\u7968\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u54a8\u8be2\u5546\u5bb6", (String)"QRGetBillServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        BillVo billVo = (BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)giftReceipt);
        billVo.setTotalAmount(billVo.getIncludeTaxAmount().subtract(billVo.getTotalTaxAmount()));
        billVo.setBuyerProperty(Integer.parseInt("0"));
        DynamicObjectCollection items2 = giftReceipt.getDynamicObjectCollection("items");
        ArrayList<BillDetailVo> billDetails = new ArrayList<BillDetailVo>(items2.size());
        for (DynamicObject item : items2) {
            BillDetailVo billDetail = new BillDetailVo();
            billDetail.setGoodsName(item.getString("goodsname"));
            billDetail.setLineProperty(item.getInt("rowtype"));
            if (billDetail.getLineProperty() == 0) {
                billDetail.setLineProperty(2);
            }
            billDetails.add(billDetail);
        }
        billVo.setBillDetail(billDetails);
        if ("2".equals(receiptState)) {
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "issuestatus", "wxid"), (QFilter[])new QFilter("orderno", "=", (Object)giftReceipt.getString("orderno")).toArray());
            if (invoice == null) {
                return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f", (String)"QRGetBillServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            String issueStatus = invoice.getString("issuestatus");
            if (IssueStatusEnum.failed.getCode().equals(issueStatus)) {
                return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u91cd\u65b0\u5f00\u7968", (String)"QRGetBillServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (IssueStatusEnum.ok.getCode().equals(issueStatus)) {
                billVo.setValidState(Integer.parseInt("2"));
                billVo.setWxId(invoice.getString("wxid"));
            } else {
                return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u5f00\u7968\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\uff0c\u957f\u65f6\u95f4\u5904\u4e8e\u5f00\u7968\u4e2d\u8bf7\u8054\u7cfb\u5546\u5bb6", (String)"QRGetBillServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        String source = giftReceipt.getString("source");
        JSONObject qrJSON = new JSONObject();
        if ("billcenter".equals(source)) {
            String availableInvoiceType = giftReceipt.getString("availableinvoicetype");
            List invoiceTypeList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)availableInvoiceType);
            for (String invoiceType : invoiceTypeList) {
                map.put(invoiceType, new BigDecimal("99999999999"));
            }
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)giftReceipt.get("org"));
            if (orgId > 0L) {
                DynamicObject giftSetting = BusinessDataServiceHelper.loadSingle((String)"bdm_st_qr_code_manage", (QFilter[])new QFilter("orgid", "=", (Object)orgId).toArray());
                qrJSON = this.getQrConfig(qrJSON, giftSetting);
            }
        } else {
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)giftReceipt.get("org"));
            DynamicObject giftSetting = BusinessDataServiceHelper.loadSingle((String)"bdm_st_qr_code_manage", (QFilter[])new QFilter("orgid", "=", (Object)orgId).toArray());
            if (giftSetting != null) {
                List invoiceArray = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)giftSetting.getString("invoicetype"));
                for (String invoiceType : invoiceArray) {
                    map.put(invoiceType, new BigDecimal("99999999999"));
                }
                qrJSON = this.getQrConfig(qrJSON, giftSetting);
            } else {
                map.put(InvoiceType.ALL_E_NORMAL.getTypeCode(), new BigDecimal("99999999999"));
                map.put(InvoiceType.ALL_E_SPECIAL.getTypeCode(), new BigDecimal("99999999999"));
                map.put(InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), new BigDecimal("99999999999"));
                map.put(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), new BigDecimal("99999999999"));
            }
        }
        billVo.setInvoiceTypes(map);
        JSONObject resultJSON = JSONObject.parseObject((String)JSON.toJSONString((Object)billVo));
        resultJSON.put("qrViewSetting", (Object)qrJSON);
        return ResponseVo.success((String)resultJSON.toString());
    }

    private JSONObject getQrConfig(JSONObject qrJSON, DynamicObject giftSetting) {
        if (giftSetting != null) {
            qrJSON.put("phonedisplayflag", (Object)giftSetting.getString("phonedisplayflag"));
            qrJSON.put("phonerequiredflag", (Object)giftSetting.getString("phonerequiredflag"));
            qrJSON.put("emaildisplayflag", (Object)giftSetting.getString("emaildisplayflag"));
            qrJSON.put("emailrequiredflag", (Object)giftSetting.getString("emailrequiredflag"));
            qrJSON.put("remarkdisplayflag", (Object)giftSetting.getString("remarkdisplayflag"));
            qrJSON.put("remarktips", (Object)giftSetting.getString("remarktips"));
        }
        return qrJSON;
    }

    public ApiResult oldScan(ScanInvoiceVo scanInvoiceVo, DynamicObject qrKeyDO) {
        BillVo billVo;
        if (qrKeyDO.getBoolean("defaultgoods")) {
            billVo = this.defaultGoodsConvert2BillVo(qrKeyDO, scanInvoiceVo);
            LOGGER.info("QR.GET.BILL-\u9ed8\u8ba4\u5f00\u7968\u9879\u6570\u636e\uff1a" + JSON.toJSONString((Object)billVo));
        } else {
            CallbackResponseVo resp = SendMsg2Erp.send((String)qrKeyDO.getString("systemcode"), (String)"GET.ORDER", (String)scanInvoiceVo.getBillNo());
            if (ApiErrCodeEnum.OK.getCode().equals(resp.getCode())) {
                BillScanErpVo scanErpVo = (BillScanErpVo)((Object)JSON.parseObject((String)resp.getData(), BillScanErpVo.class));
                if (1 == scanErpVo.getCancalState()) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.QR_ORDER_CANCAL.getCode(), (String)ApiErrCodeEnum.QR_ORDER_CANCAL.getMsg());
                }
                billVo = this.erpBillWarpData(scanErpVo);
                LOGGER.info("QR.GET.BILL-\u62c9\u53d6\u7684\u5f00\u7968\u5355\uff1a" + JSON.toJSONString((Object)billVo));
            } else {
                return ResponseVo.fail((String)resp.getCode(), (String)resp.getMessage());
            }
        }
        this.setBill(billVo, qrKeyDO, scanInvoiceVo);
        ApiResult apiResult = this.checkAndSetBill(billVo);
        if (!apiResult.getSuccess()) {
            if (StringUtils.isNotEmpty((CharSequence)scanInvoiceVo.getSystemCode())) {
                SendMsg2Erp.callBackMsg((String)scanInvoiceVo.getSystemCode(), (String)"ORDER.STATUS", (Object)SendErpVo.createMsg((String)"bill.check.error", (String)apiResult.getMessage(), (String)qrKeyDO.getString("eqinfotaxno"), (String)scanInvoiceVo.getBillNo()));
            }
            return apiResult;
        }
        return ResponseVo.success((String)JSON.toJSONString((Object)billVo));
    }

    private BillVo erpBillWarpData(BillScanErpVo scanErpVo) {
        try {
            BillVo billVo = new BillVo();
            BeanUtils.copyProperties((Object)billVo, (Object)((Object)scanErpVo));
            billVo.setTotalAmount(scanErpVo.getBillAmount());
            return billVo;
        }
        catch (Exception e) {
            LOGGER.error("\u79fb\u52a8\u7aef\u5355\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return scanErpVo;
        }
    }

    private void warpSaleInfo(BillVo bill, DynamicObject qrKeyDO) {
        bill.setBillDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        String taxNo = qrKeyDO.getString("eqinfotaxno");
        String orgCode = bill.getOrgCode();
        SaleInfo saleInfo = TaxUtils.getSaleInfoByTaxNoAndOrgCode((String)taxNo, (String)orgCode);
        bill.setSellerName(saleInfo.getSaleName());
        bill.setSellerTaxpayerId(saleInfo.getSaleTaxNo());
        bill.setSellerAddressAndTel(saleInfo.getSaleAddrAndPhone());
        bill.setSellerBankAndAccount(saleInfo.getSaleBankAndBankAcc());
    }

    public void setBill(BillVo billVo, DynamicObject qrKeyDO, ScanInvoiceVo scanInvoiceVo) {
        billVo.setBillNo(scanInvoiceVo.getBillNo());
        billVo.setDeviceNo(qrKeyDO.getString("eqinfono"));
        this.warpSaleInfo(billVo, qrKeyDO);
        if (StringUtils.isEmpty((CharSequence)billVo.getDrawer())) {
            DynamicObject equipmentDO = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)qrKeyDO.getString("eqinfono"), (String)qrKeyDO.getString("eqinfotaxno"));
            billVo.setDrawer(equipmentDO.getString("drawer"));
            billVo.setPayee(equipmentDO.getString("payee"));
            billVo.setReviewer(equipmentDO.getString("reviewer"));
        }
        if (billVo.getDeduction() != null && billVo.getDeduction().compareTo(BigDecimal.ZERO) != 0) {
            billVo.setTaxationStyle(TaxedTypeEnum.deduction.getValue());
        }
        billVo.setInvoiceTypes(qrKeyDO.getString("invoicetype"), qrKeyDO.getString("eqinfotaxno"), qrKeyDO.getString("eqinfono"));
        billVo.setTaxRate(((BillDetailVo)billVo.getBillDetail().get(0)).getTaxRate());
        billVo.setAutoInvoice(1);
        billVo.setPriority(1);
        billVo.setBillProperty(1);
        if (billVo.getDeduction() != null && billVo.getDeduction().compareTo(BigDecimal.ZERO) != 0) {
            billVo.setTaxationStyle(TaxedTypeEnum.deduction.getValue());
        }
        if (billVo.getBillDetail() != null) {
            billVo.getBillDetail().forEach(detailVo -> {
                if (StringUtils.isBlank((Object)detailVo.getPrivilegeFlag())) {
                    detailVo.setPrivilegeFlag(Integer.valueOf("0"));
                }
            });
        }
    }

    public BillVo defaultGoodsConvert2BillVo(DynamicObject qrKeyDO, ScanInvoiceVo scanInvoiceVo) {
        BillVo bill = new BillVo();
        bill.setBillNo(scanInvoiceVo.getBillNo());
        bill.setBillDetail(new ArrayList(1));
        String goodsCode = qrKeyDO.getString("goodscode");
        String goodsName = qrKeyDO.getString("goodsname");
        bill.setTaxationStyle(TaxedTypeEnum.normal.getValue());
        bill.setSystemSource(qrKeyDO.getString("systemcode"));
        bill.setDeviceNo(qrKeyDO.getString("eqinfono"));
        bill.setAutoInvoice(1);
        bill.setIncludeTaxFlag(1);
        bill.setIncludeTaxAmount(scanInvoiceVo.getAmount());
        bill.setTaxRate(qrKeyDO.getString("taxrate"));
        QFilter filter = new QFilter("number", "=", (Object)goodsCode);
        filter.and("name", "=", (Object)goodsName);
        DynamicObject goodInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (String)GoodsInfoConstant.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        BillDetailVo billDetailVo = new BillDetailVo();
        billDetailVo.setLineProperty(2);
        billDetailVo.setDetailRowNo(1);
        if (null == goodInfo) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801%s\u4e0d\u5b58\u5728", (String)"QRGetBillServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]), goodsCode));
        }
        this.setBillData(qrKeyDO, scanInvoiceVo, bill, goodInfo, billDetailVo);
        bill.getBillDetail().add(billDetailVo);
        return bill;
    }

    public void setBillData(DynamicObject qrKeyDO, ScanInvoiceVo scanInvoiceVo, BillVo bill, DynamicObject goodInfo, BillDetailVo billDetailVo) {
        BigDecimal amount = scanInvoiceVo.getAmount().divide(BigDecimal.ONE.add(new BigDecimal(qrKeyDO.getString("taxrate"))), 2, 4);
        bill.setTotalAmount(amount);
        BigDecimal tax = scanInvoiceVo.getAmount().subtract(amount);
        bill.setTotalTaxAmount(tax);
        billDetailVo.setGoodsCode(qrKeyDO.getString("goodscode"));
        billDetailVo.setGoodsName(qrKeyDO.getString("goodsname"));
        billDetailVo.setSpecification(goodInfo.get("specifications") + "");
        billDetailVo.setUnits(goodInfo.get("unit") + "");
        String price = goodInfo.get("price") + "";
        if (StringUtils.isNotBlank((CharSequence)price) && !"0".equals(price) && !price.startsWith("0E")) {
            BigDecimal num;
            if ("1".equals(goodInfo.get("isinclusive") + "")) {
                billDetailVo.setIncludeTaxPrice(goodInfo.get("price") + "");
                billDetailVo.setPrice(goodInfo.get("prices") + "");
                num = UnitPriceHelper.calcNum((BigDecimal)bill.getIncludeTaxAmount(), (BigDecimal)new BigDecimal(billDetailVo.getIncludeTaxPrice()));
                billDetailVo.setQuantity(num.toPlainString());
            } else {
                billDetailVo.setIncludeTaxPrice(goodInfo.get("prices") + "");
                billDetailVo.setPrice(goodInfo.get("price") + "");
                num = UnitPriceHelper.calcNum((BigDecimal)bill.getTotalAmount(), (BigDecimal)new BigDecimal(billDetailVo.getPrice()));
                billDetailVo.setQuantity(num.toPlainString());
            }
        }
        billDetailVo.setRevenueCode(goodInfo.getDynamicObject("taxcode").getString("number"));
        String priFlag = goodInfo.get("privilegeflag") + "";
        billDetailVo.setPrivilegeFlag(Integer.valueOf(StringUtils.isEmpty((CharSequence)priFlag) ? 0 : Integer.parseInt(priFlag)));
        billDetailVo.setPrivilegeContent(goodInfo.get("privilegetype") + "");
        billDetailVo.setIncludeTaxAmount(scanInvoiceVo.getAmount());
        billDetailVo.setAmount(amount);
        billDetailVo.setTaxRate(qrKeyDO.getString("taxrate"));
        billDetailVo.setTaxAmount(tax);
    }

    private ApiResult checkAndSetBill(BillVo billVo) {
        billVo.setBillProperty(1);
        VerifyResult devResult = BaseCheckService.checkDevNo(billVo.getDeviceNo(), billVo.getSellerTaxpayerId());
        if (!devResult.isSucceed()) {
            return ResponseVo.fail((String)devResult.getCode(), (String)devResult.getDesc());
        }
        Map orgInfo = ApiVerifyUtil.checkAndFillOrgCode((String)billVo.getSellerTaxpayerId(), (String)billVo.getOrgCode(), (String)billVo.getDeviceNo());
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)orgInfo.get("checkMsg")))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5b58\u5728\u9519\u8bef[%2$s]", (String)"QRGetBillServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), orgInfo.get("checkMsg")));
        }
        billVo.setOrgId(Long.valueOf((String)orgInfo.get("orgId")));
        QFilter qFilter = new QFilter("number", "=", (Object)billVo.getSellerTaxpayerId());
        DynamicObject seller = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_enterprise_baseinfo"), (QFilter[])qFilter.toArray());
        if (null == seller) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[%2$s]\u672a\u5728\u5e73\u53f0\u7ef4\u62a4", (String)"QRGetBillServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), billVo.getSellerTaxpayerId()));
        }
        qFilter = new QFilter("taxno", "=", (Object)billVo.getSellerTaxpayerId()).and("ischeck", "=", (Object)"1");
        DynamicObject sellerInvoiceSetting = BusinessDataServiceHelper.loadSingle((String)"sim_invoice_setting", (String)"invoiceaddr,openuserbank", (QFilter[])qFilter.toArray());
        if (!billVo.getSellerTaxpayerId().equals(seller.getString("number"))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4f20\u5165\u7684\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4", (String)"QRGetBillServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ApiResult validResult = BillValidaterHelper.validBillSeller((BillVo)billVo, (DynamicObject)seller, (DynamicObject)sellerInvoiceSetting, (ValidTypeEnum)ValidTypeEnum.BILL);
        if (!validResult.getSuccess()) {
            return validResult;
        }
        if (StringUtils.isNotBlank((CharSequence)billVo.getDrawer()) && (!GBKUtils.checkValidGbk((String)billVo.getDrawer()) || GBKUtils.getGBKLength((String)billVo.getDrawer()) > 16)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5f00\u7968\u4eba[%2$s]\u4e0d\u5408\u6cd5-\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u662f\u8d85\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"QRGetBillServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), billVo.getDrawer(), 16));
        }
        if (StringUtils.isNotBlank((CharSequence)billVo.getPayee()) && (!GBKUtils.checkValidGbk((String)billVo.getPayee()) || GBKUtils.getGBKLength((String)billVo.getPayee()) > 16)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5f00\u7968\u4eba[%2$s]\u4e0d\u5408\u6cd5-\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u662f\u8d85\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"QRGetBillServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), billVo.getPayee(), 16));
        }
        if (StringUtils.isNotBlank((CharSequence)billVo.getReviewer()) && (!GBKUtils.checkValidGbk((String)billVo.getReviewer()) || GBKUtils.getGBKLength((String)billVo.getReviewer()) > 16)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5f00\u7968\u4eba[%2$s]\u4e0d\u5408\u6cd5-\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u662f\u8d85\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"QRGetBillServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), billVo.getReviewer(), 16));
        }
        validResult = BillValidaterHelper.validBillDetailEntrance((BillVo)billVo, (ValidTypeEnum)ValidTypeEnum.BILL);
        if (!validResult.getSuccess()) {
            return validResult;
        }
        return ResponseVo.success((String)"success");
    }
}

