/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.qr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class QRGetFieldSettingServiceImpl
implements OpenApiService {
    private static final Log LOG = LogFactory.getLog(QRGetFieldSettingServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject paramObject = JSONObject.parseObject((String)requestVo.getData());
        LOG.info("\u83b7\u53d6\u9759\u6001\u4e8c\u7ef4\u7801\u5b57\u6bb5\u914d\u7f6e\u7684\u8bf7\u6c42\u53c2\u6570:{}", (Object)paramObject);
        String org = paramObject.getString("org");
        String sellerTaxpayerId = paramObject.getString("sellerTaxpayerId");
        String wxId = paramObject.getString("wxId");
        if (StringUtils.isBlank((CharSequence)org) || StringUtils.isBlank((CharSequence)sellerTaxpayerId)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("taxno", "=", (Object)sellerTaxpayerId).and("org.id", "=", (Object)Long.valueOf(org)).and("enable", "=", (Object)"1");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_static_qrcode_setting", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return ResponseVo.success((String)ResManager.loadKDString((String)"\u6210\u529f", (String)"QRGetFieldSettingServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), null);
        }
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("static_qrcode_set_entry");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("org", (Object)org);
        jsonObject.put("sellerTaxpayerId", (Object)sellerTaxpayerId);
        jsonObject.put("wxId", (Object)wxId);
        DynamicObject epInfoObject = dynamicObject.getDynamicObject("epinfo");
        if (epInfoObject != null) {
            jsonObject.put("sellerCompanyName", (Object)epInfoObject.getString("name"));
        }
        jsonObject.put("invoiceTypeList", (Object)this.getInvoiceTypeListMethod(dynamicObject));
        jsonObject.put("remarkTip", (Object)dynamicObject.getString("remark"));
        jsonObject.put("phoneProperty", (Object)this.getPhonePropertyMethod(dynamicObject));
        jsonObject.put("emailProperty", (Object)this.getEmailPropertyMethod(dynamicObject));
        jsonObject.put("filedProperty", (Object)this.getFieldPropertyMethod(dynamicObjectCollection));
        String resultData = jsonObject.toJSONString();
        LOG.info("QRGetFieldSettingServiceImpl, resultData:{}", (Object)resultData);
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u6210\u529f", (String)"QRGetFieldSettingServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)jsonObject);
    }

    private String[] getInvoiceTypeListMethod(DynamicObject dynamicObject) {
        String invoiceType = dynamicObject.getString("invoicetype");
        if (StringUtils.isNotBlank((CharSequence)invoiceType)) {
            String[] array = invoiceType.split(",");
            ArrayList<String> list = new ArrayList<String>(8);
            if (array != null && array.length > 0) {
                for (int i = 0; i < array.length; ++i) {
                    if (StringUtils.isBlank((CharSequence)array[i])) continue;
                    list.add(array[i]);
                }
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    private JSONArray getFieldPropertyMethod(DynamicObjectCollection dynamicObjectCollection) {
        JSONArray jsonArray = new JSONArray();
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return jsonArray;
        }
        for (DynamicObject qrCodeSettingItem : dynamicObjectCollection) {
            JSONObject subObject = new JSONObject();
            subObject.put("fieldName", (Object)qrCodeSettingItem.getString("fieldname"));
            String fieldType = qrCodeSettingItem.getString("fieldtype");
            subObject.put("fieldType", (Object)fieldType);
            subObject.put("fieldKey", (Object)qrCodeSettingItem.getString("fieldkey"));
            subObject.put("required", (Object)this.getRequiredPropertyMethod(qrCodeSettingItem));
            subObject.put("helpText", (Object)qrCodeSettingItem.getString("helptext"));
            subObject.put("bizControl", (Object)qrCodeSettingItem.getString("bizcontrol"));
            String fieldValue = qrCodeSettingItem.getString("fieldvalue");
            if ("radio".equals(fieldType) || "checkbox".equals(fieldType)) {
                if (StringUtils.isBlank((CharSequence)fieldValue)) continue;
                JSONArray subArray = JSONArray.parseArray((String)fieldValue);
                subObject.put("fieldItem", (Object)subArray);
            }
            jsonArray.add((Object)subObject);
        }
        return jsonArray;
    }

    private String getRequiredPropertyMethod(DynamicObject qrCodeSettingItem) {
        String required = qrCodeSettingItem.getString("fieldrequired");
        if ("true".equals(required)) {
            return "1";
        }
        return "0";
    }

    private JSONObject getEmailPropertyMethod(DynamicObject dynamicObject) {
        String emailVisible = dynamicObject.getString("email_visable");
        emailVisible = "true".equals(emailVisible) ? "1" : "0";
        String emailInput = dynamicObject.getString("email_input");
        emailInput = "true".equals(emailInput) ? "1" : "0";
        JSONObject subObject = new JSONObject();
        subObject.put("visible", (Object)emailVisible);
        subObject.put("required", (Object)emailInput);
        return subObject;
    }

    private JSONObject getPhonePropertyMethod(DynamicObject dynamicObject) {
        String phoneVisible = dynamicObject.getString("phone_visable");
        phoneVisible = "true".equals(phoneVisible) ? "1" : "0";
        String phoneInput = dynamicObject.getString("phone_input");
        phoneInput = "true".equals(phoneInput) ? "1" : "0";
        JSONObject subObject = new JSONObject();
        subObject.put("visible", (Object)phoneVisible);
        subObject.put("required", (Object)phoneInput);
        return subObject;
    }
}

