/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.qr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.openapi.ScanInvoiceVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.bill.BillPushServiceImpl;

public class QRInvoiceOpenServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(QRInvoiceOpenServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRInvoiceOpenServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ScanInvoiceVo scanInvoiceVo = null;
        if (StringUtils.isNotEmpty((CharSequence)requestVo.getData())) {
            scanInvoiceVo = (ScanInvoiceVo)JSON.parseObject((String)requestVo.getData(), ScanInvoiceVo.class);
        }
        if (scanInvoiceVo == null || scanInvoiceVo.getBill() == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRInvoiceOpenServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        LOGGER.info("QRInvoiceOpen \u5165\u53c2: " + JSONObject.toJSONString((Object)requestVo));
        BillVo billVo = scanInvoiceVo.getBill();
        if ("giftReceipt".equals(scanInvoiceVo.getBillSource())) {
            return this.giftReceiptIssue(scanInvoiceVo, billVo);
        }
        DynamicObject billDO = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])new QFilter("billno", "=", (Object)scanInvoiceVo.getBillNo()).toArray());
        BillPushServiceImpl billPushService = new BillPushServiceImpl();
        if (billDO == null) {
            String qrKey = scanInvoiceVo.getQrKey();
            DynamicObject qrKeyDO = BusinessDataServiceHelper.loadSingle((String)"bdm_scaninvoice_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_scaninvoice_setting"), (QFilter[])new QFilter("number", "=", (Object)qrKey).toArray());
            ArrayList<BillVo> billList = new ArrayList<BillVo>(1);
            billVo.setAutoInvoice(1);
            billVo.setWxId(scanInvoiceVo.getUserId());
            billList.add(billVo);
            requestVo.setData(JSON.toJSONString(billList));
            requestVo.setBusinessSystemCode(qrKeyDO.getString("systemcode"));
            return billPushService.processer(requestVo);
        }
        billDO.set("buyername", (Object)billVo.getBuyerName());
        billDO.set("buyertaxno", (Object)billVo.getBuyerTaxpayerId().replaceAll(" ", "").toUpperCase());
        billDO.set("buyeraddr", (Object)billVo.getBuyerAddressAndTel());
        billDO.set("buyerbank", (Object)billVo.getBuyerBankAndAccount());
        billDO.set("buyerphone", (Object)billVo.getBuyerRecipientPhone());
        billDO.set("buyeremail", (Object)billVo.getBuyerRecipientMail());
        billDO.set("buyerproperty", (Object)billVo.getBuyerProperty());
        if (StringUtils.isNotBlank((CharSequence)billVo.getInvoiceType())) {
            billDO.set("invoicetype", (Object)billVo.getInvoiceType());
        }
        billDO.set("wxid", (Object)scanInvoiceVo.getUserId());
        billDO.set("invoiceremark", (Object)billVo.getRemark());
        ImcSaveServiceHelper.update((DynamicObject)billDO);
        HashSet<Object> autoInvoice = new HashSet<Object>(1);
        HashSet<Object> autoMerge = new HashSet<Object>(1);
        autoInvoice.add(billDO.getPkValue());
        billPushService.executeAutoIssueInvoice(autoInvoice, autoMerge);
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u5f00\u7968\u6210\u529f", (String)"QRInvoiceOpenServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), null);
    }

    private ApiResult giftReceiptIssue(ScanInvoiceVo scanInvoiceVo, BillVo billVo) {
        boolean isAllEle;
        DynamicObject giftReceipt = BusinessDataServiceHelper.loadSingle((String)"sim_gift_receipt", (String)"receiptstate", (QFilter[])new QFilter("billno", "=", (Object)scanInvoiceVo.getBillNo()).toArray());
        if (giftReceipt == null) {
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5c0f\u7968\u7801", (String)"QRInvoiceOpenServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!"1".equals(giftReceipt.getString("receiptstate"))) {
            return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u5f00\u7968\u6210\u529f", (String)"QRInvoiceOpenServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), null);
        }
        String orderNo = UUID.randomUUID();
        giftReceipt = BusinessDataServiceHelper.loadSingle((Object)giftReceipt.getPkValue(), (String)"sim_gift_receipt");
        giftReceipt.set("buyerphone", (Object)billVo.getBuyerRecipientPhone());
        giftReceipt.set("receiptstate", (Object)"2");
        giftReceipt.set("orderno", (Object)orderNo);
        ImcSaveServiceHelper.save((DynamicObject)giftReceipt);
        DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)giftReceipt, (DynamicObject)invoice, (boolean)false, (boolean)true, (boolean)true);
        invoice.set("buyername", (Object)billVo.getBuyerName());
        invoice.set("buyertaxno", (Object)billVo.getBuyerTaxpayerId().replaceAll(" ", "").toUpperCase());
        invoice.set("buyeraddr", (Object)billVo.getBuyerAddressAndTel());
        invoice.set("buyerbank", (Object)billVo.getBuyerBankAndAccount());
        invoice.set("buyerphone", (Object)billVo.getBuyerRecipientPhone());
        invoice.set("buyeremail", (Object)billVo.getBuyerRecipientMail());
        invoice.set("buyerproperty", (Object)billVo.getBuyerProperty());
        invoice.set("invoicetype", (Object)billVo.getInvoiceType());
        invoice.set("invoiceamount", (Object)invoice.getBigDecimal("totalamount").subtract(invoice.getBigDecimal("totaltax")));
        invoice.set("orgid", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)giftReceipt.get("org")));
        invoice.set("createtime", (Object)new Date());
        invoice.set("buyertype", (Object)"12");
        invoice.set("specialtype", (Object)"00");
        invoice.set("billdate", giftReceipt.get("createtime"));
        invoice.set("issuetype", (Object)"0");
        invoice.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
        invoice.set("batchbelong", (Object)invoice.getString("billno"));
        invoice.set("issuebillstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        invoice.set("billstatus", (Object)"");
        invoice.set("issuewritebackstatus", (Object)"");
        invoice.set("abolishwritebackstatus", (Object)"");
        invoice.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        invoice.set("orderno", (Object)orderNo);
        invoice.set("wxid", (Object)scanInvoiceVo.getUserId());
        invoice.set("systemsource", (Object)giftReceipt.getString("source"));
        DynamicObjectCollection giftReceiptItems = giftReceipt.getDynamicObjectCollection("items");
        DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || AllEleAuthHelper.elePaperSetValue((Object)invoice.getString("salertaxno"), (Object)invoice.getString("invoicetype"));
        if (giftReceiptItems != null && invoiceItems != null && giftReceiptItems.size() > 0 && invoiceItems.size() > 0) {
            for (int i = 0; i < invoiceItems.size(); ++i) {
                String[] array;
                DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
                if ("1".equals(invoiceItem.getString("rowtype"))) {
                    ((DynamicObject)invoiceItems.get(i - 1)).set("rowtype", (Object)"2");
                }
                BigDecimal amount = invoiceItem.getBigDecimal("taxamount").subtract(invoiceItem.getBigDecimal("tax"));
                invoiceItem.set("amount", (Object)amount);
                invoiceItem.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)invoiceItem.getBigDecimal("num"), (boolean)isAllEle));
                DynamicObject goodsObject = ((DynamicObject)giftReceiptItems.get(i)).getDynamicObject("goodsid");
                if (goodsObject == null || (array = SimpleGoodsNameUtil.getInvoiceItemGoodsNameByCondition((DynamicObject)goodsObject)) == null || array.length != 2) continue;
                invoiceItem.set("simplegoodsname", (Object)array[0]);
                invoiceItem.set("goodsname", (Object)array[1]);
            }
        }
        ImcSaveServiceHelper.save((DynamicObject)invoice);
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{invoice});
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u5f00\u7968\u6210\u529f", (String)"QRInvoiceOpenServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), null);
    }
}

