/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.redconfirm;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.allelespecial.BillVehicheVesselShipVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.service.InvoiceAllESpecialCheckService;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.redconfirm.RedConfirmApplyRequestDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.alle.constant.EInvoiceErrCodeEnum;
import kd.imc.sim.formplugin.openapi.service.impl.alle.service.ApiRedService;
import kd.imc.sim.formplugin.openapi.service.impl.alle.service.PartRedService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public class RedConfirmBillApplyServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(RedConfirmBillApplyServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        ApiResult result;
        boolean isLeqiChannel;
        String invoiceCode;
        RedConfirmApplyRequestDTO requestDTO;
        if (log.isInfoEnabled()) {
            log.info(String.format("\u4e1a\u52a1\u7cfb\u7edf[%s]\u521b\u5efa\u7ea2\u5b57\u786e\u8ba4\u5355\u4f20\u5165\u53c2\u6570[%s]", requestVo.getBusinessSystemCode(), requestVo.getData()));
        }
        if ((requestDTO = (RedConfirmApplyRequestDTO)JSONObject.parseObject((String)requestVo.getData(), RedConfirmApplyRequestDTO.class)) == null || StringUtils.isBlank((CharSequence)requestDTO.getInvoiceNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillApplyServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!StringUtils.isEmpty((CharSequence)requestDTO.getSerialNo())) {
            requestDTO.setOrderNo(requestDTO.getSerialNo());
        }
        if (StringUtils.isBlank((CharSequence)(invoiceCode = requestDTO.getInvoiceCode())) && requestDTO.getInvoiceNo().length() != 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801\u9519\u8bef\uff0c\u957f\u5ea6\u5e94\u4e3a20", (String)"RedConfirmBillApplyServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)requestDTO.getRedReason())) {
            requestDTO.setRedReason(RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode());
        } else if (Arrays.stream(RedConfirmBillRedReasonEnum.values()).noneMatch(redReason -> redReason.getBillCode().equals(requestDTO.getRedReason()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0\u586b\u5199\u9519\u8bef", (String)"RedConfirmBillApplyServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)requestDTO.getOrderNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillApplyServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!Pattern.matches("^[0-9a-zA-Z]{20}$", requestDTO.getOrderNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u53ea\u80fd\u5305\u542b\u6570\u5b57\u4e0e\u5b57\u6bcd\u4e14\u4e3a20\u4f4d", (String)"RedConfirmBillApplyServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (String.valueOf(requestDTO.getRemark()).length() > 200) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_REMARK_OVER.getCode(), (String)ApiErrCodeEnum.BILL_PUSH_REMARK_OVER.getMsg());
        }
        InvoiceAllESpecialCheckService invoiceAllESpecialCheckService = new InvoiceAllESpecialCheckService();
        invoiceAllESpecialCheckService.dealCheckTravelerItemMethod(requestDTO.getOrderNo(), requestDTO.getTravelerList());
        List<BillVehicheVesselShipVo> vehicheVesselShipList = requestDTO.getVehicheVesselShipList();
        if (vehicheVesselShipList != null && !vehicheVesselShipList.isEmpty()) {
            invoiceAllESpecialCheckService.dealCheckVesselVehicheItemMethod(requestDTO.getOrderNo(), requestDTO.getVehicheVesselShipList());
        }
        String account = requestDTO.getAccount();
        DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "number", "uploadstatus", "govuuid", "confirmstatus"), (QFilter[])new QFilter("orderno", "=", (Object)requestDTO.getOrderNo()).toArray());
        if (redConfirmBills != null && redConfirmBills.length > 1) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_MORE_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_MORE_FAIL.getMsg(), requestDTO.getSerialNo()));
        }
        if (redConfirmBills != null && redConfirmBills.length == 1) {
            ApiResult result2;
            boolean isLeqiChannel2;
            DynamicObject redConfirmBill = redConfirmBills[0];
            if ("1".equals(redConfirmBill.getString("uploadstatus")) && !RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirmBill.getString("confirmstatus"))) {
                return ResponseVo.success((String)this.createReturnJson(redConfirmBill));
            }
            redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)redConfirmBill.getPkValue(), (String)"sim_red_confirm_bill");
            String specialType = redConfirmBill.getString("specialtype");
            String sellerTaxpayerId = redConfirmBill.getString("salertaxno");
            String buyerTaxpayerId = redConfirmBill.getString("buyertaxno");
            redConfirmBill.set("remark", (Object)requestDTO.getRemark());
            String taxNo = sellerTaxpayerId;
            if ("E12".equals(specialType)) {
                taxNo = buyerTaxpayerId;
            }
            if (!(isLeqiChannel2 = EnterpriseHelper.isLqptChannel((String)taxNo)) && StringUtils.isNotBlank((CharSequence)account)) {
                String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                }
                redConfirmBill.set("account", (Object)account);
                redConfirmBill.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)taxNo, (String)account));
            }
            if ((result2 = RedConfirmBillHelper.submit((DynamicObject)redConfirmBill)) != null) {
                return result2;
            }
            return ResponseVo.success((String)this.createReturnJson(redConfirmBill));
        }
        if (QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])new QFilter("orderno", "=", (Object)requestDTO.getOrderNo()).toArray())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u5df2\u5728\u53d1\u7968\u4e2d\u5b58\u5728", (String)"RedConfirmBillApplyServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        DynamicObject blueInvoiceDO = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicestatus", "invoiceamount"), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)requestDTO.getInvoiceNo()).toArray());
        if (blueInvoiceDO == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), (String)ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4e0d\u5b58\u5728\uff01", (String)"RedConfirmBillApplyServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        blueInvoiceDO = BusinessDataServiceHelper.loadSingle((Object)blueInvoiceDO.getPkValue(), (String)"sim_vatinvoice");
        DynamicObject redConfirm = null;
        String specialType = blueInvoiceDO.getString("specialtype");
        String sellerTaxpayerId = blueInvoiceDO.getString("salertaxno");
        String buyerTaxpayerId = blueInvoiceDO.getString("buyertaxno");
        String taxNo = sellerTaxpayerId;
        if ("E12".equals(specialType)) {
            taxNo = buyerTaxpayerId;
        }
        if (!(isLeqiChannel = EnterpriseHelper.isLqptChannel((String)taxNo))) {
            if (StringUtils.isNotBlank((CharSequence)account)) {
                String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                }
            } else {
                account = AllEleAuthHelper.getEleAccount((String)taxNo, (boolean)true);
            }
        }
        requestDTO.setAccount(account);
        boolean isAllRed = false;
        if (requestDTO.getInvoiceDetail() == null || requestDTO.getInvoiceDetail().isEmpty()) {
            isAllRed = true;
        } else {
            BigDecimal limitRed = blueInvoiceDO.getBigDecimal("remainredamount");
            if (MathUtils.isZero((BigDecimal)limitRed)) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20025.getCode(), (String)EInvoiceErrCodeEnum.AllE_RED_20025.getMsg());
            }
            String errorMsg = ApiRedService.dealCheckInvoiceDetailMethod(requestDTO.getOrderNo(), requestDTO.getInvoiceDetail(), blueInvoiceDO.getString("specialtype"));
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.ERROR.getCode(), (String)errorMsg);
            }
            BigDecimal redTotalAmount = ApiRedService.checkRedItems(requestDTO.getInvoiceDetail());
            if (limitRed.compareTo(redTotalAmount.abs()) < 0) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20019.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u53ef\u7ea2\u51b2\u9650\u989d\uff0c\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e3a:%s", (String)"RedConfirmBillApplyServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), limitRed.setScale(2, 4).toPlainString()));
            }
            if (redTotalAmount.abs().compareTo(blueInvoiceDO.getBigDecimal("invoiceamount")) == 0) {
                isAllRed = true;
            } else {
                if ("2".equals(requestDTO.getRedReason())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), (String)ResManager.loadKDString((String)"\u5f00\u7968\u6709\u8bef\u4e0d\u80fd\u90e8\u5206\u7ea2\u51b2", (String)"RedConfirmBillApplyServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                requestDTO.setRedReason(RedConfirmBillRedReasonEnum.getCodeByBillCode((String)requestDTO.getRedReason()));
                redConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
                DynamicObjectUtil.copyDynamicObject((DynamicObject)blueInvoiceDO, (DynamicObject)redConfirm);
                redConfirm.set("issuetime", null);
                redConfirm.set("remark", null);
                this.buildPartRedMain(requestDTO, blueInvoiceDO, redConfirm);
                PartRedService partRedService = new PartRedService();
                partRedService.buildRedConfirmItem(blueInvoiceDO, requestDTO.getInvoiceDetail(), requestDTO.getRedReason(), redConfirm);
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirm}, null);
                if (!operationResult.isSuccess()) {
                    throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
                }
            }
        }
        if (isAllRed) {
            redConfirm = RedConfirmBillHelper.formatRedConfirm((String)"", (String)requestDTO.getOrderNo(), (String)RedConfirmBillRedReasonEnum.getCodeByBillCode((String)requestDTO.getRedReason()), (DynamicObject)blueInvoiceDO, (String)account);
            if (StringUtils.isNotBlank((CharSequence)account) && !isLeqiChannel) {
                redConfirm.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)taxNo, (String)account));
            }
            redConfirm.set("interfacecode", (Object)OpenApiInterfaceCodeEnum.REDCONFIRMBILL_APPLY.getCode());
            redConfirm.set("remark", (Object)requestDTO.getRemark());
            String errorMsg = ApiRedService.dealCheckInvoiceDetailMethod(requestDTO.getOrderNo(), requestDTO.getInvoiceDetail(), blueInvoiceDO.getString("specialtype"));
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.ERROR.getCode(), (String)errorMsg);
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirm}, null);
            if (!operationResult.isSuccess()) {
                throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
            }
        }
        if ((result = RedConfirmBillHelper.submit(redConfirm)) != null) {
            return result;
        }
        return ResponseVo.success((String)this.createReturnJson(redConfirm));
    }

    private void buildPartRedMain(RedConfirmApplyRequestDTO requestDTO, DynamicObject blueInvoiceDO, DynamicObject redConfirm) {
        redConfirm.set("orderno", (Object)requestDTO.getOrderNo());
        redConfirm.set("org", blueInvoiceDO.get("orgid"));
        redConfirm.set("useorg", blueInvoiceDO.get("orgid"));
        redConfirm.set("createorg", blueInvoiceDO.get("orgid"));
        redConfirm.set("remark", (Object)requestDTO.getRemark());
        redConfirm.set("ctrlstrategy", (Object)"7");
        redConfirm.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        redConfirm.set("originalinvoiceno", blueInvoiceDO.get("invoiceno"));
        redConfirm.set("originalinvoicecode", blueInvoiceDO.get("invoicecode"));
        redConfirm.set("invoiceno", (Object)"");
        redConfirm.set("originalissuetime", blueInvoiceDO.get("issuetime"));
        String originalInvoiceType = blueInvoiceDO.getString("invoicetype");
        redConfirm.set("originalinvoicetype", (Object)originalInvoiceType);
        redConfirm.set("invoicetype", (Object)InvoiceType.blueTypeToAllEType((String)originalInvoiceType));
        String specialType = InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeBySpecialType((String)blueInvoiceDO.getString("specialtype"));
        redConfirm.set("specialtype", (Object)specialType);
        redConfirm.set("systemsource", (Object)blueInvoiceDO.getString("systemsource"));
        redConfirm.set("uploadstatus", (Object)"0");
        redConfirm.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
        redConfirm.set("enteridentity", (Object)"0");
        redConfirm.set("redreason", (Object)requestDTO.getRedReason());
        redConfirm.set("source", (Object)"4");
        redConfirm.set("status", (Object)BillHelper.getBillStatusByTableName((String)"sim_red_confirm_bill", (String)redConfirm.getString("source")));
        redConfirm.set("enable", (Object)"1");
        redConfirm.set("creator", (Object)RequestContext.get().getUserId());
        redConfirm.set("account", (Object)requestDTO.getAccount());
        redConfirm.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)blueInvoiceDO.getString("salertaxno"), (String)requestDTO.getAccount()));
        redConfirm.set("invoiceamount", (Object)redConfirm.getBigDecimal("invoiceamount").negate());
        redConfirm.set("totaltax", (Object)redConfirm.getBigDecimal("totaltax").negate());
        redConfirm.set("totalamount", (Object)redConfirm.getBigDecimal("totalamount").negate());
        redConfirm.set("interfacecode", (Object)OpenApiInterfaceCodeEnum.REDCONFIRMBILL_APPLY.getCode());
    }

    private String createReturnJson(DynamicObject redConfirmBill) {
        JSONObject json = new JSONObject();
        json.put("number", (Object)redConfirmBill.getString("number"));
        json.put("govRedConfirmBillUuid", (Object)redConfirmBill.getString("govuuid"));
        json.put("confirmStatus", (Object)redConfirmBill.getString("confirmstatus"));
        return json.toJSONString();
    }
}

