/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.redconfirm;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.redconfirm.RedConfirmRevokeRequestDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.redconfirm.RedConfirmBillRevokeServiceImpl;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.redconfirm.op.RedConfirmBillRefuseOp;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;

public class RedConfirmBillConfirmServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(RedConfirmBillRevokeServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        RedConfirmRevokeRequestDTO invoiceDto;
        if (log.isInfoEnabled()) {
            log.info(String.format("\u4e1a\u52a1\u7cfb\u7edf[%s]\u786e\u8ba4\u7ea2\u5b57\u786e\u8ba4\u5355\u4f20\u5165\u53c2\u6570[%s]", requestVo.getBusinessSystemCode(), requestVo.getData()));
        }
        if ((invoiceDto = (RedConfirmRevokeRequestDTO)JSONObject.parseObject((String)requestVo.getData(), RedConfirmRevokeRequestDTO.class)) == null || StringUtils.isBlank((CharSequence)invoiceDto.getNumber())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_EMPTY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillConfirmServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)invoiceDto.getQrlx()) || StringUtils.equalsIgnoreCase((CharSequence)invoiceDto.getQrlx(), (CharSequence)"C") || !StringUtils.equalsIgnoreCase((CharSequence)invoiceDto.getQrlx(), (CharSequence)"N") && !StringUtils.equalsIgnoreCase((CharSequence)invoiceDto.getQrlx(), (CharSequence)"Y")) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_EMPTY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4f20\u5165\u4e0d\u5408\u6cd5", (String)"RedConfirmBillConfirmServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!StringUtils.equals((CharSequence)invoiceDto.getEnteridentity(), (CharSequence)"0") && !StringUtils.equals((CharSequence)invoiceDto.getEnteridentity(), (CharSequence)"1")) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_ENTERIDENTITY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5f55\u5165\u65b9\u9519\u8bef", (String)"RedConfirmBillConfirmServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)invoiceDto.getTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4f20\u5165\u4e0d\u5408\u6cd5", (String)"RedConfirmBillConfirmServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        DynamicObject redConfirmBill = RedConfirmBillRevokeServiceImpl.redConfirmBillQuery(invoiceDto);
        if (redConfirmBill == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_EMPTY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmBillConfirmServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)redConfirmBill.getString("salertaxno"), (CharSequence)invoiceDto.getTaxNo()) && !StringUtils.equalsIgnoreCase((CharSequence)redConfirmBill.getString("buyertaxno"), (CharSequence)invoiceDto.getTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NOT_FIND_INV_BY_SELLER_TAX_NO.getCode(), (String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0d\u5339\u914d", (String)"RedConfirmBillConfirmServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if ((StringUtils.equals((CharSequence)redConfirmBill.getString("enteridentity"), (CharSequence)"0") && StringUtils.equalsIgnoreCase((CharSequence)invoiceDto.getTaxNo(), (CharSequence)redConfirmBill.getString("buyertaxno")) || StringUtils.equals((CharSequence)redConfirmBill.getString("enteridentity"), (CharSequence)"1") && StringUtils.equalsIgnoreCase((CharSequence)invoiceDto.getTaxNo(), (CharSequence)redConfirmBill.getString("salertaxno"))) && (redConfirmBill.getString("confirmstatus").equals("02") || redConfirmBill.getString("confirmstatus").equals("03"))) {
            String confirmStatus = redConfirmBill.getString("confirmstatus");
            String account = "";
            if (!EnterpriseHelper.isLqptChannel((String)invoiceDto.getTaxNo())) {
                account = invoiceDto.getAccount();
                String taxNo = invoiceDto.getTaxNo();
                if (StringUtils.isNotBlank((CharSequence)account)) {
                    String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
                    if (StringUtils.isNotBlank((CharSequence)msg)) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                    }
                } else {
                    account = AllEleAuthHelper.getEleAccount((String)taxNo, (boolean)true);
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)invoiceDto.getQrlx(), (CharSequence)"Y")) {
                ApiResult riskControlResult = BillRiskControlService.riskControlSingleApi((DynamicObject)redConfirmBill, (String)"sim_red_confirm_bill", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_CONFIRM);
                if (riskControlResult != null) {
                    return riskControlResult;
                }
                RedConfirmBillHelper.redConfirmBillConfirmMethod((DynamicObject)redConfirmBill, (String)account);
                if (!StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)confirmStatus) && StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)"04")) {
                    ImcSaveServiceHelper.save((DynamicObject)redConfirmBill);
                    return ResponseVo.success((String)ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f", (String)"RedConfirmBillConfirmServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_REVOKE_FAIL.getCode(), (String)redConfirmBill.getString("failreason"));
            }
            RedConfirmBillRefuseOp.redConfirmBillRefuseMethod((DynamicObject)redConfirmBill, (String)account);
            if (!StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)confirmStatus) && (StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)"05") || StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)"06"))) {
                ImcSaveServiceHelper.save((DynamicObject)redConfirmBill);
                return ResponseVo.success((String)ResManager.loadKDString((String)"\u62d2\u7edd\u6210\u529f", (String)"RedConfirmBillConfirmServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_REVOKE_FAIL.getCode(), (String)redConfirmBill.getString("failreason"));
        }
        if (!redConfirmBill.getString("confirmstatus").equals("02") && !redConfirmBill.getString("confirmstatus").equals("03")) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NOT_FIND_INV_BY_SELLER_TAX_NO.getCode(), (String)ResManager.loadKDString((String)"\u6b64\u5355\u636e\u72b6\u6001\u4e0d\u7b26\u5408\u786e\u8ba4/\u62d2\u7edd\u6761\u4ef6", (String)"RedConfirmBillConfirmServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return ResponseVo.fail((String)ApiErrCodeEnum.NOT_FIND_INV_BY_SELLER_TAX_NO.getCode(), (String)ResManager.loadKDString((String)"\u7b49\u5f85\u5bf9\u65b9\u786e\u8ba4/\u62d2\u7edd", (String)"RedConfirmBillConfirmServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }
}

