/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.redinfo;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.dto.redinfo.RedInfoApplyResponseDTO;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.common.vo.openapi.RedInfoBillApplyVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.check.BaseCheckService;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class RedInfoBillApplyServiceImpl
implements OpenApiService {
    private static final String[] applyers = new String[]{RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode(), RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode(), RedInfoConstant.ApplicantEnum.SALER.getCode()};
    private static final String[] percentTaxRate = new String[]{"1%", "1.5%", "3%", "4%", "5%", "6%", "9%", "10%", "11%", "13%", "16%", "17%"};
    private static final String[] intTaxRate = new String[]{"1", "1.5", "3", "4", "5", "6", "9", "10", "11", "13", "16", "17"};
    private static final String[] floatTaxRate = new String[]{"0.01", "0.015", "0.03", "0.04", "0.05", "0.06", "0.09", "0.10", "0.11", "0.13", "0.16", "0.17"};

    @Override
    public ApiResult processer(RequestVo requestVo) {
        String data = requestVo.getData();
        String businessSystemCode = requestVo.getBusinessSystemCode();
        List redApplyVoList = JSON.parseArray((String)data, RedInfoBillApplyVo.class);
        redApplyVoList.forEach(o -> o.setSystemSource(businessSystemCode));
        if (redApplyVoList.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5", (String)"RedInfoBillApplyServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]), (String)ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
        }
        if (redApplyVoList.size() > 1) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u63d0\u4ea4\u4e00\u4e2a\u7ea2\u5b57\u7533\u8bf7\u8868", (String)"RedInfoBillApplyServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), (String)ApiErrCodeEnum.PARAM_OVER_LIMIT.getCode());
        }
        RedInfoBillApplyVo redInfoBill = (RedInfoBillApplyVo)redApplyVoList.get(0);
        if (StringUtils.isBlank((CharSequence)redInfoBill.getSerialNo())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoBillApplyServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), (String)ApiErrCodeEnum.NON_APPLY_SERIAL_NO.getCode());
        }
        QFilter qFilter = new QFilter("billno", "=", (Object)redInfoBill.getSerialNo());
        DynamicObject redInfoExist = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)String.join((CharSequence)",", "infocode", "infoserialno", "infostatus", "statusdescribe"), (QFilter[])qFilter.toArray());
        if (redInfoExist != null) {
            RedInfoApplyResponseDTO response = (RedInfoApplyResponseDTO)DynamicObjectUtil.dynamicObject2Bean(RedInfoApplyResponseDTO.class, (DynamicObject)redInfoExist);
            return ResponseVo.success((String)SerializationUtils.toJsonString((Object)response));
        }
        String checkMsg = this.checkParams(redInfoBill);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            String[] checkMsgs = checkMsg.split(">>>>");
            if (checkMsgs.length == 2) {
                return ApiResult.fail((String)checkMsgs[0], (String)checkMsgs[1]);
            }
            return ApiResult.fail((String)checkMsg, (String)ApiErrCodeEnum.UNKNOWN_ERR.getCode());
        }
        List<DynamicObject> dynamicObjects = RedInfoBillApplyServiceImpl.convertBean2DynamicObj(redApplyVoList);
        ImcSaveServiceHelper.save(dynamicObjects);
        try {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"btn_submit", (String)"sim_red_info", (Object[])dynamicObjects.stream().map(DataEntityBase::getPkValue).toArray(), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                throw new KDBizException(OperationConstant.getErrorMsg((OperationResult)operationResult));
            }
            DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((Object)dynamicObjects.get(0).getPkValue(), (String)"sim_red_info", (String)String.join((CharSequence)",", "infocode", "infoserialno", "infostatus", "statusdescribe"));
            RedInfoApplyResponseDTO response = (RedInfoApplyResponseDTO)DynamicObjectUtil.dynamicObject2Bean(RedInfoApplyResponseDTO.class, (DynamicObject)redInfo);
            return ResponseVo.success((String)SerializationUtils.toJsonString((Object)response));
        }
        catch (KDBizException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public static List<DynamicObject> convertBean2DynamicObj(List<RedInfoBillApplyVo> redApplyVoList) {
        if (redApplyVoList.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(redApplyVoList.size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (RedInfoBillApplyVo applyVo : redApplyVoList) {
            Date originalInvoiceDate = null;
            try {
                if (StringUtils.isNotBlank((CharSequence)applyVo.getOriginalInvoiceDate())) {
                    originalInvoiceDate = sdf.parse(applyVo.getOriginalInvoiceDate());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_info");
            dynamicObject.set("billno", (Object)applyVo.getSerialNo());
            dynamicObject.set("applytaxno", (Object)applyVo.getApplyTaxpayerId());
            dynamicObject.set("applicant", (Object)applyVo.getApplyExplain());
            dynamicObject.set("originalinvoicecode", (Object)applyVo.getOriginalInvoiceCode());
            dynamicObject.set("originalinvoiceno", (Object)applyVo.getOriginalInvoiceNumber());
            dynamicObject.set("originalissuetime", (Object)originalInvoiceDate);
            dynamicObject.set("buyername", (Object)applyVo.getBuyerName());
            dynamicObject.set("buyertaxno", (Object)applyVo.getBuyerTaxpayerId().toUpperCase());
            dynamicObject.set("buyerbank", (Object)applyVo.getBuyerBankAndAccount());
            dynamicObject.set("buyeraddr", (Object)applyVo.getBuyerAddressAndTel());
            dynamicObject.set("salername", (Object)applyVo.getSellerName());
            dynamicObject.set("salertaxno", (Object)applyVo.getSellerTaxpayerId().toUpperCase());
            dynamicObject.set("salerbank", (Object)applyVo.getSellerBankAndAccount());
            dynamicObject.set("saleraddr", (Object)applyVo.getSellerAddressAndTel());
            dynamicObject.set("org", (Object)Long.parseLong(applyVo.getOrgId()));
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("infosource", (Object)"4");
            dynamicObject.set("infoserialno", (Object)RedInfoHelper.generateRedInfoSerialNo((String)applyVo.getDeviceNo()));
            dynamicObject.set("orderno", (Object)UUID.next());
            dynamicObject.set("creater", (Object)RequestContext.get().getUserId());
            dynamicObject.set("invoicetype", (Object)applyVo.getInvoiceType());
            dynamicObject.set("status", (Object)"1");
            dynamicObject.set("infodate", (Object)new Date());
            dynamicObject.set("maintaxrate", (Object)((InvoiceDetailVo)applyVo.getRedInfoBillDetail().get(0)).getTaxRate());
            dynamicObject.set("hsbz", (Object)applyVo.getIncludeTaxFlag());
            dynamicObject.set("totalamount", (Object)applyVo.getTotalamount());
            dynamicObject.set("totaltax", (Object)applyVo.getTotaltax());
            dynamicObject.set("jqbh", (Object)applyVo.getDeviceNo());
            dynamicObject.set("invoiceamount", (Object)applyVo.getInvoiceAmount());
            dynamicObject.set("originaldeduction", (Object)0);
            dynamicObject.set("billstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
            dynamicObject.set("systemsource", (Object)applyVo.getSystemSource());
            Long taxOrgId = RedInfoHelper.getTaxOrgId((String)applyVo.getSellerTaxpayerId().toUpperCase());
            dynamicObject.set("taxorg", (Object)taxOrgId);
            DynamicObjectCollection itemObjCollection = dynamicObject.getDynamicObjectCollection("items");
            List redInfoDetailList = applyVo.getRedInfoBillDetail();
            if (!redInfoDetailList.isEmpty()) {
                for (InvoiceDetailVo detail : redInfoDetailList) {
                    DynamicObject itemsObj = itemObjCollection.addNew();
                    itemsObj.set("taxflag", (Object)applyVo.getIncludeTaxFlag());
                    itemsObj.set("goodsname", (Object)detail.getGoodsName());
                    itemsObj.set("specification", (Object)detail.getSpecification());
                    itemsObj.set("unit", (Object)detail.getUnits());
                    itemsObj.set("num", (Object)detail.getQuantity());
                    itemsObj.set("unitprice", (Object)detail.getPrice());
                    itemsObj.set("amount", (Object)detail.getAmount());
                    itemsObj.set("taxrate", (Object)detail.getTaxRate());
                    itemsObj.set("tax", (Object)detail.getTaxAmount());
                    itemsObj.set("goodscode", (Object)detail.getRevenueCode());
                    itemsObj.set("taxpremark", (Object)detail.getPrivilegeFlag());
                    itemsObj.set("zzstsgl", (Object)detail.getPrivilegeContent());
                    itemsObj.set("rowtype", (Object)detail.getLineProperty());
                    itemsObj.set("taxunitprice", (Object)detail.getIncludeTaxPrice());
                    itemsObj.set("taxamount", (Object)detail.getIncludeTaxAmount());
                }
            }
            dynamicObjects.add(dynamicObject);
        }
        return dynamicObjects;
    }

    private String checkParams(RedInfoBillApplyVo redInfoBill) {
        String invType;
        Integer taxFlag;
        String applyTaxNo = redInfoBill.getApplyTaxpayerId();
        if (StringUtils.isBlank((CharSequence)applyTaxNo)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_APPLYER_TAX_NO.getCode());
        }
        String applyer = redInfoBill.getApplyExplain();
        if (StringUtils.isBlank((CharSequence)applyer)) {
            redInfoBill.setApplyExplain(RedInfoConstant.ApplicantEnum.SALER.getCode());
            applyer = redInfoBill.getApplyExplain();
        }
        if (!Arrays.asList(applyers).contains(applyer)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9\u4e0d\u5408\u6cd5>>>>%s", (String)"RedInfoBillApplyServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
        }
        BigDecimal remainRedAmount = BigDecimal.ZERO;
        if (RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode().equals(applyer) || RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer)) {
            String invNum = redInfoBill.getOriginalInvoiceNumber();
            String invCode = redInfoBill.getOriginalInvoiceCode();
            String originalInvoiceDate = redInfoBill.getOriginalInvoiceDate();
            if (StringUtils.isBlank((CharSequence)invNum) || StringUtils.isBlank((CharSequence)invCode)) {
                return String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65b9\u4e3a\u8d2d\u65b9\u7533\u8bf7--\u672a\u62b5\u6263\u6216\u9500\u65b9\u7533\u8bf7\uff0c\u539f\u53d1\u7968\u53f7\u7801\u3001\u4ee3\u7801\u5fc5\u586b>>>>%s", (String)"RedInfoBillApplyServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_INV_CODE_NUM.getCode());
            }
            if (StringUtils.isBlank((CharSequence)originalInvoiceDate)) {
                return String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65b9\u4e3a\u8d2d\u65b9\u7533\u8bf7--\u672a\u62b5\u6263\u6216\u9500\u65b9\u7533\u8bf7\uff0c\u539f\u53d1\u7968\u65e5\u671f\u5fc5\u586b>>>>%s", (String)"RedInfoBillApplyServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
            }
            if (originalInvoiceDate.length() != 10) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u539f\u53d1\u7968\u65e5\u671f\u4e0d\u5408\u6cd5>>>>%s", (String)"RedInfoBillApplyServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
            }
            if (LocalDate.parse(originalInvoiceDate).isAfter(LocalDate.now())) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u539f\u53d1\u7968\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u4eca\u5929>>>>%s", (String)"RedInfoBillApplyServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
            }
            if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer)) {
                String issueTime;
                QFilter numCodeFilter = new QFilter("invoicecode", "=", (Object)invCode).and("invoiceno", "=", (Object)invNum).and("invoicestatus", "=", (Object)"0");
                DynamicObject issueObj = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "remainredamount", "issuetime"), (QFilter[])numCodeFilter.toArray());
                if (null == issueObj) {
                    return String.format(ResManager.loadKDString((String)"\u539f\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u672a\u67e5\u8be2\u5230\u53ef\u7533\u8bf7\u7684\u7ea2\u5b57\u53d1\u7968\u8bb0\u5f55>>>>%s", (String)"RedInfoBillApplyServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NOT_FIND_BY_NUM_CODE.getCode());
                }
                remainRedAmount = issueObj.getBigDecimal("remainredamount");
                String string = issueTime = StringUtils.isNotBlank((CharSequence)issueObj.getString("issuetime")) ? issueObj.getString("issuetime").substring(0, 10) : null;
                if (!originalInvoiceDate.equals(issueTime)) {
                    return String.format(ResManager.loadKDString((String)"\u539f\u53d1\u7968\u65e5\u671f\u4e0e\u539f\u84dd\u5b57\u53d1\u7968\u65e5\u671f\u4e0d\u5339\u914d,\u539f\u84dd\u7968\u65e5\u671f\u662f:>>>>%s", (String)"RedInfoBillApplyServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]), issueTime, ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
                }
            }
        }
        if (null == (taxFlag = redInfoBill.getIncludeTaxFlag())) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u542b\u7a0e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
        }
        if (taxFlag != 1 && taxFlag != 0) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u542b\u7a0e\u6807\u8bc6\u4e0d\u5408\u6cd5>>>>%s", (String)"RedInfoBillApplyServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
        }
        redInfoBill.setBuyerTaxpayerId(null == redInfoBill.getBuyerTaxpayerId() ? "" : redInfoBill.getBuyerTaxpayerId().replaceAll(" ", "").toUpperCase());
        String buyerCheckMsg = this.checkBuyerParams(redInfoBill, applyer);
        if (StringUtils.isNotBlank((CharSequence)buyerCheckMsg)) {
            return buyerCheckMsg;
        }
        String sellerCheckMsg = this.checkSellerParams(redInfoBill, applyer);
        if (StringUtils.isNotBlank((CharSequence)sellerCheckMsg)) {
            return sellerCheckMsg;
        }
        String string = invType = null == redInfoBill.getInvoiceType() ? "" : redInfoBill.getInvoiceType();
        if (!invType.equals(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()) && !invType.equals(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode())) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u53d1\u7968\u7c7b\u578b\u4e0d\u5408\u6cd5>>>>%s", (String)"RedInfoBillApplyServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
        }
        if (StringUtils.isBlank((CharSequence)redInfoBill.getDeviceNo())) {
            String deviceNo = this.deviceNoAutoFill(redInfoBill.getOriginalInvoiceCode(), redInfoBill.getOriginalInvoiceNumber(), redInfoBill.getApplyTaxpayerId(), redInfoBill.getInvoiceType());
            if (StringUtils.isBlank((CharSequence)deviceNo)) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u672a\u7ef4\u62a4\u8bbe\u5907\u4fe1\u606f>>>>%s", (String)"RedInfoBillApplyServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_DEVICE.getCode());
            }
            redInfoBill.setDeviceNo(deviceNo);
        } else {
            VerifyResult verifyResult = BaseCheckService.checkDevNo(redInfoBill.getDeviceNo(), redInfoBill.getApplyTaxpayerId());
            if (!verifyResult.isSucceed()) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55%1$s>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]), verifyResult.getDesc(), verifyResult.getCode());
            }
        }
        String orgCode = redInfoBill.getOrgCode();
        Map rMap = ApiVerifyUtil.checkAndFillOrgCode((String)redInfoBill.getApplyTaxpayerId(), (String)orgCode, (String)redInfoBill.getDeviceNo());
        String orgCodeCheckMsg = (String)rMap.get("checkMsg");
        if (StringUtils.isNotBlank((CharSequence)orgCodeCheckMsg)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55%1$s>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]), orgCodeCheckMsg, ApiErrCodeEnum.ILLEGAL_PARAM.getCode());
        }
        redInfoBill.setOrgId((String)rMap.get("orgId"));
        List redInfoDetailList = redInfoBill.getRedInfoBillDetail();
        String detailCheckMsg = this.redInfoDetailcheck(redInfoDetailList, redInfoBill.getIncludeTaxFlag(), redInfoBill.getOrgId());
        if (StringUtils.isNotBlank((CharSequence)detailCheckMsg)) {
            return detailCheckMsg;
        }
        BigDecimal redInfoTaxAmount = BigDecimal.ZERO;
        BigDecimal redInfoAmount = BigDecimal.ZERO;
        List redInfoBillDetail = redInfoBill.getRedInfoBillDetail();
        for (InvoiceDetailVo invoiceDetailVo : redInfoBillDetail) {
            redInfoTaxAmount = redInfoTaxAmount.add(invoiceDetailVo.getTaxAmount()).setScale(2, 4);
            redInfoAmount = redInfoAmount.add(invoiceDetailVo.getAmount()).setScale(2, 4);
        }
        if (applyer.equals(RedInfoConstant.ApplicantEnum.SALER.getCode()) && remainRedAmount.compareTo(redInfoAmount.abs()) < 0) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7ea2\u51b2\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u539f\u53d1\u7968\u53ef\u7ea2\u51b2\u91d1\u989d>>>>%s", (String)"RedInfoBillApplyServiceImpl_16", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.OVER_CANRED_AMOUNT.getCode());
        }
        redInfoBill.setTotaltax(redInfoTaxAmount.toPlainString());
        redInfoBill.setInvoiceAmount(redInfoAmount.toPlainString());
        redInfoBill.setTotalamount(redInfoAmount.add(redInfoTaxAmount).toPlainString());
        if (EquipmentHelper.isDisableJQBH((Object)redInfoBill.getApplyTaxpayerId(), (Object)redInfoBill.getDeviceNo())) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u8bbe\u5907\u88ab\u7981\u7528>>>>%s", (String)"RedInfoBillApplyServiceImpl_17", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.INVOICE_DEV_DISABLE.getCode());
        }
        return "";
    }

    private String checkBuyerParams(RedInfoBillApplyVo vo, String applyer) {
        if (vo.getApplyExplain().equals(RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode()) || vo.getApplyExplain().equals(RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode())) {
            String buyerTaxNo = vo.getApplyTaxpayerId();
            QFilter qFilter = new QFilter("number", "=", (Object)buyerTaxNo);
            DynamicObject buyerObj = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "name", "number"), (QFilter[])qFilter.toArray());
            if (null != buyerObj) {
                vo.setBuyerName(buyerObj.getString("name"));
                vo.setBuyerTaxpayerId(buyerObj.getString("number"));
                QFilter invSettingFilter = new QFilter("taxno", "=", (Object)buyerTaxNo);
                DynamicObject settingObj = QueryServiceHelper.queryOne((String)"sim_invoice_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_invoice_setting"), (QFilter[])invSettingFilter.toArray());
                if (settingObj != null) {
                    vo.setBuyerBankAndAccount(settingObj.getString("openuserbank"));
                    vo.setBuyerAddressAndTel(settingObj.getString("invoiceaddr"));
                }
            }
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer) && StringUtils.isBlank((CharSequence)vo.getBuyerName())) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9\u4e3a\u9500\u65b9\u7533\u8bf7,\u8d2d\u65b9\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_18", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_BUYER_INFO.getCode());
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer) && GBKUtils.getGBKLength((String)vo.getBuyerName()) > 100) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u8d2d\u65b9\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26>>>>%s", (String)"RedInfoBillApplyServiceImpl_19", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_BUYER_INFO.getCode());
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer) && StringUtils.isBlank((CharSequence)vo.getBuyerTaxpayerId())) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9\u4e3a\u9500\u65b9\u7533\u8bf7,\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_20", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_BUYER_INFO.getCode());
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer) && !RegexUtil.isNsrsbh((String)vo.getBuyerTaxpayerId(), (boolean)true)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9\u4e3a\u9500\u65b9\u7533\u8bf7,\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u5408\u6cd5>>>>%s", (String)"RedInfoBillApplyServiceImpl_21", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_BUYER_INFO.getCode());
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer) && StringUtils.isBlank((CharSequence)vo.getBuyerBankAndAccount())) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u4e3a\u9500\u65b9\u7533\u8bf7,\u8d2d\u65b9\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_22", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_BUYER_INFO.getCode());
        }
        if (GBKUtils.getGBKLength((String)vo.getBuyerBankAndAccount()) > 100) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u8d2d\u65b9\u5f00\u6237\u884c\u548c\u8d26\u53f7\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26>>>>%s", (String)"RedInfoBillApplyServiceImpl_23", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_BUYER_INFO.getCode());
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer) && StringUtils.isBlank((CharSequence)vo.getBuyerAddressAndTel())) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u4e3a\u9500\u65b9\u7533\u8bf7,\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_24", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_BUYER_INFO.getCode());
        }
        if (GBKUtils.getGBKLength((String)vo.getBuyerAddressAndTel()) > 100) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26>>>>%s", (String)"RedInfoBillApplyServiceImpl_25", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_BUYER_INFO.getCode());
        }
        return "";
    }

    private String checkSellerParams(RedInfoBillApplyVo vo, String applyer) {
        if (vo.getApplyExplain().equals(RedInfoConstant.ApplicantEnum.SALER.getCode())) {
            String sellerTaxNo = vo.getApplyTaxpayerId();
            QFilter filter = new QFilter("taxno", "=", (Object)sellerTaxNo);
            String selectFields = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_invoice_setting", (boolean)true);
            DynamicObject sellerObj = QueryServiceHelper.queryOne((String)"sim_invoice_setting", (String)selectFields, (QFilter[])filter.toArray());
            if (null == sellerObj) {
                return String.format(ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u3010%1$s\u3011\u672a\u7ef4\u62a4\u5f00\u7968\u4fe1\u606f>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_26", (String)"imc-sim-webapi", (Object[])new Object[0]), sellerTaxNo, ApiErrCodeEnum.NON_INVOICE_SETTING_INFO.getCode());
            }
            if (StringUtils.isBlank((CharSequence)vo.getSellerTaxpayerId())) {
                vo.setSellerTaxpayerId(sellerObj.getString("taxno"));
            }
            if (StringUtils.isBlank((CharSequence)vo.getSellerBankAndAccount())) {
                vo.setSellerBankAndAccount(sellerObj.getString("openuserbank"));
            }
            if (StringUtils.isBlank((CharSequence)vo.getSellerAddressAndTel())) {
                vo.setSellerAddressAndTel(sellerObj.getString("invoiceaddr"));
            }
            if (StringUtils.isBlank((CharSequence)vo.getSellerName())) {
                QFilter qFilter = new QFilter("number", "=", (Object)sellerTaxNo);
                DynamicObject epInfoObj = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)"name", (QFilter[])qFilter.toArray());
                vo.setSellerName(epInfoObj.getString("name"));
            }
        }
        String sellerName = vo.getSellerName();
        if ((RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode().equals(applyer) || RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode().equals(applyer)) && StringUtils.isBlank((CharSequence)sellerName)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7533\u8bf7\u65b9\u4e3a\u8d2d\u65b9\u7533\u8bf7,\u9500\u65b9\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_27", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_SELLER_INFO.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)sellerName) && GBKUtils.getGBKLength((String)sellerName) > 100) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u9500\u65b9\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26>>>>%s", (String)"RedInfoBillApplyServiceImpl_28", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_SELlER_INFO.getCode());
        }
        String sellerTaxNo = vo.getSellerTaxpayerId();
        if ((RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode().equals(applyer) || RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode().equals(applyer)) && StringUtils.isBlank((CharSequence)sellerTaxNo)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9\u4e3a\u8d2d\u65b9,\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_29", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_SELLER_INFO.getCode());
        }
        if (!RegexUtil.isNsrsbh((String)sellerTaxNo)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u9500\u65b9\u7a0e\u53f7\u4e0d\u5408\u6cd5>>>>%s", (String)"RedInfoBillApplyServiceImpl_30", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_SELlER_INFO.getCode());
        }
        String sellerBankInfo = vo.getSellerBankAndAccount();
        if ((RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode().equals(applyer) || RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode().equals(applyer)) && StringUtils.isBlank((CharSequence)sellerBankInfo)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9\u4e3a\u8d2d\u65b9,\u9500\u65b9\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_31", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_SELLER_INFO.getCode());
        }
        if (GBKUtils.getGBKLength((String)sellerBankInfo) > 100) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u9500\u65b9\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26>>>>%s", (String)"RedInfoBillApplyServiceImpl_32", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_SELlER_INFO.getCode());
        }
        String sellerAddrTel = vo.getSellerAddressAndTel();
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applyer) && StringUtils.isBlank((CharSequence)sellerAddrTel)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u65b9\u4e3a\u8d2d\u65b9,\u9500\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_33", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.NON_SELLER_INFO.getCode());
        }
        if (GBKUtils.getGBKLength((String)sellerAddrTel) > 100) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u9500\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26>>>>%s", (String)"RedInfoBillApplyServiceImpl_34", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.ILLEGAL_SELlER_INFO.getCode());
        }
        return "";
    }

    private String redInfoDetailcheck(List<InvoiceDetailVo> detailList, int taxFlag, String orgId) {
        if (detailList.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a>>>>%s", (String)"RedInfoBillApplyServiceImpl_35", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiErrCodeEnum.EMPTY_DETAIL_LINE.getCode());
        }
        DynamicObject issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)Long.parseLong(orgId));
        for (int j = 0; j < detailList.size(); ++j) {
            BigDecimal checkBd;
            String taxAmount;
            String amountStr;
            String quantity;
            String goodsCode = detailList.get(j).getGoodsCode();
            String goodsName = detailList.get(j).getGoodsName();
            DynamicObject goodsObj = this.getGoodsObj(detailList.get(j), orgId);
            if (StringUtils.isBlank((CharSequence)goodsCode) && StringUtils.isBlank((CharSequence)goodsName)) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_37", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.NON_DETAIL_LINE.getCode());
            }
            if (null != goodsObj) {
                String simpleCodeName = null == goodsObj.getDynamicObject("taxcode") ? "" : goodsObj.getDynamicObject("taxcode").getString("simplename");
                simpleCodeName = "*" + simpleCodeName + "*";
                if (StringUtils.isEmpty((CharSequence)detailList.get(j).getGoodsCode())) {
                    detailList.get(j).setGoodsCode(goodsObj.getString("goodscode"));
                }
                if (StringUtils.isEmpty((CharSequence)detailList.get(j).getGoodsName())) {
                    detailList.get(j).setGoodsName(simpleCodeName.concat(goodsObj.getString("name")));
                } else {
                    detailList.get(j).setGoodsName(simpleCodeName.concat(detailList.get(j).getGoodsName()));
                }
            }
            if (GBKUtils.getGBKLength((String)(goodsName = detailList.get(j).getGoodsName())) > 92 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                detailList.get(j).setGoodsName(GBKUtils.cutGBKString((String)goodsName, (int)92));
            } else if (GBKUtils.getGBKLength((String)goodsName) > 92 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc792\u5b57\u7b26>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_38", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            String spec = detailList.get(j).getSpecification();
            if (StringUtils.isNotBlank((CharSequence)spec) && GBKUtils.getGBKLength((String)spec) > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                detailList.get(j).setSpecification(GBKUtils.cutGBKString((String)spec, (int)40));
            } else if (StringUtils.isNotBlank((CharSequence)spec) && GBKUtils.getGBKLength((String)spec) > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u89c4\u683c\u4e0d\u80fd\u8d85\u8fc740\u5b57\u7b26>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_39", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            String unit = detailList.get(j).getUnits();
            if (StringUtils.isNotBlank((CharSequence)unit) && GBKUtils.getGBKLength((String)unit) > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                detailList.get(j).setUnits(GBKUtils.cutGBKString((String)unit, (int)22));
            } else if (StringUtils.isNotBlank((CharSequence)unit) && GBKUtils.getGBKLength((String)unit) > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u5355\u4f4d\u4e0d\u80fd\u8d85\u8fc722\u5b57\u7b26>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_40", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)detailList.get(j).getPrice())) {
                String[] price = detailList.get(j).getPrice().split("\\.");
                if (price.length > 2) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u5355\u4ef7\u4e0d\u5408\u6cd5>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_41", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
                }
                if (price[0].length() > 13) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u5355\u4ef7\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u8d85\u8fc713\u4f4d>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_42", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
                }
                BigDecimal bigDecimal = new BigDecimal(detailList.get(j).getPrice());
                if (bigDecimal.doubleValue() < 0.0) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_43", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(quantity = detailList.get(j).getQuantity()))) {
                BigDecimal bigDecimal = new BigDecimal(quantity);
                if (bigDecimal.doubleValue() >= 0.0) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e0>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_44", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
                }
            }
            String string = amountStr = null == detailList.get(j).getAmount() ? "" : detailList.get(j).getAmount().toPlainString();
            if (StringUtils.isBlank((CharSequence)amountStr)) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_45", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.NON_DETAIL_LINE.getCode());
            }
            String[] amountStrs = amountStr.split("\\.");
            if (amountStrs.length > 2) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u91d1\u989d\u4e0d\u5408\u6cd5>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_46", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            if (amountStr.length() > 16) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc716\u4f4d>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_47", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            if (detailList.get(j).getAmount().doubleValue() >= 0.0) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e0>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_48", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            String taxRate = detailList.get(j).getTaxRate();
            if (StringUtils.isBlank((CharSequence)taxRate)) {
                String taxRateStr = null == goodsObj ? "" : (StringUtils.isBlank((CharSequence)goodsObj.getString("taxrate")) ? "" : goodsObj.getString("taxrate"));
                detailList.get(j).setTaxRate(taxRateStr);
                taxRate = taxRateStr;
            } else {
                if (taxRate.contains("%") && !Arrays.asList(percentTaxRate).contains(taxRate)) {
                    return String.format("%s%s%s%s>>>>%s", ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u7a0e\u7387\u683c\u5f0f\u4e3a\u3010\u767e\u5206\u6bd4\u3011,\u4ec5\u652f\u6301%2$s>>>>%3$s", (String)"RedInfoBillApplyServiceImpl_49", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, Arrays.toString(percentTaxRate), ApiErrCodeEnum.ILLEGAL_TAX_RATE.getCode());
                }
                if (taxRate.contains(".") && !Arrays.asList(floatTaxRate).contains(taxRate)) {
                    return String.format("%s%s%s%s>>>>%s", ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u7a0e\u7387\u683c\u5f0f\u4e3a\u3010\u5c0f\u6570\u683c\u5f0f\u3011,\u4ec5\u652f\u6301%2$s>>>>%3$s", (String)"RedInfoBillApplyServiceImpl_50", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, Arrays.toString(floatTaxRate), ApiErrCodeEnum.ILLEGAL_TAX_RATE.getCode());
                }
                if (RegexUtil.isInteger((String)taxRate) && !Arrays.asList(intTaxRate).contains(taxRate)) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u7a0e\u7387\u683c\u5f0f\u4e3a\u3010\u6b63\u6574\u6570\u3011,\u4ec5\u652f\u6301%2$s>>>>%3$s", (String)"RedInfoBillApplyServiceImpl_51", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, Arrays.toString(intTaxRate), ApiErrCodeEnum.ILLEGAL_TAX_RATE.getCode());
                }
                taxRate = TaxRateUtil.okTaxRate((String)taxRate);
                detailList.get(j).setTaxRate(taxRate);
            }
            int zzstsgl = detailList.get(j).getPrivilegeFlag();
            if (1 == zzstsgl) {
                String privilegeType = detailList.get(j).getPrivilegeContent();
                if (StringUtils.isBlank((CharSequence)privilegeType)) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u4eab\u53d7\u4f18\u60e0\u653f\u7b56,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_52", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_PRIVILEGE_CONTENT.getCode());
                }
                String tsglCheckMsg = TaxRateUtil.checkPrivilegeTypeByTaxCode((String)detailList.get(j).getRevenueCode(), (String)privilegeType, (String)taxRate);
                if (StringUtils.isNotBlank((CharSequence)tsglCheckMsg)) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c%2$s>>>>%3$s", (String)"RedInfoBillApplyServiceImpl_53", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, tsglCheckMsg, ApiErrCodeEnum.ILLEGAL_TAX_RATE.getCode());
                }
            }
            String taxAmountStr = null == detailList.get(j).getTaxAmount() ? "" : detailList.get(j).getTaxAmount().toPlainString();
            String taxRateStr = TaxRateUtil.convertTaxRate((String)detailList.get(j).getTaxRate());
            if (StringUtils.isBlank((CharSequence)taxAmountStr) && StringUtils.isNotBlank((CharSequence)taxRateStr)) {
                BigDecimal taxRateb = new BigDecimal(taxRateStr);
                BigDecimal calTaxAmount = TaxCalcUtil.calTax((BigDecimal)detailList.get(j).getAmount(), null, (BigDecimal)taxRateb, (Boolean)(1 == taxFlag ? 1 : 0), (Boolean)false, (int)2);
                detailList.get(j).setTaxAmount(calTaxAmount);
            }
            if (0 == detailList.get(j).getLineProperty() || 2 == detailList.get(j).getLineProperty()) {
                String num = detailList.get(j).getQuantity();
                try {
                    String standardNum = UnitPriceHelper.getNumStrValue((String)num, (String)"\u6570\u91cf");
                    detailList.get(j).setQuantity(standardNum);
                }
                catch (KDBizException e) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c%2$s>>>>%3$s", (String)"RedInfoBillApplyServiceImpl_53", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, e.getMessage(), ApiErrCodeEnum.NUMBER_ERR.getCode());
                }
                String price = detailList.get(j).getPrice();
                try {
                    String standardPrice = PriceHelper.getStrValue((String)price, (String)"\u6570\u91cf", (boolean)Boolean.FALSE);
                    detailList.get(j).setPrice(standardPrice);
                }
                catch (KDBizException e) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c%2$s>>>>%3$s", (String)"RedInfoBillApplyServiceImpl_53", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, e.getMessage(), ApiErrCodeEnum.PRICE_ERR.getCode());
                }
                this.calcDetailData(taxFlag, detailList.get(j), j + 1);
            }
            String quantityStr = detailList.get(j).getQuantity();
            String priceStr = detailList.get(j).getPrice();
            if (StringUtils.isNotBlank((CharSequence)quantityStr) && StringUtils.isNotBlank((CharSequence)priceStr)) {
                BigDecimal qpAmount;
                if (1 == taxFlag) {
                    priceStr = detailList.get(j).getIncludeTaxPrice();
                }
                if (Math.abs((qpAmount = new BigDecimal(quantityStr).multiply(new BigDecimal(priceStr))).subtract(detailList.get(j).getAmount()).doubleValue()) > 0.01) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u6570\u91cf*\u5355\u4ef7-\u91d1\u989d\u8bef\u5dee\u5927\u4e8e\u00b10.01>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_54", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
                }
            }
            this.calcTaxAmountData(taxFlag, detailList.get(j));
            String string2 = taxAmount = null == detailList.get(j).getTaxAmount() ? "" : detailList.get(j).getTaxAmount().toPlainString();
            if (StringUtils.isBlank((CharSequence)taxAmount)) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_55", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.NON_DETAIL_LINE.getCode());
            }
            if (taxAmount.length() > 16) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u7a0e\u989d\u4e0d\u80fd\u8d85\u8fc716\u4f4d>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_56", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            String[] taxAmounts = taxAmount.split("\\.");
            if (taxAmounts.length > 2) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u7a0e\u989d\u4e0d\u5408\u6cd5>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_57", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            if (detailList.get(j).getTaxAmount().doubleValue() >= 0.0) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e0>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_58", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            BigDecimal value = new BigDecimal("0.06");
            if (detailList.size() == 1 && StringUtils.isNotBlank((CharSequence)detailList.get(j).getTaxRate())) {
                value = new BigDecimal("1.27");
            }
            if (null != detailList.get(j).getAmount() && StringUtils.isNotBlank((CharSequence)detailList.get(j).getTaxRate()) && (checkBd = detailList.get(j).getAmount().multiply(new BigDecimal(detailList.get(j).getTaxRate())).subtract(detailList.get(j).getTaxAmount())).abs().compareTo(value) > 0) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u3010\u4e0d\u542b\u7a0e\u91d1\u989d*\u7a0e\u7387-\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e\u00b1%2$s\u3011>>>>%3$s", (String)"RedInfoBillApplyServiceImpl_59", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, value, ApiErrCodeEnum.ILLEGAL_DETAIL_LINE.getCode());
            }
            if (StringUtils.isBlank((CharSequence)detailList.get(j).getRevenueCode()) && 1 != detailList.get(j).getLineProperty()) {
                String taxCodeId = null == goodsObj ? "" : goodsObj.getString("taxcode_id");
                QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(taxCodeId));
                String selFields = "id,number,status,creator,enable,longnumber,fullname,taxrate,simplecodename,zzstsgl,zzszcyj,zzstsnrdm,bmbbbh,gjz,xfsgl,xfszcyj,yhzc,yhzcmc,lslvbs,code,hzx,description";
                DynamicObject taxCodeObj = QueryServiceHelper.queryOne((String)"bdm_taxrate_code", (String)selFields, (QFilter[])new QFilter[]{qFilter});
                String revenueCode = null == taxCodeObj ? "" : taxCodeObj.getString("number");
                detailList.get(j).setRevenueCode(revenueCode);
            }
            if (StringUtils.isBlank((CharSequence)goodsCode) && StringUtils.isBlank((CharSequence)detailList.get(j).getRevenueCode())) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0e\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_60", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.NON_DETAIL_LINE.getCode());
            }
            boolean revenueCheckFlag = this.checkSfbm(detailList.get(j).getRevenueCode());
            if (!revenueCheckFlag) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u6c47\u603b\u9879\u6216\u4e0d\u5b58\u5728>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_61", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.NOT_FIND_TAX_CODE.getCode());
            }
            int privilegeFlag = detailList.get(j).getPrivilegeFlag();
            if (1 == privilegeFlag && StringUtils.isBlank((CharSequence)detailList.get(j).getPrivilegeContent())) {
                return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u4e3a\u3010\u4eab\u53d7\u4f18\u60e0\u3011,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_62", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.NON_DETAIL_LINE.getCode());
            }
            if (0 != privilegeFlag || !StringUtils.isNotBlank((CharSequence)detailList.get(j).getPrivilegeContent())) continue;
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c\u660e\u7ec6\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u4e3a\u3010\u4e0d\u4eab\u53d7\u4f18\u60e0\u3011,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5fc5\u987b\u4e3a\u7a7a>>>>%2$s", (String)"RedInfoBillApplyServiceImpl_63", (String)"imc-sim-webapi", (Object[])new Object[0]), j + 1, ApiErrCodeEnum.NON_DETAIL_LINE.getCode());
        }
        return "";
    }

    private DynamicObject getGoodsObj(InvoiceDetailVo detail, String orgId) {
        QFilter qFilter = new QFilter("number", "=", (Object)detail.getGoodsCode());
        qFilter.or("name", "=", (Object)detail.getGoodsName());
        return BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (String)GoodsInfoConstant.SELECT_PROPERTIES, (QFilter[])new QFilter[]{qFilter, ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId)});
    }

    private String deviceNoAutoFill(String invoiceCode, String invoiceNum, String applyerTaxNo, String invoiceType) {
        if (StringUtils.isNotBlank((CharSequence)invoiceCode) && StringUtils.isNotBlank((CharSequence)invoiceNum)) {
            String jqbh;
            String selectFields = "jqbh,originalinvoicetype";
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNum);
            DynamicObject invoiceObj = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)selectFields, (QFilter[])qFilter.toArray());
            String string = jqbh = null == invoiceObj ? "" : invoiceObj.getString("jqbh");
            if (StringUtils.isBlank((CharSequence)jqbh)) {
                QFilter filter = new QFilter("epinfo.number", "=", (Object)applyerTaxNo);
                DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org"), (QFilter[])filter.toArray());
                Map devnoMap = EquipmentUtil.getBindDevList((DynamicObject)org, (String)invoiceType);
                return devnoMap.values().stream().findFirst().orElse("");
            }
            return jqbh;
        }
        return "";
    }

    private void calcDetailData(int includeTaxFlag, InvoiceDetailVo detail, int detailRow) {
        try {
            BigDecimal priceB = null;
            BigDecimal quantityB = null;
            if (StringUtils.isBlank((CharSequence)detail.getPrice()) && StringUtils.isNotBlank((CharSequence)detail.getQuantity())) {
                priceB = PriceHelper.calcPriceOrNum((BigDecimal)detail.getAmount(), (BigDecimal)new BigDecimal(detail.getQuantity()), (boolean)Boolean.FALSE);
            }
            if (StringUtils.isBlank((CharSequence)detail.getQuantity()) && StringUtils.isNotBlank((CharSequence)detail.getPrice())) {
                quantityB = UnitPriceHelper.calcNum((BigDecimal)detail.getAmount(), (BigDecimal)new BigDecimal(detail.getPrice()));
            }
            if (1 == includeTaxFlag) {
                if (null == priceB && StringUtils.isBlank((CharSequence)detail.getPrice())) {
                    detail.setIncludeTaxPrice("");
                }
                if (null != priceB) {
                    detail.setIncludeTaxPrice(PriceHelper.getStrValue((String)priceB.setScale(15, 0).toPlainString(), (String)"\u542b\u7a0e\u5355\u4ef7", (boolean)Boolean.FALSE));
                }
                if (null == priceB && StringUtils.isNotBlank((CharSequence)detail.getPrice())) {
                    detail.setIncludeTaxPrice(detail.getPrice());
                }
                if (null == quantityB && StringUtils.isBlank((CharSequence)detail.getQuantity())) {
                    detail.setQuantity("");
                }
                if (null != quantityB) {
                    detail.setQuantity(UnitPriceHelper.getNumStrValue((String)quantityB.setScale(15, 0).toPlainString(), (String)"\u6570\u91cf"));
                }
                BigDecimal bhsje = detail.getAmount().subtract(detail.getTaxAmount());
                if (StringUtils.isNotBlank((CharSequence)detail.getQuantity())) {
                    detail.setPrice(PriceHelper.calcPriceOrNum((BigDecimal)bhsje, (BigDecimal)new BigDecimal(detail.getQuantity()), (boolean)Boolean.FALSE).toPlainString());
                }
            }
            if (0 == includeTaxFlag) {
                if (null == priceB && StringUtils.isBlank((CharSequence)detail.getPrice())) {
                    detail.setPrice("");
                }
                if (null != priceB) {
                    detail.setPrice(priceB.setScale(15, 0).toPlainString());
                }
                if (null != quantityB) {
                    detail.setQuantity(quantityB.setScale(15, 0).toPlainString());
                }
                if (null == quantityB && StringUtils.isBlank((CharSequence)detail.getQuantity())) {
                    detail.setQuantity("");
                }
                if (StringUtils.isNotBlank((CharSequence)detail.getQuantity())) {
                    String includeTaxPrice = PriceHelper.calcPriceOrNum((BigDecimal)detail.getAmount().add(detail.getTaxAmount()), (BigDecimal)new BigDecimal(detail.getQuantity()), (boolean)Boolean.FALSE).toPlainString();
                    detail.setIncludeTaxPrice(includeTaxPrice);
                }
            }
        }
        catch (KDBizException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7\u8bb0\u5f55\u7684\u7b2c%1$s\u884c%2$s", (String)"RedInfoBillApplyServiceImpl_64", (String)"imc-sim-webapi", (Object[])new Object[0]), detailRow, e.getMessage()));
        }
    }

    private void calcTaxAmountData(int includeTaxFlag, InvoiceDetailVo detail) {
        if (1 == includeTaxFlag && null != detail.getTaxAmount()) {
            detail.setIncludeTaxAmount(detail.getAmount());
            BigDecimal amount = detail.getAmount().subtract(detail.getTaxAmount());
            detail.setAmount(amount);
        }
        if (0 == includeTaxFlag) {
            BigDecimal taxAmount = detail.getAmount().add(detail.getTaxAmount());
            detail.setIncludeTaxAmount(taxAmount);
        }
    }

    private boolean checkSfbm(String sfbm) {
        if (StringUtils.isBlank((CharSequence)sfbm)) {
            return false;
        }
        return Objects.nonNull(TaxClassCodeCheckHelper.geTaxCode((String)sfbm));
    }
}

