/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.redinfo;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.sim.common.dto.redinfo.RedInfoDownloadRequestDTO;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.model.redinfo.Resp93007;
import kd.imc.sim.common.model.redinfo.Resp93007Fyxm;
import kd.imc.sim.common.model.redinfo.Resp93007Hzxxb;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.common.vo.openapi.RedInfoBillDownloadVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseRedInfoBillDownloadVo;
import kd.imc.sim.common.vo.openapi.ResponseRedInfoBillVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RedInfoBillDownloadServiceImpl
implements OpenApiService {
    private static final Log LOG = LogFactory.getLog(RedInfoBillDownloadServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        RedInfoBillDownloadVo downloadVo;
        try {
            downloadVo = (RedInfoBillDownloadVo)JSON.parseObject((String)requestVo.getData(), RedInfoBillDownloadVo.class);
        }
        catch (Exception e) {
            LOG.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"RedInfoBillDownloadServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (null == downloadVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"RedInfoBillDownloadServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)downloadVo.getApplyTaxpayerId()) || !RegexUtil.isNsrsbh((String)downloadVo.getApplyTaxpayerId())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_ERR_TAXPAYERID.getCode(), (String)String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[%s]\u4f20\u5165\u4e0d\u5408\u6cd5", (String)"RedInfoBillDownloadServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), downloadVo.getApplyTaxpayerId()));
        }
        if (StringUtils.isEmpty((CharSequence)downloadVo.getDeviceNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_NO_DEVICE.getCode(), (String)ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u672a\u4f20\u5165\u503c", (String)"RedInfoBillDownloadServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (EquipmentHelper.isDisableJQBH((Object)downloadVo.getSellerTaxpayerId(), (Object)downloadVo.getDeviceNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_NO_DEVICE.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7%s\u88ab\u7981\u7528", (String)"RedInfoBillDownloadServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), downloadVo.getDeviceNo()));
        }
        if (StringUtils.isEmpty((CharSequence)downloadVo.getInvoiceType())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_NO_INVOICETYPE.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u672a\u4f20\u5165\u503c", (String)"RedInfoBillDownloadServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!downloadVo.getInvoiceType().equals(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode()) && !downloadVo.getInvoiceType().equals(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_NO_SUPPORT_INVOICETYPE.getCode(), (String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d1\u7968\u79cd\u7c7b[%1$s],\u53ea\u652f\u6301\u7eb8\u8d28\u4e13\u7968[%2$s],\u7535\u5b50\u4e13\u7968[%3$s]", (String)"RedInfoBillDownloadServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), downloadVo.getInvoiceType(), InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)downloadVo.getBuyerTaxpayerId()) && !RegexUtil.isNsrsbh((String)downloadVo.getBuyerTaxpayerId())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_ERR_TAXPAYERID.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[%s]\u4f20\u5165\u4e0d\u5408\u6cd5", (String)"RedInfoBillDownloadServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), downloadVo.getBuyerTaxpayerId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)downloadVo.getSellerTaxpayerId()) && !RegexUtil.isNsrsbh((String)downloadVo.getSellerTaxpayerId())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_ERR_TAXPAYERID.getCode(), (String)String.format(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[%s]\u4f20\u5165\u4e0d\u5408\u6cd5", (String)"RedInfoBillDownloadServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), downloadVo.getSellerTaxpayerId()));
        }
        if (0 != downloadVo.getDownloadScope() && 1 != downloadVo.getDownloadScope() && 2 != downloadVo.getDownloadScope()) {
            downloadVo.setDownloadScope(0);
        }
        Date applyDateS = null;
        Date applyDateE = null;
        if (StringUtils.isNotEmpty((CharSequence)downloadVo.getApplyDateS())) {
            try {
                applyDateS = new SimpleDateFormat("yyyy-MM-dd").parse(downloadVo.getApplyDateS());
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"RedInfoBillDownloadServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)downloadVo.getApplyDateE())) {
            try {
                applyDateE = new SimpleDateFormat("yyyy-MM-dd").parse(downloadVo.getApplyDateE());
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"RedInfoBillDownloadServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        if (null != applyDateS && null != applyDateE && applyDateS.after(applyDateE)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u7533\u8bf7\u8d77\u59cb\u65e5\u671f\u5927\u4e8e\u7ec8\u6b62\u65e5\u671f", (String)"RedInfoBillDownloadServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        DynamicObject device = DeviceUtil.getDeviceByTaxpayerIdAndDeviceNo((String)downloadVo.getApplyTaxpayerId(), (String)downloadVo.getDeviceNo());
        if (null == device) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDINFOBILLDOWNLOAD_ERR_TAXPAYERID.getCode(), (String)String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba%1$s\u8bbe\u5907%2$s\u4e0d\u5b58\u5728", (String)"RedInfoBillDownloadServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]), downloadVo.getApplyTaxpayerId(), downloadVo.getDeviceNo()));
        }
        try {
            RedInfoDownloadRequestDTO request = new RedInfoDownloadRequestDTO();
            request.setKjf_jh(downloadVo.getDeviceNo());
            request.setKjf_nsrsbh(downloadVo.getSellerTaxpayerId());
            request.setKjf_sbbh(downloadVo.getDeviceNo());
            request.setQstkrq(downloadVo.getApplyDateS());
            request.setJstkrq(downloadVo.getApplyDateE());
            request.setXhf_nsrsbh(downloadVo.getSellerTaxpayerId());
            request.setGhf_nsrsbh(downloadVo.getBuyerTaxpayerId());
            request.setXxbbh(downloadVo.getRedInfoBillNo());
            request.setXzfw(String.valueOf(downloadVo.getDownloadScope()));
            request.setYqzt("N");
            request.setFpzl(downloadVo.getInvoiceType());
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u4e0b\u8f7d\u7ea2\u5b57\u4fe1\u606f\u8868\u4f20\u5165\u53c2\u6570%s", JSON.toJSONString((Object)request)));
            }
            Resp93007 resp93007 = RedInfoHelper.downloadRedInfo((RedInfoDownloadRequestDTO)request, (long)RequestContext.get().getOrgId());
            List pairList = RedInfoHelper.convertResp93007ToDynamicObject((List)resp93007.getHzxxb(), (long)RequestContext.get().getOrgId(), (String)downloadVo.getDeviceNo());
            for (Pair pair : pairList) {
                if ("save".equals(pair.getLeft())) {
                    OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_info", (DynamicObject[])((List)pair.getRight()).toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    continue;
                }
                ImcSaveServiceHelper.save((List)((List)pair.getRight()));
            }
            ResponseRedInfoBillDownloadVo downloadRedInfoBills = this.transferRedInfoBill(resp93007.getHzxxb());
            downloadRedInfoBills.setTotals(resp93007.getZjls().intValue());
            return ResponseVo.success((String)JSON.toJSONString((Object)downloadRedInfoBills));
        }
        catch (KDException e) {
            String msg = e.getMessage();
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)msg);
            }
        }
        catch (Exception e) {
            LOG.error("\u4e0b\u8f7d\u7ea2\u5b57\u4fe1\u606f\u8868\u5931\u8d25", (Throwable)e);
        }
        return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u7ea2\u5b57\u4fe1\u606f\u8868\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"RedInfoBillDownloadServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    private ResponseRedInfoBillDownloadVo transferRedInfoBill(List<Resp93007Hzxxb> xxbs) {
        ResponseRedInfoBillDownloadVo downloadRedInfoBills = new ResponseRedInfoBillDownloadVo();
        if (null == xxbs || xxbs.isEmpty()) {
            downloadRedInfoBills.setRedInfoBills(null);
        } else {
            ArrayList<ResponseRedInfoBillVo> redInfoBills = new ArrayList<ResponseRedInfoBillVo>(xxbs.size());
            for (Resp93007Hzxxb xxb : xxbs) {
                ResponseRedInfoBillVo redInfoBill = new ResponseRedInfoBillVo(xxb.getSqdh(), xxb.getXxbbh(), xxb.getXxbzt(), xxb.getZtms(), xxb.getFpdm(), xxb.getFphm(), 0, "", xxb.getXfmc(), xxb.getXfsh(), xxb.getGfmc(), xxb.getGfsh(), xxb.getInvoicetype(), xxb.getHjje(), xxb.getHjse(), xxb.getZhsj(), 0);
                if (null != xxb.getDate()) {
                    redInfoBill.setApplyDate(new SimpleDateFormat("yyyy-MM-dd").format(xxb.getDate()));
                }
                if (null != xxb.getFyxm() && !xxb.getFyxm().isEmpty()) {
                    ArrayList<InvoiceDetailVo> redInfoBillDetails = new ArrayList<InvoiceDetailVo>(xxb.getFyxm().size());
                    String preTaxRate = "";
                    for (Resp93007Fyxm xm : xxb.getFyxm()) {
                        InvoiceDetailVo detailVo = new InvoiceDetailVo(xm.getSpmc(), xm.getGgxh(), xm.getDw(), String.valueOf(xm.getSpsl()), String.valueOf(xm.getSpdj()), xm.getJe(), xm.getSl(), xm.getSe(), xm.getSpbm(), 0, xm.getZzstsgl(), xm.getLslbs());
                        if (StringUtils.isNotEmpty((CharSequence)xm.getYhzcbs())) {
                            try {
                                detailVo.setPrivilegeFlag(Integer.parseInt(xm.getYhzcbs()));
                            }
                            catch (Exception e) {
                                LOG.error("\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
                            }
                        }
                        if (StringUtils.isEmpty((CharSequence)preTaxRate)) {
                            preTaxRate = xm.getSl();
                        } else if (!preTaxRate.equals(xm.getSl())) {
                            redInfoBill.setMultiTaxRateFlag(1);
                        }
                        redInfoBillDetails.add(detailVo);
                    }
                    redInfoBill.setRedInfoBillDetail(redInfoBillDetails);
                }
                redInfoBills.add(redInfoBill);
            }
            downloadRedInfoBills.setRedInfoBills(redInfoBills);
        }
        return downloadRedInfoBills;
    }
}

