/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.vehicle;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleVehicleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleVehicleResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class VehicleInfoQueryServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(VehicleInfoQueryServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        ApiResult result;
        String account;
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"InvoiceOpenAllEServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        AllEleVehicleRequestDTO requestDto = (AllEleVehicleRequestDTO)JSON.parseObject((String)requestVo.getData(), AllEleVehicleRequestDTO.class);
        if (StringUtils.isEmpty((CharSequence)requestDto.getChassisNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_CLASSIS_NO_EMPTY.getCode(), (String)ApiErrCodeEnum.ALLE_CLASSIS_NO_EMPTY.getMsg());
        }
        if (requestDto.getChassisNo().length() > 30) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_CLASSIS_LENGTH_ERROR.getCode(), (String)ApiErrCodeEnum.ALLE_CLASSIS_LENGTH_ERROR.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)requestDto.getTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_TAX_NO_EMPTY.getCode(), (String)ApiErrCodeEnum.ALLE_TAX_NO_EMPTY.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)requestDto.getInvoiceType())) {
            if (!InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(requestDto.getInvoiceType())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_FAIL.getCode(), (String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_FAIL.getMsg());
            }
        } else {
            requestDto.setInvoiceType(InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)(account = requestDto.getAccount()))) {
            String taxNo = requestDto.getTaxNo();
            String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
            }
        } else {
            account = AllEleAuthHelper.getEleAccount((String)requestDto.getTaxNo(), (boolean)true);
            if (StringUtils.isEmpty((CharSequence)account)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_NO_DEFAULT_ACCOUNT.getCode(), (String)ApiErrCodeEnum.ALLE_NO_DEFAULT_ACCOUNT.getMsg());
            }
        }
        if ((result = ApiAllEHelper.alleLoginCheck((String)requestDto.getTaxNo(), (String)account)) != null) {
            return result;
        }
        requestDto.setAccount(account);
        requestDto.setInvoiceType("12");
        requestDto.setRequest_path(AllEleInterfaceTypeEnum.ELE_PAPER_MOTORVEHICLE_INFO_QUERY.getRequestPath());
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)requestDto.getTaxNo(), (AllEleRequestDTO)requestDto, AllEleVehicleResponseDTO.class);
        if (ErrorType.SUCCESS.getCode().equals(response.getErrcode())) {
            return ResponseVo.success((String)SerializationUtils.toJsonString((Object)response.getData()));
        }
        return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_QUERY_FAIL.getCode(), (String)(ApiErrCodeEnum.ALLE_QUERY_FAIL.getMsg() + response.getDescription()));
    }
}

