/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.vehicle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.helper.InvoiceCancelHelper;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.vo.openapi.InvoiceCancelVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.impl.AbstractVehicleInvoiceServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class VehicleInvoiceCancelServiceImpl
extends AbstractVehicleInvoiceServiceImpl {
    @Override
    public ApiResult processer(RequestVo requestVo) {
        try {
            InvoiceCancelVo invoiceCancelVo = this.checkInvoiceCancleParam(requestVo);
            DynamicObject vehicleInvoice = this.getVehicleInvoice(invoiceCancelVo);
            boolean isCanceled = this.checkVehicleInvocie(vehicleInvoice);
            if (!isCanceled) {
                String jqbh = vehicleInvoice.getString("jqbh");
                String sellerTaxNo = vehicleInvoice.getString("salertaxno");
                boolean allEVehicleInv = InvoiceUtils.isAllEVehicleInv((String)vehicleInvoice.getString("invoicetype"));
                if (!allEVehicleInv && EquipmentHelper.isDisableJQBH((Object)sellerTaxNo, (Object)jqbh)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u53f7%s\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u4f5c\u5e9f", (String)"VehicleInvoiceCancelServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]), jqbh));
                }
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)vehicleInvoice.get("orgid")));
                String hxbzdh = saleInfo.getDefaultTerminal();
                String canceler = invoiceCancelVo.getCanceler();
                String abolishReason = invoiceCancelVo.getAbolishReason();
                HashSet elePaperValidReasons = new HashSet();
                Collections.addAll(elePaperValidReasons, "\u5f00\u7968\u6709\u8bef", "\u670d\u52a1\u7ec8\u6b62", "\u9500\u8d27\u9000\u56de", "\u5176\u4ed6");
                if (allEVehicleInv) {
                    ApiResult result;
                    if (!elePaperValidReasons.contains(abolishReason)) {
                        return ResponseVo.fail((ApiErrCodeEnum)ApiErrCodeEnum.INVOICE_CANCEL_REASON_ERROR);
                    }
                    String account = invoiceCancelVo.getAccount();
                    if (StringUtils.isNotBlank((CharSequence)account)) {
                        String taxNo = invoiceCancelVo.getSellerTaxpayerId();
                        String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
                        if (StringUtils.isNotBlank((CharSequence)msg)) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                        }
                    } else {
                        account = AllEleAuthHelper.getEleAccount((String)invoiceCancelVo.getSellerTaxpayerId(), (boolean)true);
                        if (StringUtils.isEmpty((CharSequence)account)) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_NO_DEFAULT_ACCOUNT.getCode(), (String)ApiErrCodeEnum.ALLE_NO_DEFAULT_ACCOUNT.getMsg());
                        }
                    }
                    if ((result = ApiAllEHelper.alleLoginCheck((String)invoiceCancelVo.getSellerTaxpayerId(), (String)account)) != null) {
                        return result;
                    }
                    MsgResponse msgResponse = AllEleServiceHelper.elePaperInvoiceAbolish((DynamicObject)vehicleInvoice, (String)abolishReason);
                    if (!ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                        throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), msgResponse.getErrorMsg());
                    }
                    InvoiceCancelHelper.updateInvoiceAbolishStatus((DynamicObject)vehicleInvoice, (String)canceler, (Object)abolishReason, (String)"sim_vatinvoice_vehicles");
                } else {
                    InvoiceCancelHelper.cancelVehicleInvoice((DynamicObject)vehicleInvoice, (String)hxbzdh, (String)canceler, (String)abolishReason);
                }
            }
            return this.createVehicleInvoiceCancleResult(vehicleInvoice.getPkValue());
        }
        catch (Exception e) {
            return this.handlerException(e);
        }
    }

    private ApiResult createVehicleInvoiceCancleResult(Object pkValue) {
        DynamicObject vehicleInvoice = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"sim_vatinvoice_vehicles");
        JSONObject returnData = new JSONObject();
        returnData.put("invoiceStatus", vehicleInvoice.get("invoicestatus"));
        returnData.put("invalidDate", vehicleInvoice.get("invaliddate"));
        returnData.put("invalidEr", vehicleInvoice.get("invalider"));
        returnData.put("invoiceCode", vehicleInvoice.get("invoicecode"));
        returnData.put("invoiceNo", vehicleInvoice.get("invoiceno"));
        returnData.put("billNo", vehicleInvoice.get("billno"));
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u4f5c\u5e9f\u6210\u529f", (String)"VehicleInvoiceCancelServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)returnData.toJSONString());
    }

    private boolean checkVehicleInvocie(DynamicObject vehicleInvoice) {
        if ("2".equals(vehicleInvoice.getString("invoicestatus"))) {
            return true;
        }
        if (!"0".equals(vehicleInvoice.getString("invoicestatus"))) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_ERROR_STATUS.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"VehicleInvoiceCancelServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (null == vehicleInvoice.get("issuetime")) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICEDATE.getCode(), ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u53d1\u7968\u5f00\u5177\u65e5\u671f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"VehicleInvoiceCancelServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        Date date = vehicleInvoice.getDate("issuetime");
        Date now = new Date();
        if (now.getYear() != date.getYear() || now.getMonth() != date.getMonth()) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_INVOICE_EXPIRE.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u8de8\u6708\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"VehicleInvoiceCancelServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return false;
    }

    private DynamicObject getVehicleInvoice(InvoiceCancelVo cancelVo) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)cancelVo.getInvoiceCode()).and("invoiceno", "=", (Object)cancelVo.getInvoiceNumber()).and("salertaxno", "=", (Object)cancelVo.getSellerTaxpayerId());
        DynamicObject vehicle = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_vehicles"), (QFilter[])qFilter.toArray());
        if (vehicle == null) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), String.format(ResManager.loadKDString((String)"\u65e0\u6b64\u53d1\u7968\u4fe1\u606f[\u4ee3\u7801:%1$s,\u53f7\u7801:%2$s]", (String)"VehicleInvoiceCancelServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getInvoiceCode(), cancelVo.getInvoiceNumber()));
        }
        return vehicle;
    }

    private InvoiceCancelVo checkInvoiceCancleParam(RequestVo requestVo) {
        InvoiceCancelVo cancelVo;
        try {
            cancelVo = (InvoiceCancelVo)JSON.parseObject((String)requestVo.getData(), InvoiceCancelVo.class);
        }
        catch (Exception e) {
            log.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5", (Throwable)e);
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u4f20\u5165\u4f5c\u5e9f\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"VehicleInvoiceCancelServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (null == cancelVo) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u4f20\u5165\u4f5c\u5e9f\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"VehicleInvoiceCancelServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getSellerTaxpayerId())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_TAXPAYERID.getCode(), ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u4f20\u5165\u503c", (String)"VehicleInvoiceCancelServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getInvoiceCode())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICECODE.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u672a\u4f20\u5165\u503c", (String)"VehicleInvoiceCancelServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getInvoiceNumber())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICENUMBER.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u672a\u4f20\u5165\u503c", (String)"VehicleInvoiceCancelServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getCanceler())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba\u672a\u4f20\u5165\u503c", (String)"VehicleInvoiceCancelServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!GBKUtils.checkValidGbk((String)cancelVo.getCanceler())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba[%s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"VehicleInvoiceCancelServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getCanceler()));
        }
        if (GBKUtils.getGBKLength((String)cancelVo.getCanceler()) > 10) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba[%s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u957f\u5ea610\u5b57\u8282", (String)"VehicleInvoiceCancelServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getCanceler()));
        }
        if (!GBKUtils.checkValidGbk((String)cancelVo.getAbolishReason())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u539f\u56e0[%s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"VehicleInvoiceCancelServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getAbolishReason()));
        }
        if (GBKUtils.getGBKLength((String)cancelVo.getAbolishReason()) > 40) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u539f\u56e0[%s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u957f\u5ea620\u5b57\u7b26", (String)"VehicleInvoiceCancelServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getAbolishReason()));
        }
        return cancelVo;
    }
}

