/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.vehicle;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.VehicleInvoice;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.vo.openapi.InvoiceQueryVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.invoice.InvoiceQueryServiceImpl;

public class VehicleInvoiceQueryServiceImpl
implements OpenApiService {
    @Override
    public ApiResult processer(RequestVo requestVo) {
        InvoiceQueryVo queryVo;
        InvoiceQueryServiceImpl service = new InvoiceQueryServiceImpl();
        try {
            queryVo = service.checkQueryVo(requestVo.getData());
        }
        catch (MsgException e) {
            return ResponseVo.fail((String)e.getErrorCode(), (String)e.getErrorMsg());
        }
        Object[] orgIds = new OrgHelper().getOrgIdsByTaxNo(queryVo.getSellerTaxpayerId());
        if (orgIds.length == 0) {
            return ResponseVo.success((String)"[]");
        }
        QFilter filter = new QFilter("orgid", "in", (Object)orgIds);
        ApiResult apiResult = service.checkQuryInvoice(queryVo, filter, "2");
        if (apiResult != null) {
            return apiResult;
        }
        DynamicObject[] invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_vehicles", (boolean)true), (QFilter[])filter.toArray(), null, (int)(queryVo.getPageNo() - 1), (int)queryVo.getPageSize());
        if (invoiceList == null || invoiceList.length == 0) {
            return ResponseVo.success((String)"[]");
        }
        ArrayList<VehicleInvoice> list = new ArrayList<VehicleInvoice>(invoiceList.length);
        for (DynamicObject dynamic : invoiceList) {
            list.add(VehicleInvoiceQueryServiceImpl.vehicleInvoiceObj2Bean(dynamic));
        }
        return ResponseVo.success((String)SerializationUtils.toJsonString(list));
    }

    public static VehicleInvoice vehicleInvoiceObj2Bean(DynamicObject vehicleInvoice) {
        VehicleInvoice invoice = (VehicleInvoice)DynamicObjectUtil.dynamicObject2Bean(VehicleInvoice.class, (DynamicObject)vehicleInvoice);
        invoice.setTotalAmount(vehicleInvoice.getBigDecimal("totalamount").setScale(2, 4).toString());
        invoice.setInvoiceAmount(vehicleInvoice.getBigDecimal("invoiceamount").setScale(2, 4).toString());
        invoice.setTotalTaxAmount(vehicleInvoice.getBigDecimal("totaltax").setScale(2, 4).toString());
        Date issueTime = vehicleInvoice.getDate("issuetime");
        String issuetime = issueTime == null ? "" : DateUtils.format((Date)issueTime, (String)"yyyy-MM-dd");
        Date invalidDate = vehicleInvoice.getDate("invaliddate");
        String invaliddate = invalidDate == null ? "" : DateUtils.format((Date)invalidDate, (String)"yyyy-MM-dd");
        invoice.setInvoiceDate(issuetime);
        invoice.setInvalidDate(invaliddate);
        return invoice;
    }
}

