/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;
import org.apache.commons.lang3.StringUtils;

public enum SeatClassTypeEnum {
    FLIGHT_ECONOMY_CLASS(new MultiLangEnumBridge("\u7ecf\u6d4e\u8231", "SeatClassTypeEnum_0", "imc-sim-common"), "1", new MultiLangEnumBridge("\u98de\u673a", "SeatClassTypeEnum_1", "imc-sim-common")),
    FLIGHT_FIRST_CLASS(new MultiLangEnumBridge("\u5934\u7b49\u8231", "SeatClassTypeEnum_2", "imc-sim-common"), "1", new MultiLangEnumBridge("\u98de\u673a", "SeatClassTypeEnum_1", "imc-sim-common")),
    FLIGHT_BUS_CLASS(new MultiLangEnumBridge("\u516c\u52a1\u8231", "SeatClassTypeEnum_3", "imc-sim-common"), "1", new MultiLangEnumBridge("\u98de\u673a", "SeatClassTypeEnum_1", "imc-sim-common")),
    TRAIN_ONE_CLASS(new MultiLangEnumBridge("\u4e00\u7b49\u5ea7", "SeatClassTypeEnum_4", "imc-sim-common"), "2", new MultiLangEnumBridge("\u706b\u8f66", "SeatClassTypeEnum_5", "imc-sim-common")),
    TRAIN_TWO_CLASS(new MultiLangEnumBridge("\u4e8c\u7b49\u5ea7", "SeatClassTypeEnum_6", "imc-sim-common"), "2", new MultiLangEnumBridge("\u706b\u8f66", "SeatClassTypeEnum_5", "imc-sim-common")),
    TRAIN_SOFT_CLASS(new MultiLangEnumBridge("\u8f6f\u5e2d\uff08\u8f6f\u5ea7\u3001\u8f6f\u5367\uff09", "SeatClassTypeEnum_7", "imc-sim-common"), "2", new MultiLangEnumBridge("\u706b\u8f66", "SeatClassTypeEnum_5", "imc-sim-common")),
    TRAIN_HARD_CLASS(new MultiLangEnumBridge("\u786c\u5e2d\uff08\u786c\u5ea7\u3001\u786c\u5367\uff09", "SeatClassTypeEnum_8", "imc-sim-common"), "2", new MultiLangEnumBridge("\u706b\u8f66", "SeatClassTypeEnum_5", "imc-sim-common")),
    SHIP_ONE_CLASS(new MultiLangEnumBridge("\u4e00\u7b49\u8231", "SeatClassTypeEnum_9", "imc-sim-common"), "7", new MultiLangEnumBridge("\u8239\u8236", "SeatClassTypeEnum_10", "imc-sim-common")),
    SHIP_TWO_CLASS(new MultiLangEnumBridge("\u4e8c\u7b49\u8231", "SeatClassTypeEnum_11", "imc-sim-common"), "7", new MultiLangEnumBridge("\u8239\u8236", "SeatClassTypeEnum_10", "imc-sim-common")),
    SHIP_THREE_CLASS(new MultiLangEnumBridge("\u4e09\u7b49\u8231", "SeatClassTypeEnum_12", "imc-sim-common"), "7", new MultiLangEnumBridge("\u8239\u8236", "SeatClassTypeEnum_10", "imc-sim-common"));

    private final MultiLangEnumBridge bridgeName;
    private final String code;
    private final MultiLangEnumBridge bridgeDesc;

    private SeatClassTypeEnum(MultiLangEnumBridge bridgeName, String code, MultiLangEnumBridge bridgeDesc) {
        this.bridgeName = bridgeName;
        this.code = code;
        this.bridgeDesc = bridgeDesc;
    }

    public String getName() {
        return this.bridgeName.loadKDString();
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.bridgeDesc.loadKDString();
    }

    public static List<String> getSeatClassNameByDesc(String desc) {
        ArrayList list = Lists.newArrayListWithCapacity((int)8);
        if (StringUtils.isEmpty((CharSequence)desc)) {
            return null;
        }
        for (SeatClassTypeEnum seatClassTypeEnum : SeatClassTypeEnum.values()) {
            if (!desc.equals(seatClassTypeEnum.getDesc())) continue;
            list.add(seatClassTypeEnum.getName());
        }
        return list;
    }

    public static List<String> getSeatClassNameByCode(String code) {
        ArrayList list = Lists.newArrayListWithCapacity((int)8);
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (SeatClassTypeEnum seatClassTypeEnum : SeatClassTypeEnum.values()) {
            if (!code.equals(seatClassTypeEnum.getCode())) continue;
            list.add(seatClassTypeEnum.getName());
        }
        return list;
    }
}

