/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;
import org.apache.commons.lang3.StringUtils;

public enum TransportTypeEnum {
    FLIGHT("1", new MultiLangEnumBridge("\u98de\u673a", "TransportTypeEnum_0", "imc-sim-common")),
    TRAIN("2", new MultiLangEnumBridge("\u706b\u8f66", "TransportTypeEnum_1", "imc-sim-common")),
    LONG_DISTANCE_CAR("3", new MultiLangEnumBridge("\u957f\u9014\u6c7d\u8f66", "TransportTypeEnum_2", "imc-sim-common")),
    PUBLIC_TRANSPORTATION("4", new MultiLangEnumBridge("\u516c\u5171\u4ea4\u901a", "TransportTypeEnum_3", "imc-sim-common")),
    TAXI("5", new MultiLangEnumBridge("\u51fa\u79df\u8f66", "TransportTypeEnum_4", "imc-sim-common")),
    CAR("6", new MultiLangEnumBridge("\u6c7d\u8f66", "TransportTypeEnum_5", "imc-sim-common")),
    SHIP("7", new MultiLangEnumBridge("\u8239\u8236", "TransportTypeEnum_6", "imc-sim-common")),
    OTHER("9", new MultiLangEnumBridge("\u5176\u4ed6", "TransportTypeEnum_7", "imc-sim-common"));

    private final String code;
    private final MultiLangEnumBridge bridge;

    private TransportTypeEnum(String code, MultiLangEnumBridge bridge) {
        this.code = code;
        this.bridge = bridge;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.bridge.loadKDString();
    }

    public static TransportTypeEnum getByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (TransportTypeEnum value : TransportTypeEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value;
        }
        return null;
    }

    public static String getCodeByDesc(String desc) {
        if (StringUtils.isEmpty((CharSequence)desc)) {
            return null;
        }
        for (TransportTypeEnum value : TransportTypeEnum.values()) {
            if (!value.getDesc().equals(desc)) continue;
            return value.getCode();
        }
        return null;
    }

    public static List<String> getTransportDescList() {
        ArrayList<String> list = new ArrayList<String>(8);
        for (TransportTypeEnum transportTypeEnum : TransportTypeEnum.values()) {
            list.add(transportTypeEnum.getDesc());
        }
        return list;
    }

    public static String getDescByCode(String code) {
        TransportTypeEnum value = TransportTypeEnum.getByCode(code);
        return value != null ? value.bridge.loadKDString() : "";
    }
}

