/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;

public class AccountCheckHelper {
    private static final Log LOG = LogFactory.getLog(AccountCheckHelper.class);

    public static void accountCheck(DynamicObject invoiceDynamicObject) {
        if (invoiceDynamicObject.getString("buyertype").equals("4")) {
            try {
                Boolean isRed = Boolean.FALSE;
                Long pkValue = invoiceDynamicObject.getLong("id");
                if (invoiceDynamicObject.getString("issuetype").equals("1")) {
                    QFilter invoiceFilter = new QFilter("invoicecode", "=", (Object)invoiceDynamicObject.getString("originalinvoicecode"));
                    invoiceFilter.and("invoiceno", "=", (Object)invoiceDynamicObject.getString("originalinvoiceno"));
                    LOG.info("\u84dd\u7968\u7ea2\u51b2\uff1ainvoicecode\uff1a" + invoiceDynamicObject.getString("invoicecode") + "invoiceno:" + invoiceDynamicObject.getString("invoiceno"));
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])invoiceFilter.toArray());
                    pkValue = invoice.getLong("id");
                    isRed = Boolean.TRUE;
                }
                QFilter invFilter = new QFilter("tbillid", "=", (Object)pkValue);
                DynamicObject[] relationDynamic = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true), (QFilter[])invFilter.toArray());
                LOG.info("\u83b7\u53d6\u5173\u7cfb\u8868\uff0c\u5e76\u5224\u65ad\u662f\u5426\u4e3a\u7a7a" + invoiceDynamicObject.getLong("id") + "  \u5173\u7cfb\u8868\u6570\u91cf:" + relationDynamic.length);
                if (relationDynamic.length > 0) {
                    Map<Long, List<DynamicObject>> relationMaps = Arrays.stream(relationDynamic).collect(Collectors.groupingBy(o -> o.getLong("sbillid")));
                    DynamicObject[] originalDy = BusinessDataServiceHelper.load((Object[])relationMaps.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
                    LOG.info("\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355id\u5206\u7ec4\uff0c\u7b5b\u9009\u51fa\u5bf9\u5e94\u7684\u660e\u7ec6\u4f5c\u4e3a  originalDy:" + originalDy.length);
                    BigDecimal invamount = invoiceDynamicObject.getBigDecimal("invoiceamount");
                    BigDecimal invtax = invoiceDynamicObject.getBigDecimal("totaltax");
                    Boolean lastKey = Boolean.FALSE;
                    Integer setSize = 0;
                    for (Map.Entry<Long, List<DynamicObject>> aLong : relationMaps.entrySet()) {
                        LOG.info("\u6839\u636esbillid\u5206\u7ec4\uff0c aLong:" + aLong);
                        List<DynamicObject> relationDy = aLong.getValue();
                        DynamicObject currentDy = Arrays.stream(originalDy).filter(o -> o.getLong("id") == ((Long)aLong.getKey()).longValue()).findFirst().get();
                        Integer n = setSize;
                        Integer n2 = setSize = Integer.valueOf(setSize + 1);
                        if (setSize.intValue() == relationMaps.size()) {
                            lastKey = Boolean.TRUE;
                        } else {
                            invamount = invamount.subtract(currentDy.getBigDecimal("invoiceamount"));
                            invtax = invtax.subtract(currentDy.getBigDecimal("invoiceamount"));
                        }
                        AccountCheckHelper.saveReconciliation(currentDy, lastKey, invamount, invtax, relationDy, invoiceDynamicObject, isRed);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("\u5f00\u7968\u540c\u6b65\u5bf9\u8d26\u6c47\u603b\u5931\u8d25\uff1a", (Object)e.getMessage());
            }
        }
    }

    private static void saveReconciliation(DynamicObject currentDy, Boolean lastKey, BigDecimal invamount, BigDecimal invtax, List<DynamicObject> relationDy, DynamicObject invoiceDynamicObject, Boolean isRed) {
        QFilter filter = new QFilter("originalid", "=", currentDy.getPkValue());
        DynamicObject isExsit = BusinessDataServiceHelper.loadSingle((String)"sim_reconciliation_sum", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_reconciliation_sum", (boolean)true), (QFilter[])filter.toArray());
        BigDecimal relamount = relationDy.stream().map(o -> o.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reltax = relationDy.stream().map(o -> o.getBigDecimal("tax")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (null != isExsit) {
            if (isRed.booleanValue()) {
                relamount = invoiceDynamicObject.getBigDecimal("invoiceamount");
                reltax = invoiceDynamicObject.getBigDecimal("totaltax");
            }
            BigDecimal invoiceamount = isExsit.getBigDecimal("invoiceamount").add(relamount);
            BigDecimal totaltax = isExsit.getBigDecimal("totaltax").add(reltax);
            BigDecimal totalamount = isExsit.getBigDecimal("totalamount").add(relamount).add(reltax);
            isExsit.set("invoiceamount", (Object)invoiceamount);
            isExsit.set("totaltax", (Object)totaltax);
            isExsit.set("totalamount", (Object)totalamount);
            isExsit.set("invoiceamountdiffer", (Object)isExsit.getBigDecimal("originvoiceamount").subtract(invoiceamount));
            isExsit.set("totalamountdiffer", (Object)isExsit.getBigDecimal("origtotalamount").subtract(totalamount));
            isExsit.set("totaltaxdiffer", (Object)isExsit.getBigDecimal("origtotaltax").subtract(totaltax));
            DynamicObjectCollection exsitItems = isExsit.getDynamicObjectCollection("sim_reconciliation_item");
            if (isRed.booleanValue()) {
                exsitItems.forEach(o -> {
                    if (o.getString("invoicecode").equals(invoiceDynamicObject.getString("originalinvoicecode")) && o.getString("invoiceno").equals(invoiceDynamicObject.getString("originalinvoiceno"))) {
                        o.set("invoicestatus", (Object)"3");
                    }
                });
                AccountCheckHelper.createSimReconciliationSum(currentDy, lastKey, invamount, invtax, relationDy, invoiceDynamicObject);
            } else {
                DynamicObject item = exsitItems.addNew();
                item.set("seq", (Object)exsitItems.size());
                item.set("invoiceid", invoiceDynamicObject.getPkValue());
                item.set("invoicecode", invoiceDynamicObject.get("invoicecode"));
                item.set("invoiceno", invoiceDynamicObject.get("invoiceno"));
                item.set("invoicetype", invoiceDynamicObject.get("invoicetype"));
                item.set("invoicestatus", invoiceDynamicObject.get("invoicestatus"));
                item.set("issuetime", invoiceDynamicObject.get("issuetime"));
                item.set("createdate", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{isExsit});
        } else {
            AccountCheckHelper.createSimReconciliationSum(currentDy, lastKey, invamount, invtax, relationDy, invoiceDynamicObject);
        }
    }

    private static void createSimReconciliationSum(DynamicObject currentDy, Boolean lastKey, BigDecimal invamount, BigDecimal invtax, List<DynamicObject> relationDy, DynamicObject invoiceDynamicObject) {
        BigDecimal relamount = relationDy.stream().map(o -> o.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reltax = relationDy.stream().map(o -> o.getBigDecimal("tax")).reduce(BigDecimal.ZERO, BigDecimal::add);
        Boolean isByHand = Boolean.FALSE;
        if (relationDy.get(0).getString("sdetailid").equals("0") || StringUtils.isBlank((CharSequence)relationDy.get(0).getString("sdetailid"))) {
            isByHand = Boolean.TRUE;
        }
        BigDecimal amount = currentDy.getBigDecimal("invoiceamount");
        BigDecimal tax = currentDy.getBigDecimal("totaltax");
        BigDecimal taxamount = currentDy.getBigDecimal("totalamount");
        DynamicObject reconciliation = BusinessDataServiceHelper.newDynamicObject((String)"sim_reconciliation_sum");
        reconciliation.set("billno", (Object)currentDy.getString("billno"));
        reconciliation.set("originalid", currentDy.getPkValue());
        reconciliation.set("billdate", (Object)currentDy.getDate("billdate"));
        reconciliation.set("orgid", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDynamicObject.get("orgid")));
        reconciliation.set("origtotalamount", (Object)taxamount);
        reconciliation.set("origtotaltax", (Object)tax);
        reconciliation.set("originvoiceamount", (Object)amount);
        reconciliation.set("buyername", (Object)invoiceDynamicObject.getString("buyername"));
        if (isByHand.booleanValue()) {
            if (lastKey.booleanValue()) {
                reconciliation.set("invoiceamount", (Object)amount);
                reconciliation.set("totalamount", (Object)taxamount);
                reconciliation.set("totaltax", (Object)tax);
                reconciliation.set("invoiceamountdiffer", (Object)amount.subtract(invamount));
                reconciliation.set("totalamountdiffer", (Object)taxamount.subtract(invamount).subtract(invtax));
                reconciliation.set("totaltaxdiffer", (Object)tax.subtract(invtax));
            } else {
                reconciliation.set("invoiceamount", (Object)amount);
                reconciliation.set("totalamount", (Object)taxamount);
                reconciliation.set("totaltax", (Object)tax);
                reconciliation.set("invoiceamountdiffer", (Object)BigDecimal.ZERO);
                reconciliation.set("totalamountdiffer", (Object)BigDecimal.ZERO);
                reconciliation.set("totaltaxdiffer", (Object)BigDecimal.ZERO);
            }
        } else {
            reconciliation.set("invoiceamount", (Object)relamount);
            reconciliation.set("totalamount", (Object)relamount.add(reltax));
            reconciliation.set("totaltax", (Object)reltax);
            reconciliation.set("invoiceamountdiffer", (Object)amount.subtract(relamount));
            reconciliation.set("totalamountdiffer", (Object)taxamount.subtract(reltax).subtract(relamount));
            reconciliation.set("totaltaxdiffer", (Object)tax.subtract(reltax));
        }
        DynamicObjectCollection itemCollection = reconciliation.getDynamicObjectCollection("sim_reconciliation_item");
        DynamicObject item = itemCollection.addNew();
        item.set("seq", (Object)0);
        item.set("invoiceid", invoiceDynamicObject.getPkValue());
        item.set("invoicecode", invoiceDynamicObject.get("invoicecode"));
        item.set("invoiceno", invoiceDynamicObject.get("invoiceno"));
        item.set("invoicetype", invoiceDynamicObject.get("invoicetype"));
        item.set("invoicestatus", invoiceDynamicObject.get("invoicestatus"));
        item.set("issuetime", invoiceDynamicObject.get("issuetime"));
        item.set("createdate", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reconciliation});
    }
}

