/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.imc.bdm.common.constant.BillRelateInvoicesConstant;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BillArchiveHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.ErrorMsgDTO;
import kd.imc.sim.common.helper.BillSpecialGoodsRemarkCheckHelper;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import org.apache.commons.lang.StringUtils;

public class BillHelper {
    public static final String SIM_SELECT_DEVICE = "sim_select_device";

    public static boolean isFilledBlue(DynamicObject obj) {
        String blueinvoicecode = obj.getString("blueinvoicecode");
        String blueinvoiceno = obj.getString("blueinvoiceno");
        Object blueIssueTime = obj.get("originalissuetime");
        String infocode = obj.getString("infocode");
        String invoiceType = obj.getString("invoicetype");
        String salerorbuyer = obj.getString("salerorbuyer");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            if ("0".equals(salerorbuyer)) {
                return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infocode) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)blueinvoiceno) && blueIssueTime != null;
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)salerorbuyer)) {
                return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infocode);
            }
            return false;
        }
        String applicant = obj.getString("applicant");
        if (!InvoiceUtils.isSpecialInvoice((String)invoiceType) || AllEleAuthHelper.isElePaper((Object)obj.getString("iselepaper"))) {
            return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)blueinvoicecode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)blueinvoiceno);
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infocode) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)blueinvoicecode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)blueinvoiceno) && blueIssueTime != null;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)applicant)) {
            return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infocode);
        }
        return false;
    }

    public static boolean isRedInfo(DynamicObject obj) {
        BigDecimal totalamount = obj.getBigDecimal("totalamount");
        String invoiceType = obj.getString("invoicetype");
        return totalamount.compareTo(new BigDecimal(0)) < 0 && InvoiceUtils.isSpecialInvoice((String)invoiceType) && !AllEleAuthHelper.isElePaper((Object)obj.get("iselepaper"));
    }

    public static boolean isAllERedConfirm(DynamicObject obj) {
        BigDecimal totalamount = obj.getBigDecimal("totalamount");
        String invoiceType = obj.getString("invoicetype");
        return totalamount.compareTo(new BigDecimal(0)) < 0 && (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)obj.get("iselepaper")));
    }

    public static void nextQuery(AbstractFormPlugin that, Object[] primaryKeyValues) {
        if (primaryKeyValues == null || primaryKeyValues.length == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"BillHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            return;
        }
        IFormView view = that.getView();
        String entityId = view.getEntityId();
        if (view instanceof ListView) {
            entityId = ((ListView)view).getEntityTypeId();
        }
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("BillHelper.sim_original_bill", entityId, String.join((CharSequence)",", "id", "billsourcetype", "invoicecode", "invoiceno", "matchstatus"), new QFilter("id", "in", (Object)primaryKeyValues).toArray(), "id");){
            boolean hasInvalidBill = false;
            boolean hasCommonBill = false;
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
            ArrayList<Object> matchBillIds = new ArrayList<Object>(primaryKeyValues.length);
            ArrayList<Object> commonBillIds = new ArrayList<Object>(primaryKeyValues.length);
            while (ds.hasNext()) {
                Row obj = ds.next();
                if ("C".equals(obj.getString("billsourcetype"))) {
                    hasInvalidBill = true;
                    QFilter q = new QFilter("invoicecode", "=", obj.get("invoicecode")).and("invoiceno", "=", obj.get("invoiceno"));
                    qFilter.or(q);
                    continue;
                }
                hasCommonBill = true;
                String matchStatus = obj.getString("matchstatus");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)matchStatus) && !MatchBillConstant.MatchStatusEnum.UN_PROCESS.getCode().equals(matchStatus)) {
                    matchBillIds.add(obj.getLong("id"));
                    continue;
                }
                commonBillIds.add(obj.getLong("id"));
            }
            if (hasCommonBill) {
                hasCommonBill = BillHelper.commonNextQuery(that, matchBillIds, commonBillIds);
            }
            if (hasInvalidBill) {
                hasInvalidBill = BillHelper.invalidNextQuery(that, qFilter);
            }
            if (!hasCommonBill && !hasInvalidBill) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"BillHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
    }

    private static boolean invalidNextQuery(AbstractFormPlugin that, QFilter qFilter) {
        if (qFilter.toString().equals(new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1").toString())) {
            return false;
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
        if (invoices.length == 0) {
            return false;
        }
        ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_invoice_valid_list", (Collection)Stream.of(invoices).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        return true;
    }

    private static boolean commonNextQuery(AbstractFormPlugin that, List<Object> matchBillIds, List<Object> commonBillIds) {
        HashSet<Object> successInvIds = new HashSet<Object>(commonBillIds.size());
        HashSet<Object> unSuccessInvIds = new HashSet<Object>(commonBillIds.size());
        HashSet<Object> redInfoIds = new HashSet<Object>(commonBillIds.size());
        HashSet<Object> redConfirmBillIds = new HashSet<Object>(commonBillIds.size());
        HashSet botpTBillIds = new HashSet();
        if (!CollectionUtils.isEmpty(matchBillIds)) {
            BillHelper.matchBillTrackDown(matchBillIds, successInvIds, unSuccessInvIds, redInfoIds, redConfirmBillIds);
        }
        if (!CollectionUtils.isEmpty(commonBillIds)) {
            QFilter addfilter;
            DynamicObject[] array;
            DynamicObjectCollection relations = OrgHelper.getListByIds((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "tbillid", "ttable", "tbillno"), commonBillIds, (String)"sbillid");
            List list = relations.stream().filter(relation -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)relation.getString("tbillno"))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                List billNos = list.stream().map(o -> o.getString("tbillno")).distinct().collect(Collectors.toList());
                QFilter qFilter = OrgHelper.getIdFilter(billNos, (String)"billno");
                BillHelper.invoiceQuery(qFilter, successInvIds, unSuccessInvIds);
                BillHelper.redInfoQuery(qFilter, successInvIds, redInfoIds, unSuccessInvIds);
                BillHelper.redConfirmQuery(qFilter, successInvIds, redConfirmBillIds, unSuccessInvIds);
            }
            if ((array = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)"invoicecode,invoiceno,invoiceamount,totalamount,totaltax,invoicetype,serialno", (QFilter[])(addfilter = OrgHelper.getIdFilter(commonBillIds, (String)"originalbillid").and(BillHelper.notCancelFilter())).toArray())) != null && array.length > 0) {
                for (DynamicObject addDynamicObject : array) {
                    QFilter qFilterNo;
                    QFilter qFilterCode = new QFilter("invoicecode", "=", (Object)addDynamicObject.getString("invoicecode"));
                    QFilter queryQFilter = qFilterCode.and(qFilterNo = new QFilter("invoiceno", "=", (Object)addDynamicObject.getString("invoiceno")));
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])queryQFilter.toArray());
                    if (invoice == null) continue;
                    successInvIds.add(invoice.getPkValue());
                }
            }
        }
        if (!CollectionUtils.isEmpty(unSuccessInvIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_invoice_wait", unSuccessInvIds);
        }
        if (!CollectionUtils.isEmpty(successInvIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_vatinvoice", successInvIds);
        }
        if (!CollectionUtils.isEmpty(redInfoIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_red_info", redInfoIds);
        }
        if (!CollectionUtils.isEmpty(redConfirmBillIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_red_confirm_bill", redConfirmBillIds);
        }
        commonBillIds.addAll(matchBillIds);
        boolean isPushAr = BillHelper.isPushAr(commonBillIds);
        if (isPushAr) {
            that.getView().invokeOperation("trackdown");
        }
        QFilter billQfilter = OrgHelper.getIdFilter(commonBillIds, (String)"sbillid").and("relationtype", "=", (Object)"0");
        DynamicObjectCollection billRelations = QueryServiceHelper.query((String)"sim_bill_relation", (String)String.join((CharSequence)",", "tbillid"), (QFilter[])billQfilter.toArray());
        Set billIds = billRelations.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(billIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_original_bill", billIds);
        }
        return !CollectionUtils.isEmpty(unSuccessInvIds) || !CollectionUtils.isEmpty(successInvIds) || !CollectionUtils.isEmpty(redInfoIds) || !CollectionUtils.isEmpty(redConfirmBillIds) || !CollectionUtils.isEmpty(billIds) || !CollectionUtils.isEmpty(botpTBillIds);
    }

    public static void matchBillTrackDown(List<Object> matchBillIds, Set<Object> successInvIds, Set<Object> unSuccessInvIds, Set<Object> redInfoIds, Set<Object> redConfirmBillIds) {
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)"tbillid", (QFilter[])OrgHelper.getIdFilter(matchBillIds, (String)"sbillid").toArray());
        if (billRelations.length == 0) {
            return;
        }
        DynamicObject[] matchBills = BusinessDataServiceHelper.load((String)"sim_match_bill", (String)"invoicetype", (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(billRelations).map(relation -> relation.getLong("tbillid")).collect(Collectors.toSet())).toArray());
        if (matchBills.length == 0) {
            return;
        }
        DynamicObject[] invRelations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(matchBills).map(DataEntityBase::getPkValue).collect(Collectors.toSet()), (String)"sbillid").toArray());
        if (invRelations.length == 0) {
            return;
        }
        Map<Object, List<DynamicObject>> invRelationMap = Arrays.stream(invRelations).collect(Collectors.groupingBy(relation -> relation.get("sbillid")));
        HashSet redConfirmId = new HashSet();
        HashSet redInfoId = new HashSet();
        HashSet invoiceId = new HashSet();
        for (DynamicObject matchBill : matchBills) {
            List<DynamicObject> relations = invRelationMap.get(matchBill.getPkValue());
            if (CollectionUtils.isEmpty(relations)) continue;
            if (InvoiceUtils.isAllEInvoice((Object)matchBill.getString("invoicetype"))) {
                redConfirmId.addAll(relations.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toSet()));
                continue;
            }
            if (InvoiceUtils.isSpecialInvoice((String)matchBill.getString("invoicetype"))) {
                redInfoId.addAll(relations.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toSet()));
                continue;
            }
            invoiceId.addAll(relations.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(invoiceId)) {
            BillHelper.invoiceQuery(OrgHelper.getIdFilter(invoiceId), successInvIds, unSuccessInvIds);
        }
        if (!CollectionUtils.isEmpty(redInfoId)) {
            BillHelper.redInfoQuery(OrgHelper.getIdFilter(redInfoId), successInvIds, redInfoIds, unSuccessInvIds);
        }
        if (!CollectionUtils.isEmpty(redConfirmId)) {
            BillHelper.redConfirmQuery(OrgHelper.getIdFilter(redConfirmId), successInvIds, redConfirmBillIds, unSuccessInvIds);
        }
    }

    public static void invoiceQuery(QFilter qFilter, Set<Object> successInvIds, Set<Object> unSuccessInvIds) {
        DynamicObject[] invoiceList;
        for (DynamicObject invoice : invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"issuestatus", (QFilter[])qFilter.toArray())) {
            if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
                successInvIds.add(invoice.getPkValue());
                continue;
            }
            unSuccessInvIds.add(invoice.getPkValue());
        }
    }

    private static void redInfoQuery(QFilter qFilter, Set<Object> successInvIds, Set<Object> redInfoIds, Set<Object> unSuccessInvIds) {
        DynamicObject[] redInfos;
        for (DynamicObject redInfo : redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.format("%s, %s, %s, %s, %s", "status", "infocode", "invoicecode", "invoiceno", "infosource"), (QFilter[])qFilter.toArray())) {
            if ("4".equals(redInfo.getString("status"))) {
                DynamicObject[] invoices;
                for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo(redInfo.getString("invoicecode"), redInfo.getString("invoiceno")).toArray())) {
                    successInvIds.add(invoice.getPkValue());
                }
                continue;
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)redInfo.getString("infocode"))) {
                redInfoIds.add(redInfo.getPkValue());
                continue;
            }
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"issuestatus", (QFilter[])new QFilter("infocode", "=", (Object)redInfo.getString("infocode")).and("invoicestatus", "!=", (Object)"6").toArray());
            if (invoice == null) {
                redInfoIds.add(redInfo.getPkValue());
                continue;
            }
            if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
                successInvIds.add(invoice.getPkValue());
                continue;
            }
            unSuccessInvIds.add(invoice.getPkValue());
        }
    }

    public static void redConfirmQuery(QFilter qFilter, Set<Object> successInvIds, Set<Object> redConfirmBillIds, Set<Object> unSuccessInvIds) {
        DynamicObject[] redConfirmBills;
        for (DynamicObject redConfirmBill : redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.format("%s, %s, %s, %s", "issuestatus", "number", "invoicecode", "invoiceno"), (QFilter[])qFilter.toArray())) {
            if ("0".equals(redConfirmBill.getString("issuestatus"))) {
                DynamicObject[] invoices;
                for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo("", redConfirmBill.getString("invoiceno")).toArray())) {
                    successInvIds.add(invoice.getPkValue());
                }
                continue;
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)redConfirmBill.getString("number"))) {
                redConfirmBillIds.add(redConfirmBill.getPkValue());
                continue;
            }
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"issuestatus", (QFilter[])new QFilter("infocode", "=", (Object)redConfirmBill.getString("number")).toArray());
            if (invoice == null) {
                redConfirmBillIds.add(redConfirmBill.getPkValue());
                continue;
            }
            if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
                successInvIds.add(invoice.getPkValue());
                continue;
            }
            unSuccessInvIds.add(invoice.getPkValue());
        }
    }

    private static boolean isPushAr(List<Object> otherBillIds) {
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "closestatus", "pushamount"), (QFilter[])OrgHelper.getIdFilter(otherBillIds).toArray());
        boolean isPushAr = false;
        for (DynamicObject bill : bills) {
            String closeStatus = bill.getString("closestatus");
            BigDecimal pushAmount = bill.getBigDecimal("pushamount");
            if (!"1".equalsIgnoreCase(closeStatus) || BigDecimalUtil.compareZero((BigDecimal)pushAmount)) continue;
            isPushAr = true;
            break;
        }
        return isPushAr;
    }

    public static void originalBillTrackup(AbstractListPlugin that) {
        Object[] pk;
        ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
        String billFormId = ((IListView)that.getView()).getBillFormId();
        if (BillHelper.originalBillTrackup((AbstractFormPlugin)that, billFormId, pk = rows.getPrimaryKeyValues())) {
            that.getView().invokeOperation("trackup");
        }
    }

    public static boolean originalBillTrackup(AbstractFormPlugin that, String billFormId, Object[] pk) {
        QFilter qFilter = new QFilter("tbillid", "in", (Object)pk).and("relationtype", "=", (Object)"0");
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)"sbillid", (QFilter[])qFilter.toArray());
        if (relations.length != 0) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)billFormId, (Collection)Stream.of(relations).map(relation -> relation.get("sbillid")).collect(Collectors.toList()));
        }
        ArrayList sources = new ArrayList();
        Collections.addAll(sources, "3", "8");
        DynamicObjectCollection bills = QueryServiceHelper.query((String)billFormId, (String)"id", (QFilter[])new QFilter("id", "in", (Object)pk).and("billsource", "in", (Object)sources.toArray()).toArray());
        if (bills.size() != 0) {
            ArrayList pkList = new ArrayList(bills.size());
            bills.forEach(obj -> pkList.add(obj.getLong("id")));
            int trackUp = 0;
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"sim_original_bill", (Long[])pkList.toArray(new Long[0]));
            for (Map.Entry map : sourceBills.entrySet()) {
                String archEntity = BillArchiveHelper.getArchiveEnetity((String)((String)map.getKey()));
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)archEntity)) {
                    ArrayList list = new ArrayList(((HashSet)map.getValue()).size());
                    ((HashSet)map.getValue()).forEach(obj -> list.add(obj));
                    DynamicObjectCollection collect = QueryServiceHelper.query((String)archEntity, (String)"id", (QFilter[])new QFilter("id", "in", list).toArray());
                    ArrayList viewList = new ArrayList(collect.size());
                    collect.forEach(obj -> viewList.add(obj.getLong("id")));
                    if (!viewList.isEmpty()) {
                        if (viewList.size() < list.size()) {
                            ++trackUp;
                        }
                        ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)archEntity, viewList);
                        continue;
                    }
                    ++trackUp;
                    continue;
                }
                ++trackUp;
            }
            return trackUp > 0;
        }
        if (relations.length == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"BillHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return false;
    }

    public static void trackup(AbstractListPlugin that, String ttable, Object[] selectRowPks) {
        HashSet<String> tbillNos = new HashSet<String>(selectRowPks.length);
        HashSet<Object> tbillIds = new HashSet<Object>(selectRowPks.length);
        HashSet<Object> sbillIds = new HashSet<Object>(selectRowPks.length);
        HashSet<Object> matchInvIds = new HashSet<Object>(selectRowPks.length);
        if ("sim_vatinvoice".equals(ttable)) {
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "billno", "invoiceamount", "invoicetype", "infocode", "orgid", "contraststatus"), (QFilter[])new QFilter("id", "in", (Object)selectRowPks).toArray());
            CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)that, ImcPermItemEnum.IMC_PRE_QUERY, invoices);
            BillHelper.invoiceTrackUp(invoices, tbillNos, tbillIds, sbillIds, matchInvIds);
        } else if ("sim_red_info".equals(ttable)) {
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.join((CharSequence)",", "billno", "org", "infosource"), (QFilter[])new QFilter("id", "in", (Object)selectRowPks).toArray());
            BillHelper.redInfoTrackUp(redInfos, tbillIds, tbillNos, matchInvIds);
        } else {
            DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"source", (QFilter[])new QFilter("id", "in", (Object)selectRowPks).toArray());
            BillHelper.redConfirmTrackUp(redConfirmBills, matchInvIds, tbillIds);
        }
        if (tbillNos.size() != 0 || tbillIds.size() != 0) {
            QFilter qFilter = new QFilter("1", "=", (Object)-1);
            if (tbillNos.size() != 0) {
                qFilter.or(OrgHelper.getIdFilter(tbillNos, (String)"tbillno"));
            }
            if (tbillIds.size() != 0) {
                qFilter.or(OrgHelper.getIdFilter(tbillIds, (String)"tbillid"));
            }
            DynamicObjectCollection list = QueryServiceHelper.query((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])qFilter.toArray());
            sbillIds.addAll(list.stream().map(relation -> relation.get("sbillid")).collect(Collectors.toList()));
        }
        if (sbillIds.size() == 0 && matchInvIds.size() == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"BillHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            return;
        }
        if (matchInvIds.size() != 0) {
            DynamicObject[] billRelations;
            DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter(matchInvIds, (String)"tbillid").toArray());
            matchInvIds.clear();
            if (relations.length != 0 && (billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(relations).map(relation -> relation.get("sbillid")).collect(Collectors.toSet()), (String)"tbillid").toArray())).length != 0) {
                matchInvIds.addAll(Arrays.stream(billRelations).map(relation -> relation.get("sbillid")).collect(Collectors.toSet()));
            }
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_original_bill_negativ", matchInvIds);
        }
        BillHelper.trackupOriginalBill(that, "sim_original_bill", sbillIds);
    }

    public static void trackupOriginalBill(AbstractListPlugin plugin, String tableId, Set<Object> sbillIds) {
        if (sbillIds != null && !sbillIds.isEmpty()) {
            Set hisSbillIds;
            Map<String, Object> splitReuslt = BillHelper.splitOriginalBillSbillIds(tableId, sbillIds);
            Set newSbillIds = (Set)splitReuslt.get(tableId);
            if (newSbillIds != null && !newSbillIds.isEmpty()) {
                ViewUtil.openTrackListPage((AbstractFormPlugin)plugin, (String)tableId, (Collection)newSbillIds);
            }
            if ((hisSbillIds = (Set)splitReuslt.get("hisBillIds")) != null && !hisSbillIds.isEmpty()) {
                ViewUtil.openTrackListPage((AbstractFormPlugin)plugin, (String)((String)splitReuslt.get("hisTable")), (Collection)hisSbillIds);
            }
        }
    }

    private static Map<String, Object> splitOriginalBillSbillIds(String tableId, Set<Object> sbillIds) {
        String config = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.ORIGINAL_BILL_BACKUP);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)config)) {
            result.put(tableId, sbillIds);
        } else {
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_original_bill", (String)"id", (QFilter[])new QFilter("id", "in", sbillIds).toArray());
            HashSet<Long> newSbillIds = new HashSet<Long>(collect.size());
            for (DynamicObject object : collect) {
                newSbillIds.add(object.getLong("id"));
            }
            if (!newSbillIds.isEmpty()) {
                sbillIds.removeAll(newSbillIds);
            }
            result.put(tableId, newSbillIds);
            result.put("hisBillIds", sbillIds);
            result.put("hisTable", config);
        }
        return result;
    }

    private static void redInfoTrackUp(DynamicObject[] redInfos, Set<Object> tbillIds, Set<String> tbillNos, Set<Object> matchInvIds) {
        for (DynamicObject redInfo : redInfos) {
            if ("10".equals(redInfo.getString("infosource"))) {
                matchInvIds.add(redInfo.getPkValue());
                continue;
            }
            tbillIds.add(redInfo.getPkValue());
            String billNo = redInfo.getString("billno");
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNo)) continue;
            tbillNos.add(billNo);
        }
    }

    private static void invoiceTrackUp(DynamicObject[] invoices, Set<String> tbillNos, Set<Object> tbillIds, Set<Object> sbillIds, Set<Object> matchInvIds) {
        ArrayList<String> infoCodes = new ArrayList<String>(invoices.length);
        ArrayList<String> redConfirmBillNos = new ArrayList<String>(invoices.length);
        for (DynamicObject invoice : invoices) {
            String billNo = invoice.getString("billno");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNo)) {
                tbillNos.add(billNo);
            }
            if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) > 0) continue;
            String invoiceType = invoice.getString("invoicetype");
            if (InvoiceUtils.isNormalInvoice((String)invoice.getString("invoicetype"))) {
                if (!"10".equals(invoice.getString("contraststatus"))) continue;
                matchInvIds.add(invoice.getPkValue());
                tbillNos.remove(invoice.getString("billno"));
                continue;
            }
            String infoCode = invoice.getString("infocode");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)infoCode)) continue;
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                redConfirmBillNos.add(infoCode);
                continue;
            }
            infoCodes.add(infoCode);
        }
        if (infoCodes.size() != 0) {
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.join((CharSequence)",", "billno", "org", "infosource"), (QFilter[])new QFilter("infocode", "in", infoCodes).toArray());
            BillHelper.redInfoTrackUp(redInfos, tbillIds, tbillNos, matchInvIds);
        }
        if (!CollectionUtils.isEmpty(redConfirmBillNos)) {
            DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"source", (QFilter[])new QFilter("number", "in", redConfirmBillNos).toArray());
            BillHelper.redConfirmTrackUp(redConfirmBills, matchInvIds, tbillIds);
        }
        QFilter addfilter = new QFilter("invoiceid", "in", (Object)Stream.of(invoices).map(inv -> String.valueOf(inv.getPkValue().toString())).toArray()).and(BillHelper.notCancelFilter());
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)"originalbillid", (QFilter[])addfilter.toArray());
        sbillIds.addAll(Stream.of(array).map(add -> add.get("originalbillid")).collect(Collectors.toList()));
    }

    private static void redConfirmTrackUp(DynamicObject[] recConfirmBills, Set<Object> matchInvIds, Set<Object> tBillIds) {
        for (DynamicObject recConfirmBill : recConfirmBills) {
            if ("10".equals(recConfirmBill.getString("source"))) {
                matchInvIds.add(recConfirmBill.getPkValue());
                continue;
            }
            tBillIds.add(recConfirmBill.getPkValue());
        }
    }

    public static void clearWorkbench(ListSelectedRowCollection rows) {
        if (rows.size() == 0) {
            return;
        }
        BillHelper.clearWorkbench(rows.getPrimaryKeyValues());
    }

    public static void clearWorkbench(Object[] pks) {
        String currentUserId = RequestContext.get().getUserId();
        for (Object pk : pks) {
            String cacheUserId = CacheHelper.get((String)(pk + "workbench"));
            if (!currentUserId.equals(cacheUserId)) continue;
            CacheHelper.remove((String)(pk + "workbench"));
        }
    }

    public static String getBillStatusByTableName(String tableName, String source) {
        String billStatusStr = ImcConfigUtil.getValue((String)"sim_not_approval_required", (String)tableName);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)billStatusStr)) {
            return BillStatusEnum.NO_APPROVAL_REQUIRED.getCode();
        }
        try {
            if (billStatusStr.length() == 1) {
                return BillHelper.getBillStatus(billStatusStr);
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(billStatusStr = JSONObject.parseObject((String)billStatusStr).getString(source)))) {
                return BillStatusEnum.NO_APPROVAL_REQUIRED.getCode();
            }
            return BillHelper.getBillStatus(billStatusStr);
        }
        catch (Exception e) {
            return BillStatusEnum.NO_APPROVAL_REQUIRED.getCode();
        }
    }

    private static String getBillStatus(String billStatusStr) {
        if (Arrays.stream(BillStatusEnum.values()).anyMatch(status -> status.getCode().equals(billStatusStr))) {
            return billStatusStr;
        }
        return BillStatusEnum.NO_APPROVAL_REQUIRED.getCode();
    }

    public static String getComprehensiveStatusByBillStatus(String billStatus) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)billStatus)) {
            return "";
        }
        if (BillStatusEnum.TEMP_SAVE.getCode().equals(billStatus)) {
            return "11";
        }
        if (BillStatusEnum.IN_AUDIT.getCode().equals(billStatus)) {
            return "12";
        }
        if (BillStatusEnum.AUDIT_SUCCESS.getCode().equals(billStatus)) {
            return "01";
        }
        if (BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(billStatus)) {
            return "01";
        }
        return "";
    }

    public static String getBatchNumbersuffix(int index) {
        int digit;
        StringBuilder suffix = new StringBuilder(String.valueOf(index));
        for (int i = digit = suffix.toString().length(); i < 4; ++i) {
            suffix.insert(0, '0');
        }
        return suffix.toString();
    }

    public static ErrorMsgDTO checkInvoiceSpecialGoodCodeRemark(DynamicObject invoiceDynamicObject) {
        try {
            DynamicObjectCollection items2 = invoiceDynamicObject.getDynamicObjectCollection("items");
            for (int i = 0; i < items2.size(); ++i) {
                ErrorMsgDTO errorMsgDTO;
                DynamicObject itemObj = (DynamicObject)items2.get(i);
                String goodCode = itemObj.getString("goodscode");
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)goodCode) || (errorMsgDTO = BillSpecialGoodsRemarkCheckHelper.checkInvoiceSpecialGoodCodeRemark(invoiceDynamicObject, goodCode, i + 1, "batchlist")) == null) continue;
                return errorMsgDTO;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ErrorMsgDTO checkInvoiceListSpecialGoodCodeRemark(List<DynamicObject> batchSourceInvoiceList) {
        try {
            if (batchSourceInvoiceList != null && batchSourceInvoiceList.size() > 0) {
                StringBuilder allbillNo = new StringBuilder();
                int lackCount = 0;
                for (DynamicObject object : batchSourceInvoiceList) {
                    DynamicObject itemObj;
                    String goodCode;
                    ErrorMsgDTO errorMsgDTO = null;
                    String billNo = object.getString("billno");
                    DynamicObjectCollection items2 = object.getDynamicObjectCollection("items");
                    for (int i = 0; !(i >= items2.size() || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodCode = (itemObj = (DynamicObject)items2.get(i)).getString("goodscode"))) && (errorMsgDTO = BillSpecialGoodsRemarkCheckHelper.checkInvoiceSpecialGoodCodeRemark(object, goodCode, i + 1, "batchlist")) != null); ++i) {
                    }
                    if (errorMsgDTO == null) continue;
                    allbillNo.append(billNo).append(',');
                    if (++lackCount <= 5) continue;
                    break;
                }
                if (lackCount > 0) {
                    String allBillNoStr = allbillNo.toString();
                    if (allBillNoStr.endsWith(",")) {
                        allBillNoStr = allBillNoStr.substring(0, allBillNoStr.length() - 1);
                    }
                    ErrorMsgDTO allErrorMsgDTO = new ErrorMsgDTO("", String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u4e2d\u7f3a\u5c11\u7279\u6b8a\u7c7b\u522b\u660e\u7ec6\u9700\u8981\u7684\u53d1\u7968\u5907\u6ce8", (String)"BillHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), allBillNoStr));
                    return allErrorMsgDTO;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ErrorMsgDTO checkInvoiceSpecialGoodCodeRemark(ListSelectedRowCollection rows) {
        try {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                StringBuilder tipCodeAndNoSb = new StringBuilder();
                int lackCount = 0;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObject itemObj;
                    String goodCode;
                    ErrorMsgDTO errorMsgDTO = null;
                    DynamicObjectCollection items2 = dynamicObject.getDynamicObjectCollection("items");
                    String invoiceCode = dynamicObject.getString("invoicecode");
                    String invoiceNo = dynamicObject.getString("invoiceno");
                    for (int i = 0; !(i >= items2.size() || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodCode = (itemObj = (DynamicObject)items2.get(i)).getString("goodscode"))) && (errorMsgDTO = BillSpecialGoodsRemarkCheckHelper.checkInvoiceSpecialGoodCodeRemark(dynamicObject, goodCode, i + 1, "redlist")) != null); ++i) {
                    }
                    if (errorMsgDTO == null) continue;
                    tipCodeAndNoSb.append(String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4ee3\u7801\uff1a%1$s,\u53d1\u7968\u53f7\u7801:%2$s\u3011,", (String)"BillHelper_11", (String)"imc-sim-common", (Object[])new Object[0]), invoiceCode, invoiceNo));
                    if (++lackCount > 5) break;
                }
                if (lackCount > 0) {
                    String tipCodeAndNo = tipCodeAndNoSb.toString();
                    if (tipCodeAndNo.endsWith(",")) {
                        tipCodeAndNo = tipCodeAndNo.substring(0, tipCodeAndNo.length() - 1);
                    }
                    ErrorMsgDTO allErrorMsgDTO = new ErrorMsgDTO("", String.format(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968%s\u4e2d\u7f3a\u5c11\u7279\u6b8a\u7c7b\u522b\u660e\u7ec6\u9700\u8981\u7684\u53d1\u7968\u5907\u6ce8", (String)"BillHelper_4", (String)"imc-sim-common", (Object[])new Object[0]), tipCodeAndNo));
                    return allErrorMsgDTO;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ErrorMsgDTO checkRedInfoSpecialGoodCodeRemark(ListSelectedRowCollection rows) {
        try {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"));
            BotpHelper.checkRedInfoPartRed((DynamicObject[])dynamicObjects);
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                StringBuilder allRedinfoSerialNoSb = new StringBuilder();
                int lackCount = 0;
                for (DynamicObject redinfo : dynamicObjects) {
                    DynamicObject itemObj;
                    String goodCode;
                    ErrorMsgDTO errorMsgDTO = null;
                    String redinfoSerialNo = redinfo.getString("infoserialno");
                    DynamicObjectCollection items2 = redinfo.getDynamicObjectCollection("items");
                    for (int i = 0; !(i >= items2.size() || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodCode = (itemObj = (DynamicObject)items2.get(i)).getString("goodscode"))) && (errorMsgDTO = BillSpecialGoodsRemarkCheckHelper.checkRedInfoListSpecialGoodCodeRemark(redinfo, goodCode, i + 1, "redinfolist")) != null); ++i) {
                    }
                    if (errorMsgDTO != null) {
                        allRedinfoSerialNoSb.append('\u3010').append(redinfoSerialNo).append("\u3011,");
                        if (++lackCount > 5) break;
                    }
                    EquipmentHelper.checkOriginalBillJQBH((DynamicObject)redinfo);
                }
                if (lackCount > 0) {
                    String allRedinfoSerialNo = allRedinfoSerialNoSb.toString();
                    if (allRedinfoSerialNo.endsWith(",")) {
                        allRedinfoSerialNo = allRedinfoSerialNo.substring(0, allRedinfoSerialNo.length() - 1);
                    }
                    ErrorMsgDTO allErrorMsgDTO = new ErrorMsgDTO("", String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u6d41\u6c34\u53f7%s\u4e2d\u7f3a\u5c11\u7279\u6b8a\u7c7b\u522b\u660e\u7ec6\u9700\u8981\u7684\u53d1\u7968\u5907\u6ce8", (String)"BillHelper_5", (String)"imc-sim-common", (Object[])new Object[0]), allRedinfoSerialNo));
                    return allErrorMsgDTO;
                }
            }
        }
        catch (MsgException e) {
            throw new KDBizException(e.getErrorMsg());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ErrorMsgDTO checkBillSpecialGoodCodeRemark(DynamicObject[] dynamicObjects) {
        return null;
    }

    public static ErrorMsgDTO checkSpecialGoodCodeRemark(AbstractFormPlugin that, JSONObject dataArr, String from) {
        try {
            StringBuilder allBillNoSb = new StringBuilder();
            for (String str : dataArr.keySet()) {
                JSONArray dyArr = dataArr.getJSONArray(str);
                String billno = JSONObject.parseObject((String)that.getPageCache().get(str)).getString("billno");
                int lackCounts = 0;
                ErrorMsgDTO errorMsgDTO = null;
                for (int i = 0; i < dyArr.size(); ++i) {
                    JSONObject itemObj;
                    String goodCode;
                    JSONObject dyJson = dyArr.getJSONObject(i);
                    String remark = dyJson.getString("remark");
                    JSONArray itemsJsonArr = dyJson.getJSONArray("items");
                    if (itemsJsonArr == null || itemsJsonArr.size() <= 0) continue;
                    for (int j = 0; !(j >= itemsJsonArr.size() || StringUtils.isNotBlank((String)(goodCode = (itemObj = itemsJsonArr.getJSONObject(j)).getString("goodscode"))) && (errorMsgDTO = BillSpecialGoodsRemarkCheckHelper.checkBillSpecialGoodCodeRemark(billno, i + 1, goodCode, remark, from)) != null); ++j) {
                    }
                    ++lackCounts;
                }
                if (lackCounts > 5) break;
                if (errorMsgDTO == null) continue;
                allBillNoSb.append(billno).append(',');
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)allBillNoSb)) {
                String allBillNo = allBillNoSb.toString();
                if (allBillNo.endsWith(",")) {
                    allBillNo = allBillNo.substring(0, allBillNo.length() - 1);
                }
                ErrorMsgDTO allErrorMsgDTO = new ErrorMsgDTO("", String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u4e2d\u7f3a\u5c11\u7279\u6b8a\u7c7b\u522b\u660e\u7ec6\u9700\u8981\u7684\u53d1\u7968\u5907\u6ce8", (String)"BillHelper_6", (String)"imc-sim-common", (Object[])new Object[0]), allBillNo));
                return allErrorMsgDTO;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ErrorMsgDTO checkSplitSpecialGoodCodeRemark(String ars, String from) {
        try {
            JSONObject arsJSON = JSONObject.parseObject((String)ars);
            JSONObject dataArr = arsJSON.getJSONObject("data");
            StringBuilder allBillNoSb = new StringBuilder();
            for (String str : dataArr.keySet()) {
                JSONArray dyArr = dataArr.getJSONArray(str);
                String billno = "";
                int lackCounts = 0;
                ErrorMsgDTO errorMsgDTO = null;
                for (int i = 0; i < dyArr.size(); ++i) {
                    JSONObject itemObj;
                    String goodCode;
                    JSONObject dyJson = dyArr.getJSONObject(i);
                    String remark = dyJson.getString("remark");
                    billno = dyJson.getString("billno");
                    JSONArray itemsJsonArr = dyJson.getJSONArray("items");
                    if (itemsJsonArr == null || itemsJsonArr.size() <= 0) continue;
                    for (int j = 0; !(j >= itemsJsonArr.size() || StringUtils.isNotBlank((String)(goodCode = (itemObj = itemsJsonArr.getJSONObject(j)).getString("goodscode"))) && (errorMsgDTO = BillSpecialGoodsRemarkCheckHelper.checkBillSpecialGoodCodeRemark(billno, i + 1, goodCode, remark, from)) != null); ++j) {
                    }
                    ++lackCounts;
                }
                if (lackCounts > 5) break;
                if (errorMsgDTO == null) continue;
                allBillNoSb.append(billno).append(',');
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)allBillNoSb)) {
                String allBillNo = allBillNoSb.toString();
                if (allBillNo.endsWith(",")) {
                    allBillNo = allBillNo.substring(0, allBillNo.length() - 1);
                }
                ErrorMsgDTO allErrorMsgDTO = new ErrorMsgDTO("", String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u4e2d\u7f3a\u5c11\u7279\u6b8a\u7c7b\u522b\u660e\u7ec6\u9700\u8981\u7684\u53d1\u7968\u5907\u6ce8", (String)"BillHelper_6", (String)"imc-sim-common", (Object[])new Object[0]), allBillNo));
                return allErrorMsgDTO;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void checkIssuePushSpecialCodeRemark(AbstractFormPlugin that, DynamicObject[] bills, HashSet<Object> typeSet) {
        ErrorMsgDTO errorMsgDTO = BillHelper.checkBillSpecialGoodCodeRemark(bills);
        if (errorMsgDTO != null) {
            String msgKey = "bill_issuepush_check_remark";
            String msg = String.format(ResManager.loadKDString((String)"%1$s,\u662f\u5426\u8865\u5145?", (String)"BillHelper_7", (String)"imc-sim-common", (Object[])new Object[0]), errorMsgDTO.getFailmsg());
            ViewUtil.openConfirm((String)msgKey, (String)msg, (AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u8865\u5145", (String)"BillHelper_8", (String)"imc-sim-common", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4e0d\u8865\u5145", (String)"BillHelper_9", (String)"imc-sim-common", (Object[])new Object[0]));
        } else {
            BillHelper.issuePushBill(that, Stream.of(bills).map(DataEntityBase::getPkValue).toArray(), typeSet);
        }
    }

    public static void issuePushBill(AbstractFormPlugin that, Object[] pks, HashSet<Object> typeSet) {
        try {
            HashMap params = Maps.newHashMap();
            params.put("pks", pks);
            params.put("typeSet", typeSet);
            ViewUtil.openDialog((AbstractFormPlugin)that, (Map)params, (String)SIM_SELECT_DEVICE, (String)"btn_clickopeninvoice");
        }
        catch (Exception e) {
            that.getView().showTipNotification(e.getMessage());
        }
    }

    public static int getBillLimitCount() {
        return Integer.parseInt(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_ORIGINAL_BILL_SUBMIT_LIMIT));
    }

    public static void checkRelation(List<Object> relateOriginalBillPks, List<Object> relateInvoiceBillPks, List<Object> redConfirmBillPks) {
        if (!relateInvoiceBillPks.isEmpty()) {
            HashSet<Object> tBillPks = BillHelper.getRelatePks(relateInvoiceBillPks);
            QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoiceno", (QFilter[])new QFilter("id", "in", (Object)tBillPks.toArray()).and(issuedFilter).toArray());
            if (invoices.length != tBillPks.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u672a\u5f00\u5177\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301\u5173\u95ed", (String)"BillHelper_10", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
        if (!relateOriginalBillPks.isEmpty()) {
            DynamicObject[] redInfos;
            HashSet<Object> redInfoPks = BillHelper.getRelatePks(relateOriginalBillPks);
            for (DynamicObject redInfo : redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"issuetime", (QFilter[])new QFilter("id", "in", (Object)redInfoPks.toArray()).toArray())) {
                Object issueTime = redInfo.get("issuetime");
                if (null != issueTime) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u672a\u5f00\u5177\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301\u5173\u95ed", (String)"BillHelper_10", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
        if (!redConfirmBillPks.isEmpty()) {
            DynamicObject[] redConfirms;
            HashSet<Object> redConfirmPks = BillHelper.getRelatePks(redConfirmBillPks);
            for (DynamicObject redConfirm : redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"invoiceno", (QFilter[])new QFilter("id", "in", (Object)redConfirmPks.toArray()).toArray())) {
                String invoiceNo = (String)redConfirm.get("invoiceno");
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoiceNo)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u672a\u5f00\u5177\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301\u5173\u95ed", (String)"BillHelper_10", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
    }

    private static HashSet<Object> getRelatePks(List<Object> relateInvoicePks) {
        QFilter deleteFilter = new QFilter("isdelete", "!=", (Object)"Y");
        QFilter filter = new QFilter("sbillid", "in", (Object)relateInvoicePks.toArray()).and(deleteFilter);
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])filter.toArray());
        HashSet<Object> tBillPks = new HashSet<Object>();
        for (DynamicObject relation : relations) {
            tBillPks.add(relation.get("tbillid"));
        }
        return tBillPks;
    }

    public static void clearRedInvoiceData(DynamicObject reIssueBill) {
        reIssueBill.set("blueinvoicecode", (Object)"");
        reIssueBill.set("blueinvoiceno", (Object)"");
        reIssueBill.set("originalissuetime", null);
        reIssueBill.set("blueinvoicetype", (Object)"");
        reIssueBill.set("redreason", (Object)"");
        reIssueBill.set("applicant", (Object)"");
        reIssueBill.set("infocode", (Object)"");
    }

    public static QFilter notCancelFilter() {
        return new QFilter("iscancel", "!=", (Object)BillRelateInvoicesConstant.IsCancelEnum.YES);
    }

    public static boolean isBillFromQrScan(String billSource) {
        return "7".equals(billSource) || "5".equals(billSource);
    }
}

