/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang.StringUtils;

public class BillPushSetValueHelper {
    public static void setDetailTaxRate(BillVo bill, BillDetailVo detail, int index) {
        if ("0.00".equals(detail.getTaxRate()) || "0.0".equals(detail.getTaxRate())) {
            detail.setTaxRate("0");
        }
        detail.setTaxRate(ApiVerifyUtil.getStandardTaxRateOrOriginalValue(detail.getTaxRate()));
        if (!(Arrays.asList(ApiVerifyUtil.getPercentTaxRate()).contains(detail.getTaxRate()) || Arrays.asList(ApiVerifyUtil.getIntTaxRate()).contains(detail.getTaxRate()) || Arrays.asList(ApiVerifyUtil.getFloatTaxRate()).contains(detail.getTaxRate()))) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u7a0e\u7387[%3$s]\u4e0d\u5408\u6cd5", (String)"BillPushSetValueHelper_0", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), index, detail.getTaxRate()));
        }
        if (Arrays.asList(ApiVerifyUtil.getPercentTaxRate()).contains(detail.getTaxRate()) || Arrays.asList(ApiVerifyUtil.getIntTaxRate()).contains(detail.getTaxRate())) {
            detail.setTaxRate(TaxRateUtil.okTaxRate((String)detail.getTaxRate()));
        }
        if ("0".equals(detail.getTaxRate())) {
            if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(bill.getInvoiceType()) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(bill.getInvoiceType()) || InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(bill.getInvoiceType())) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4e0d\u5141\u8bb8\u5f00\u51770\u7a0e\u7387\u53d1\u7968", (String)"BillPushSetValueHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), index));
            }
            if (StringUtils.isEmpty((String)detail.getPrivilegeContent())) {
                detail.setPrivilegeContent("\u666e\u901a\u96f6\u7a0e\u7387");
            }
            if (!("\u514d\u7a0e".equals(detail.getPrivilegeContent()) || "\u4e0d\u5f81\u7a0e".equals(detail.getPrivilegeContent()) || "\u666e\u901a\u96f6\u7a0e\u7387".equals(detail.getPrivilegeContent()) || "\u51fa\u53e3\u9000\u7a0e".equals(detail.getPrivilegeContent()))) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u7a0e\u7387\u4e3a0\uff0c\u4eab\u53d7\u4f18\u60e0\u5185\u5bb9\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u4e3a[\u51fa\u53e3\u96f6\u7a0e\uff0c\u514d\u7a0e\uff0c\u4e0d\u5f81\u7a0e\uff0c\u666e\u901a\u96f6\u7a0e\u7387]\u4e2d\u7684\u4e00\u79cd", (String)"BillPushSetValueHelper_2", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), index));
            }
            if ("\u666e\u901a\u96f6\u7a0e\u7387".equals(detail.getPrivilegeContent())) {
                detail.setPrivilegeFlag(Integer.valueOf(0));
            } else {
                detail.setPrivilegeFlag(Integer.valueOf(1));
            }
        } else if ("\u514d\u7a0e".equals(detail.getPrivilegeContent()) || "\u4e0d\u5f81\u7a0e".equals(detail.getPrivilegeContent()) || "\u666e\u901a\u96f6\u7a0e\u7387".equals(detail.getPrivilegeContent()) || "\u51fa\u53e3\u9000\u7a0e".equals(detail.getPrivilegeContent())) {
            detail.setPrivilegeContent("");
            detail.setPrivilegeFlag(Integer.valueOf(0));
        }
    }

    public static BigDecimal getCETaxHS(BillDetailVo detail, BigDecimal deduction, BigDecimal taxRate) {
        if (detail.getLineProperty() != 2) {
            deduction = BigDecimal.ZERO;
        }
        BigDecimal subtract = detail.getIncludeTaxAmount().subtract(deduction);
        BigDecimal tax = BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRate), 15, RoundingMode.HALF_UP).multiply(taxRate).multiply(subtract).setScale(2, RoundingMode.HALF_UP);
        return tax;
    }

    public static BigDecimal getCETaxBHS(BillDetailVo detail, BigDecimal deduction, BigDecimal taxRate) {
        if (detail.getLineProperty() != 2) {
            deduction = BigDecimal.ZERO;
        }
        BigDecimal subtract = detail.getAmount().subtract(deduction);
        BigDecimal tax = subtract.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
        return tax;
    }

    public static void setDetailBHS(BillVo bill, BillDetailVo detail, int index) {
        boolean isCezs;
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || "1".equals(bill.getIsElePaper());
        boolean bl = isCezs = TaxedTypeEnum.deduction.getValue().equals(bill.getTaxationStyle()) || TaxedTypeEnum.all_e_deduction.getValue().equals(bill.getTaxationStyle());
        if (null == detail.getTaxAmount() || !"0".equals(detail.getTaxRate()) && detail.getTaxAmount().compareTo(BigDecimal.ZERO) == 0) {
            if (isCezs && !"0.015".equals(detail.getTaxRate())) {
                BigDecimal tax = BillPushSetValueHelper.getCETaxBHS(detail, BillPushSetValueHelper.getDeduction(bill, detail), new BigDecimal(detail.getTaxRate()));
                detail.setTaxAmount(tax);
            } else {
                if (isCezs && "0.015".equals(detail.getTaxRate())) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec60.015\u7a0e\u7387\u4e0d\u5141\u8bb8\u5f00\u5177\u5dee\u989d\u53d1\u7968", (String)"BillPushSetValueHelper_3", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), index));
                }
                if ("0.015".equals(detail.getTaxRate()) && !TaxedTypeEnum.all_e_reduced_tax.getValue().equals(bill.getTaxationStyle())) {
                    detail.setTaxAmount(detail.getAmount().multiply(InvoiceConstant.TAX_015).setScale(8, RoundingMode.HALF_UP).divide(new BigDecimal("1.035"), 2, RoundingMode.HALF_UP));
                } else {
                    detail.setTaxAmount(detail.getAmount().multiply(new BigDecimal(detail.getTaxRate())).setScale(2, RoundingMode.HALF_UP));
                }
            }
        }
        if (MathUtils.isZero(detail.getAmount()) && !MathUtils.isZero(detail.getTaxAmount())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u91d1\u989d\u4e3a0\u65f6\uff0c\u7a0e\u989d\u5e94\u4e3a0", (String)"BillPushSetValueHelper_4", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        detail.setIncludeTaxAmount(detail.getAmount().add(detail.getTaxAmount()));
        if (StringUtils.isNotBlank((String)detail.getPrice())) {
            BigDecimal num = StringUtils.isEmpty((String)detail.getQuantity()) || "0".equals(detail.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(detail.getQuantity());
            BigDecimal taxUnitPrice = PriceHelper.getTaxUnitPriceByBHS(new BigDecimal(detail.getTaxRate()), num, detail.getIncludeTaxAmount(), new BigDecimal(detail.getPrice()), isAllEle);
            detail.setIncludeTaxPrice(taxUnitPrice.toPlainString());
        }
        if (null != detail.getDiscountAmount() && detail.getDiscountAmount().compareTo(BigDecimal.ZERO) != 0) {
            if ("0.015".equals(detail.getTaxRate())) {
                detail.setDiscountTaxAmount(detail.getDiscountAmount().multiply(new BigDecimal("0.015")).setScale(8, RoundingMode.HALF_UP).divide(new BigDecimal("1.035"), 2, RoundingMode.HALF_UP));
            } else if (MathUtils.isZero(detail.getDiscountTaxAmount())) {
                detail.setDiscountTaxAmount(detail.getDiscountAmount().multiply(new BigDecimal(detail.getTaxRate())).setScale(2, RoundingMode.HALF_UP));
            }
        }
    }

    public static void setRemainAmount(BillDetailVo detail, BigDecimal amount) {
        detail.setRemainQuantity(detail.getQuantity());
        detail.setRemainAmount(amount);
        detail.setRemainTaxAmount(detail.getTaxAmount());
    }

    public static void setDetailHS(BillVo bill, BillDetailVo detail, int index) {
        boolean isAllEle;
        boolean isCezs;
        if (MathUtils.isZero(detail.getIncludeTaxAmount())) {
            detail.setIncludeTaxAmount(detail.getAmount().setScale(2, RoundingMode.HALF_UP));
        }
        detail.setIncludeTaxPrice(detail.getPrice());
        boolean bl = isCezs = TaxedTypeEnum.deduction.getValue().equals(bill.getTaxationStyle()) || TaxedTypeEnum.all_e_deduction.getValue().equals(bill.getTaxationStyle());
        if (null == detail.getTaxAmount() || !"0".equals(detail.getTaxRate()) && detail.getTaxAmount().compareTo(BigDecimal.ZERO) == 0) {
            if (isCezs && !"0.015".equals(detail.getTaxRate())) {
                BigDecimal tax = BillPushSetValueHelper.getCETaxHS(detail, BillPushSetValueHelper.getDeduction(bill, detail), new BigDecimal(detail.getTaxRate()));
                detail.setTaxAmount(tax);
            } else {
                if (isCezs && "0.015".equals(detail.getTaxRate())) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec60.015\u7a0e\u7387\u4e0d\u5141\u8bb8\u5f00\u5177\u5dee\u989d\u53d1\u7968", (String)"BillPushSetValueHelper_3", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), index));
                }
                if ("0.015".equals(detail.getTaxRate()) && !TaxedTypeEnum.all_e_reduced_tax.getValue().equals(bill.getTaxationStyle())) {
                    detail.setTaxAmount(detail.getAmount().multiply(new BigDecimal("0.015")).setScale(8, RoundingMode.HALF_UP).divide(new BigDecimal("1.05"), 2, RoundingMode.HALF_UP));
                } else {
                    detail.setTaxAmount(detail.getIncludeTaxAmount().divide(new BigDecimal(detail.getTaxRate()).add(new BigDecimal("1")), 8, RoundingMode.HALF_UP).multiply(new BigDecimal(detail.getTaxRate())).setScale(2, RoundingMode.HALF_UP));
                }
            }
        }
        if (MathUtils.isZero(detail.getAmount()) && !MathUtils.isZero(detail.getTaxAmount())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u91d1\u989d\u4e3a0\u65f6\uff0c\u7a0e\u989d\u5e94\u4e3a0", (String)"BillPushSetValueHelper_4", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        detail.setAmount(detail.getIncludeTaxAmount().subtract(detail.getTaxAmount()).setScale(2, RoundingMode.HALF_UP));
        boolean bl2 = isAllEle = InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || AllEleAuthHelper.elePaperSetValue((Object)bill.getSellerTaxpayerId(), (Object)bill.getInvoiceType());
        if (StringUtils.isNotBlank((String)detail.getPrice())) {
            detail.setIncludeTaxPrice(detail.getPrice());
            BigDecimal num = StringUtils.isEmpty((String)detail.getQuantity()) || "0".equals(detail.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(detail.getQuantity());
            BigDecimal unitPriceByHS = PriceHelper.getUnitPriceByHS(new BigDecimal(detail.getTaxRate()), num, detail.getAmount(), new BigDecimal(detail.getIncludeTaxPrice()), isAllEle);
            detail.setPrice(unitPriceByHS.toPlainString());
        }
        if (null != detail.getDiscountAmount() && detail.getDiscountAmount().compareTo(BigDecimal.ZERO) != 0) {
            if ("0.015".equals(detail.getTaxRate())) {
                detail.setDiscountTaxAmount(detail.getDiscountAmount().multiply(new BigDecimal("0.015")).setScale(8, RoundingMode.HALF_UP).divide(new BigDecimal("1.05"), 2, RoundingMode.HALF_UP));
            } else if (MathUtils.isZero(detail.getDiscountTaxAmount())) {
                detail.setDiscountTaxAmount(detail.getDiscountAmount().multiply(new BigDecimal(detail.getTaxRate())).divide(new BigDecimal(detail.getTaxRate()).add(new BigDecimal("1")), 2, RoundingMode.HALF_UP));
            }
        }
    }

    public static BigDecimal getDeduction(BillVo bill, BillDetailVo detail) {
        BigDecimal deduction = detail.getDeduction() != null && detail.getDeduction().compareTo(BigDecimal.ZERO) != 0 ? detail.getDeduction() : bill.getDeduction();
        return deduction;
    }

    public static void clearAndFillDiscountData(BillVo bill, BillDetailVo detail, int i) {
        detail.setPrice("");
        detail.setQuantity("");
        detail.setSpecification("");
        detail.setUnits("");
        detail.setOriNum("");
        detail.setOriUnitPrice("");
        detail.setDiscountAmount(BigDecimal.ZERO);
        detail.setDiscountTaxAmount(BigDecimal.ZERO);
        detail.setDiscountRate("");
        if (bill.isNormalRowCheck()) {
            BillDetailVo normalDetail = (BillDetailVo)bill.getBillDetail().get(i - 1);
            detail.setGoodsName(normalDetail.getGoodsName());
            detail.setGoodsCode(normalDetail.getGoodsCode());
            detail.setGoodsId(normalDetail.getGoodsId());
            detail.setTaxCodeId(normalDetail.getTaxCodeId());
            detail.setRevenueCode(normalDetail.getRevenueCode());
            detail.setRevenueName(normalDetail.getRevenueName());
            detail.setTaxRate(normalDetail.getTaxRate());
        }
    }
}

