/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;

public class CheckCurrentOrgHelper {
    public static void checkPermissonAndIsSameOrg(AbstractFormPlugin _this, ImcPermItemEnum permission, DynamicObject[] objs) {
        Set<Long> orgSet = CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor(_this, permission, objs);
        if (orgSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u6765\u6e90\u4e8e\u591a\u4e2a\u4e0d\u540c\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u6570\u636e\u64cd\u4f5c", (String)"CheckCurrentOrgHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static Set<Long> checkSelectRowsCurrentAuthor(AbstractFormPlugin _this, ImcPermItemEnum permission, DynamicObject[] objs) {
        return CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor(_this, permission, "", objs);
    }

    public static Set<Long> checkSelectRowsCurrentAuthor(AbstractFormPlugin _this, ImcPermItemEnum permission, String entityId, DynamicObject[] objs) {
        if (objs.length == 0) {
            return new HashSet<Long>(1);
        }
        String orgKey = CheckCurrentOrgHelper.getOrgKey(objs[0].getDynamicObjectType().getName());
        Set<Long> orgIds = Arrays.stream(objs).map(o -> DynamicObjectUtil.getDynamicObjectLongValue((Object)o.getDynamicObject(orgKey))).collect(Collectors.toSet());
        for (Long orgId : orgIds) {
            if (PermissionHelper.checkOrgPermission((AbstractFormPlugin)_this, (ImcPermItemEnum)permission, (String)entityId, (Long)orgId)) continue;
            DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s\u7ec4\u7ec7\u7684%2$s\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"CheckCurrentOrgHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), bosOrg == null ? "" : bosOrg.getString("name"), permission.getDescription()));
        }
        return orgIds;
    }

    private static String getOrgKey(String entityName) {
        switch (entityName) {
            case "sim_vatinvoice": {
                return "orgid";
            }
            case "sim_original_bill": {
                return "orgid";
            }
            case "sim_red_info": {
                return "org";
            }
            case "sim_lqpt_summary": {
                return "org";
            }
        }
        return "orgid";
    }
}

