/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.HTXXUtil;
import kd.imc.sim.common.model.taxcopyandreset.CopyTaxAndRestUnlockVo;
import kd.imc.sim.common.model.taxcopyandreset.CopyTaxReturn;
import kd.imc.sim.common.model.taxcopyandreset.TaxKeyCopyReturnDataDto;
import kd.imc.sim.common.model.taxcopyandreset.VirtualEquipmentCopyTaxDto;
import org.apache.commons.lang3.StringUtils;

public class CopyTaxAndRestHelper
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(CopyTaxAndRestHelper.class);
    private static final String SIM_COPY_TAX_RETURNS = "sim_copy_tax_returns";
    private static final String VIRTUAL_COPY_AND_REST_OK = "0";

    public static Map<String, String> copyTaxAndRestUnlock(CopyTaxAndRestUnlockVo vo) {
        if (null == vo) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6284\u7a0e\u6e05\u5361\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38!", (String)"CopyTaxAndRestHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        String deviceType = String.valueOf(vo.getDeviceType());
        if (VIRTUAL_COPY_AND_REST_OK.equals(deviceType) || "2".equals(deviceType) || "1".equals(deviceType)) {
            return CopyTaxAndRestHelper.taxKeyDeal(vo);
        }
        if (EquipmentType.isLyServer((String)vo.getDeviceType().toString())) {
            return CopyTaxAndRestHelper.LyServerDeviceDeal(vo);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7[%1$s],\u8bbe\u5907\u7c7b\u578b[%2$s]\u6682\u4e0d\u652f\u6301\u6284\u62a5\u7a0e\u64cd\u4f5c", (String)"CopyTaxAndRestHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), vo.getDeviceNo(), EquipmentType.EQUIPMENT_MAP.get(deviceType)));
    }

    private static Map<String, String> LyServerDeviceDeal(CopyTaxAndRestUnlockVo vo) {
        HashMap<String, String> rMap = new HashMap<String, String>(4);
        MsgRequest msgRequest = new MsgRequest();
        logger.info(String.format("\u8054\u4e91\u6284\u62a5\u7a0e\u5361\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\u662f\uff1a%s", JSON.toJSONString((Object)vo)));
        msgRequest.setReqData((Object)vo);
        JSONObject params = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)vo));
        logger.info(String.format("\u8054\u4e91\u6284\u62a5\u7a0e\u5361\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u662f\uff1a%s", JSON.toJSONString((Object)vo)));
        try {
            String response = HTXXUtil.callIsmcInvoice((JSONObject)params, (String)"LyServerOpenInvoice", (String)"termInfo");
            VirtualEquipmentCopyTaxDto copyTaxDto = (VirtualEquipmentCopyTaxDto)JSON.parseObject((String)response, VirtualEquipmentCopyTaxDto.class);
            if (null == copyTaxDto) {
                rMap.put("msg", ResManager.loadKDString((String)"\u6284\u7a0e\u6e05\u5361\u5f02\u5e38,\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"CopyTaxAndRestHelper_2", (String)"imc-sim-common", (Object[])new Object[0]));
                return rMap;
            }
            if (VIRTUAL_COPY_AND_REST_OK.equals(copyTaxDto.getCbzt()) && VIRTUAL_COPY_AND_REST_OK.equals(copyTaxDto.getQlzt())) {
                String nowMonth;
                String cbyf = new StringBuilder(copyTaxDto.getCbyf()).insert(4, "-").toString().substring(0, 7);
                if (!cbyf.equals(nowMonth = DateUtils.format((Date)new Date(), (String)"yyyy-MM"))) {
                    HTXXUtil.callIsmcInvoice((JSONObject)params, (String)"LyServerOpenInvoice", (String)"newspaperTax");
                    HTXXUtil.callIsmcInvoice((JSONObject)params, (String)"LyServerOpenInvoice", (String)"taxreturn_monitor");
                    response = HTXXUtil.callIsmcInvoice((JSONObject)params, (String)"LyServerOpenInvoice", (String)"termInfo");
                    copyTaxDto = (VirtualEquipmentCopyTaxDto)JSON.parseObject((String)response, VirtualEquipmentCopyTaxDto.class);
                }
                CopyTaxReturn copyTaxReturn = new CopyTaxReturn();
                cbyf = new StringBuilder(copyTaxDto.getCbyf()).insert(4, "-").toString().substring(0, 7);
                copyTaxReturn.setId(String.valueOf(vo.getCopyTaxReturnId()));
                copyTaxReturn.setCopySuccessMonth(cbyf);
                Date cbsj = null;
                try {
                    Date bszzrq = DateUtils.stringToDate((String)copyTaxDto.getBszzrq(), (String)"yyyyMMdd");
                    Date kpzzrq = DateUtils.stringToDate((String)copyTaxDto.getKpzzrq(), (String)"yyyyMMdd");
                    cbsj = DateUtils.stringToDate((String)copyTaxDto.getCbsj(), (String)"yyyyMMdd");
                    copyTaxReturn.setTaxReturnEndDate(bszzrq);
                    copyTaxReturn.setInvEndDate(kpzzrq);
                }
                catch (Exception e) {
                    logger.error(String.format("\u865a\u62df\u8bbe\u5907\u6284\u7a0e\u6e05\u5361\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38\uff1a%s", e.getMessage()));
                }
                copyTaxReturn.setTaxCopyTime(cbsj);
                copyTaxReturn.setResetAndUnlockTime(cbsj);
                copyTaxReturn.setOrgId(vo.getOrgId());
                copyTaxReturn.setEpInfoId(vo.getEpInfoId());
                copyTaxReturn.setEquipmentId(vo.getEquipmentId());
                copyTaxReturn.setEqupmentStatus(vo.getEqupmentStatus());
                CopyTaxAndRestHelper.updateCopyTaxReturn(copyTaxReturn);
            }
            rMap.put("code", ErrorType.SUCCESS.getCode());
            rMap.put("msg", ResManager.loadKDString((String)"\u89e6\u53d1\u6284\u62a5\u7a0e\u6210\u529f", (String)"CopyTaxAndRestHelper_3", (String)"imc-sim-common", (Object[])new Object[0]));
            return rMap;
        }
        catch (Exception e) {
            logger.error(String.format("\u8054\u4e91\u8bbe\u5907\u6284\u7a0e\u6e05\u5361\u5f02\u5e38\uff1a%s", e));
            throw new KDBizException(e.getMessage());
        }
    }

    private static Map<String, String> taxKeyDeal(CopyTaxAndRestUnlockVo vo) {
        HashMap<String, String> rMap = new HashMap<String, String>();
        rMap.put("code", ErrorType.FAIL.getCode());
        rMap.put("msg", ErrorType.FAIL.getName());
        String url = ComponentServiceHelper.getComponentRequestUrl((String)vo.getDeviceNo());
        JSONObject sjd = new JSONObject();
        sjd.put("kpzl", (Object)"");
        sjd.put("zdqc", (Object)"1");
        ComponentRequest componentRequest = new ComponentRequest("36", (Object)sjd, "");
        ComponentResponse returnDto = ComponentServiceHelper.doPost((String)url, (String)JSON.toJSONString((Object)componentRequest), TaxKeyCopyReturnDataDto.class);
        if (returnDto.isSucess()) {
            CopyTaxReturn taxReturn = new CopyTaxReturn();
            taxReturn.setId(String.valueOf(vo.getCopyTaxReturnId()));
            String bscgyf = ((TaxKeyCopyReturnDataDto)returnDto.getResponse()).getZxbsrq();
            bscgyf = bscgyf.length() >= 6 ? bscgyf.substring(0, 4) + "-" + bscgyf.substring(4, 6) : "";
            taxReturn.setCopySuccessMonth(bscgyf);
            try {
                SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
                SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss");
                String kpzzrq = ((TaxKeyCopyReturnDataDto)returnDto.getResponse()).getKpzzrq();
                kpzzrq = kpzzrq.length() >= 8 ? kpzzrq.substring(0, 8) : "";
                Date kpzzrqDate = StringUtils.isBlank((CharSequence)kpzzrq) ? null : yyyyMMdd.parse(kpzzrq);
                Date bszzrqDate = StringUtils.isBlank((CharSequence)((TaxKeyCopyReturnDataDto)returnDto.getResponse()).getBszzrq()) ? null : yyyyMMdd.parse(((TaxKeyCopyReturnDataDto)returnDto.getResponse()).getBszzrq());
                Date zxbssjDate = StringUtils.isBlank((CharSequence)((TaxKeyCopyReturnDataDto)returnDto.getResponse()).getZxbssj()) ? null : yyyyMMddHHmmss.parse(((TaxKeyCopyReturnDataDto)returnDto.getResponse()).getZxbssj());
                taxReturn.setOrgId(vo.getOrgId());
                taxReturn.setEpInfoId(vo.getEpInfoId());
                taxReturn.setEquipmentId(vo.getEquipmentId());
                taxReturn.setTaxReturnEndDate(bszzrqDate);
                taxReturn.setInvEndDate(kpzzrqDate);
                taxReturn.setTaxCopyTime(zxbssjDate);
                taxReturn.setResetAndUnlockTime(zxbssjDate);
                taxReturn.setEqupmentStatus(vo.getEqupmentStatus());
            }
            catch (Exception e) {
                logger.error(String.format("\u7a0e\u52a1UKey\u6284\u7a0e\u6e05\u5361\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a%s", e.getMessage()));
            }
            CopyTaxAndRestHelper.updateCopyTaxReturn(taxReturn);
            rMap.put("code", ErrorType.SUCCESS.getCode());
            rMap.put("msg", returnDto.getDescription());
            return rMap;
        }
        rMap.put("msg", returnDto.getDescription());
        return rMap;
    }

    private static void updateCopyTaxReturn(CopyTaxReturn copyTaxReturn) {
        boolean exists;
        if (null == copyTaxReturn || null == copyTaxReturn.getId()) {
            return;
        }
        String pkId = copyTaxReturn.getId();
        if (String.valueOf(-999999999).equals(pkId)) {
            QFilter filter1 = new QFilter("equipment", "=", (Object)copyTaxReturn.getEquipmentId());
            QFilter filter2 = new QFilter("org", "=", (Object)copyTaxReturn.getOrgId());
            DynamicObject copObj = QueryServiceHelper.queryOne((String)SIM_COPY_TAX_RETURNS, (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
            pkId = null == copObj ? "-999999999" : copObj.getString("id");
        }
        DynamicObject obj = !(exists = QueryServiceHelper.exists((String)SIM_COPY_TAX_RETURNS, (Object)pkId)) ? BusinessDataServiceHelper.newDynamicObject((String)SIM_COPY_TAX_RETURNS) : BusinessDataServiceHelper.loadSingle((Object)copyTaxReturn.getId(), (String)SIM_COPY_TAX_RETURNS);
        obj.set("copy_success_date", (Object)copyTaxReturn.getCopySuccessMonth());
        obj.set("tax_return_end_date", (Object)copyTaxReturn.getTaxReturnEndDate());
        obj.set("inv_end_date", (Object)copyTaxReturn.getInvEndDate());
        obj.set("tax_copy_time", (Object)copyTaxReturn.getTaxCopyTime());
        obj.set("reset_and_unlock_time", (Object)copyTaxReturn.getResetAndUnlockTime());
        obj.set("epinfo", (Object)copyTaxReturn.getEpInfoId());
        obj.set("equipment", (Object)copyTaxReturn.getEquipmentId());
        obj.set("equipment_status", (Object)copyTaxReturn.getEqupmentStatus());
        obj.set("org", (Object)copyTaxReturn.getOrgId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    public static String checkRules(Map<String, Object> pMap) {
        String msg = "";
        if (1 != (Integer)pMap.get("deviceStatus")) {
            return ResManager.loadKDString((String)"\u62a5\u7a0e\u8bbe\u5907\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u6284\u7a0e\u6e05\u5361", (String)"CopyTaxAndRestHelper_4", (String)"imc-sim-common", (Object[])new Object[0]);
        }
        String taxReturnEndDateStr = (String)pMap.get("taxReturnEndDate");
        String copySuccessDateStr = (String)pMap.get("copySuccessDate");
        if (StringUtils.isNotBlank((CharSequence)taxReturnEndDateStr) && StringUtils.isNotBlank((CharSequence)copySuccessDateStr)) {
            LocalDate currMonthDate;
            int currMonthValue = LocalDate.now().getMonthValue();
            String currMonthStr = currMonthValue < 10 ? VIRTUAL_COPY_AND_REST_OK + currMonthValue : String.valueOf(currMonthValue);
            String currMonth = LocalDate.now().getYear() + "-" + currMonthStr;
            LocalDate copySuccessDate = LocalDate.parse(copySuccessDateStr + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            if (copySuccessDate.equals(currMonthDate = LocalDate.parse(currMonth + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd")))) {
                return ResManager.loadKDString((String)"\u60a8\u672c\u671f\u5df2\u6210\u529f\u6284\u62a5\uff0c\u8bf7\u52ff\u91cd\u590d\u6284\u62a5", (String)"CopyTaxAndRestHelper_5", (String)"imc-sim-common", (Object[])new Object[0]);
            }
        }
        return msg;
    }
}

