/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.PaperPrintHelper;
import kd.imc.sim.common.helper.eim.EimInvoiceCallBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.InvalidInvoiceWriteBackHelper;

public class InvoiceCancelHelper {
    private static final Log LOG = LogFactory.getLog(InvoiceCancelHelper.class);
    private static final Set<String> ABOLISH_REASON_SET = InvoiceCancelHelper.ABOLISH_REASON_SET();

    private static final Set<String> ABOLISH_REASON_SET() {
        return Sets.newHashSet((Object[])new String[]{ResManager.loadKDString((String)"\u586b\u5199\u6709\u8bef", (String)"InvoiceCancelHelper_0", (String)"imc-sim-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u9762\u635f\u6bc1", (String)"InvoiceCancelHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6253\u5370\u9519\u8bef", (String)"InvoiceCancelHelper_2", (String)"imc-sim-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9500\u8d27\u9000\u56de", (String)"InvoiceCancelHelper_3", (String)"imc-sim-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9500\u552e\u6298\u8ba9", (String)"InvoiceCancelHelper_4", (String)"imc-sim-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u670d\u52a1\u7ec8\u6b62", (String)"InvoiceCancelHelper_5", (String)"imc-sim-common", (Object[])new Object[0])});
    }

    public static void cancelInvoice(DynamicObject invoice, String canceler, String abolishReason) {
        if (!"sim_vatinvoice".equals(invoice.getDataEntityType().getName())) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u4f20\u5165\u6570\u636e\u9519\u8bef", (String)"InvoiceCancelHelper_6", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (!InvoiceUtils.isPaperInvoice((String)invoice.getString("invoicetype"))) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_SUPPORT_INVOICE.getCode(), ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d1\u7968\u79cd\u7c7b[\u63a5\u53e3\u53ea\u652f\u6301\u589e\u503c\u7a0e\u7eb8\u8d28\u4e13\u7528\u53d1\u7968\u3001\u589e\u503c\u7a0e\u7eb8\u8d28\u666e\u901a\u53d1\u7968]", (String)"InvoiceCancelHelper_7", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        String orgId = null == invoice.getDynamicObject("orgid") ? "" : String.valueOf(invoice.getDynamicObject("orgid").getPkValue());
        String billStatus = invoice.getString("billstatus");
        String invCode = invoice.getString("invoicecode");
        String invNo = invoice.getString("invoiceno");
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u53d1\u7968\u4f5c\u5e9f\u4ee3\u7801%s,\u4f5c\u5e9f\u53f7\u7801%s,\u7ec4\u7ec7ID\u662f%s", invCode, invNo, orgId));
        }
        if ("6".equals(invoice.getString("invoicestatus"))) {
            return;
        }
        if (null == invoice.get("issuetime")) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICEDATE.getCode(), ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u53d1\u7968\u5f00\u5177\u65e5\u671f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"InvoiceCancelHelper_8", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        Date date = invoice.getDate("issuetime");
        Date now = new Date();
        if (now.getYear() != date.getYear() || now.getMonth() != date.getMonth()) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_INVOICE_EXPIRE.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u8de8\u6708\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"InvoiceCancelHelper_9", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (!InvoiceStatus.isAbsoluteNormal((String)invoice.getString("invoicestatus"))) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_ERROR_STATUS.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"InvoiceCancelHelper_10", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (!BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(billStatus) && !BillStatusEnum.AUDIT_SUCCESS.getCode().equals(billStatus)) {
            String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53d1\u7968\u53f7\u7801%2$s\u7684\u4f5c\u5e9f\u5ba1\u6838\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\u3002", (String)"InvoiceCancelHelper_11", (String)"imc-sim-common", (Object[])new Object[0]), invCode, invNo);
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), msg);
        }
        try {
            String equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)invoice.getString("jqbh"));
            if (AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"))) {
                MsgResponse msgResponse = AllEleServiceHelper.elePaperInvoiceAbolish((DynamicObject)invoice, (String)abolishReason);
                if (!ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                    throw new MsgException(msgResponse.getErrorCode(), String.format(ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25:%s", (String)"InvoiceCancelHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), msgResponse.getErrorMsg()));
                }
            } else if (EquipmentHelper.isBlockChainOrHostModeDevice((String)equipmentType)) {
                MsgResponse msgResponse = new MsgResponse();
                msgResponse = HostModeInvoiceHelper.invoiceAbolish(invoice, msgResponse);
                if (!ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                    throw new MsgException(msgResponse.getErrorCode(), String.format(ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25:%s", (String)"InvoiceCancelHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), msgResponse.getErrorMsg()));
                }
            } else if ("8".equals(equipmentType)) {
                MsgResponse msgResponse = new MsgResponse();
                BwServerInvoiceHelper.invoiceAbolish(invoice, msgResponse);
                if (!ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                    throw new MsgException(msgResponse.getErrorCode(), String.format(ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25:%s", (String)"InvoiceCancelHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), msgResponse.getErrorMsg()));
                }
            } else if (EquipmentType.isLyServer((String)equipmentType)) {
                MsgResponse msgResponse = new MsgResponse();
                LyServerInvoiceHelper.invoiceAbolish(invoice, canceler, msgResponse);
                if (!ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                    throw new MsgException(msgResponse.getErrorCode(), String.format(ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25:%s", (String)"InvoiceCancelHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), msgResponse.getErrorMsg()));
                }
            } else if ("3".equals(equipmentType)) {
                if (LOG.isInfoEnabled()) {
                    Thread.sleep(2000L);
                    LOG.info(String.format("\u865a\u62dfUKEY\u76f4\u63a5\u4f5c\u5e9f\uff0c\u53d1\u7968\u4ee3\u7801%s\uff0c\u53d1\u7968\u53f7\u7801%s", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                }
            } else {
                String url = ComponentServiceHelper.getComponentRequestUrl((String)invoice.getString("jqbh"));
                String reqParam = PaperPrintHelper.makeInvAbolishComponentParams(invoice, canceler).toJSONString();
                JSONObject jsonObject = ComponentServiceHelper.doPost((String)url, (String)reqParam);
                InvoiceCancelHelper.dealVehicleInvoiceCancleResult(jsonObject);
            }
            abolishReason = InvoiceCancelHelper.standardAbolishReason(abolishReason);
            InvoiceCancelHelper.updateInvoiceAbolishStatus(invoice, canceler, abolishReason, "sim_vatinvoice");
        }
        catch (MsgException e) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), e.getErrorMsg());
        }
        catch (Exception e) {
            LOG.error("\u53d1\u7968\u4f5c\u5e9f\u5931\u8d25", (Throwable)e);
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), e.toString());
        }
        finally {
            invoice.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
            ImcSaveServiceHelper.update((DynamicObject)invoice);
        }
    }

    private static String standardAbolishReason(String abolishReason) {
        if (StringUtils.isNotEmpty((String)abolishReason) && !ABOLISH_REASON_SET.contains(abolishReason)) {
            abolishReason = String.format(ResManager.loadKDString((String)"\u5176\u4ed6\uff1a%s", (String)"InvoiceCancelHelper_13", (String)"imc-sim-common", (Object[])new Object[0]), abolishReason);
        }
        return abolishReason;
    }

    public static void updateInvoiceAbolishStatus(DynamicObject invoiceDynamicObject, String canceler, Object abolishReason, String formId) {
        invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)invoiceDynamicObject.getPkValue(), (String)formId);
        if ("sim_vatinvoice".equals(formId)) {
            invoiceDynamicObject.set("invoicestatus", (Object)"6");
        } else {
            invoiceDynamicObject.set("invoicestatus", (Object)"2");
        }
        invoiceDynamicObject.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        invoiceDynamicObject.set("invalider", (Object)canceler);
        invoiceDynamicObject.set("abolishtype", (Object)"0");
        invoiceDynamicObject.set("abolishreason", abolishReason);
        invoiceDynamicObject.set("invaliddate", (Object)new Date());
        if ("sim_vatinvoice".equals(formId)) {
            InvalidInvoiceWriteBackHelper.writeBack2OriginBillByInvalid(invoiceDynamicObject);
        }
        ImcSaveServiceHelper.update((DynamicObject)invoiceDynamicObject);
        if ("sim_vatinvoice".equals(formId)) {
            try {
                OperationServiceHelper.executeOperate((String)"aftercancel", (String)"sim_vatinvoice", (DynamicObject[])new DynamicObject[]{invoiceDynamicObject}, null);
            }
            catch (Exception e) {
                LOG.error(String.format("\u6267\u884c\u4f5c\u5e9f\u540e\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u6c34\u53f7%s", invoiceDynamicObject.getString("orderno")), (Throwable)e);
            }
            if ("1".equals(invoiceDynamicObject.getString("issuetype")) && !StringUtils.isBlank((String)invoiceDynamicObject.getString("originalinvoicecode")) && !StringUtils.isBlank((String)invoiceDynamicObject.getString("originalinvoiceno"))) {
                InvoiceCancelHelper.updateBlueInvoice(invoiceDynamicObject);
            }
            if (CallbackHelperUtil.isNeedCallBack((DynamicObject)invoiceDynamicObject)) {
                CallbackHelperUtil.sendCallbackMessage((DynamicObject)invoiceDynamicObject, (String)invoiceDynamicObject.getString("systemsource"), (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL.getCode());
            }
            InvoiceCancelHelper.updateCountCheckAbolish(invoiceDynamicObject);
            if ("BILL_CENTER".equals(invoiceDynamicObject.getString("systemsource"))) {
                LOG.info(String.format("\u4f5c\u5e9f\u5f00\u59cb\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u662f%s", invoiceDynamicObject.getString("orderno")));
                DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"BillCenterCallBackServiceImpl", (String)"callback", (Object[])new Object[]{invoiceDynamicObject.getPkValue()});
            } else {
                EimInvoiceCallBackHelper.cancelCallBack(invoiceDynamicObject);
            }
            IssuePolicyHelper.deleteUseAmountLog((DynamicObject)invoiceDynamicObject);
        } else if ("1".equals(invoiceDynamicObject.getString("issuetype"))) {
            InvoiceCancelHelper.updateVehicleBlueInvoice(invoiceDynamicObject, formId);
        }
    }

    private static void updateVehicleBlueInvoice(DynamicObject invoiceDynamicObject, String formId) {
        if (!StringUtils.isBlank((String)invoiceDynamicObject.getString("originalinvoicecode")) && !StringUtils.isBlank((String)invoiceDynamicObject.getString("originalinvoiceno"))) {
            QFilter fCode = new QFilter("invoicecode", "=", (Object)invoiceDynamicObject.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invoiceDynamicObject.getString("originalinvoiceno")).and("orgid", "=", invoiceDynamicObject.getDynamicObject("orgid").get("id"));
            DynamicObject originalInv = BusinessDataServiceHelper.loadSingle((String)formId, (String)"id", (QFilter[])fCode.toArray());
            if (originalInv == null) {
                return;
            }
            DynamicObject inv = BusinessDataServiceHelper.loadSingle((Object)originalInv.getPkValue(), (String)formId);
            inv.set("invoicestatus", (Object)"0");
            ImcSaveServiceHelper.update((DynamicObject)inv);
        }
    }

    private static void updateBlueInvoice(DynamicObject invoiceDynamicObject) {
        QFilter fCode = new QFilter("invoicecode", "=", (Object)invoiceDynamicObject.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invoiceDynamicObject.getString("originalinvoiceno")).and("orgid", "=", invoiceDynamicObject.getDynamicObject("orgid").get("id"));
        DynamicObject originalInv = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])fCode.toArray());
        if (originalInv == null) {
            return;
        }
        BigDecimal invoiceAmount = invoiceDynamicObject.getBigDecimal("invoiceamount");
        BigDecimal totalTax = invoiceDynamicObject.getBigDecimal("totaltax");
        DynamicObject inv = BusinessDataServiceHelper.loadSingle((Object)originalInv.getPkValue(), (String)"sim_vatinvoice");
        inv.set("invoicestatus", (Object)"0");
        inv.set("remainredamount", (Object)inv.getBigDecimal("remainredamount").add(invoiceAmount.abs()));
        inv.set("canredtaxamount", (Object)inv.getBigDecimal("canredtaxamount").add(totalTax.abs()));
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{inv});
    }

    private static void updateCountCheckAbolish(DynamicObject invoice) {
        ThreadPools.executeOnce((String)"sim_abolish_check_count", () -> {
            try {
                LOG.info("\u5f00\u59cb\u56de\u5199\u5bf9\u8d26\u6c47\u603b\u8868\uff1ainvoiceBillNo\uff1a" + invoice.getString("billno"));
                QFilter relFilter = new QFilter("tbillid", "=", invoice.getPkValue());
                DynamicObject[] relDynamic = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)false), (QFilter[])relFilter.toArray());
                Map<String, List<DynamicObject>> relationgMaps = Arrays.stream(relDynamic).collect(Collectors.groupingBy(o -> o.getString("sbillid")));
                for (Map.Entry<String, List<DynamicObject>> sbillidMap : relationgMaps.entrySet()) {
                    String sbillid = sbillidMap.getKey();
                    QFilter reconciFilter = new QFilter("originalid", "=", (Object)Long.valueOf(sbillid));
                    DynamicObject reconciDy = BusinessDataServiceHelper.loadSingle((String)"sim_reconciliation_sum", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_reconciliation_sum", (boolean)false), (QFilter[])reconciFilter.toArray());
                    if (reconciDy == null) continue;
                    List<DynamicObject> dynamicObjects = relationgMaps.get(sbillid);
                    BigDecimal relamount = dynamicObjects.stream().map(o -> o.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal reltax = dynamicObjects.stream().map(o -> o.getBigDecimal("tax")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal reconciAmount = reconciDy.getBigDecimal("invoiceamount");
                    BigDecimal reconciTax = reconciDy.getBigDecimal("totaltax");
                    BigDecimal reconciTotal = reconciDy.getBigDecimal("totalamount");
                    if (reconciAmount.subtract(relamount).compareTo(BigDecimal.ZERO) == 0 && reconciTax.subtract(reltax).compareTo(BigDecimal.ZERO) == 0) {
                        QFilter deletFilter = new QFilter("originalid", "=", (Object)Long.valueOf(sbillid));
                        DeleteServiceHelper.delete((String)"sim_reconciliation_sum", (QFilter[])deletFilter.toArray());
                        continue;
                    }
                    reconciDy.set("invoiceamount", (Object)reconciAmount.subtract(relamount));
                    reconciDy.set("totalamount", (Object)reconciTotal.subtract(relamount).subtract(reltax));
                    reconciDy.set("totaltax", (Object)reconciTax.subtract(reltax));
                    reconciDy.set("invoiceamountdiffer", (Object)reconciDy.getBigDecimal("invoiceamountdiffer").add(relamount));
                    reconciDy.set("totalamountdiffer", (Object)reconciDy.getBigDecimal("totalamountdiffer").add(relamount).add(reltax));
                    reconciDy.set("totaltaxdiffer", (Object)reconciDy.getBigDecimal("totaltaxdiffer").add(reltax));
                    DynamicObjectCollection reconciItems = reconciDy.getDynamicObjectCollection("sim_reconciliation_item");
                    for (int i = 0; i < reconciItems.size(); ++i) {
                        if (!((DynamicObject)reconciItems.get(i)).getString("invoiceid").equals(invoice.getPkValue())) continue;
                        reconciItems.remove(i);
                        break;
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reconciDy});
                }
            }
            catch (Exception e) {
                LOG.error("\u4f5c\u5e9f\u540c\u6b65\u5bf9\u8d26\u6c47\u603b\u5931\u8d25\uff1a", (Object)e.getMessage());
            }
        });
    }

    public static void cancelVehicleInvoice(DynamicObject vehicleInvoice, String hxbzdh, String canceler, String abolishReason) {
        try {
            String equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)vehicleInvoice.getString("jqbh"));
            if (EquipmentHelper.isBlockChainOrHostModeDevice((String)equipmentType) || "8".equals(equipmentType) || EquipmentType.isLyServer((String)equipmentType)) {
                throw new MsgException(ApiErrCodeEnum.INVOICE_CANCEL_INVOICE_EQUIPMENT_UNSUPPORTED.getCode(), ApiErrCodeEnum.INVOICE_CANCEL_INVOICE_EQUIPMENT_UNSUPPORTED.getMsg());
            }
            if ("3".equals(equipmentType)) {
                if (LOG.isInfoEnabled()) {
                    Thread.sleep(2000L);
                    LOG.info(String.format("\u865a\u62dfUKEY\u76f4\u63a5\u4f5c\u5e9f\uff0c\u53d1\u7968\u4ee3\u7801%s\uff0c\u53d1\u7968\u53f7\u7801%s", vehicleInvoice.getString("invoicecode"), vehicleInvoice.getString("invoiceno")));
                }
            } else {
                String url = ComponentServiceHelper.getComponentRequestUrl((String)vehicleInvoice.getString("jqbh"));
                DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                invoice.set("terminalno", (Object)hxbzdh);
                invoice.set("invoicetype", (Object)InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode());
                invoice.set("invoicecode", (Object)vehicleInvoice.getString("invoicecode"));
                invoice.set("invoiceno", (Object)vehicleInvoice.getString("invoiceno"));
                String reqParam = PaperPrintHelper.makeInvAbolishComponentParams(invoice, canceler).toJSONString();
                JSONObject jsonObject = ComponentServiceHelper.doPost((String)url, (String)reqParam);
                InvoiceCancelHelper.dealVehicleInvoiceCancleResult(jsonObject);
            }
            abolishReason = InvoiceCancelHelper.standardAbolishReason(abolishReason);
            InvoiceCancelHelper.updateInvoiceAbolishStatus(vehicleInvoice, canceler, abolishReason, "sim_vatinvoice_vehicles");
        }
        catch (MsgException e) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), e.getErrorMsg());
        }
        catch (Exception e) {
            LOG.error("\u53d1\u7968\u4f5c\u5e9f\u5931\u8d25", (Throwable)e);
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), e.toString());
        }
        finally {
            vehicleInvoice.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
            ImcSaveServiceHelper.update((DynamicObject)vehicleInvoice);
        }
    }

    private static void dealVehicleInvoiceCancleResult(JSONObject jsonObject) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u53d1\u7968\u4f5c\u5e9f\u7ed3\u679c:" + jsonObject.toJSONString());
        }
        if (!"6011".equals(jsonObject.getString("errcode")) && !jsonObject.toJSONString().contains("\u5df2\u7ecf\u4f5c\u5e9f")) {
            throw new MsgException(jsonObject.getString("errcode"), String.format(ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25:%s", (String)"InvoiceCancelHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), jsonObject.toJSONString()));
        }
    }
}

