/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.CheckBillRelateInvoiceVo;
import kd.imc.bdm.common.dto.CheckJsonItemMergeVo;
import kd.imc.bdm.common.dto.InvoiceRollBackVo;
import kd.imc.bdm.common.dto.NeedMergeItemJsonVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BillRollbackHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ItemMerge2OneHelper {
    private static final Log LOGGER = LogFactory.getLog(ItemMerge2OneHelper.class);
    private static final String ISSUED = "0";
    private static final String ISSUING = "1";
    private static final String ISSUE_FAILED = "3";
    private static final String[] mergeArray = new String[]{"1", "2"};

    public static void dealNumOne(DynamicObject item) {
        if (!ISSUING.equals(item.getString("rowtype"))) {
            BigDecimal num = BigDecimal.ZERO.compareTo(item.getBigDecimal("amount")) <= 0 ? BigDecimal.ONE : BigDecimal.ONE.negate();
            item.set("remainvalidnum", (Object)num);
        }
    }

    public static CheckBillRelateInvoiceVo checkRelateOriginalBillInvoicesIsWait(Object[] pks) {
        boolean isIssueFailedExist;
        HashSet<Object> resultInvoicePkSet = new HashSet<Object>(Arrays.asList(pks));
        QFilter filter = new QFilter("id", "in", (Object)pks).and("mergelable", "in", (Object)mergeArray);
        DynamicObject[] mergeNumInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray());
        HashSet mergePks = Sets.newHashSet();
        boolean isRedSpecialInvoiceIssueFailedExist = false;
        for (DynamicObject invoice : mergeNumInvoices) {
            if (InvoiceUtils.isRedInfoInvoice((String)invoice.getString("issuetype"), (String)invoice.getString("invoicetype"))) {
                isRedSpecialInvoiceIssueFailedExist = ItemMerge2OneHelper.isRedSpecialInvoiceIssueFailed(isRedSpecialInvoiceIssueFailedExist, invoice);
                continue;
            }
            mergePks.add(invoice.getPkValue());
        }
        if (mergePks.size() == 0) {
            new CheckBillRelateInvoiceVo(false, isRedSpecialInvoiceIssueFailedExist);
        }
        InvoiceRollBackVo rollBackVo = new InvoiceRollBackVo();
        if (mergePks.size() > 0) {
            rollBackVo.setInvoicePks(mergePks);
            rollBackVo.setChoosedPks(mergePks);
            ItemMerge2OneHelper.getRollBackVo(rollBackVo);
            resultInvoicePkSet.addAll(rollBackVo.getInvoicePks());
        }
        isIssueFailedExist = (isIssueFailedExist = ItemMerge2OneHelper.checkInvoiceIssued(resultInvoicePkSet.toArray())) || isRedSpecialInvoiceIssueFailedExist;
        boolean isContainOtherInvoice = rollBackVo.getInvoicePks().size() != rollBackVo.getChoosedPks().size();
        return new CheckBillRelateInvoiceVo(isContainOtherInvoice, isIssueFailedExist);
    }

    public static boolean isRedSpecialInvoiceIssueFailed(boolean isRedSpecialInvoiceIssueFailed, DynamicObject invoice) {
        String issueStatus = invoice.getString("issuestatus");
        String invoiceStatus = invoice.getString("invoicestatus");
        if ((ISSUED.equals(issueStatus) || ISSUING.equals(issueStatus)) && InvoiceStatus.isNormalInvIncludePartRed((String)invoiceStatus)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u9000\u53d1\u7968\u5173\u8054\u7684\u540c\u4e00\u6279\u6b21\u53d1\u7968\u4e2d\u5305\u542b\u5df2\u5f00\u7968\u6216\u5f00\u7968\u4e2d\u7684\u53d1\u7968(\u53d1\u7968\u4ee3\u7801\uff1a%1$s,\u53d1\u7968\u53f7\u7801\uff1a%2$s)\uff0c\u4e0d\u5141\u8bb8\u56de\u9000", (String)"ItemMerge2OneHelper_0", (String)"imc-sim-common", (Object[])new Object[0]), invoice.getString("invoicecode"), invoice.getString("invoiceno")));
        }
        if (ISSUE_FAILED.equals(issueStatus)) {
            isRedSpecialInvoiceIssueFailed = true;
        }
        return isRedSpecialInvoiceIssueFailed;
    }

    public static boolean checkInvoiceIssued(Object[] invoicePks) {
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "issuestatus", "invoicestatus", "invoicecode", "invoiceno"), (QFilter[])new QFilter("id", "in", (Object)invoicePks).toArray());
        boolean isIssueFailed = false;
        for (DynamicObject invoice : invoices) {
            String issueStatus = invoice.getString("issuestatus");
            String invoiceStatus = invoice.getString("invoicestatus");
            if ((ISSUED.equals(issueStatus) || ISSUING.equals(issueStatus)) && InvoiceStatus.isNormalInvIncludePartRed((String)invoiceStatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u9000\u53d1\u7968\u5173\u8054\u7684\u540c\u4e00\u6279\u6b21\u53d1\u7968\u4e2d\u5305\u542b\u5df2\u5f00\u7968\u6216\u5f00\u7968\u4e2d\u7684\u53d1\u7968(\u53d1\u7968\u4ee3\u7801\uff1a%1$s,\u53d1\u7968\u53f7\u7801\uff1a%2$s)\uff0c\u4e0d\u5141\u8bb8\u56de\u9000", (String)"ItemMerge2OneHelper_0", (String)"imc-sim-common", (Object[])new Object[0]), invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            if (!ISSUE_FAILED.equals(issueStatus)) continue;
            isIssueFailed = true;
        }
        return isIssueFailed;
    }

    public static Object[] rollBackWaitInvoice(Object[] invoicePks) {
        QFilter filter = new QFilter("id", "in", (Object)invoicePks).and("mergelable", "in", (Object)mergeArray);
        DynamicObject[] mergeInvoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray());
        HashSet<Object> mergeNumOnePks = new HashSet<Object>();
        ArrayList<Object> allPks = new ArrayList<Object>(Arrays.asList(invoicePks));
        HashSet infoCodes = Sets.newHashSet();
        HashSet redConfirmBillNos = Sets.newHashSet();
        HashSet redInfoInvoicePks = Sets.newHashSet();
        HashSet redConfirmInvoicePks = Sets.newHashSet();
        Object orgPk = null;
        for (DynamicObject dynamicObject : mergeInvoiceArray) {
            orgPk = dynamicObject.getDynamicObject("orgid").getPkValue();
            allPks.remove(dynamicObject.getPkValue());
            if (InvoiceUtils.isRedInfoInvoice((String)dynamicObject.getString("issuetype"), (String)dynamicObject.getString("invoicetype"))) {
                infoCodes.add(dynamicObject.getString("infocode"));
                redInfoInvoicePks.add(dynamicObject.getPkValue());
                continue;
            }
            if (InvoiceUtils.isRedConfirmInvoice((String)dynamicObject.getString("issuetype"), (String)dynamicObject.getString("invoicetype"))) {
                redConfirmBillNos.add(dynamicObject.getString("infocode"));
                redConfirmInvoicePks.add(dynamicObject.getPkValue());
            }
            mergeNumOnePks.add(dynamicObject.getPkValue());
        }
        if (infoCodes.size() > 0) {
            QFilter redInfoFilter = new QFilter("infocode", "in", (Object)infoCodes.toArray(new Object[0])).and("org", "=", orgPk);
            DynamicObject[] redInfoArray = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id", (QFilter[])redInfoFilter.toArray());
            HashSet redInfoPks = Sets.newHashSet();
            for (DynamicObject object : redInfoArray) {
                redInfoPks.add(object.getPkValue());
            }
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "in", (Object)redInfoPks.toArray(new Object[0])).toArray());
            HashSet oriBillPks = Sets.newHashSet();
            for (DynamicObject relation : dynamicObjectArray) {
                oriBillPks.add(relation.getLong("sbillid"));
            }
            InvoiceRollBackVo redInfoRollBackVo = new InvoiceRollBackVo();
            redInfoRollBackVo.setInvoicePks(redInfoInvoicePks);
            redInfoRollBackVo.setOriginalBillPks(oriBillPks);
            ItemMerge2OneHelper.rollBackRedSpecialInvoice(redInfoRollBackVo);
        }
        if (redConfirmBillNos.size() <= 0 || redConfirmInvoicePks.size() > 0) {
            // empty if block
        }
        if (mergeNumOnePks.size() > 0) {
            InvoiceRollBackVo rollBackVo = new InvoiceRollBackVo();
            rollBackVo.setInvoicePks(mergeNumOnePks);
            rollBackVo.setChoosedPks(mergeNumOnePks);
            ItemMerge2OneHelper.getRollBackVo(rollBackVo);
            ItemMerge2OneHelper.rollBack(rollBackVo);
        }
        return allPks.toArray();
    }

    public static void getRollBackVo(InvoiceRollBackVo rollBackVo) {
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "in", (Object)rollBackVo.getInvoicePks().toArray()).toArray());
        HashSet<Object> originalBillPks = new HashSet<Object>();
        for (DynamicObject relation : relations) {
            originalBillPks.add(relation.get("sbillid"));
        }
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "in", (Object)originalBillPks.toArray()).toArray());
        HashSet<Object> relateInvoicePks = new HashSet<Object>();
        for (DynamicObject billRelation : billRelations) {
            relateInvoicePks.add(billRelation.get("tbillid"));
        }
        if (relateInvoicePks.size() == rollBackVo.getInvoicePks().size()) {
            rollBackVo.setOriginalBillPks(originalBillPks);
            return;
        }
        if (relateInvoicePks.size() < rollBackVo.getInvoicePks().size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u4e0d\u662f\u4ece\u5f00\u7968\u7533\u8bf7\u5355\u4ece\u4e0b\u63a8\u7684\uff0c\u56de\u9000\u5931\u8d25", (String)"ItemMerge2OneHelper_1", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        rollBackVo.setInvoicePks(relateInvoicePks);
        ItemMerge2OneHelper.getRollBackVo(rollBackVo);
    }

    public static void rollBackRedSpecialInvoice(InvoiceRollBackVo rollBackVo) {
        HashSet rollBackIds = rollBackVo.getInvoicePks();
        QFilter qFilter = new QFilter("id", "in", (Object)rollBackVo.getInvoicePks().toArray(new Object[0])).and("invoicetype", "in", (Object)InvoiceUtils.getSpecialInvoiceType()).and("invoiceamount", "<", (Object)BigDecimal.ZERO);
        DynamicObject[] userAddWaitInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.format("%s, %s", "infocode", "orgid"), (QFilter[])qFilter.toArray());
        try (TXHandle h1 = TX.required();){
            try {
                if (userAddWaitInvoices.length != 0) {
                    List userAddWaitInvoiceIds = Stream.of(userAddWaitInvoices).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                    rollBackIds.removeIf(userAddWaitInvoiceIds::contains);
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"), (Object[])userAddWaitInvoiceIds.toArray());
                    new BillRollbackHelper().userAddredInfoRollback(userAddWaitInvoices);
                }
            }
            catch (Exception e) {
                h1.markRollback();
                LOGGER.error("\u5f85\u5f00\u56de\u9000\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f85\u5f00\u56de\u9000\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25%s", (String)"ItemMerge2OneHelper_2", (String)"imc-sim-common", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static void rollBack(InvoiceRollBackVo rollBackVo) {
        try (TXHandle h1 = TX.required();){
            try {
                DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoicetype"), (QFilter[])new QFilter("issuestatus", "in", (Object)new String[]{IssueStatusEnum.none.getCode(), IssueStatusEnum.failed.getCode()}).and("id", "in", (Object)rollBackVo.getInvoicePks().toArray()).toArray());
                Object[] waitPks = invoices.stream().map(invoice -> invoice.get("id")).toArray();
                if (invoices.size() > 0) {
                    int deleteInvoiceNum = DeleteServiceHelper.delete((String)"sim_vatinvoice", (QFilter[])new QFilter("id", "in", (Object)waitPks).toArray());
                    LOGGER.info(String.format("\u5220\u9664\u7684\u53d1\u7968\u6570\u91cf\uff1a%s", deleteInvoiceNum));
                }
                DynamicObject[] originalBillArr = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)rollBackVo.getOriginalBillPks().toArray()).toArray());
                List<DynamicObject> originalBills = new BillRollbackHelper().originalBillAllRollBack(originalBillArr);
                ImcSaveServiceHelper.save(originalBills);
                int relationNum = DeleteServiceHelper.delete((String)"sim_bill_inv_relation", (QFilter[])new QFilter("tbillid", "in", (Object)waitPks).toArray());
                LOGGER.info(String.format("\u5220\u9664\u7684\u4e2d\u95f4\u5173\u7cfb\u8868\u6570\u91cf\uff1a%s", relationNum));
                Object[] alleInvoicePk = invoices.stream().filter(invoice -> InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))).map(invoice -> invoice.get("id")).toArray();
                if (alleInvoicePk.length != 0) {
                    ItemMerge2OneHelper.mergeBillRollback(alleInvoicePk, rollBackVo.getOriginalBillPks());
                }
            }
            catch (Exception e) {
                h1.markRollback();
                LOGGER.error("\u5f85\u5f00\u56de\u9000\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f85\u5f00\u56de\u9000\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25%s", (String)"ItemMerge2OneHelper_2", (String)"imc-sim-common", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private static void mergeBillRollback(Object[] alleInvoicePk, HashSet<Object> originalBillPks) {
        DynamicObjectCollection relations = QueryServiceHelper.query((String)"sim_mergebill_relation", (String)String.join((CharSequence)",", "id", "tbillid"), (QFilter[])new QFilter("sbillid", "in", originalBillPks).toArray());
        if (CollectionUtils.isNotEmpty((Collection)relations)) {
            DeleteServiceHelper.delete((String)"sim_merge_bill", (QFilter[])new QFilter("id", "in", (Object)relations.stream().map(relation -> relation.getLong("tbillid")).toArray()).toArray());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_mergebill_relation"), (Object[])relations.stream().map(relation -> relation.getLong("id")).toArray());
        }
        DeleteServiceHelper.delete((String)"sim_merge_inv_relation", (QFilter[])new QFilter("tbillid", "in", (Object)alleInvoicePk).toArray());
    }

    public static void issueWriteBack(DynamicObject invoice) {
        DynamicObject[] array;
        if (ItemMerge2OneHelper.isNeedNumExtraDeal(invoice.getString("mergelable"))) {
            DynamicObject[] oriBills = ItemMerge2OneHelper.queryInvoiceAllOriginalBills(invoice.getPkValue());
            ItemMerge2OneHelper.dealNumDifference(oriBills);
            return;
        }
        String issueType = invoice.getString("issuetype");
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType) && (array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter("invoicecode", "=", (Object)invoice.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invoice.getString("originalinvoiceno")).toArray())).length > 0) {
            DynamicObject[] oriBills = ItemMerge2OneHelper.queryInvoiceAllOriginalBills(array[0].getPkValue());
            List<DynamicObject> originalBills = new BillRollbackHelper().originalBillAllRollBack(oriBills);
            ImcSaveServiceHelper.save(originalBills);
        }
    }

    public static void dealNumDifference(DynamicObject[] oriBills) {
        for (DynamicObject oriBill : oriBills) {
            DynamicObjectCollection items2 = oriBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items2) {
                item.set("numdeviation", (Object)BigDecimal.ZERO);
            }
        }
        SaveServiceHelper.update((DynamicObject[])oriBills);
    }

    public static DynamicObject[] queryInvoiceAllOriginalBills(Object invoicePk) {
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "=", invoicePk).toArray());
        return ItemMerge2OneHelper.getOriginalBills(relations);
    }

    public static void writeBackCancelInvoiceItemNumMerge2One(DynamicObject invoice) {
        DynamicObject[] array;
        if (ItemMerge2OneHelper.isNeedNumExtraDeal(invoice.getString("mergelable")) && ItemMerge2OneHelper.isBillTotalAmountSame(invoice)) {
            DynamicObject[] oriBills = ItemMerge2OneHelper.queryInvoiceAllOriginalBills(invoice.getPkValue());
            ItemMerge2OneHelper.dealMergeNum(oriBills, false);
        }
        String issueType = invoice.getString("issuetype");
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType) && (array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "totalamount"), (QFilter[])new QFilter("invoicecode", "=", (Object)invoice.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invoice.getString("originalinvoiceno")).and(new QFilter("mergelable", "in", (Object)new String[]{ISSUING, "2"})).toArray())).length > 0 && ItemMerge2OneHelper.isBillTotalAmountSame(array[0])) {
            DynamicObject[] oriBills = ItemMerge2OneHelper.queryInvoiceAllOriginalBills(array[0].getPkValue());
            ItemMerge2OneHelper.dealMergeNum(oriBills, true);
        }
    }

    public static void dealMergeNum(DynamicObject[] oriBills, boolean isBlueInvoiceRelateRedInvoiceCancel) {
        for (DynamicObject oriBill : oriBills) {
            DynamicObjectCollection items2 = oriBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items2) {
                item.set("remainvalidnum", (Object)item.getBigDecimal("num"));
                if (!isBlueInvoiceRelateRedInvoiceCancel) continue;
                item.set("remainvalidnum", (Object)BigDecimal.ZERO);
            }
        }
        SaveServiceHelper.update((DynamicObject[])oriBills);
    }

    public static boolean isBillTotalAmountSame(DynamicObject invoice) {
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "=", invoice.getPkValue()).toArray());
        HashSet<Object> originalBillPks = new HashSet<Object>();
        for (DynamicObject relation : relations) {
            originalBillPks.add(relation.get("sbillid"));
        }
        DynamicObject[] oriBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"totalamount", (QFilter[])new QFilter("id", "in", (Object)originalBillPks.toArray()).toArray());
        BigDecimal billTotalAmount = BigDecimal.ZERO;
        for (DynamicObject oriBill : oriBills) {
            billTotalAmount = billTotalAmount.add(oriBill.getBigDecimal("totalamount"));
        }
        return billTotalAmount.compareTo(invoice.getBigDecimal("totalamount")) == 0;
    }

    public static boolean isUseNormalWriteBack(DynamicObject invoice) {
        String issueType = invoice.getString("issuetype");
        if (ItemMerge2OneHelper.isNeedNumExtraDeal(invoice.get("mergelable")) && ItemMerge2OneHelper.isBillTotalAmountSame(invoice)) {
            return false;
        }
        if (ItemMerge2OneHelper.isNeedNumExtraDeal(invoice.get("mergelable")) && !ItemMerge2OneHelper.isBillTotalAmountSame(invoice)) {
            return true;
        }
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "mergelable", "totalamount"), (QFilter[])new QFilter("invoicecode", "=", (Object)invoice.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invoice.getString("originalinvoiceno")).toArray());
            return array.length <= 0 || !ItemMerge2OneHelper.isNeedNumExtraDeal(array[0].get("mergelable")) || !ItemMerge2OneHelper.isBillTotalAmountSame(array[0]);
        }
        return true;
    }

    public static boolean isNeedNumExtraDeal(Object mergeLable) {
        return ISSUING.equals(mergeLable) || "2".equals(mergeLable);
    }

    private static DynamicObject[] getOriginalBills(DynamicObject[] relations) {
        HashSet<Object> originalBillPks = new HashSet<Object>();
        for (DynamicObject relation : relations) {
            originalBillPks.add(relation.get("sbillid"));
        }
        return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)originalBillPks.toArray()).toArray());
    }

    public static void dealOriginalBillNumDifference(DynamicObject[] invoices) {
        DynamicObject[] originalBills;
        if (null == invoices) {
            return;
        }
        ArrayList<Object> mergePks = new ArrayList<Object>();
        for (DynamicObject invoice : invoices) {
            String mergeLable = invoice.getString("mergelable");
            if (!ISSUING.equals(mergeLable) && !"2".equals(mergeLable)) continue;
            mergePks.add(invoice.getPkValue());
        }
        if (mergePks.size() == 0) {
            return;
        }
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "in", (Object)mergePks.toArray()).toArray());
        for (DynamicObject originalBill : originalBills = ItemMerge2OneHelper.getOriginalBills(relations)) {
            DynamicObjectCollection collection = originalBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : collection) {
                item.set("numdeviation", (Object)BigDecimal.ZERO);
            }
        }
        if (originalBills.length > 0) {
            SaveServiceHelper.update((DynamicObject[])originalBills);
        }
    }

    public static void manualOffsetMerge(JSONObject invoice, JSONArray newInvoiceItems, boolean isNumOne, boolean isPartApply) {
        BigDecimal totalAmount = invoice.getBigDecimal("totalamount");
        boolean isBiggerThanZero = BigDecimal.ZERO.compareTo(totalAmount) < 0;
        CheckJsonItemMergeVo checkVo = ItemMerge2OneHelper.checkItemCanOffsetMerge(newInvoiceItems, isBiggerThanZero);
        if (checkVo.isUseOffSet()) {
            if (isPartApply) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u89c4\u5219\u201c\u660e\u7ec6\u5269\u4f59\u91d1\u989d\u4e0e\u540c\u7a0e\u7387\u7684\u884c\u5408\u5e76\u201d\u4f7f\u7528\u65f6\uff0c\u5355\u636e\u4e0d\u80fd\u90e8\u5206\u7533\u8bf7", (String)"ItemMerge2OneHelper_3", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            ItemMerge2OneHelper.reMergeJsonItem(checkVo, isBiggerThanZero, newInvoiceItems, isNumOne);
            invoice.put("mergelable", (Object)"2");
        }
    }

    private static void reMergeJsonItem(CheckJsonItemMergeVo checkVo, boolean isBiggerThanZero, JSONArray newInvoiceItems, boolean isNumOne) {
        HashSet needDealTaxRate = checkVo.getNeedDealTaxRate();
        HashMap itemTaxRateMap = checkVo.getItemMap();
        ArrayList zeroItems = new ArrayList();
        HashSet zeroItemPks = new HashSet();
        for (Object taxRate : needDealTaxRate) {
            List taxRateItemList = (List)itemTaxRateMap.get(taxRate);
            HashMap<BigDecimal, List<List<JSONObject>>> map = new HashMap<BigDecimal, List<List<JSONObject>>>();
            BigDecimal oneTaxRateTaxAmount = BigDecimal.ZERO;
            ArrayList<JSONObject> tempZeroItems = new ArrayList<JSONObject>();
            HashSet<String> tempZeroItemPks = new HashSet<String>();
            for (List listItem : taxRateItemList) {
                BigDecimal itemRemainAmount = BigDecimal.ZERO;
                for (JSONObject item : listItem) {
                    itemRemainAmount = itemRemainAmount.add(item.getBigDecimal("taxamount"));
                    oneTaxRateTaxAmount = oneTaxRateTaxAmount.add(item.getBigDecimal("taxamount"));
                    tempZeroItems.add(item);
                    tempZeroItemPks.add(item.getString("id"));
                }
                ArrayList taxRateItems = map.get(itemRemainAmount) == null ? Lists.newArrayList() : map.get(itemRemainAmount);
                taxRateItems.add(listItem);
                map.put(itemRemainAmount, taxRateItems);
            }
            if (map.size() == 1 && BigDecimal.ZERO.compareTo(oneTaxRateTaxAmount) == 0) {
                zeroItems.addAll(tempZeroItems);
                zeroItemPks.addAll(tempZeroItemPks);
                continue;
            }
            Set keySet = map.keySet();
            Object[] sortedArray = keySet.stream().sorted().toArray();
            if (!isBiggerThanZero) continue;
            NeedMergeItemJsonVo countVo = ItemMerge2OneHelper.negativeJsonCountAmount(map, sortedArray);
            NeedMergeItemJsonVo mergeVo = ItemMerge2OneHelper.negativeJsonMergeCount(countVo, sortedArray, map, isNumOne);
            ItemMerge2OneHelper.dealBillItem(newInvoiceItems, mergeVo);
        }
        if (zeroItems.size() > 0) {
            Iterator it = newInvoiceItems.iterator();
            while (it.hasNext()) {
                JSONObject item = (JSONObject)it.next();
                if (!zeroItems.contains(item)) continue;
                it.remove();
            }
            JSONObject targetRow = (JSONObject)newInvoiceItems.get(0);
            targetRow.put("id", (Object)ItemMerge2OneHelper.concatMergedIds(zeroItemPks, targetRow.getString("id")));
        }
    }

    private static void dealBillItem(JSONArray newInvoiceItems, NeedMergeItemJsonVo mergeVo) {
        Iterator iterator = newInvoiceItems.iterator();
        HashSet mergedPks = mergeVo.getNeedMergeItemPks();
        JSONObject targetItem = mergeVo.getMergeResultTarget();
        while (iterator.hasNext()) {
            JSONObject item = (JSONObject)iterator.next();
            if (!mergedPks.contains(item.get((Object)"id"))) continue;
            iterator.remove();
        }
        targetItem.put("id", (Object)ItemMerge2OneHelper.concatMergedIds(mergedPks, targetItem.getString("id")));
    }

    private static String concatMergedIds(HashSet mergedPks, String oriPk) {
        if (mergedPks.size() > 0) {
            StringBuilder oriPkBuilder = new StringBuilder(oriPk);
            for (Object mergedPk : mergedPks) {
                oriPkBuilder.insert(0, mergedPk + ",");
            }
            oriPk = oriPkBuilder.toString();
        }
        return oriPk;
    }

    private static NeedMergeItemJsonVo negativeJsonMergeCount(NeedMergeItemJsonVo countVo, Object[] sortedArray, HashMap<BigDecimal, List<List<JSONObject>>> amountKeyMap, boolean isNumOne) {
        BigDecimal needMergeTaxAmount = countVo.getNeedMergeTaxAmount();
        BigDecimal needMergeTax = countVo.getNeedMergeTax();
        for (int i = sortedArray.length - 1; i >= 0; --i) {
            BigDecimal taxAmount = (BigDecimal)sortedArray[i];
            List<List<JSONObject>> listItems = amountKeyMap.get(taxAmount);
            for (List<JSONObject> items2 : listItems) {
                BigDecimal itemsRemainAmount = BigDecimal.ZERO;
                BigDecimal itemsRemainTax = BigDecimal.ZERO;
                for (JSONObject item : items2) {
                    itemsRemainAmount = itemsRemainAmount.add(item.getBigDecimal("taxamount"));
                    itemsRemainTax = itemsRemainTax.add(item.getBigDecimal("tax"));
                }
                if (itemsRemainAmount.compareTo(needMergeTaxAmount.negate()) > 0) {
                    JSONObject firstItem = items2.get(0);
                    BigDecimal remainValidAmount = firstItem.getBigDecimal("taxamount");
                    BigDecimal remainTaxAmount = remainValidAmount.add(needMergeTaxAmount);
                    firstItem.put("taxamount", (Object)remainTaxAmount);
                    BigDecimal mergedTax = firstItem.getBigDecimal("tax").add(needMergeTax);
                    firstItem.put("tax", (Object)mergedTax);
                    BigDecimal itemAmount = remainTaxAmount.subtract(mergedTax);
                    firstItem.put("amount", (Object)itemAmount);
                    if (BigDecimal.ZERO.compareTo(firstItem.getBigDecimal("unitprice")) != 0) {
                        BigDecimal remainNum = UnitPriceHelper.calcNum(itemAmount, firstItem.getBigDecimal("unitprice"));
                        firstItem.put("num", (Object)remainNum);
                    }
                    if (isNumOne) {
                        firstItem.put("num", (Object)BigDecimal.ONE);
                        firstItem.put("unitprice", (Object)itemAmount);
                        firstItem.put("taxunitprice", (Object)remainTaxAmount);
                    }
                    countVo.setMergeResultTarget(firstItem);
                    return countVo;
                }
                needMergeTaxAmount = needMergeTaxAmount.add(taxAmount);
                needMergeTax = needMergeTax.add(itemsRemainTax);
                countVo.getNeedMergeItemPks().add(items2.get(0).get((Object)"id"));
                if (items2.size() <= 1) continue;
                countVo.getNeedMergeItemPks().add(items2.get(1).get((Object)"id"));
            }
        }
        return countVo;
    }

    private static NeedMergeItemJsonVo negativeJsonCountAmount(HashMap<BigDecimal, List<List<JSONObject>>> map, Object[] sortedArray) {
        NeedMergeItemJsonVo result = new NeedMergeItemJsonVo();
        BigDecimal totalMergeAmount = BigDecimal.ZERO;
        BigDecimal totalMergeTax = BigDecimal.ZERO;
        for (Object o : sortedArray) {
            BigDecimal taxAmount = (BigDecimal)o;
            List<List<JSONObject>> listItem = map.get(taxAmount);
            if (taxAmount.compareTo(BigDecimal.ZERO) > 0) {
                return result;
            }
            for (List<JSONObject> items2 : listItem) {
                for (JSONObject item : items2) {
                    totalMergeAmount = totalMergeAmount.add(taxAmount);
                    result.setNeedMergeTaxAmount(totalMergeAmount);
                    totalMergeTax = totalMergeTax.add(item.getBigDecimal("tax"));
                    result.setNeedMergeTax(totalMergeTax);
                    result.getNeedMergeItemPks().add(item.get((Object)"id"));
                }
            }
        }
        return result;
    }

    public static CheckJsonItemMergeVo checkItemCanOffsetMerge(JSONArray newInvoiceItems, boolean isBiggerThanZero) {
        HashMap<Object, List<List<JSONObject>>> map = new HashMap<Object, List<List<JSONObject>>>();
        HashSet<Object> needDealTaxRate = new HashSet<Object>();
        ItemMerge2OneHelper.createTaxRateDivideJsonMap(newInvoiceItems, map, needDealTaxRate);
        boolean isUseOffSet = ItemMerge2OneHelper.jsonItemMergeCheck(isBiggerThanZero, map);
        CheckJsonItemMergeVo vo = new CheckJsonItemMergeVo();
        vo.setItemMap(map);
        vo.setNeedDealTaxRate(needDealTaxRate);
        vo.setUseOffSet(isUseOffSet);
        return vo;
    }

    private static boolean jsonItemMergeCheck(boolean isBiggerThanZero, HashMap<Object, List<List<JSONObject>>> map) {
        boolean isUseOffSet = false;
        for (Map.Entry<Object, List<List<JSONObject>>> entry : map.entrySet()) {
            List<List<JSONObject>> list = entry.getValue();
            BigDecimal taxRateTotalTaxAmount = BigDecimal.ZERO;
            for (List<JSONObject> jsonList : list) {
                for (JSONObject item : jsonList) {
                    BigDecimal itemTaxAmount = item.getBigDecimal("taxamount");
                    if (!ISSUING.equals(item.getString("rowtype")) && BigDecimal.ZERO.compareTo(itemTaxAmount) >= 0) {
                        isUseOffSet = true;
                    }
                    taxRateTotalTaxAmount = taxRateTotalTaxAmount.add(itemTaxAmount);
                }
            }
            if (isBiggerThanZero && taxRateTotalTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25\uff0c\u8d1f\u6570\u5546\u54c1\u51b2\u62b5\u4e0d\u4e86,\u8bf7\u91cd\u65b0\u8c03\u6574\u9700\u8981\u5408\u5e76\u7684\u5355\u636e\uff01", (String)"ItemMerge2OneHelper_4", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (isBiggerThanZero || taxRateTotalTaxAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25\uff0c\u6b63\u6570\u5546\u54c1\u51b2\u62b5\u4e0d\u4e86,\u8bf7\u91cd\u65b0\u8c03\u6574\u9700\u8981\u5408\u5e76\u7684\u5355\u636e\uff01", (String)"ItemMerge2OneHelper_5", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return isUseOffSet;
    }

    private static void createTaxRateDivideJsonMap(JSONArray newInvoiceItems, HashMap<Object, List<List<JSONObject>>> map, HashSet<Object> needDealTaxRate) {
        int size = newInvoiceItems.size();
        for (int i = 0; i < size; ++i) {
            JSONObject nextItem;
            JSONObject itemJson = (JSONObject)newInvoiceItems.get(i);
            Object taxRate = itemJson.get((Object)"taxrate");
            if (itemJson.getBigDecimal("amount").compareTo(BigDecimal.ZERO) <= 0 && !ISSUING.equals(itemJson.getString("rowtype"))) {
                needDealTaxRate.add(taxRate);
            }
            if (map.containsKey(taxRate)) {
                List<List<JSONObject>> list = map.get(taxRate);
                ArrayList<JSONObject> itemList = new ArrayList<JSONObject>();
                itemList.add(itemJson);
                if (i + 1 < size && ISSUING.equals((nextItem = (JSONObject)newInvoiceItems.get(i + 1)).get((Object)"rowtype"))) {
                    itemList.add(nextItem);
                    ++i;
                }
                list.add(itemList);
                continue;
            }
            ArrayList<JSONObject> divideItems = new ArrayList<JSONObject>();
            ArrayList<ArrayList<JSONObject>> itemListContainer = new ArrayList<ArrayList<JSONObject>>();
            divideItems.add(itemJson);
            itemListContainer.add(divideItems);
            if (i + 1 < size && ISSUING.equals((nextItem = (JSONObject)newInvoiceItems.get(i + 1)).get((Object)"rowtype"))) {
                divideItems.add(nextItem);
                ++i;
            }
            map.put(taxRate, itemListContainer);
        }
    }

    public static boolean isNegativeRowMerge(DynamicObject mergeRule) {
        return "2".equals(mergeRule.getString("negativeoffset"));
    }
}

