/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.sim.common.constant.table.MatchBillConstant;

public class NegativeBillMatchHelper {
    public DynamicObject[] getMatchBillByTBillId(List<Object> pks) {
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter(pks, (String)"tbillid").toArray());
        return BusinessDataServiceHelper.load((Object[])Arrays.stream(relations).map(relation -> relation.get("sbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
    }

    public DynamicObject[] writeInfoCode2MatchBill(List<DynamicObject> redInfoOrRedConfirms) {
        if (null == redInfoOrRedConfirms || redInfoOrRedConfirms.size() == 0) {
            return new DynamicObject[0];
        }
        boolean isRedconfirm = "sim_red_confirm_bill".equals(redInfoOrRedConfirms.get(0).getDataEntityType().getName());
        List redInfoOrRedConfirmList = redInfoOrRedConfirms.stream().filter(redInfoOrRedConfirm -> "10".equals(redInfoOrRedConfirm.getString(isRedconfirm ? "source" : "infosource"))).collect(Collectors.toList());
        if (redInfoOrRedConfirms.size() == 0) {
            return new DynamicObject[0];
        }
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])OrgHelper.getIdFilter((Collection)redInfoOrRedConfirmList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()), (String)"tbillid").toArray());
        HashMap<Object, Set> tBillId2SBillIdMap = new HashMap<Object, Set>(relations.length);
        for (DynamicObject relation2 : relations) {
            Set sBillIdSet = tBillId2SBillIdMap.computeIfAbsent(relation2.get("tbillid"), k -> new HashSet());
            sBillIdSet.add(relation2.get("sbillid"));
        }
        Map matchBillMap = BusinessDataServiceHelper.loadFromCache((Object[])Arrays.stream(relations).map(relation -> relation.get("sbillid")).toArray(), (String)"sim_match_bill");
        for (DynamicObject redInfoOrRedConfirm2 : redInfoOrRedConfirmList) {
            String originalInvoiceCode = redInfoOrRedConfirm2.getString("originalinvoicecode");
            String originalInvoiceNo = redInfoOrRedConfirm2.getString("originalinvoiceno");
            Set sBillIds = (Set)tBillId2SBillIdMap.get(redInfoOrRedConfirm2.getPkValue());
            for (Object sBillId : sBillIds) {
                DynamicObject matchBill = (DynamicObject)matchBillMap.get(sBillId);
                DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items2) {
                    DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject oriItem : oriItems) {
                        if (!oriItem.getString("oriinvoicecode").equals(originalInvoiceCode) || !oriItem.getString("oriinvoiceno").equals(originalInvoiceNo)) continue;
                        oriItem.set("infocode", redInfoOrRedConfirm2.get(isRedconfirm ? "number" : "infocode"));
                    }
                }
            }
        }
        ImcSaveServiceHelper.save((DynamicObject[])matchBillMap.values().toArray(new DynamicObject[0]));
        return matchBillMap.values().toArray(new DynamicObject[0]);
    }

    public static void changePushStatus(DynamicObject matchBill) {
        DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashSet<String> statusSet = new HashSet<String>(2);
        BigDecimal pushdownamount = BigDecimal.ZERO;
        BigDecimal pushdowntax = BigDecimal.ZERO;
        HashSet<String> pushdowninvoiceSet = new HashSet<String>();
        String matchTarget = matchBill.getString("matchtarget");
        boolean isConfirm = "1".equalsIgnoreCase(matchTarget) || "2".equals(matchTarget);
        for (int i = 0; i < items2.size(); ++i) {
            DynamicObjectCollection subentryentitys = ((DynamicObject)items2.get(i)).getDynamicObjectCollection("subentryentity");
            DynamicObjectCollection confirmEntities = ((DynamicObject)items2.get(i)).getDynamicObjectCollection("confirmsubentryentity");
            if (!MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(((DynamicObject)items2.get(i)).getString("itemmatchstatus")) && !MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(((DynamicObject)items2.get(i)).getString("itemmatchstatus"))) continue;
            if (isConfirm) {
                for (DynamicObject confirmEntity : confirmEntities) {
                    pushdowntax = pushdowntax.add(confirmEntity.getBigDecimal("confirmoriitemtax").abs());
                    pushdownamount = pushdownamount.add(confirmEntity.getBigDecimal("confirmoriitemamount").abs());
                    pushdowninvoiceSet.add(confirmEntity.getString("confirminfocode"));
                }
                continue;
            }
            for (int j = 0; j < subentryentitys.size(); ++j) {
                statusSet.add(((DynamicObject)subentryentitys.get(j)).getString("pushstatus"));
                if (!"1".equals(((DynamicObject)subentryentitys.get(j)).getString("pushstatus"))) continue;
                pushdowntax = pushdowntax.add(((DynamicObject)subentryentitys.get(j)).getBigDecimal("oriitemtax"));
                pushdownamount = pushdownamount.add(((DynamicObject)subentryentitys.get(j)).getBigDecimal("oriitemamount"));
                pushdowninvoiceSet.add(((DynamicObject)subentryentitys.get(j)).getString("oriinvoicecode") + ((DynamicObject)subentryentitys.get(j)).getString("oriinvoiceno"));
            }
        }
        if (isConfirm) {
            matchBill.set("pushdownstatus", null);
            matchBill.set("pushdowninvoicenum", (Object)BigDecimal.ZERO);
            matchBill.set("pushdownamount", (Object)BigDecimal.ZERO);
            matchBill.set("pushdowntax", (Object)BigDecimal.ZERO);
            matchBill.set("pushdownstatus", null);
        } else {
            matchBill.set("pushdowninvoicenum", (Object)pushdowninvoiceSet.size());
            matchBill.set("pushdownamount", (Object)pushdownamount.negate());
            matchBill.set("pushdowntax", (Object)pushdowntax.negate());
            if (statusSet.isEmpty()) {
                matchBill.set("pushdownstatus", (Object)"0");
            } else if (statusSet.size() != 1) {
                matchBill.set("pushdownstatus", (Object)"1");
            } else {
                String status = (String)statusSet.toArray()[0];
                status = "1".equals(status) ? "2" : "0";
                matchBill.set("pushdownstatus", (Object)status);
            }
        }
    }
}

