/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.SaleAddrAndPayeeDTO;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.dto.ComponentTaxCodeDTO;
import kd.imc.sim.common.dto.redinfo.ComponentRedInfoDTO;
import kd.imc.sim.common.dto.redinfo.ComponentRedInfoItemDTO;
import kd.imc.sim.common.dto.redinfo.RedInfoApplyRequestDTO;
import kd.imc.sim.common.dto.redinfo.RedInfoApplyResponseDTO;
import kd.imc.sim.common.dto.redinfo.RedInfoDownloadRequestDTO;
import kd.imc.sim.common.dto.redinfo.RedInfoDownloadResponseDTO;
import kd.imc.sim.common.dto.redinfo.RedInfoRevokeRequestDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.cache.InvoiceTitleCacheHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.model.redinfo.Resp93007;
import kd.imc.sim.common.model.redinfo.Resp93007Fyxm;
import kd.imc.sim.common.model.redinfo.Resp93007Hzxxb;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RedInfoHelper {
    private static final Log log = LogFactory.getLog(RedInfoHelper.class);
    public static final String INVOICETYPE = "invoicetype";
    private static final DateTimeFormatter yyMMddHHmmss_EN = DateTimeFormatter.ofPattern("yyMMddHHmmss");

    public static void fillInOriginalInvoice(AbstractFormPlugin formPlugin, DynamicObject vatInvoice) {
        Date issueTime = vatInvoice.getDate("issuetime");
        if (issueTime != null) {
            formPlugin.getView().getModel().setValue("originalissuetime", (Object)issueTime);
        }
        formPlugin.getView().getModel().setValue("originaldeduction", vatInvoice.get("deduction"));
        formPlugin.getView().getModel().setValue(INVOICETYPE, vatInvoice.get(INVOICETYPE));
        formPlugin.getView().getModel().setValue("buyername", vatInvoice.get("buyername"));
        formPlugin.getPageCache().put("buyername", vatInvoice.getString("buyername"));
        formPlugin.getView().getModel().setValue("buyertaxno", vatInvoice.get("buyertaxno"));
        formPlugin.getView().getModel().setValue("buyeraddr", vatInvoice.get("buyeraddr"));
        formPlugin.getView().getModel().setValue("buyeraddrtext", vatInvoice.get("buyeraddr"));
        formPlugin.getView().getModel().setValue("buyerbank", vatInvoice.get("buyerbank"));
        formPlugin.getView().getModel().setValue("salername", vatInvoice.get("salername"));
        formPlugin.getPageCache().put("salername", vatInvoice.getString("salername"));
        formPlugin.getView().getModel().setValue("salertaxno", vatInvoice.get("salertaxno"));
        formPlugin.getView().getModel().setValue("saleraddr", vatInvoice.get("saleraddr"));
        formPlugin.getView().getModel().setValue("saleraddrtext", vatInvoice.get("saleraddr"));
        formPlugin.getView().getModel().setValue("salerbank", vatInvoice.get("salerbank"));
        formPlugin.getView().getModel().setValue("inventorymark", vatInvoice.get("inventorymark"));
        String jqbh = vatInvoice.getString("jqbh");
        if (StringUtils.isNotBlank((CharSequence)jqbh)) {
            formPlugin.getView().getModel().setValue("jqbh", (Object)jqbh);
        }
    }

    public static DynamicObjectCollection convertItemsBlueToRed(DynamicObject obj) {
        DynamicObject redDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectCollection newList = redDynamicObject.getDynamicObjectCollection("items");
        RedInfoHelper.handlerItems(obj, newList);
        newList.forEach(RedInfoHelper::handleData);
        return newList;
    }

    private static void handlerItems(DynamicObject dynamicObject, DynamicObjectCollection newList) {
        DynamicObjectCollection detailList = dynamicObject.getDynamicObjectCollection("items");
        if (TaxedTypeEnum.deduction.getValue().equals(dynamicObject.getString("taxedtype"))) {
            if (detailList.size() > 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u84dd\u7968\u6570\u636e\u9519\u8bef\uff0c\u5dee\u989d\u5f81\u7a0e\u53ea\u5141\u8bb8\u4e00\u884c\u660e\u7ec6", (String)"RedInfoHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (detailList.size() == 1) {
                DynamicObject obj = newList.addNew();
                DynamicObjectUtil.copyDynamicObject((DynamicObject)((DynamicObject)detailList.get(0)), (DynamicObject)obj);
            } else {
                if (!"2".equals(((DynamicObject)detailList.get(0)).getString("rowtype")) || !"1".equals(((DynamicObject)detailList.get(1)).getString("rowtype"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u84dd\u7968\u6570\u636e\u9519\u8bef\uff0c\u5dee\u989d\u5f81\u7a0e\u53ea\u5141\u8bb8\u4e00\u884c\u660e\u7ec6", (String)"RedInfoHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
                }
                RedInfoHelper.createItem(detailList, newList);
            }
            return;
        }
        RedInfoHelper.createItem(detailList, newList);
    }

    private static void createItem(DynamicObjectCollection detailList, DynamicObjectCollection newList) {
        for (int i = 0; i < detailList.size(); ++i) {
            DynamicObject detail = (DynamicObject)detailList.get(i);
            String rowType = detail.getString("rowtype");
            if (!"0".equals(rowType) && !"2".equals(rowType)) continue;
            if ("2".equals(rowType)) {
                DynamicObject discountRow = (DynamicObject)detailList.get(i + 1);
                BigDecimal discountAmount = discountRow.getBigDecimal("amount");
                BigDecimal amount = detail.getBigDecimal("amount");
                if (discountAmount.abs().compareTo(amount.abs()) == 0) continue;
            }
            DynamicObject newObj = newList.addNew();
            DynamicObjectUtil.copyDynamicObject((DynamicObject)detail, (DynamicObject)newObj);
            if (!"2".equals(rowType)) continue;
            DynamicObject zkDetail = (DynamicObject)detailList.get(i + 1);
            newObj.set("amount", (Object)detail.getBigDecimal("amount").add(zkDetail.getBigDecimal("amount")));
            newObj.set("taxamount", (Object)detail.getBigDecimal("taxamount").add(zkDetail.getBigDecimal("taxamount")));
            newObj.set("tax", (Object)detail.getBigDecimal("tax").add(zkDetail.getBigDecimal("tax")));
            newObj.set("num", null);
            newObj.set("unitprice", null);
            newObj.set("taxunitprice", null);
            newObj.set("rowtype", (Object)"0");
        }
    }

    public static void handleData(DynamicObject obj) {
        DataEntityPropertyCollection properties = obj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if ("id".equals(property.getName()) || "unitprice".equals(property.getName()) || "taxunitprice".equals(property.getName()) || !(property instanceof DecimalProp)) continue;
            obj.set(property.getName(), (Object)obj.getBigDecimal(property.getName()).negate());
        }
    }

    public static DynamicObject buildInvoiceDynamicObject(AbstractFormPlugin formPlugin, String itemJsonArray, Object org) {
        DynamicObject dynamicObject = ModelUtil.getModelValue2DynamicObject((String)"sim_red_info", (AbstractFormPlugin)formPlugin);
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)org));
        EquipmentHelper.checkTerminalNo((String)((String)formPlugin.getView().getModel().getValue("jqbh")), (String)saleInfo.getSaleTaxNo(), (String)((String)formPlugin.getView().getModel().getValue("terminalno")));
        JSONArray json = JSONObject.parseArray((String)itemJsonArray);
        if (json.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u4e0d\u5b58\u5728", (String)"RedInfoHelper_1", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        BigDecimal totalje = BigDecimal.ZERO;
        BigDecimal totalse = BigDecimal.ZERO;
        DynamicObjectCollection items2 = dynamicObject.getDynamicObjectCollection("items");
        HashSet<String> taxRates = new HashSet<String>(json.size());
        for (int i = 0; i < json.size(); ++i) {
            DynamicObject item = items2.addNew();
            JSONObject obj = json.getJSONObject(i);
            String xmje = obj.getString("xmje");
            String se = obj.getString("se");
            if (StringUtils.isEmpty((CharSequence)xmje)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"RedInfoHelper_2", (String)"imc-sim-common", (Object[])new Object[0]), i + 1));
            }
            if (!BigDecimalUtil.isNumber((String)xmje)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u660e\u7ec6\u91d1\u989d\u586b\u5199\u9519\u8bef", (String)"RedInfoHelper_3", (String)"imc-sim-common", (Object[])new Object[0]), i + 1));
            }
            if (!BigDecimalUtil.isNumber((String)se)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u660e\u7ec6\u7a0e\u989d\u586b\u5199\u9519\u8bef", (String)"RedInfoHelper_4", (String)"imc-sim-common", (Object[])new Object[0]), i + 1));
            }
            totalje = totalje.add(new BigDecimal(xmje));
            totalse = totalse.add(new BigDecimal(se));
            RedInfoHelper.buildItemData(i, item, obj);
            String slv = obj.getString("sl");
            if (!StringUtils.isNotBlank((CharSequence)slv)) continue;
            taxRates.add(slv);
        }
        dynamicObject.set("maintaxrate", taxRates.size() == 1 ? taxRates.toArray()[0] : null);
        dynamicObject.set("invoiceamount", (Object)totalje);
        dynamicObject.set("totaltax", (Object)totalse);
        dynamicObject.set("totalamount", (Object)totalje.add(totalse));
        RedInfoHelper.buildRedInfoMainData(formPlugin, dynamicObject);
        return dynamicObject;
    }

    private static void buildItemData(int i, DynamicObject itemDynamicObject, JSONObject obj) {
        itemDynamicObject.set("seq", (Object)i);
        itemDynamicObject.set("goodsname", (Object)obj.getString("xmmc"));
        itemDynamicObject.set("goodscode", (Object)obj.getString("spbm"));
        itemDynamicObject.set("specification", (Object)obj.getString("ggxh"));
        itemDynamicObject.set("unit", (Object)obj.getString("xmdw"));
        itemDynamicObject.set("num", (Object)obj.getBigDecimal("xmsl"));
        itemDynamicObject.set("unitprice", (Object)obj.getBigDecimal("xmdj"));
        itemDynamicObject.set("taxunitprice", (Object)obj.getBigDecimal("xmdjhs"));
        itemDynamicObject.set("amount", (Object)obj.getBigDecimal("xmje"));
        itemDynamicObject.set("taxamount", (Object)obj.getBigDecimal("xmjehs"));
        itemDynamicObject.set("tax", (Object)obj.getString("se"));
        itemDynamicObject.set("taxpremark", (Object)0);
        itemDynamicObject.set("zzstsgl", (Object)"");
        if ("0.00Z1".equals(obj.getString("slText"))) {
            itemDynamicObject.set("taxpremark", (Object)1);
            itemDynamicObject.set("zerotaxmark", (Object)1);
            itemDynamicObject.set("zzstsgl", (Object)"\u514d\u7a0e");
        } else if ("0.00Z2".equals(obj.getString("slText"))) {
            itemDynamicObject.set("taxpremark", (Object)1);
            itemDynamicObject.set("zerotaxmark", (Object)2);
            itemDynamicObject.set("zzstsgl", (Object)"\u4e0d\u5f81\u7a0e");
        } else if ("0.00Z0".equals(obj.getString("slText"))) {
            itemDynamicObject.set("taxpremark", (Object)1);
            itemDynamicObject.set("zerotaxmark", (Object)1);
            itemDynamicObject.set("zzstsgl", (Object)"\u51fa\u53e3\u9000\u7a0e");
        } else if ("0.00Z3".equals(obj.getString("slText"))) {
            itemDynamicObject.set("taxpremark", (Object)0);
            itemDynamicObject.set("zerotaxmark", (Object)3);
        }
        if (!StringUtils.isEmpty((CharSequence)obj.getString("zzstsgl"))) {
            itemDynamicObject.set("taxpremark", (Object)1);
            itemDynamicObject.set("zzstsgl", (Object)obj.getString("zzstsgl"));
        }
        itemDynamicObject.set("taxflag", (Object)"0");
        itemDynamicObject.set("simplegoodsname", (Object)obj.getString("spmc"));
        itemDynamicObject.set("taxrate", obj.get((Object)"sl"));
        itemDynamicObject.set("rowtype", (Object)obj.getString("xmlx"));
        itemDynamicObject.set("billsourceid", obj.get((Object)"billsourceid"));
    }

    private static void buildRedInfoMainData(AbstractFormPlugin formPlugin, DynamicObject dynamicObject) {
        dynamicObject.set("buyername", formPlugin.getView().getModel().getValue("buyername"));
        dynamicObject.set("salername", formPlugin.getView().getModel().getValue("salername"));
        dynamicObject.set("org", formPlugin.getView().getModel().getValue("org"));
        dynamicObject.set("applicant", formPlugin.getView().getModel().getValue("applicant"));
        dynamicObject.set("originalinvoicecode", formPlugin.getView().getModel().getValue("originalinvoicecode"));
        dynamicObject.set("originalinvoiceno", formPlugin.getView().getModel().getValue("originalinvoiceno"));
        dynamicObject.set("jqbh", formPlugin.getView().getModel().getValue("jqbh"));
        dynamicObject.set("terminalno", formPlugin.getView().getModel().getValue("terminalno"));
        dynamicObject.set("originalissuetime", formPlugin.getView().getModel().getValue("originalissuetime"));
        dynamicObject.set("originaldeduction", formPlugin.getView().getModel().getValue("originaldeduction"));
        dynamicObject.set(INVOICETYPE, formPlugin.getView().getModel().getValue(INVOICETYPE));
        dynamicObject.set("status", (Object)"1");
        dynamicObject.set("saleraddr", formPlugin.getView().getModel().getValue("saleraddr"));
        dynamicObject.set("buyeraddr", formPlugin.getView().getModel().getValue("buyeraddr"));
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("inventorymark", formPlugin.getView().getModel().getValue("inventorymark"));
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(dynamicObject.getString("applicant"))) {
            dynamicObject.set("applytaxno", (Object)dynamicObject.getString("salertaxno"));
        } else {
            dynamicObject.set("applytaxno", (Object)dynamicObject.getString("buyertaxno"));
        }
    }

    public static void submitBwServerRedInfo(List<DynamicObject> successObjs, DynamicObject redInfo, OperationResult operationResult) {
        if (!RedInfoConstant.ApplicantEnum.SALER.getCode().equals(redInfo.getString("applicant"))) {
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, ResManager.loadKDString((String)"\u53ea\u652f\u6301\u9500\u65b9\u7533\u8bf7\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u64cd\u4f5c", (String)"RedInfoHelper_5", (String)"imc-sim-common", (Object[])new Object[0])));
            return;
        }
        MsgResponse msgResponse = BwServerInvoiceHelper.redInfoUpload(redInfo);
        if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            redInfo.set("taxbureauaudittime", (Object)new Date());
            redInfo.set("submitdate", (Object)new Date());
            successObjs.add(redInfo);
        } else {
            if (log.isInfoEnabled()) {
                log.info(String.format("\u4e0a\u4f20\u7ea2\u5b57\u4fe1\u606f\u8868\u8fd4\u56de,\u4fe1\u606f\u8868\u6d41\u6c34\u53f7\u662f[%s], \u8fd4\u56de\u63cf\u8ff0:[%s]", redInfo.getString("infoserialno"), msgResponse.getErrorMsg()));
            }
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedInfoHelper_6", (String)"imc-sim-common", (Object[])new Object[0]), redInfo.getString("infoserialno"), msgResponse.getErrorMsg())));
        }
    }

    public static void submitLyServerRedInfo(List<DynamicObject> successObjs, DynamicObject redInfo, OperationResult operationResult) {
        MsgResponse msgResponse = LyServerInvoiceHelper.redInfoUpload(redInfo);
        if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            JSONObject retJson = JSONObject.parseObject((String)msgResponse.getRespData());
            log.info("\u63d0\u4ea4\u8054\u4e91\u8fd4\u56de\u6570\u636e:{}", (Object)retJson.toJSONString());
            redInfo.set("taxbureauaudittime", (Object)new Date());
            redInfo.set("submitdate", (Object)new Date());
            redInfo.set("infocode", (Object)retJson.getString("infocode"));
            redInfo.set("infostatus", (Object)retJson.getString("infostatus"));
            if (RedInfoConstant.isAuditSuccess((String)retJson.getString("infostatus"))) {
                redInfo.set("status", (Object)"3");
            } else {
                redInfo.set("status", (Object)"2");
            }
            redInfo.set("statusdescribe", (Object)retJson.getString("ztms"));
            successObjs.add(redInfo);
        } else {
            if (log.isInfoEnabled()) {
                log.info(String.format("\u4e0a\u4f20\u7ea2\u5b57\u4fe1\u606f\u8868\u8fd4\u56de,\u4fe1\u606f\u8868\u6d41\u6c34\u53f7\u662f[%s], \u8fd4\u56de\u63cf\u8ff0:[%s]", redInfo.getString("infoserialno"), msgResponse.getErrorMsg()));
            }
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedInfoHelper_6", (String)"imc-sim-common", (Object[])new Object[0]), redInfo.getString("infoserialno"), msgResponse.getErrorMsg())));
        }
    }

    public static void submitHostModeRedInfo(List<DynamicObject> successObj, DynamicObject redInfo, OperationResult operationResult) {
        JSONObject invoiceJson = new JSONObject();
        invoiceJson.put("salertaxno", (Object)redInfo.getString("salertaxno"));
        invoiceJson.put("jqbh", (Object)redInfo.getString("jqbh"));
        invoiceJson.put("thirdserialno", (Object)UUID.next());
        String applicant = redInfo.getString("applicant");
        invoiceJson.put("applytaxno", (Object)redInfo.getString(RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant) ? "salertaxno" : "buyertaxno"));
        invoiceJson.put(INVOICETYPE, (Object)redInfo.getString(INVOICETYPE));
        invoiceJson.put("redInfoList", (Object)SerializationUtils.toJsonString(Collections.singletonList(redInfo)));
        MsgResponse msgResponse = HostModeInvoiceHelper.redInfoUpload(invoiceJson);
        if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            JSONArray responseJsonArray = JSON.parseArray((String)msgResponse.getRespData());
            for (int i = 0; i < responseJsonArray.size(); ++i) {
                JSONObject redInfoResponse = responseJsonArray.getJSONObject(i);
                if (!redInfo.getString("infoserialno").equals(redInfoResponse.getString("reqbillno"))) continue;
                redInfo.set("infocode", (Object)redInfoResponse.getString("resbillno"));
                redInfo.set("infostatus", (Object)redInfoResponse.getString("statusdm"));
                redInfo.set("taxbureauaudittime", (Object)new Date());
                String statusmc = (String)StringUtils.defaultIfEmpty((CharSequence)redInfoResponse.getString("statusmc"), (CharSequence)"");
                if (RedInfoConstant.isAuditSuccess((String)redInfoResponse.getString("statusdm"))) {
                    redInfo.set("status", (Object)"3");
                } else if (statusmc.contains("\u91cd\u590d\u4e0a\u4f20")) {
                    redInfo.set("status", (Object)"3");
                    redInfo.set("infostatus", (Object)"TZD0000");
                } else {
                    redInfo.set("status", (Object)"2");
                }
                redInfo.set("statusdescribe", (Object)(statusmc.length() > 50 ? statusmc.substring(0, 50) : statusmc));
                successObj.add(redInfo);
            }
        } else {
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c%s", (String)"RedInfoHelper_7", (String)"imc-sim-common", (Object[])new Object[0]), msgResponse.getErrorMsg())));
        }
    }

    public static void submitVirtualRedInfo(DynamicObject redInfo) {
        redInfo.set("infocode", (Object)RedInfoHelper.getVirtualInfoCode());
        redInfo.set("status", (Object)"3");
        redInfo.set("taxbureauaudittime", (Object)new Date());
        redInfo.set("infostatus", (Object)"TZD0000");
    }

    private static String getVirtualInfoCode() {
        String infoCode = RandomString.nextString((int)15, (boolean)true, (boolean)true);
        char[] chars = infoCode.toCharArray();
        int sum = 0;
        for (char aChar : chars) {
            sum += aChar - 48;
        }
        String sumStr = String.valueOf(sum);
        return infoCode + sumStr.substring(sumStr.length() - 1);
    }

    public static void submitRedInfoToComponent(List<DynamicObject> successObj, DynamicObject redInfo, boolean isComponentBw, OperationResult operationResult) {
        if (log.isInfoEnabled()) {
            log.info(String.format("\u5f00\u59cb\u4e0a\u4f20\u7ea2\u5b57\u4fe1\u606f\u8868,\u4fe1\u606f\u8868\u6d41\u6c34\u53f7\u662f[%s]", redInfo.getString("infoserialno")));
        }
        String errMsg = "";
        RedInfoApplyRequestDTO requestDTO = RedInfoHelper.buildRedInfoComponentRequest(redInfo);
        ComponentRequest componentRequest = new ComponentRequest(ComponentInterfaceTypeEnum.APPLY_RED_INFO.getCzlx(), (Object)requestDTO, redInfo.getString("terminalno"));
        try {
            ComponentResponse componentResponse;
            if (UnitTestHelper.isUnitTest()) {
                RedInfoApplyResponseDTO response = new RedInfoApplyResponseDTO();
                response.setHzxxbm(RedInfoHelper.getVirtualInfoCode());
                response.setZtm("TZD0000");
                componentResponse = new ComponentResponse(ErrorType.SUCCESS.getCode(), "", Integer.valueOf(0), (Object)response, null);
            } else {
                componentResponse = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)redInfo.getString("jqbh")), (String)JSON.toJSONString((Object)componentRequest), RedInfoApplyResponseDTO.class);
            }
            if (componentResponse.isSucess() || "0001".equals(componentResponse.getErrcode())) {
                redInfo.set("infocode", (Object)((RedInfoApplyResponseDTO)componentResponse.getResponse()).getHzxxbm());
                redInfo.set("taxbureauaudittime", (Object)new Date());
                if (isComponentBw) {
                    if (StringUtils.isNotBlank((CharSequence)((RedInfoApplyResponseDTO)componentResponse.getResponse()).getHzxxbm())) {
                        redInfo.set("infostatus", (Object)"TZD0000");
                        redInfo.set("statusdescribe", (Object)"\u5ba1\u6838\u901a\u8fc7");
                        redInfo.set("status", (Object)"3");
                    } else {
                        redInfo.set("status", (Object)"2");
                    }
                } else {
                    if (RedInfoConstant.isAuditSuccess((String)((RedInfoApplyResponseDTO)componentResponse.getResponse()).getZtm())) {
                        redInfo.set("status", (Object)"3");
                    } else {
                        redInfo.set("status", (Object)"2");
                    }
                    redInfo.set("infostatus", (Object)((RedInfoApplyResponseDTO)componentResponse.getResponse()).getZtm());
                    if ("0001".equals(componentResponse.getErrcode())) {
                        if (StringUtils.isNotBlank((CharSequence)((RedInfoApplyResponseDTO)componentResponse.getResponse()).getHzxxbm())) {
                            redInfo.set("status", (Object)"3");
                            redInfo.set("infostatus", (Object)"TZD0000");
                            redInfo.set("statusdescribe", (Object)"\u5ba1\u6838\u901a\u8fc7");
                        } else {
                            errMsg = ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u5df2\u4e0a\u4f20\uff0c\u8bf7\u6309\u4fe1\u606f\u8868\u7f16\u53f7\u4e0b\u8f7d\u66f4\u65b0\u6570\u636e\u3002", (String)"RedInfoHelper_8", (String)"imc-sim-common", (Object[])new Object[0]);
                        }
                    }
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info(String.format("\u4e0a\u4f20\u7ea2\u5b57\u4fe1\u606f\u8868\u8fd4\u56de,\u4fe1\u606f\u8868\u6d41\u6c34\u53f7\u662f[%s], \u8fd4\u56de\u63cf\u8ff0:[%s]", redInfo.getString("infoserialno"), componentResponse.getDescription()));
                }
                errMsg = StringUtils.isBlank((CharSequence)componentResponse.getDescription()) ? ResManager.loadKDString((String)"\u672a\u6536\u5230\u7ec4\u4ef6\u8fd4\u56de\u7ed3\u679c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"RedInfoHelper_9", (String)"imc-sim-common", (Object[])new Object[0]) : componentResponse.getDescription();
            }
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedInfoHelper_6", (String)"imc-sim-common", (Object[])new Object[0]), redInfo.getString("infoserialno"), errMsg)));
        } else {
            successObj.add(redInfo);
        }
    }

    private static RedInfoApplyRequestDTO buildRedInfoComponentRequest(DynamicObject redInfo) {
        RedInfoApplyRequestDTO requestDTO = (RedInfoApplyRequestDTO)DynamicObjectUtil.dynamicObject2Bean(RedInfoApplyRequestDTO.class, (DynamicObject)redInfo);
        requestDTO.setSzlb("1");
        if (StringUtils.isBlank((CharSequence)requestDTO.getXxblx())) {
            requestDTO.setXxblx("0");
        }
        requestDTO.setZsfs("0");
        String fpzl = InvoiceType.getTypeCodeHx((String)redInfo.getString(INVOICETYPE));
        requestDTO.setKpzl(StringUtils.isBlank((CharSequence)fpzl) ? InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCodeHx() : fpzl);
        requestDTO.setTkrq(DateUtils.format((Date)redInfo.getDate("infodate"), (String)"yyyy-MM-dd"));
        requestDTO.setKprq(DateUtils.format((Date)redInfo.getDate("originalissuetime"), (String)"yyyy-MM-dd"));
        DynamicObjectCollection items2 = redInfo.getDynamicObjectCollection("items");
        for (int i = 0; i < items2.size(); ++i) {
            BigDecimal taxUnitPrice;
            ComponentTaxCodeDTO taxCode = RedInfoHelper.buildComponentTaxCode((DynamicObject)items2.get(i));
            if (!"1".equals(((DynamicObject)items2.get(i)).getString("rowtype"))) {
                BigDecimal deduction = redInfo.getBigDecimal("deduction");
                if (MathUtils.isNullOrZero(deduction)) {
                    deduction = redInfo.getBigDecimal("originaldeduction").negate();
                }
                if (!MathUtils.isNullOrZero(deduction)) {
                    taxCode.setKce(deduction.setScale(2, 4).toString());
                    requestDTO.setZsfs("2");
                }
            }
            requestDTO.getItems().get(i).setTaxcode(taxCode);
            if (!"1".equals(requestDTO.getHsbz())) continue;
            requestDTO.getItems().get(i).setXmdj(MathUtils.isNullOrZero(taxUnitPrice = ((DynamicObject)items2.get(i)).getBigDecimal("taxunitprice")) ? "" : taxUnitPrice.setScale(8, 4).stripTrailingZeros().toPlainString());
            requestDTO.getItems().get(i).setXmje(((DynamicObject)items2.get(i)).getBigDecimal("taxamount").setScale(2, 4).toString());
        }
        for (ComponentRedInfoItemDTO item : requestDTO.getItems()) {
            if (StringUtils.isBlank((CharSequence)item.getXmdj()) || MathUtils.isZero(new BigDecimal(item.getXmdj()))) {
                item.setXmdj("");
            }
            if (!StringUtils.isBlank((CharSequence)item.getXmsl()) && !MathUtils.isZero(new BigDecimal(item.getXmsl()))) continue;
            item.setXmsl("");
        }
        return requestDTO;
    }

    public static ComponentTaxCodeDTO buildComponentTaxCode(DynamicObject dynamicObject) {
        ComponentTaxCodeDTO taxCode = new ComponentTaxCodeDTO();
        taxCode.setSsyhzc(dynamicObject.getString("taxpremark"));
        taxCode.setSsyhzcnr(dynamicObject.getString("zzstsgl"));
        taxCode.setSsflbm(dynamicObject.getString("goodscode"));
        taxCode.setQyzbm(dynamicObject.getString("goodscode"));
        if (StringUtils.isBlank((CharSequence)taxCode.getSsyhzc())) {
            taxCode.setSsyhzc("0");
        }
        if (StringUtils.isNotBlank((CharSequence)taxCode.getSsflbm())) {
            DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)taxCode.getSsflbm());
            if (taxClassCode != null) {
                taxCode.setBmbb(taxClassCode.getString("version"));
            }
        } else {
            taxCode.setBmbb("");
        }
        taxCode.setKce("");
        taxCode.setLslbs("");
        taxCode.setQyzbm("");
        return taxCode;
    }

    public static void revokeRedInfo(DynamicObject obj) {
        obj.set("infoserialno", (Object)RedInfoHelper.generateRedInfoSerialNo(obj.getString("jqbh")));
        obj.set("infocode", (Object)"");
        obj.set("status", (Object)"1");
        obj.set("infostatus", (Object)"");
        obj.set("statusdescribe", (Object)"");
    }

    public static void componentRevoke(List<DynamicObject> successObjs, DynamicObject obj, OperationResult operationResult) {
        RedInfoRevokeRequestDTO request = new RedInfoRevokeRequestDTO(obj.getString(INVOICETYPE), obj.getString("infocode"));
        ComponentRequest componentRequest = new ComponentRequest(ComponentInterfaceTypeEnum.REVOKE_RED_INFO.getCzlx(), (Object)request, "");
        if (log.isInfoEnabled()) {
            log.info("\u7ea2\u5b57\u4fe1\u606f\u8868\u8bf7\u6c42\u53c2\u6570:{" + SerializationUtils.toJsonString((Object)componentRequest) + "}");
        }
        ComponentResponse response = UnitTestHelper.isUnitTest() ? new ComponentResponse(ErrorType.SUCCESS.getCode(), "", Integer.valueOf(0), null, null) : ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)obj.getString("jqbh")), (String)JSON.toJSONString((Object)componentRequest), RedInfoDownloadResponseDTO.class);
        if (log.isInfoEnabled()) {
            log.info("\u7ea2\u5b57\u4fe1\u606f\u8868\u8fd4\u56de\u53c2\u6570:{" + SerializationUtils.toJsonString((Object)response) + "}");
        }
        if (response.isSucess()) {
            RedInfoHelper.revokeRedInfo(obj);
            successObjs.add(obj);
        } else {
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(obj, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u7a0e\u5c40\u64a4\u9500\u5931\u8d25\uff0c%2$s", (String)"RedInfoHelper_10", (String)"imc-sim-common", (Object[])new Object[0]), obj.getString("infoserialno"), response.getDescription())));
        }
    }

    public static void initDescribe(AbstractFormPlugin formPlugin, boolean isDeduction) {
        String applicant = (String)formPlugin.getView().getModel().getValue("applicant");
        String originalInvoiceCode = (String)formPlugin.getView().getModel().getValue("originalinvoicecode");
        String originalInvoiceNo = (String)formPlugin.getView().getModel().getValue("originalinvoiceno");
        ((Label)formPlugin.getControl("applicanttext")).setText(RedInfoConstant.ApplicantEnum.getDescribeByCode((String)applicant));
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode)) {
            StringBuilder invoicecodetext = new StringBuilder();
            if (isDeduction) {
                invoicecodetext.append(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u3002", (String)"RedInfoHelper_11", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            invoicecodetext.append(MessageFormat.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u84dd\u5b57\u4e13\u7528\u53d1\u7968\u4ee3\u7801:{0}\u53f7\u7801:{1}", (String)"RedInfoHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), originalInvoiceCode, originalInvoiceNo));
            ((Label)formPlugin.getControl("invoicecodetext")).setText(invoicecodetext.toString());
        } else {
            formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"invoicecodetext", "applyreason"});
        }
    }

    public static String generateRedInfoSerialNo(String jqbh) {
        return RedInfoHelper.generateRedInfoSerialNo(jqbh, 0);
    }

    private static String generateRedInfoSerialNo(String jqbh, int i) {
        if (i == 5) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4fe1\u606f\u8868\u6d41\u6c34\u53f7\u5931\u8d25", (String)"RedInfoHelper_13", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        try (DLock lock = DLock.create((String)(jqbh + "generateRedInfoSerialNo"));){
            block21: {
                lock.lock();
                jqbh = StringUtils.isNotBlank((CharSequence)jqbh) && jqbh.length() >= 12 ? jqbh.substring(jqbh.length() - 12) : RandomString.nextString((int)12, (boolean)true, (boolean)true);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    if (i >= 5) break block21;
                    String string = RedInfoHelper.generateRedInfoSerialNo(jqbh, ++i);
                    if (lock != null) {
                        if (var3_3 != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            lock.close();
                        }
                    }
                    return string;
                }
            }
            String string = jqbh + LocalDateTime.now().format(yyMMddHHmmss_EN);
            return string;
        }
    }

    private static void fillInTaxRedInfoDetail(Resp93007Fyxm xm, String hsbz) {
        if ("1".equals(hsbz)) {
            xm.setJshj(xm.getJe());
            xm.setJe(xm.getJshj().subtract(xm.getSe()));
        } else {
            xm.setJshj(xm.getJe().add(xm.getSe()));
        }
        if (MathUtils.isNullOrZero(xm.getSpdj())) {
            xm.setSphsdj(BigDecimal.ZERO);
        } else if ("1".equals(hsbz)) {
            xm.setSphsdj(xm.getSpdj());
            if (MathUtils.isNullOrZero(xm.getSpsl())) {
                xm.setSpdj(PriceHelper.calcPriceOrNum(xm.getSphsdj(), BigDecimal.ONE.add(new BigDecimal(xm.getSl())), Boolean.FALSE));
            } else {
                xm.setSpdj(PriceHelper.calcPriceOrNum(xm.getJe(), xm.getSpsl(), Boolean.FALSE));
            }
        } else if (MathUtils.isNullOrZero(xm.getSpsl())) {
            xm.setSphsdj(PriceHelper.getValue(xm.getSpdj().multiply(BigDecimal.ONE.add(new BigDecimal(xm.getSl()))), Boolean.FALSE));
        } else {
            xm.setSphsdj(PriceHelper.calcPriceOrNum(xm.getJshj(), xm.getSpsl(), Boolean.FALSE));
        }
    }

    public static List<Pair<String, List<DynamicObject>>> convertResp93007ToDynamicObject(List<Resp93007Hzxxb> hzxxbList, long orgId, String jqbh) {
        String lockKey = String.valueOf(orgId) + '_' + jqbh;
        try (DLock lock = DLock.create((String)lockKey, (String)"downloadRedConfirmLock");){
            ArrayList<Pair<String, List<DynamicObject>>> pairList = new ArrayList<Pair<String, List<DynamicObject>>>();
            if (!lock.tryLock(100L)) {
                ArrayList<Pair<String, List<DynamicObject>>> arrayList = pairList;
                return arrayList;
            }
            if (CollectionUtils.isEmpty(hzxxbList)) {
                ArrayList<Pair<String, List<DynamicObject>>> arrayList = pairList;
                return arrayList;
            }
            Map<String, DynamicObject> buyerAddrMap = InvoiceTitleCacheHelper.getInvoiceTitle(orgId);
            SaleInfo saleInfo = new SaleInfo();
            saleInfo.setSaleTaxNo(hzxxbList.get(0).getXfsh());
            SaleAddrAndPayeeDTO addrAndPayee = TaxUtils.getDefaultAddrAndPayee((SaleInfo)saleInfo);
            Long taxOrgId = RedInfoHelper.getTaxOrgId(saleInfo.getSaleTaxNo());
            List existDynamicObjectList = Collections.synchronizedList(new ArrayList(hzxxbList.size()));
            List dynamicObjectList = Collections.synchronizedList(new ArrayList(hzxxbList.size()));
            HashMap orgSaleTaxNoMap = new HashMap(hzxxbList.size() >> 2);
            ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService();
            CountDownLatch countdownlatch = new CountDownLatch(hzxxbList.size());
            RequestContext requestContext = RequestContext.get();
            String selectFields = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)true);
            for (Resp93007Hzxxb xxb : hzxxbList) {
                Runnable runnable = () -> {
                    try {
                        DynamicObject[] redInfos;
                        RequestContext.copyAndSet((RequestContext)requestContext);
                        QFilter qFilter = new QFilter("infocode", "=", (Object)xxb.getXxbbh()).and("org", "=", (Object)orgId);
                        DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)selectFields, (QFilter[])qFilter.toArray());
                        if (redInfo == null && StringUtils.isNotBlank((CharSequence)xxb.getSqdh()) && !xxb.getSqdh().startsWith("000000000000")) {
                            qFilter = new QFilter("infoserialno", "=", (Object)xxb.getSqdh());
                            redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)selectFields, (QFilter[])qFilter.toArray());
                            redInfo = RedInfoHelper.getRedInfo(orgSaleTaxNoMap, redInfos);
                        }
                        if (redInfo == null) {
                            qFilter = new QFilter("infocode", "=", (Object)xxb.getXxbbh());
                            redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)selectFields, (QFilter[])qFilter.toArray());
                            redInfo = RedInfoHelper.getRedInfo(orgSaleTaxNoMap, redInfos);
                        }
                        if (redInfo == null) {
                            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_info");
                            DynamicObjectUtil.bean2DynamicObject((Object)xxb, (DynamicObject)dynamicObject);
                            RedInfoHelper.buildRedInfoDownloadMainData(dynamicObject, addrAndPayee, buyerAddrMap, xxb.getGfmc());
                            DynamicObject invoice = RedInfoHelper.loadInvoiceByCodeAndNo(dynamicObject.getString("originalinvoicecode"), dynamicObject.getString("originalinvoiceno"));
                            String buyerName = xxb.getGfmc();
                            dynamicObject.set("org", (Object)orgId);
                            dynamicObject.set("jqbh", (Object)jqbh);
                            RedInfoHelper.setOrgInfoAndBuyerAddr(orgId, dynamicObject, invoice, buyerName);
                            if (RedInfoConstant.isAuditSuccess((String)xxb.getXxbzt())) {
                                dynamicObject.set("status", (Object)"3");
                            } else {
                                dynamicObject.set("status", (Object)"2");
                            }
                            dynamicObject.set("taxorg", (Object)taxOrgId);
                            dynamicObjectList.add(dynamicObject);
                            DrawerStrategyHelper.setOtherObjDrawers((DynamicObject)dynamicObject);
                        } else {
                            if ("6".equals(redInfo.getString("infosource"))) {
                                RedInfoHelper.setBillAddInfo2Bill(redInfo, xxb);
                            }
                            if (!"4".equals(redInfo.getString("status"))) {
                                redInfo.set("infostatus", (Object)xxb.getXxbzt());
                                redInfo.set("statusdescribe", (Object)xxb.getZtms());
                                redInfo.set("infocode", (Object)xxb.getXxbbh());
                                if (RedInfoConstant.isAuditSuccess((String)xxb.getXxbzt())) {
                                    redInfo.set("status", (Object)"3");
                                } else {
                                    redInfo.set("status", (Object)"2");
                                }
                            }
                            existDynamicObjectList.add(redInfo);
                        }
                    }
                    catch (Exception e) {
                        log.error(String.format("\u4fe1\u606f\u8868\u7f16\u53f7%s\u4e0b\u8f7d\u5931\u8d25", xxb.getXxbbh()), (Throwable)e);
                    }
                    finally {
                        countdownlatch.countDown();
                    }
                };
                executorService.execute(runnable);
            }
            try {
                countdownlatch.await();
                executorService.shutdown();
            }
            catch (Exception e) {
                throw new KDBizException(e.toString());
            }
            if (!CollectionUtils.isEmpty(dynamicObjectList)) {
                pairList.add((Pair<String, List<DynamicObject>>)Pair.of((Object)"save", dynamicObjectList));
            }
            if (!CollectionUtils.isEmpty(existDynamicObjectList)) {
                pairList.add((Pair<String, List<DynamicObject>>)Pair.of((Object)"update", existDynamicObjectList));
            }
            ArrayList<Pair<String, List<DynamicObject>>> arrayList = pairList;
            return arrayList;
        }
    }

    private static void setBillAddInfo2Bill(DynamicObject redInfo, Resp93007Hzxxb xxb) {
        DynamicObjectCollection collection = redInfo.getDynamicObjectCollection("items");
        DeleteServiceHelper.delete((IDataEntityType)collection.getDynamicObjectType(), (Object[])collection.stream().map(DataEntityBase::getPkValue).toArray());
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_info");
        DynamicObjectUtil.bean2DynamicObject((Object)xxb, (DynamicObject)dynamicObject);
        redInfo.set("items", dynamicObject.get("items"));
        redInfo.set("invoiceamount", (Object)xxb.getHjje());
        redInfo.set("totaltax", (Object)xxb.getHjse());
        redInfo.set("totalamount", (Object)redInfo.getBigDecimal("invoiceamount").add(redInfo.getBigDecimal("totaltax")));
        redInfo.set("infosource", (Object)"5");
        redInfo.set("infoserialno", (Object)xxb.getSqdh());
        QFilter relationFilter = new QFilter("tbillid", "=", redInfo.getPkValue()).and("ttable", "=", (Object)"sim_red_info");
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"pushtype", (QFilter[])relationFilter.toArray());
        if (relations.length != 0) {
            for (DynamicObject relation : relations) {
                relation.set("pushtype", (Object)"-1");
            }
            ImcSaveServiceHelper.save((DynamicObject[])relations);
        }
    }

    private static void setOrgInfoAndBuyerAddr(long orgId, DynamicObject redInfo, DynamicObject invoice, String buyerName) {
        if (invoice == null) {
            return;
        }
        long invoiceOrgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
        if (invoiceOrgId == 0L) {
            return;
        }
        redInfo.set("org", (Object)invoiceOrgId);
        if (orgId != invoiceOrgId) {
            RedInfoHelper.setBuyerAddrAndBank(redInfo, invoiceOrgId, buyerName);
        }
    }

    private static DynamicObject getRedInfo(Map<Long, String> orgSaleTaxNoMap, DynamicObject[] redInfos) {
        if (redInfos.length == 0) {
            return null;
        }
        for (DynamicObject info : redInfos) {
            try {
                long infoOrgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)info.get("org"));
                String infoSaleTaxNo = orgSaleTaxNoMap.get(infoOrgId);
                if (StringUtils.isBlank((CharSequence)infoSaleTaxNo)) {
                    infoSaleTaxNo = TaxUtils.getSaleInfoByOrg((Long)infoOrgId).getSaleTaxNo();
                    orgSaleTaxNoMap.put(infoOrgId, infoSaleTaxNo);
                }
                if (!info.getString("salertaxno").equals(infoSaleTaxNo)) continue;
                return info;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void setBuyerAddrAndBank(DynamicObject dynamicObject, long invoiceOrgId, String buyerName) {
        QFilter titleFilter = new QFilter("name", "=", (Object)buyerName);
        QFilter baseDataFilter = ImcBaseDataHelper.getInvTitleFilter((Object)invoiceOrgId);
        baseDataFilter.and(titleFilter);
        DynamicObject invTitle = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)String.join((CharSequence)",", "addr", "openingbank"), (QFilter[])baseDataFilter.toArray());
        if (invTitle != null) {
            dynamicObject.set("buyeraddr", invTitle.get("addr"));
            dynamicObject.set("buyerbank", invTitle.get("openingbank"));
        }
    }

    private static DynamicObject loadInvoiceByCodeAndNo(String code, String no) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)no)) {
            log.info("RedInfoHelp loadInvoiceByCodeAndNo code or no is blank");
            return null;
        }
        QFilter qFilter = new QFilter("invoiceno", "=", (Object)no);
        qFilter.and("invoicecode", "=", (Object)code);
        return BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"orgid", (QFilter[])qFilter.toArray());
    }

    private static void buildRedInfoDownloadMainData(DynamicObject dynamicObject, SaleAddrAndPayeeDTO info, Map<String, DynamicObject> buyerAddrMap, String gfmc) {
        dynamicObject.set("creater", (Object)RequestContext.get().getUserId());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("originaldeduction", (Object)BigDecimal.ZERO);
        dynamicObject.set("saleraddr", (Object)info.getInvoiceAddr());
        dynamicObject.set("salerbank", (Object)info.getOpenUserBank());
        DynamicObject invTitle = buyerAddrMap.get(gfmc);
        if (invTitle != null) {
            dynamicObject.set("buyeraddr", invTitle.get("addr"));
            dynamicObject.set("buyerbank", invTitle.get("openingbank"));
        }
        dynamicObject.set("infosource", (Object)"2");
        dynamicObject.set("billstatus", (Object)BillHelper.getBillStatusByTableName("sim_red_info", "2"));
        dynamicObject.set("totalamount", (Object)dynamicObject.getBigDecimal("invoiceamount").add(dynamicObject.getBigDecimal("totaltax")));
        dynamicObject.set("orderno", (Object)UUID.next());
        DynamicObjectCollection items2 = dynamicObject.getDynamicObjectCollection("items");
        boolean isTobacco = true;
        for (DynamicObject item : items2) {
            String goodsCode = item.getString("goodscode");
            if (goodsCode.startsWith("1030402")) continue;
            isTobacco = false;
            break;
        }
        dynamicObject.set("specialtype", (Object)(isTobacco ? "11" : "00"));
    }

    public static Resp93007 downloadRedInfo(RedInfoDownloadRequestDTO request, long orgId) {
        DynamicObject equipmentDynamicObject;
        if (log.isInfoEnabled()) {
            log.info("\u7ea2\u5b57\u4fe1\u606f\u8868\u8bf7\u6c42\u53c2\u6570:" + SerializationUtils.toJsonString((Object)request));
        }
        if ((equipmentDynamicObject = EquipmentUtil.getCommonEquipment((String)request.getKjf_sbbh(), (String)request.getKjf_nsrsbh(), (String)request.getHxbzdh())) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u5b58\u5728\u8bbe\u5907\u7f16\u53f7%s", (String)"RedInfoHelper_14", (String)"imc-sim-common", (Object[])new Object[0]), request.getKjf_sbbh()));
        }
        String equipmentType = equipmentDynamicObject.getString("equipmenttype");
        if ("3".equals(equipmentType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u865a\u62dfUKEY\u4e0b\u8f7d\u529f\u80fd", (String)"RedInfoHelper_15", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return RedInfoHelper.downloadRedInfoFromComponent(request, orgId);
    }

    private static Resp93007 downloadRedInfoFromComponent(RedInfoDownloadRequestDTO request, long orgId) {
        int pageSize;
        int pageno = 1;
        try {
            pageSize = Integer.parseInt(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_RED_INFO_DOWNLOAD_PAGESIZE));
        }
        catch (Exception e) {
            pageSize = 100;
        }
        request.setPageno(String.valueOf(pageno));
        request.setPagesize(String.valueOf(pageSize));
        ComponentRequest componentRequest = new ComponentRequest(ComponentInterfaceTypeEnum.DOWNLOAD_RED_INFO.getCzlx(), (Object)request, request.getHxbzdh());
        ComponentResponse response = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)request.getKjf_sbbh()), (String)JSON.toJSONString((Object)componentRequest), RedInfoDownloadResponseDTO.class);
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("\u7ea2\u5b57\u4fe1\u606f\u8868\u7ec4\u4ef6\u4e0b\u8f7d\u8fd4\u56de,\u5408\u8ba1:{0},\u9875\u6570:{1},\u6570\u636e:{2}", response.getZjls(), request.getPageno(), SerializationUtils.toJsonString((Object)response)));
        }
        ArrayList responseList = Lists.newArrayListWithCapacity((int)100);
        if (response.isSucess() && !CollectionUtils.isEmpty((Collection)response.getResponseList())) {
            responseList.addAll(response.getResponseList());
            int totalPage = (response.getZjls() + pageSize - 1) / pageSize;
            ++pageno;
            while (pageno <= totalPage && pageno <= 10) {
                request.setPageno(String.valueOf(pageno));
                responseList.addAll(RedInfoHelper.downloadFromComponent(request, orgId));
                ++pageno;
            }
        }
        return RedInfoHelper.buildResp93007((ComponentResponse<RedInfoDownloadResponseDTO>)response, responseList);
    }

    public static Resp93007 buildResp93007(ComponentResponse<RedInfoDownloadResponseDTO> response, List<RedInfoDownloadResponseDTO> responseList) {
        if (CollectionUtils.isEmpty(responseList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u4e0b\u8f7d\u5230\u7ea2\u5b57\u4fe1\u606f\u8868\u6570\u636e", (String)"RedInfoHelper_16", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        List<Resp93007Hzxxb> hzxxb = RedInfoHelper.covertComponentToResp93007Hzxxb(responseList);
        hzxxb = hzxxb.stream().distinct().collect(Collectors.toList());
        Resp93007 resp93007 = new Resp93007();
        resp93007.setZjls(response.getZjls());
        resp93007.setHzxxb(hzxxb);
        return resp93007;
    }

    private static List<Resp93007Hzxxb> covertComponentToResp93007Hzxxb(List<RedInfoDownloadResponseDTO> responseList) {
        ArrayList<Resp93007Hzxxb> hzxxbs = new ArrayList<Resp93007Hzxxb>(responseList.size());
        for (RedInfoDownloadResponseDTO redInfo : responseList) {
            Resp93007Hzxxb hzxxb = RedInfoHelper.covertRedInfo(redInfo);
            ArrayList fyxmList = Lists.newArrayListWithCapacity((int)redInfo.getInvoice().getItems().size());
            for (ComponentRedInfoItemDTO item : redInfo.getInvoice().getItems()) {
                fyxmList.add(RedInfoHelper.covertRedInfoItem(item, redInfo.getInvoice().getHsbz()));
            }
            hzxxb.setFyxm(fyxmList);
            hzxxbs.add(hzxxb);
        }
        return hzxxbs;
    }

    private static Resp93007Hzxxb covertRedInfo(RedInfoDownloadResponseDTO redInfo) {
        Resp93007Hzxxb hzxxb = new Resp93007Hzxxb();
        hzxxb.setXxbbh(redInfo.getHzxxbm());
        hzxxb.setSqdh(redInfo.getSqdh());
        hzxxb.setZtms(redInfo.getZtms());
        hzxxb.setXxbzt(redInfo.getZtm());
        ComponentRedInfoDTO invoice = redInfo.getInvoice();
        hzxxb.setFpdm(invoice.getFpdm());
        hzxxb.setFphm(invoice.getFphm());
        String kpzl = invoice.getKpzl();
        if (StringUtils.isBlank((CharSequence)kpzl)) {
            hzxxb.setInvoicetype(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
        } else {
            hzxxb.setInvoicetype(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCodeHx().equals(kpzl) ? InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode() : InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)invoice.getKprq())) {
            try {
                hzxxb.setDate(DateUtils.stringToDate((String)invoice.getKprq()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hzxxb.setGfmc(invoice.getGhf_mc());
        hzxxb.setGfsh(invoice.getGhf_nsrsbh());
        hzxxb.setXfmc(invoice.getXhf_mc());
        hzxxb.setXfsh(invoice.getXhf_nsrsbh());
        hzxxb.setHjje(new BigDecimal(invoice.getHjbhsje()));
        hzxxb.setHjse(new BigDecimal(invoice.getKphjse()));
        if ("5".equals(invoice.getSqsm()) || "6".equals(invoice.getSqsm())) {
            hzxxb.setSqsm(RedInfoConstant.ApplicantEnum.SALER.getCode());
        } else if ("0".equals(invoice.getSqsm())) {
            hzxxb.setSqsm(RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode());
        } else {
            hzxxb.setSqsm(RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode());
        }
        hzxxb.setHsbz(invoice.getHsbz());
        return hzxxb;
    }

    private static Resp93007Fyxm covertRedInfoItem(ComponentRedInfoItemDTO item, String hsbz) {
        Resp93007Fyxm fyxm = new Resp93007Fyxm();
        fyxm.setSpmc(item.getXmmc());
        fyxm.setGgxh(item.getGgxh());
        fyxm.setRowtype("0");
        fyxm.setDw(item.getXmdw());
        fyxm.setSpsl(StringUtils.isBlank((CharSequence)item.getXmsl()) ? BigDecimal.ZERO : new BigDecimal(item.getXmsl()));
        fyxm.setSpdj(StringUtils.isBlank((CharSequence)item.getXmdj()) ? BigDecimal.ZERO : new BigDecimal(item.getXmdj()));
        fyxm.setSl(item.getSl());
        fyxm.setJe(new BigDecimal(item.getXmje()));
        fyxm.setSe(new BigDecimal(item.getSe()));
        fyxm.setHsbz(hsbz);
        fyxm.setSpbm(item.getTaxcode().getSsflbm());
        fyxm.setYhzcbs(item.getTaxcode().getSsyhzc());
        fyxm.setLslbs(item.getTaxcode().getLslbs());
        fyxm.setZzstsgl(item.getTaxcode().getSsyhzcnr());
        RedInfoHelper.fillInTaxRedInfoDetail(fyxm, hsbz);
        return fyxm;
    }

    public static List<RedInfoDownloadResponseDTO> downloadFromComponent(RedInfoDownloadRequestDTO request, long orgId) {
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        ComponentRequest componentRequest = new ComponentRequest(ComponentInterfaceTypeEnum.DOWNLOAD_RED_INFO.getCzlx(), (Object)request, saleInfo.getDefaultTerminal());
        ComponentResponse response = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)request.getKjf_sbbh()), (String)JSON.toJSONString((Object)componentRequest), RedInfoDownloadResponseDTO.class);
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("\u7ea2\u5b57\u4fe1\u606f\u8868\u7ec4\u4ef6\u8fd4\u56de,\u5408\u8ba1:{0},\u9875\u6570:{1},\u6570\u636e:{2}", response.getZjls(), request.getPageno(), SerializationUtils.toJsonString((Object)response)));
        }
        if (response.isSucess()) {
            return response.getResponseList();
        }
        return new ArrayList<RedInfoDownloadResponseDTO>();
    }

    public static DynamicObjectCollection queryOriginalInvoiceRemainRedAmount(DynamicObject[] dynamicObjects) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
        for (DynamicObject obj : dynamicObjects) {
            if (!StringUtils.isNotBlank((Object)obj.get("originalinvoicecode")) || !StringUtils.isNotBlank((Object)obj.get("originalinvoiceno"))) continue;
            QFilter q = new QFilter("invoicecode", "=", obj.get("originalinvoicecode")).and("invoiceno", "=", obj.get("originalinvoiceno"));
            qFilter.or(q);
        }
        QFilter buyerTypeFilter = new QFilter("buyertype", "!=", (Object)"9");
        return QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicecode", "invoiceno", "remainredamount", "canredtaxamount", "buyertype"), (QFilter[])new QFilter[]{qFilter, buyerTypeFilter});
    }

    public static DynamicObject convertInvoice2RedInfo(DynamicObject invoice, SaleInfo saleInfo) {
        DynamicObject redInfo = RedInfoHelper.handleRedInfoMainEntity(invoice, saleInfo);
        DynamicObjectCollection redInfoItems = redInfo.getDynamicObjectCollection("items");
        RedInfoHelper.handlerItems(invoice, redInfoItems);
        redInfoItems.forEach(RedInfoHelper::handleData);
        return redInfo;
    }

    private static DynamicObject handleRedInfoMainEntity(DynamicObject invoice, SaleInfo saleInfo) {
        DynamicObject redInfo = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_info");
        DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)invoice, (DynamicObject)redInfo);
        redInfo.set("org", invoice.get("orgid"));
        redInfo.set("infoserialno", (Object)RedInfoHelper.generateRedInfoSerialNo(invoice.getString("jqbh")));
        redInfo.set("orderno", (Object)UUID.next());
        redInfo.set("billstatus", (Object)BillHelper.getBillStatusByTableName("sim_red_info", "1"));
        redInfo.set("salername", (Object)saleInfo.getSaleName());
        redInfo.set("salertaxno", (Object)saleInfo.getSaleTaxNo());
        redInfo.set("infosource", (Object)"1");
        redInfo.set("infodate", (Object)new Date());
        redInfo.set("creater", (Object)RequestContext.get().getUserId());
        redInfo.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
        redInfo.set("originalinvoicecode", invoice.get("invoicecode"));
        redInfo.set("originalinvoiceno", invoice.get("invoiceno"));
        redInfo.set("originalissuetime", invoice.get("issuetime"));
        redInfo.set("invoicecode", null);
        redInfo.set("invoiceno", null);
        redInfo.set("issuetime", null);
        redInfo.set("originaldeduction", invoice.get("deduction"));
        redInfo.set("status", (Object)"1");
        redInfo.set("createtime", (Object)new Date());
        redInfo.set("applytaxno", (Object)invoice.getString("salertaxno"));
        redInfo.set("invoiceamount", (Object)redInfo.getBigDecimal("invoiceamount").negate());
        redInfo.set("totaltax", (Object)redInfo.getBigDecimal("totaltax").negate());
        redInfo.set("totalamount", (Object)redInfo.getBigDecimal("totalamount").negate());
        redInfo.set("id", null);
        return redInfo;
    }

    public static QFilter getRedInfoFromFilter(Object applicant, Object buyerTaxNo, Object billOrgId, Object salerTaxNo) {
        QFilter filter = new QFilter("applicant", "=", applicant).and("status", "in", (Object)new String[]{"3", "4"}).and("infosource", "not in", (Object)new String[]{"5", "6"}).and("org", "=", billOrgId).and("salertaxno", "=", salerTaxNo);
        if (StringUtils.isNotBlank((Object)buyerTaxNo)) {
            filter.and("buyertaxno", "=", buyerTaxNo);
        }
        return filter;
    }

    public static void checkRedInfo(String infoCode, DynamicObject obj) {
        if (StringUtils.isBlank((CharSequence)infoCode)) {
            return;
        }
        if (obj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_17", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        List<String> infoCodeList = Arrays.asList(infoCode.split(","));
        long orgid = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("orgid"));
        QFilter qFilter = new QFilter("infocode", "in", infoCodeList).and("org", "=", (Object)orgid);
        DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)false), (QFilter[])qFilter.toArray());
        if (redInfos.length != infoCodeList.size()) {
            return;
        }
        BigDecimal redInfoInvoiceAmount = BigDecimal.ZERO;
        BigDecimal redInfoTotalTax = BigDecimal.ZERO;
        for (DynamicObject redInfo : redInfos) {
            if (!redInfo.getString("buyername").equals(obj.getString("buyername"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u8d2d\u65b9\u540d\u79f0\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_18", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (!redInfo.getString("buyertaxno").equals(obj.getString("buyertaxno"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_19", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (!redInfo.getString("salername").equals(obj.getString("salername"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_20", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (!redInfo.getString("salertaxno").equals(obj.getString("salertaxno"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u9500\u65b9\u7a0e\u53f7\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_21", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (!RedInfoConstant.isAuditSuccess((String)redInfo.getString("infostatus")) || !"3".equals(redInfo.getString("status"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u72b6\u6001\u4e3a\u975e'\u5ba1\u6838\u901a\u8fc7'\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968", (String)"RedInfoHelper_22", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (!BillStatusEnum.notApproval.contains((Object)redInfo.getString("billstatus"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u5185\u90e8\u5ba1\u6838\u72b6\u6001\u4e3a\u975e'\u5df2\u5ba1\u6838'\u6216'\u65e0\u9700\u5ba1\u6279'\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968", (String)"RedInfoHelper_23", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)redInfo.getString("infocode")) || redInfo.getString("infocode").length() != 16) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u4e0d\u5408\u6cd5\uff0816\u4f4d\u6570\u5b57\uff09", (String)"RedInfoHelper_24", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            redInfoInvoiceAmount = redInfoInvoiceAmount.add(redInfo.getBigDecimal("invoiceamount"));
            redInfoTotalTax = redInfoTotalTax.add(redInfo.getBigDecimal("totaltax"));
        }
        DynamicObjectCollection billItems = obj.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal invoiceamount = billItems.stream().map(o -> o.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTax = billItems.stream().map(o -> o.getBigDecimal("tax")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (redInfoInvoiceAmount.setScale(2, 4).compareTo(invoiceamount.setScale(2, 4)) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355%1$s\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002\u7ea2\u5b57\u4fe1\u606f\u8868%2$s\u91d1\u989d\uff1a%3$s", (String)"RedInfoHelper_25", (String)"imc-sim-common", (Object[])new Object[0]), obj.getString("billno"), infoCodeList, redInfoInvoiceAmount));
        }
        if (redInfoTotalTax.setScale(2, 4).compareTo(totalTax.setScale(2, 4)) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355%1$s\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u7a0e\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_26", (String)"imc-sim-common", (Object[])new Object[0]), obj.getString("billno")));
        }
    }

    public static void checkRedInfoNotNull(String infoCode, DynamicObject obj) {
        Long orgid;
        if (StringUtils.isBlank((CharSequence)infoCode)) {
            return;
        }
        if (obj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_17", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        String entityName = "\u5f00\u7968\u7533\u8bf7\u5355";
        List<String> infoCodeList = Arrays.asList(infoCode.split(","));
        DynamicObject[] dynamicObject = RedInfoHelper.loadReadInfo(infoCodeList, orgid = Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("orgid"))));
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\uff0c\u8bf7\u5148\u5230\u201c\u7ea2\u5b57\u4fe1\u606f\u8868\u201d\u5217\u8868\u4e0b\u8f7d\uff0c\u6216\u68c0\u67e5\u4fe1\u606f\u8868\u7f16\u53f7\u662f\u5426\u6b63\u786e\uff01", (String)"RedInfoHelper_27", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (dynamicObject.length > infoCodeList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u4fe1\u606f\u7f16\u53f7\u7684\u6570\u636e\uff0c\u8bf7\u5148\u5230\u201c\u7ea2\u5b57\u4fe1\u606f\u8868\u201d\u68c0\u67e5\u4fe1\u606f\u8868\u7f16\u53f7\u662f\u5426\u91cd\u590d\uff01", (String)"RedInfoHelper_28", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        BigDecimal redInfoInvoiceAmount = BigDecimal.ZERO;
        BigDecimal redInfoTotalTax = BigDecimal.ZERO;
        for (DynamicObject redInfo : dynamicObject) {
            if (StringUtils.isNotBlank((CharSequence)obj.getString("buyername")) && !redInfo.getString("buyername").equals(obj.getString("buyername"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u8d2d\u65b9\u540d\u79f0\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_29", (String)"imc-sim-common", (Object[])new Object[0]), entityName));
            }
            if (StringUtils.isNotBlank((CharSequence)obj.getString("buyertaxno")) && !redInfo.getString("buyertaxno").equals(obj.getString("buyertaxno"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_30", (String)"imc-sim-common", (Object[])new Object[0]), entityName));
            }
            if (StringUtils.isNotBlank((CharSequence)obj.getString("salername")) && !redInfo.getString("salername").equals(obj.getString("salername"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_31", (String)"imc-sim-common", (Object[])new Object[0]), entityName));
            }
            if (StringUtils.isNotBlank((CharSequence)obj.getString("salertaxno")) && !redInfo.getString("salertaxno").equals(obj.getString("salertaxno"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u9500\u65b9\u7a0e\u53f7\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_32", (String)"imc-sim-common", (Object[])new Object[0]), entityName));
            }
            redInfoInvoiceAmount = redInfoInvoiceAmount.add(redInfo.getBigDecimal("invoiceamount"));
            redInfoTotalTax = redInfoTotalTax.add(redInfo.getBigDecimal("totaltax"));
        }
        if (BigDecimal.ZERO.compareTo(obj.getBigDecimal("invoiceamount")) != 0 && redInfoInvoiceAmount.compareTo(obj.getBigDecimal("invoiceamount")) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u91d1\u989d\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_33", (String)"imc-sim-common", (Object[])new Object[0]), entityName));
        }
        if (BigDecimal.ZERO.compareTo(obj.getBigDecimal("totaltax")) != 0 && redInfoTotalTax.compareTo(obj.getBigDecimal("totaltax")) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868\u7a0e\u989d\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_34", (String)"imc-sim-common", (Object[])new Object[0]), entityName));
        }
    }

    public static DynamicObject[] loadReadInfo(List<String> infoCodeList, Long orgId) {
        QFilter qFilter = new QFilter("infocode", "in", infoCodeList).and("org", "=", (Object)orgId);
        log.info("checkRedInfoNotNull:" + SerializationUtils.toJsonString((Object)qFilter));
        return BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)false), (QFilter[])qFilter.toArray());
    }

    public static Long getTaxOrgId(String taxNo) {
        long taxOrgId = 0L;
        try {
            QFilter qFilter = new QFilter("unifiedsocialcode", "=", (Object)taxNo);
            DynamicObject taxMain = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])qFilter.toArray());
            if (taxMain != null) {
                taxOrgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)taxMain.get("org"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return taxOrgId;
    }

    public static DynamicObject redInfoToInvoice(DynamicObject redInfoDynamicObject) {
        DynamicObject invoiceObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)redInfoDynamicObject, (DynamicObject)invoiceObj);
        RedInfoHelper.fillInVatInvoiceData(redInfoDynamicObject, invoiceObj);
        return invoiceObj;
    }

    public static void queryWaitInvoiceByInfoCodeThenDelete(DynamicObject redInfoDynamicObject) {
        QFilter qFilter = new QFilter("infocode", "=", (Object)redInfoDynamicObject.getString("infocode"));
        qFilter.and("issuestatus", "!=", (Object)IssueStatusEnum.ok.getCode());
        qFilter.and("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)redInfoDynamicObject.get("org")));
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "issuebillstatus", "issuestatus"), (QFilter[])qFilter.toArray());
        if (invoice == null) {
            return;
        }
        if (!BillStatusEnum.notApproval.contains((Object)invoice.getString("issuebillstatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u5bf9\u5e94\u5f85\u5f00\u53d1\u7968\u975e\u5ba1\u6838\u901a\u8fc7\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968", (String)"RedInfoHelper_35", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        String issueStatus = invoice.getString("issuestatus");
        if (IssueStatusEnum.submit.getCode().equals(issueStatus) || IssueStatusEnum.underway.getCode().equals(issueStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u5bf9\u5e94\u5f85\u5f00\u53d1\u7968\u6b63\u5728\u5f00\u7968\u4e2d\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u5f00\u7968", (String)"RedInfoHelper_36", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        DeleteServiceHelper.delete((String)"sim_vatinvoice", (QFilter[])qFilter.toArray());
    }

    public static void fillInVatInvoiceData(DynamicObject redInfoObj, DynamicObject invoiceObj) {
        invoiceObj.set("buyertype", (Object)("5".equals(redInfoObj.getString("infosource")) || "6".equals(redInfoObj.getString("infosource")) ? "4" : "0"));
        DynamicObject equipmentDynamicObject = EquipmentUtil.getCommonEquipment((String)redInfoObj.getString("jqbh"), (String)redInfoObj.getString("salertaxno"), (String)invoiceObj.getString("terminalno"));
        if (equipmentDynamicObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65b9\u7a0e\u53f7%1$s\u4e0b\u4e0d\u5b58\u5728\u76d8\u53f7\u4e3a%2$s\u7684\u76d8", (String)"RedInfoHelper_37", (String)"imc-sim-common", (Object[])new Object[0]), redInfoObj.getString("salertaxno"), redInfoObj.getString("jqbh")));
        }
        String equipmentType = equipmentDynamicObject.getString("equipmenttype");
        invoiceObj.set("issuesource", (Object)equipmentType);
        invoiceObj.set("issuetype", (Object)IssueTypeEnum.red.getValue());
        invoiceObj.set("orderno", (Object)redInfoObj.getString("orderno"));
        invoiceObj.set("remark", (Object)GBKUtils.cutGBKString((String)(RemarkTemplateHelper.generateRedInfoRemark((DynamicObject)redInfoObj) + redInfoObj.getString("applyreason")), (int)230));
        invoiceObj.set("orgid", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)redInfoObj.get("org")));
        invoiceObj.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
        invoiceObj.set("issuewritebackstatus", (Object)"0");
        invoiceObj.set("abolishwritebackstatus", (Object)"2");
        DynamicObjectCollection collection = redInfoObj.getDynamicObjectCollection("items");
        if (collection.size() > 8) {
            invoiceObj.set("inventorymark", (Object)"1");
        } else {
            invoiceObj.set("inventorymark", (Object)"0");
        }
        invoiceObj.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        DynamicObjectCollection items2 = invoiceObj.getDynamicObjectCollection("items");
        for (DynamicObject item : items2) {
            String rowType = item.getString("rowtype");
            if (!StringUtils.isBlank((CharSequence)rowType)) continue;
            item.set("rowtype", (Object)"0");
        }
    }

    public static DynamicObject checkInfoCode(BillVo bill, long orgId, HashMap<String, String> infoCodeMap, String billName) {
        DynamicObject[] redInfos;
        int maxLength;
        boolean isAllEInvoice;
        boolean bl = isAllEInvoice = InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || AllEleAuthHelper.isElePaper((Object)bill.getIsElePaper());
        if (BigDecimalUtil.greaterZero((BigDecimal)bill.getTotalAmount()) || InvoiceUtils.isNormalInvoice((String)bill.getInvoiceType()) && !isAllEInvoice) {
            bill.setInfoCode("");
            bill.setApplicant("");
            return null;
        }
        String infoCode = bill.getInfoCode();
        if (StringUtils.isBlank((CharSequence)infoCode)) {
            if (bill.getAutoInvoice() == 1 && isAllEInvoice) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f00\u7968", (String)"RedInfoHelper_38", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName));
            }
            return null;
        }
        if (infoCodeMap.containsKey(bill.getInfoCode())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7f16\u53f7[%2$s]\u5df2\u5173\u8054\u5355\u636e[%3$s]", (String)"RedInfoHelper_39", (String)"imc-sim-common", (Object[])new Object[0]), billName, infoCode, infoCodeMap.get(infoCode)));
        }
        infoCodeMap.put(infoCode, bill.getBillNo());
        int n = maxLength = isAllEInvoice ? 20 : 16;
        if (infoCode.length() != maxLength) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u4e0d\u5408\u6cd5\uff08%4$s\u4f4d\u6570\u5b57\uff09", (String)"RedInfoHelper_40", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode, maxLength));
        }
        QFilter qFilter = new QFilter("infocode", "=", (Object)infoCode);
        qFilter.and("orgid", "=", (Object)orgId);
        DynamicObject[] dynamicObjectArray = redInfos = isAllEInvoice ? RedInfoHelper.loadRedConfirmBill(Lists.newArrayList((Object[])new String[]{infoCode}), orgId, bill.getSellerTaxpayerId()) : RedInfoHelper.loadReadInfo(Lists.newArrayList((Object[])new String[]{infoCode}), orgId);
        if (redInfos.length == 0) {
            if (isAllEInvoice && bill.getAutoInvoice() == 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u4e0d\u5b58\u5728\u53d1\u7968\u4e91\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"RedInfoHelper_41", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode));
            }
            if (StringUtils.isBlank((CharSequence)bill.getApplicant())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u4e0d\u5b58\u5728\u53d1\u7968\u4e91\uff0c\u8bf7\u586b\u5199\u7533\u8bf7\u65b9", (String)"RedInfoHelper_42", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode));
            }
            return null;
        }
        if (redInfos.length > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u5b58\u5728\u591a\u6761\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"RedInfoHelper_43", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode));
        }
        DynamicObject redInfo = redInfos[0];
        RedInfoHelper.checkBlueInfo(redInfo, bill, billName);
        if (isAllEInvoice) {
            if ("0".equals(redInfo.getString("issuestatus"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u5df2\u7ecf\u7ea2\u51b2\uff0c\u65e0\u6cd5\u5f00\u7968", (String)"RedInfoHelper_44", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode));
            }
        } else if (!"3".equals(redInfo.getString("status"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u672a\u5ba1\u6838\u6210\u529f\uff0c\u65e0\u6cd5\u5f00\u7968", (String)"RedInfoHelper_45", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode));
        }
        if (!bill.getInvoiceType().equals(redInfo.getString(INVOICETYPE))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s\u4e0e%2$s\u7f16\u53f7[%3$s]\u53d1\u7968\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5f00\u7968", (String)"RedInfoHelper_46", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode));
        }
        DynamicObject originalBill = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)"id,infocode,billno", (QFilter[])qFilter.toArray());
        if (null != originalBill) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7f16\u53f7[%2$s]\u5df2\u5173\u8054\u5355\u636e[%3$s]", (String)"RedInfoHelper_39", (String)"imc-sim-common", (Object[])new Object[0]), billName, infoCode, originalBill.getString("billno")));
        }
        BigDecimal redInfoInvoiceAmount = redInfo.getBigDecimal("invoiceamount");
        BigDecimal redInfoTotalTax = redInfo.getBigDecimal("totaltax");
        BigDecimal totalAmount = bill.getTotalAmount();
        BigDecimal totalTaxAmount = bill.getTotalTaxAmount();
        if (bill.getAutoInvoice() == 1) {
            if (!BigDecimalUtil.compareZero((BigDecimal)totalAmount) && redInfoInvoiceAmount.compareTo(totalAmount) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355:%1$s\u4e0e%2$s\u91d1\u989d\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_47", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName));
            }
            if (!BigDecimalUtil.compareZero((BigDecimal)totalTaxAmount) && redInfoTotalTax.compareTo(totalTaxAmount) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355:%1$s\u4e0e%2$s\u7a0e\u989d\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_48", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName));
            }
            if (!redInfo.getString("buyername").equals(bill.getBuyerName())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u4e0e%4$s\u8d2d\u65b9\u540d\u79f0\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_49", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode, billName));
            }
            if (!redInfo.getString("buyertaxno").equals(bill.getBuyerTaxpayerId())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u4e0e%4$s\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_50", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode, billName));
            }
            if (!redInfo.getString("salername").equals(bill.getSellerName())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u4e0e%4$s\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_51", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode, billName));
            }
            if (!redInfo.getString("salertaxno").equals(bill.getSellerTaxpayerId())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u4e0e%4$s\u9500\u65b9\u7a0e\u53f7\u4e0d\u4e00\u6837\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_52", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, infoCode, billName));
            }
        }
        bill.setApplicant(redInfo.getString("applicant"));
        return redInfo;
    }

    private static DynamicObject[] loadRedConfirmBill(List<String> infoCodeList, Long orgId, String salerTaxNo) {
        QFilter baseDataFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)orgId);
        QFilter qFilter = baseDataFilter.and("number", "in", infoCodeList).and("salertaxno", "=", (Object)salerTaxNo);
        return BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)false), (QFilter[])qFilter.toArray());
    }

    public static Resp93007 dynamicObjectBuildResp93007(int size, List<DynamicObject> responseList) {
        Resp93007 resp93007 = new Resp93007();
        resp93007.setZjls(size);
        List<Resp93007Hzxxb> hzxxb = RedInfoHelper.dynamicObjectBuildCovertResp93007(responseList);
        resp93007.setHzxxb(hzxxb);
        return resp93007;
    }

    private static List<Resp93007Hzxxb> dynamicObjectBuildCovertResp93007(List<DynamicObject> responseList) {
        ArrayList hzxxbs = Lists.newArrayListWithCapacity((int)responseList.size());
        for (DynamicObject redInfo : responseList) {
            Resp93007Hzxxb resp93007Hzxxb = (Resp93007Hzxxb)DynamicObjectUtil.dynamicObject2Bean(Resp93007Hzxxb.class, (DynamicObject)redInfo);
            hzxxbs.add(resp93007Hzxxb);
        }
        return hzxxbs;
    }

    public static ValidationErrorInfo buildValidationErrorInfo(DynamicObject redInfo, String errMsg) {
        return new ValidationErrorInfo("", redInfo.getPkValue(), 0, 0, ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"RedInfoHelper_53", (String)"imc-sim-common", (Object[])new Object[0]), errMsg, ErrorLevel.Error);
    }

    private static void checkBlueInfo(DynamicObject redInfo, BillVo bill, String billName) {
        String redInfoCode = StringUtils.trimToEmpty((String)redInfo.getString("originalinvoicecode"));
        String redInfoNo = StringUtils.trimToEmpty((String)redInfo.getString("originalinvoiceno"));
        if (StringUtils.isEmpty((CharSequence)redInfoCode) && StringUtils.isEmpty((CharSequence)redInfoNo)) {
            return;
        }
        String blueInvoiceCode = StringUtils.trimToEmpty((String)bill.getBlueinvoiceCode());
        String blueInvoiceNo = StringUtils.trimToEmpty((String)bill.getBlueinvoiceNo());
        if (StringUtils.isEmpty((CharSequence)blueInvoiceCode) && StringUtils.isEmpty((CharSequence)blueInvoiceNo)) {
            bill.setBlueinvoiceCode(redInfoCode);
            bill.setBlueinvoiceNo(redInfoNo);
            return;
        }
        if (!blueInvoiceCode.equals(redInfoCode) || !blueInvoiceNo.equals(redInfoNo)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,%2$s\u7f16\u53f7[%3$s]\u4fe1\u606f\u8868\u5bf9\u5e94\u7684\u84dd\u7968\u4fe1\u606f\u4e0e\u9700\u8981\u7ea2\u51b2\u7684\u539f\u84dd\u7968\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"RedInfoHelper_54", (String)"imc-sim-common", (Object[])new Object[0]), bill.getBillNo(), billName, bill.getInfoCode()));
        }
    }
}

