/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.imc.sim.common.dto.bill.workbench.WorkbenchPrintInvoiceDTO;
import kd.imc.sim.common.dto.bill.workbench.WorkbenchPrintInvoiceGroupDTO;

public class WorkbenchPrintInvoiceHelper {
    public static List<WorkbenchPrintInvoiceGroupDTO> groupBy(List<DynamicObject> invoiceList) {
        ArrayList<WorkbenchPrintInvoiceDTO> workbenchPrintInvoiceDTOList = new ArrayList<WorkbenchPrintInvoiceDTO>(invoiceList.size());
        for (DynamicObject invoice : invoiceList) {
            workbenchPrintInvoiceDTOList.add(new WorkbenchPrintInvoiceDTO(invoice.getLong("id"), invoice.getString("jqbh"), invoice.getString("invoicetype"), invoice.getString("invoicecode"), invoice.getString("invoiceno")));
        }
        Map<String, List<WorkbenchPrintInvoiceDTO>> collect = workbenchPrintInvoiceDTOList.stream().collect(Collectors.groupingBy(WorkbenchPrintInvoiceDTO::getInvoiceType));
        ArrayList<WorkbenchPrintInvoiceGroupDTO> list = new ArrayList<WorkbenchPrintInvoiceGroupDTO>(collect.size());
        collect.forEach((invoiceType, invoices) -> {
            WorkbenchPrintInvoiceGroupDTO workbenchPrintInvoiceGroupDTO = WorkbenchPrintInvoiceHelper.invoiceGroupBy(invoiceType, invoices);
            list.add(workbenchPrintInvoiceGroupDTO);
        });
        return list;
    }

    private static WorkbenchPrintInvoiceGroupDTO invoiceGroupBy(String invoiceType, List<WorkbenchPrintInvoiceDTO> workbenchPrintInvoiceDTOList) {
        Map invoiceMap = workbenchPrintInvoiceDTOList.stream().collect(Collectors.groupingBy(WorkbenchPrintInvoiceDTO::getInvoiceCode, TreeMap::new, Collectors.toList()));
        ArrayList<List<WorkbenchPrintInvoiceDTO>> groupList = new ArrayList<List<WorkbenchPrintInvoiceDTO>>();
        invoiceMap.forEach((k, invoices) -> {
            invoices.sort(Comparator.comparing(WorkbenchPrintInvoiceDTO::getInvoiceNo));
            WorkbenchPrintInvoiceHelper.invoiceGroupBy(groupList, invoices, 0);
        });
        WorkbenchPrintInvoiceGroupDTO workbenchPrintInvoiceGroupDTO = new WorkbenchPrintInvoiceGroupDTO();
        workbenchPrintInvoiceGroupDTO.setInvoiceType(invoiceType);
        workbenchPrintInvoiceGroupDTO.setList(groupList);
        return workbenchPrintInvoiceGroupDTO;
    }

    private static void invoiceGroupBy(List<List<WorkbenchPrintInvoiceDTO>> groupList, List<WorkbenchPrintInvoiceDTO> workbenchPrintInvoiceDTOS, int index) {
        WorkbenchPrintInvoiceDTO workbenchPrintInvoiceDTO;
        int i;
        ArrayList<WorkbenchPrintInvoiceDTO> list = new ArrayList<WorkbenchPrintInvoiceDTO>();
        list.add(workbenchPrintInvoiceDTOS.get(index));
        groupList.add(list);
        for (i = index + 1; i < workbenchPrintInvoiceDTOS.size() && Integer.parseInt((workbenchPrintInvoiceDTO = workbenchPrintInvoiceDTOS.get(i)).getInvoiceNo()) - 1 == Integer.parseInt(workbenchPrintInvoiceDTOS.get(i - 1).getInvoiceNo()); ++i) {
            list.add(workbenchPrintInvoiceDTO);
        }
        if (i < workbenchPrintInvoiceDTOS.size()) {
            WorkbenchPrintInvoiceHelper.invoiceGroupBy(groupList, workbenchPrintInvoiceDTOS, i);
        }
    }

    public static List<WorkbenchPrintInvoiceDTO> getDetailList(List<DynamicObject> invoiceList) {
        ArrayList<WorkbenchPrintInvoiceDTO> workbenchPrintInvoiceDTOList = new ArrayList<WorkbenchPrintInvoiceDTO>(invoiceList.size());
        for (DynamicObject invoice : invoiceList) {
            if (!"1".equals(invoice.getString("inventorymark"))) continue;
            workbenchPrintInvoiceDTOList.add(new WorkbenchPrintInvoiceDTO(invoice.getLong("id"), invoice.getString("jqbh"), invoice.getString("invoicetype"), invoice.getString("invoicecode"), invoice.getString("invoiceno")));
        }
        return workbenchPrintInvoiceDTOList;
    }
}

