/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.allele;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashMap;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleCreditQuotaResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.lqpt.service.SxedService;
import org.apache.commons.lang.StringUtils;

public class CreditQuotaHelper {
    public static final String creditQuota = "creditQuota_";
    public static final String totalCreditQuota = "totalCreditQuota_";

    public static String getCreditQuota(AbstractFormPlugin that, String taxNo) {
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            AllEleCreditQuotaResponseDTO allEleCreditQuotaResponseDTO = new SxedService().querySxed(taxNo);
            return CreditQuotaHelper.setCreditQuota(taxNo, allEleCreditQuotaResponseDTO);
        }
        String creditQuotaStr = CacheHelper.get((String)(creditQuota + taxNo));
        if (StringUtils.isNotBlank((String)creditQuotaStr)) {
            return creditQuotaStr;
        }
        AllEleResponseDTO<AllEleCreditQuotaResponseDTO> creditQuotaResponse = CreditQuotaHelper.queryCreditQuota(taxNo);
        if (creditQuotaResponse.getSuccess().booleanValue()) {
            return CreditQuotaHelper.setCreditQuota(taxNo, (AllEleCreditQuotaResponseDTO)creditQuotaResponse.getData());
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("salertaxno", taxNo);
        param.put("request_path", AllEleInterfaceTypeEnum.QUERY_CREDIT_QUOTA.getRequestPath());
        if (that.getView().getControl("account") != null) {
            param.put("account", that.getView().getModel().getValue("account"));
        }
        if (!AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)that, param) && (creditQuotaResponse = CreditQuotaHelper.queryCreditQuota(taxNo)).getSuccess().booleanValue()) {
            return CreditQuotaHelper.setCreditQuota(taxNo, (AllEleCreditQuotaResponseDTO)creditQuotaResponse.getData());
        }
        return "0.00";
    }

    public static String getNumberFormat(BigDecimal amount) {
        String amountStr = amount.toString();
        try {
            amountStr = NumberFormat.getNumberInstance().format(amount);
            if (!amountStr.contains(".")) {
                amountStr = amountStr + ".00";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amountStr;
    }

    public static String setCreditQuota(String taxNo, AllEleCreditQuotaResponseDTO creditQuotaResponse) {
        String creditQuotaStr = "0.00";
        if (StringUtils.isNotBlank((String)creditQuotaResponse.getAvailableVolume())) {
            creditQuotaStr = CreditQuotaHelper.getNumberFormat(new BigDecimal(creditQuotaResponse.getAvailableVolume()));
            CacheHelper.put((String)(creditQuota + taxNo), (String)creditQuotaStr, (int)604800);
        }
        if (StringUtils.isNotBlank((String)creditQuotaResponse.getTotalVolume())) {
            String totalCreditQuotaStr = CreditQuotaHelper.getNumberFormat(new BigDecimal(creditQuotaResponse.getTotalVolume()));
            CacheHelper.put((String)(totalCreditQuota + taxNo), (String)totalCreditQuotaStr, (int)604800);
        }
        return creditQuotaStr;
    }

    public static AllEleResponseDTO<AllEleCreditQuotaResponseDTO> queryCreditQuota(String taxNo) {
        AllEleResponseDTO response = new AllEleResponseDTO();
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            response.setErrcode(ErrorType.SUCCESS.getCode());
            response.setData((Object)new SxedService().querySxed(taxNo));
        } else {
            AllEleRequestDTO requestDTO = new AllEleRequestDTO();
            requestDTO.setRequest_path(AllEleInterfaceTypeEnum.QUERY_CREDIT_QUOTA.getRequestPath());
            response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)requestDTO, AllEleCreditQuotaResponseDTO.class);
        }
        return response;
    }
}

