/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.sim.common.utils.MathUtils;

public class PriceHelper {
    public static final int ALL_E_MAX_LEN = 25;
    public static final int TAX_INV_MAX_LEN = 16;
    private static final int TAX_INV_MAX_INT_LEN = 13;
    private static final int ALL_ELE_MAX_INT_LEN = 12;
    private static final int DECIMAL_MAX_LEN = 13;

    public static BigDecimal getUnitPriceByHS(BigDecimal taxRate, BigDecimal num, BigDecimal amount, BigDecimal taxUnitPrice, boolean isAllele) {
        if (MathUtils.isZero(taxUnitPrice) || !MathUtils.isZero(amount)) {
            if (MathUtils.isZero(num)) {
                return BigDecimal.ZERO;
            }
            return PriceHelper.calcPriceOrNum(amount, num, isAllele);
        }
        return PriceHelper.getValue(taxUnitPrice.divide(BigDecimal.ONE.add(taxRate), 15, RoundingMode.HALF_UP), "\u4e0d\u542b\u7a0e\u5355\u4ef7", isAllele);
    }

    public static BigDecimal getTaxUnitPriceByBHS(BigDecimal taxRate, BigDecimal num, BigDecimal taxAmount, BigDecimal unitPrice, boolean isAllele) {
        if (MathUtils.isZero(unitPrice) || !MathUtils.isZero(taxAmount)) {
            if (MathUtils.isZero(num)) {
                return BigDecimal.ZERO;
            }
            return PriceHelper.calcPriceOrNum(taxAmount, num, isAllele);
        }
        return PriceHelper.getValue(unitPrice.multiply(BigDecimal.ONE.add(taxRate)), "\u542b\u7a0e\u5355\u4ef7", isAllele);
    }

    public static BigDecimal calcPriceOrNum(BigDecimal divisor, BigDecimal dividend, boolean isAllele) {
        if (MathUtils.isNullOrZero(dividend)) {
            return BigDecimal.ZERO;
        }
        return divisor.divide(dividend, PriceHelper.getMaxPointLength(divisor, dividend, isAllele), 4).stripTrailingZeros();
    }

    public static int getMaxPointLength(BigDecimal divisor, BigDecimal dividend, boolean isAllele) {
        int maxLen;
        int pointLength;
        int intLength = divisor.divide(dividend, 0, 1).abs().toPlainString().length();
        if (isAllele) {
            if (intLength > 12) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f97\u51fa\u7684\u5355\u4ef7\u6574\u6570\u4f4d\u8d85\u957f\uff0c \u6574\u6570\u4f4d\u6700\u591a12\u4f4d", (String)"PriceHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        } else if (intLength > 13) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f97\u51fa\u7684\u5355\u4ef7\u6574\u6570\u4f4d\u8d85\u957f\uff0c \u6574\u6570\u4f4d\u6700\u591a13\u4f4d", (String)"PriceHelper_2", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if ((pointLength = (maxLen = isAllele ? 25 : 16) - intLength - 1) > 13) {
            pointLength = 13;
        }
        return pointLength;
    }

    public static BigDecimal getValue(BigDecimal inputValue, String name, boolean isAllEle) {
        if (null == inputValue) {
            return BigDecimal.ZERO;
        }
        String inputValueStr = inputValue.toPlainString();
        String replacedStr = inputValueStr.replace("-", "");
        int maxIntLen = 13;
        if (isAllEle) {
            maxIntLen = 12;
        }
        if (!inputValueStr.contains(".") && replacedStr.length() > maxIntLen) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6574\u6570\u4f4d\u8d85\u957f,\u6574\u6570\u4f4d\u6700\u591a%3$s\u4f4d", (String)"PriceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), name, inputValue, maxIntLen));
        }
        String[] array = replacedStr.split("\\.");
        if (array[0].length() > maxIntLen) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6574\u6570\u4f4d\u8d85\u957f,\u6574\u6570\u4f4d\u6700\u591a%3$s\u4f4d", (String)"PriceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), name, inputValue, maxIntLen));
        }
        if (array.length > 1) {
            int firstLength = array[0].length();
            int maxLen = isAllEle ? 25 : 16;
            return inputValue.setScale(maxLen - firstLength - 1, RoundingMode.HALF_UP).stripTrailingZeros();
        }
        return inputValue.stripTrailingZeros();
    }

    public static String getStrValue(String inputValue, String name, boolean isAllEle) {
        if (StringUtils.isBlank((CharSequence)inputValue)) {
            return inputValue;
        }
        if (!BigDecimalUtil.isNumber((String)inputValue)) {
            return "";
        }
        return PriceHelper.getValue(new BigDecimal(inputValue), name, isAllEle).toPlainString();
    }

    public static BigDecimal calTaxUnitPrice(BigDecimal unitPrice, BigDecimal taxRate, boolean isAllEle) {
        if (MathUtils.isNullOrZero(unitPrice) || MathUtils.isNullOrZero(taxRate)) {
            return BigDecimal.ZERO;
        }
        BigDecimal taxPrice = unitPrice.multiply(BigDecimal.ONE.add(taxRate)).setScale(28, 4);
        return PriceHelper.getValue(taxPrice, "\u542b\u7a0e\u5355\u4ef7", isAllEle);
    }

    public static BigDecimal getValue(BigDecimal inputValue, boolean isAllEle) {
        return PriceHelper.getValue(inputValue, "", isAllEle);
    }

    public static void checkPriceLegal(BigDecimal priceValue, String name, boolean isEle) {
        String inputValueStr = priceValue.toPlainString();
        String replacedStr = inputValueStr.replace("-", "");
        int maxIntLen = 13;
        if (isEle) {
            maxIntLen = 12;
        }
        int totalLen = 16;
        if (isEle) {
            totalLen = 25;
        }
        if (!inputValueStr.contains(".") && replacedStr.length() > maxIntLen) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6574\u6570\u4f4d\u8d85\u957f,\u6574\u6570\u4f4d\u6700\u591a%3$s\u4f4d", (String)"PriceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), name, priceValue, maxIntLen));
        }
        String[] array = replacedStr.split("\\.");
        if (array[0].length() > maxIntLen) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6574\u6570\u4f4d\u8d85\u957f,\u6574\u6570\u4f4d\u6700\u591a%3$s\u4f4d", (String)"PriceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), name, priceValue, maxIntLen));
        }
        if (replacedStr.length() > totalLen) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u7684\u957f\u5ea6\u8d85\u8fc7\u9650\u5236%3$s\u4f4d\uff08\u4e0d\u5305\u542b\u8d1f\u53f7\uff0c\u5305\u542b\u5c0f\u6570\u70b9\uff09", (String)"PriceHelper_3", (String)"imc-sim-common", (Object[])new Object[0]), name, priceValue, totalLen));
        }
    }

    public static int getMaxPriceAllLen(boolean isAllEle) {
        if (isAllEle) {
            return 25;
        }
        return 16;
    }

    public static void convertPrice2Str(JSONArray invoiceList) {
        for (Object o : invoiceList) {
            JSONObject json = (JSONObject)o;
            JSONArray jsonArray = json.getJSONArray("items");
            for (Object item : jsonArray) {
                Object taxUnitPrice;
                JSONObject itemJson = (JSONObject)item;
                Object unitPrice = itemJson.get((Object)"unitprice");
                if (unitPrice instanceof BigDecimal) {
                    unitPrice = ((BigDecimal)unitPrice).stripTrailingZeros().toPlainString();
                }
                if ((taxUnitPrice = itemJson.get((Object)"taxunitprice")) instanceof BigDecimal) {
                    taxUnitPrice = ((BigDecimal)taxUnitPrice).stripTrailingZeros().toPlainString();
                }
                itemJson.put("unitprice", unitPrice);
                itemJson.put("taxunitprice", taxUnitPrice);
            }
        }
    }

    public static void convertMapPrice2Str(List<Map<String, Object>> positiveBillMapList) {
        for (Map<String, Object> stringObjectMap : positiveBillMapList) {
            List items2 = (List)stringObjectMap.get("sim_original_bill_item");
            if (null == items2) continue;
            for (Map item : items2) {
                Object taxUnitPrice;
                Object unitPrice = item.get("unitprice");
                if (unitPrice instanceof BigDecimal) {
                    unitPrice = ((BigDecimal)unitPrice).stripTrailingZeros().toPlainString();
                }
                if ((taxUnitPrice = item.get("taxunitprice")) instanceof BigDecimal) {
                    taxUnitPrice = ((BigDecimal)taxUnitPrice).stripTrailingZeros().toPlainString();
                }
                item.put("unitprice", unitPrice);
                item.put("taxunitprice", taxUnitPrice);
            }
        }
    }

    public static void convertInvoicePrice2Str(List<Map<String, Object>> invoiceListMap) {
        for (Map<String, Object> invMap : invoiceListMap) {
            Object items2 = invMap.get("items");
            if (null == items2) continue;
            List itemLists = (List)items2;
            for (Map itemMap : itemLists) {
                Object price = itemMap.get("unitprice");
                if (price instanceof BigDecimal) {
                    price = ((BigDecimal)price).stripTrailingZeros().toPlainString();
                }
                itemMap.put("unitprice", price);
                Object taxPrice = itemMap.get("taxunitprice");
                if (taxPrice instanceof BigDecimal) {
                    taxPrice = ((BigDecimal)taxPrice).stripTrailingZeros().toPlainString();
                }
                itemMap.put("taxunitprice", taxPrice);
            }
        }
    }
}

