/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice.writeback;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.sim.common.dto.FillInInvoiceResponseDTO;
import kd.imc.sim.common.helper.ItemMerge2OneHelper;
import kd.imc.sim.common.helper.ReOpenInvoiceHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.AbstractIssueInvoiceWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.MatchBillWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.RedInfoAndConfirmBillWriteBackHelper;
import kd.imc.sim.common.utils.MathUtils;

public class IssuedInvoiceWriteBackHelper
extends AbstractIssueInvoiceWriteBackHelper {
    private static final Log LOG = LogFactory.getLog(IssuedInvoiceWriteBackHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBackIssueAmount2OriginBill(DynamicObject invoice) {
        if (StringUtils.isBlank((CharSequence)invoice.getString("issuewritebackstatus"))) {
            LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u5f00\u7968\u53cd\u5199\u72b6\u6001\u4e3a\u7a7a, \u662f\u65e7\u6570\u636e\u6216\u975e\u5355\u636e\u62c6\u5408\u5f00\u7968\uff0c\u6b64\u6b21\u4e0d\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            return;
        }
        String lockKey = invoice.getString("invoicecode") + "_" + invoice.getString("invoiceno") + "issuewriteback";
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(1L)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("%s\u672a\u83b7\u53d6\u5230\u9501\uff0c\u5f53\u524d\u6b63\u5728\u5f00\u7968\u56de\u5199\u56de\u5199", lockKey));
                }
                return;
            }
            if ("1".equals(invoice.getString("issuewritebackstatus"))) {
                LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u5f00\u7968\u53cd\u5199\u6210\u529f\uff0c\u6b64\u6b21\u4e0d\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                return;
            }
            TXHandle tx = TX.required();
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u51c6\u5907\u5f00\u7968\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            DLock billLock = IssuedInvoiceWriteBackHelper.lockOriginalBillWriteBack(invoice);
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u83b7\u53d6\u5230\u9501\uff0c\u5f00\u59cb\u5f00\u7968\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                }
                if (IssuedInvoiceWriteBackHelper.isNegativeSpecialInvoice(invoice)) {
                    RedInfoAndConfirmBillWriteBackHelper.writeBack2OriginBillByRedSpecial(invoice);
                } else {
                    IssuedInvoiceWriteBackHelper.writeBack(invoice, invoice, false);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOG.error("\u5f00\u7968\u56de\u5199\u5931\u8d25", (Throwable)e);
            }
            finally {
                tx.close();
                billLock.unlock();
            }
        }
        IssuedInvoiceWriteBackHelper.invokeBillCenter(invoice);
    }

    private static void invokeBillCenter(DynamicObject invoice) {
        try {
            String issueType = invoice.getString("issuetype");
            if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
                QFilter qFilter = InvoiceQueryUtil.getInvoiceByCodeAndNo((String)invoice.getString("originalinvoicecode"), (String)invoice.getString("originalinvoiceno"));
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,systemsource", (QFilter[])qFilter.toArray());
                String systemSource = blueInvoice.getString("systemsource");
                if (blueInvoice != null && "BILL_CENTER".equals(systemSource)) {
                    invoice.set("systemsource", (Object)"BILL_CENTER");
                } else if (blueInvoice != null && "billcenter".equals(systemSource)) {
                    invoice.set("systemsource", (Object)"BILL_CENTER");
                }
            }
            String systemSource = invoice.getString("systemsource");
            LOG.info("invokeBillCenter, systemSource:{}", (Object)systemSource);
            if ("BILL_CENTER".equals(systemSource)) {
                LOG.info(String.format("\u5f00\u59cb\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u662f%s", invoice.getString("orderno")));
                DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"BillCenterCallBackServiceImpl", (String)"callback", (Object[])new Object[]{invoice.getPkValue()});
            }
        }
        catch (Exception e) {
            LOG.error(String.format("\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\u5931\u8d25\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u662f%s", invoice.getString("orderno")), (Throwable)e);
        }
    }

    static void writeBack(DynamicObject invoiceOrRedInfo, DynamicObject invoice, boolean isValid) {
        DynamicObject invalidBill;
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u6839\u636e\u5173\u7cfb\u8868\u5f00\u59cb\u8fdb\u884c\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
        }
        if (!isValid && "10".equals(invoice.getString("contraststatus"))) {
            MatchBillWriteBackHelper.issueWriteback(invoice, invoice);
            return;
        }
        boolean redPush = false;
        DynamicObject[] billInvRelations = IssuedInvoiceWriteBackHelper.getRelationsByTBillId(invoiceOrRedInfo.getPkValue());
        if (billInvRelations.length == 0 && invoiceOrRedInfo.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
            DynamicObject blueInvoice = IssuedInvoiceWriteBackHelper.getBlueInvoiceByRed(invoiceOrRedInfo);
            if (blueInvoice == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("\u53d1\u7968\u53f7\u7801\uff1a[%s]\u672a\u627e\u5230\u5bf9\u5e94\u84dd\u7968\u4fe1\u606f\uff0c\u7ea2\u51b2\u64cd\u4f5c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", invoiceOrRedInfo.getString("invoiceno")));
                }
                IssuedInvoiceWriteBackHelper.updateIssueWriteBackStatus(invoice, "-1", "\u672a\u627e\u5230\u5bf9\u5e94\u84dd\u7968\u4fe1\u606f\uff0c\u7ea2\u51b2\u64cd\u4f5c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355");
                return;
            }
            billInvRelations = IssuedInvoiceWriteBackHelper.getRelationsByTBillId(blueInvoice.getPkValue());
            if (invoiceOrRedInfo.getBigDecimal("invoiceamount").abs().compareTo(blueInvoice.getBigDecimal("invoiceamount")) < 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("\u53d1\u7968\u53f7\u7801\uff1a[%s]\u90e8\u5206\u7ea2\u51b2\uff0c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", invoiceOrRedInfo.getString("invoiceno")));
                }
                IssuedInvoiceWriteBackHelper.updateIssueWriteBackStatus(invoice, "-1", "\u90e8\u5206\u7ea2\u51b2\uff0c\u7ea2\u51b2\u64cd\u4f5c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355");
                return;
            }
            redPush = true;
        }
        if (isValid && (invalidBill = IssuedInvoiceWriteBackHelper.getInvalidBill(invoice)) != null) {
            IssuedInvoiceWriteBackHelper.writeInvoiceCodeAndNo2OriginalBill(invoice, true, redPush);
            invalidBill.set("validstate", (Object)"2");
            invalidBill.set("confirmstate", (Object)"2");
            ImcSaveServiceHelper.update((DynamicObject)invalidBill);
            HashMap<String, DynamicObject> invalidBillMap = new HashMap<String, DynamicObject>();
            ReOpenInvoiceHelper.issueReOpenInvoice(invalidBill, invoice, invalidBillMap);
            return;
        }
        if (billInvRelations.length == 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u53f7\u7801\uff1a[%s]\u672a\u627e\u5230\u5173\u7cfb\u8868\u5173\u8054\u5173\u7cfb\uff0c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", invoiceOrRedInfo.getString("invoiceno")));
            }
            IssuedInvoiceWriteBackHelper.updateIssueWriteBackStatus(invoice, "-1", "\u672a\u627e\u5230\u5173\u7cfb\u8868\u5173\u8054\u5173\u7cfb\uff0c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355");
            return;
        }
        Object[] billIds = Stream.of(billInvRelations).map(relation -> relation.get("sbillid")).toArray();
        Map<Long, DynamicObject> billMap = IssuedInvoiceWriteBackHelper.getBillMapByBillIds(billIds);
        HashMap<String, DynamicObject> invalidBillMap = new HashMap<String, DynamicObject>();
        HashMap<Long, ArBillRelationExtensionDTO> arIssuedRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>(billIds.length);
        if (Stream.of(billInvRelations).anyMatch(relation -> relation.getLong("sdetailid") == 0L)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u901a\u8fc7\u624b\u5de5\u5904\u7406\u7f16\u8f91\u540e\u7684\u6570\u636e\u8fdb\u884c\u56de\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            IssuedInvoiceWriteBackHelper.writeBackSplitEdit(billMap, isValid, redPush, invoiceOrRedInfo);
        } else {
            ArrayList<DynamicObject> writeBackLogList = new ArrayList<DynamicObject>(billIds.length);
            Map<Long, List<DynamicObject>> relationMap = Stream.of(billInvRelations).collect(Collectors.groupingBy(k -> k.getLong("tdetailid")));
            Set<Map.Entry<Long, List<DynamicObject>>> entries = relationMap.entrySet();
            for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
                List<DynamicObject> relations = entry.getValue();
                block12: for (DynamicObject relation2 : relations) {
                    DynamicObject bill = billMap.get(relation2.getLong("sbillid"));
                    ReOpenInvoiceHelper.issueReOpenInvoice(bill, invoice, invalidBillMap);
                    DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
                    for (int i = 0; i < billItems.size(); ++i) {
                        DynamicObject billItem = (DynamicObject)billItems.get(i);
                        DynamicObject lastRow = null;
                        if (i != 0) {
                            lastRow = (DynamicObject)billItems.get(i - 1);
                        }
                        if (relation2.getLong("sdetailid") != billItem.getLong("id")) continue;
                        DynamicObject writeBackLog = IssuedInvoiceWriteBackHelper.createWriteBackLog(bill, invoiceOrRedInfo);
                        writeBackLog.set("param", (Object)IssuedInvoiceWriteBackHelper.writeItem(bill, billItem, relation2, isValid, redPush, invoiceOrRedInfo, arIssuedRelationMap, lastRow));
                        writeBackLogList.add(writeBackLog);
                        continue block12;
                    }
                }
            }
            try (TXHandle txHandle = TX.requiresNew();){
                ImcSaveServiceHelper.save(writeBackLogList);
            }
            catch (Exception e) {
                LOG.error("\u4fdd\u5b58\u5f00\u7968\u56de\u5199\u6570\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
        IssuedInvoiceWriteBackHelper.updateBillState(billMap.values().toArray(new DynamicObject[0]), invoice, isValid, redPush, arIssuedRelationMap);
        if (isValid) {
            ItemMerge2OneHelper.writeBackCancelInvoiceItemNumMerge2One(invoice);
        } else if (!ItemMerge2OneHelper.isUseNormalWriteBack(invoice)) {
            ItemMerge2OneHelper.issueWriteBack(invoice);
        }
    }

    private static void writeBackSplitEdit(Map<Long, DynamicObject> billMap, boolean isValid, boolean redPush, DynamicObject invoiceOrRedInfo) {
        Collection<DynamicObject> bills = billMap.values();
        ArrayList<DynamicObject> writeBackLogList = new ArrayList<DynamicObject>(bills.size());
        boolean positive = isValid == redPush;
        for (DynamicObject bill : bills) {
            DynamicObject writeBackLog = IssuedInvoiceWriteBackHelper.createWriteBackLog(bill, invoiceOrRedInfo);
            writeBackLog.set("param", (Object)"{\"desc\": \"\u5f00\u7968\u7533\u8bf7\u5355\u624b\u5de5\u5904\u7406\u589e\u5220\u884c\u5168\u989d\u56de\u5199\"}");
            writeBackLogList.add(writeBackLog);
            boolean isTax = "1".equals(bill.getString("hsbz"));
            bill.set("mainissuedamount", positive ? bill.get("invoiceamount") : BigDecimal.ZERO);
            bill.set("mainissuedtax", positive ? bill.get("totaltax") : BigDecimal.ZERO);
            bill.set("surplusamount", positive ? BigDecimal.ZERO : bill.get("invoiceamount"));
            bill.set("surplustax", positive ? BigDecimal.ZERO : bill.get("totaltax"));
            boolean noWriteBack = IssuedInvoiceWriteBackHelper.isNoWriteBack(isValid, redPush, invoiceOrRedInfo);
            if (!noWriteBack) {
                BigDecimal confirmAmount = bill.getBigDecimal(isTax ? "totalamount" : "invoiceamount");
                bill.set("confirmamount", (Object)(positive ? confirmAmount : BigDecimal.ZERO));
            } else if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u53f7\u7801\uff1a[%s]\u6570\u636e\u6765\u6e90\u7cfb\u7edf\u662f[%s]\uff0c\u7ea2\u51b2\u64cd\u4f5c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", invoiceOrRedInfo.getString("invoiceno"), invoiceOrRedInfo.getString("systemsource")));
            }
            DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items2) {
                if (!noWriteBack) {
                    item.set("remainvalidamount", positive ? BigDecimal.ZERO : item.get(isTax ? "taxamount" : "amount"));
                    item.set("remainvalidtax", positive ? BigDecimal.ZERO : item.get("tax"));
                    item.set("remainvalidnum", positive ? BigDecimal.ZERO : item.get("num"));
                }
                item.set("issuedamount", positive ? item.get("amount") : BigDecimal.ZERO);
                item.set("issuedtax", positive ? item.get("tax") : BigDecimal.ZERO);
                item.set("issuedtotaltaxamount", positive ? item.get("taxamount") : BigDecimal.ZERO);
                item.set("issuednum", positive ? item.get("num") : BigDecimal.ZERO);
                if (BigDecimalUtil.compareZero((BigDecimal)item.getBigDecimal("modelnumrate"))) continue;
                item.set("oriissuednum", (Object)(positive ? item.getBigDecimal("orinum") : BigDecimal.ZERO));
            }
        }
        try (TXHandle txHandle = TX.requiresNew();){
            ImcSaveServiceHelper.save(writeBackLogList);
        }
        catch (Exception e) {
            LOG.error("\u4fdd\u5b58\u5f00\u7968\u56de\u5199\u6570\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
    }

    private static String writeItem(DynamicObject bill, DynamicObject billItem, DynamicObject relation, boolean isValid, boolean redPush, DynamicObject invoiceOrRedInfo, Map<Long, ArBillRelationExtensionDTO> map, DynamicObject lastRow) {
        BigDecimal amount = relation.getBigDecimal("amount");
        BigDecimal tax = relation.getBigDecimal("tax");
        BigDecimal num = relation.getBigDecimal("num");
        if (isValid != redPush) {
            amount = amount.negate();
            tax = tax.negate();
            num = num.negate();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u5f00\u59cb\u53cd\u5199\u5f00\u7968\u7533\u8bf7\u5355\u660e\u7ec6\uff0c\u5f00\u7968\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7\u4e3a[%s], \u660e\u7ec6\u884c\u53f7\u662f[%s], \u660e\u7ec6\u5546\u54c1\u540d\u79f0\u662f[%s], \u91d1\u989d\u662f[%s], \u7a0e\u989d\u662f[%s], \u6570\u91cf\u662f[%s]", bill.getString("billno"), billItem.get("seq"), billItem.get("goodsname"), amount, tax, num));
        }
        JSONObject writeJson = new JSONObject();
        writeJson.put("sDetailId", (Object)relation.getLong("sdetailid"));
        writeJson.put("tDetailId", (Object)relation.getLong("tdetailid"));
        IssuedInvoiceWriteBackHelper.updateBefore(writeJson, billItem);
        if (BotpHelper.isFromAr((Object)bill.getString("systemsource"))) {
            IssuedInvoiceWriteBackHelper.addArIssuedRelation(bill, billItem, map, lastRow, amount, tax, num);
        }
        billItem.set("issuedamount", (Object)billItem.getBigDecimal("issuedamount").add(amount));
        billItem.set("issuedtax", (Object)billItem.getBigDecimal("issuedtax").add(tax));
        billItem.set("issuedtotaltaxamount", (Object)billItem.getBigDecimal("issuedamount").add(billItem.getBigDecimal("issuedtax")));
        billItem.set("issuednum", (Object)billItem.getBigDecimal("issuednum").add(num));
        IssuedInvoiceWriteBackHelper.updateAfter(writeJson, billItem);
        if (!MathUtils.isNullOrZero(billItem.getBigDecimal("modelnumrate"))) {
            BigDecimal taxAmount;
            BigDecimal oriissuedNum = billItem.getBigDecimal("oriissuednum");
            BigDecimal issuedTotalTaxAmount = billItem.getBigDecimal("issuedtotaltaxamount");
            oriissuedNum = issuedTotalTaxAmount.compareTo(taxAmount = billItem.getBigDecimal("taxamount")) == 0 ? billItem.getBigDecimal("orinum") : oriissuedNum.add(num.divide(billItem.getBigDecimal("modelnumrate"), 8, 4));
            billItem.set("oriissuednum", (Object)oriissuedNum);
        }
        IssuedInvoiceWriteBackHelper.writeBillIssued(bill, amount, tax);
        IssuedInvoiceWriteBackHelper.writeItemRemainValidAmount(bill, billItem, relation, isValid, redPush, invoiceOrRedInfo, writeJson);
        return writeJson.toJSONString();
    }

    private static void addArIssuedRelation(DynamicObject bill, DynamicObject billItem, Map<Long, ArBillRelationExtensionDTO> map, DynamicObject lastRow, BigDecimal amount, BigDecimal tax, BigDecimal num) {
        ArBillRelationExtensionDTO arBillRelation;
        String closeStatus = bill.getString("closestatus");
        boolean isClosed = "1".equals(closeStatus);
        String rowType = billItem.getString("rowtype");
        Long sDetailPk = billItem.getLong("id");
        if ("1".equals(rowType) && null != lastRow) {
            sDetailPk = lastRow.getLong("id");
        }
        if (null == (arBillRelation = map.get(sDetailPk))) {
            arBillRelation = new ArBillRelationExtensionDTO();
            map.put(sDetailPk, arBillRelation);
            if ("1".equals(rowType) && null != lastRow) {
                arBillRelation.setDeducatedRow(Boolean.valueOf(true));
            }
            arBillRelation.setsDetailId(sDetailPk);
        }
        arBillRelation.setsBillId(Long.valueOf(bill.getLong("id")));
        arBillRelation.setAmount(arBillRelation.getAmount().add(amount));
        arBillRelation.setTax(arBillRelation.getTax().add(tax));
        BigDecimal beforeRateNum = BotpHelper.getNumBeforeNumRate((BigDecimal)num, (DynamicObject)billItem);
        arBillRelation.setNum(arBillRelation.getNum().add(beforeRateNum));
        arBillRelation.setClosed(Boolean.valueOf(isClosed));
        arBillRelation.setFrom(Boolean.valueOf(CurrencyHelper.isFrom((Object)bill.getDynamicObject("fromcurr"))));
    }

    private static void writeItemRemainValidAmount(DynamicObject bill, DynamicObject billItem, DynamicObject relation, boolean isValid, boolean redPush, DynamicObject invoiceOrRedInfo, JSONObject writeJson) {
        if (!isValid && !redPush) {
            return;
        }
        BigDecimal amount = relation.getBigDecimal("amount");
        BigDecimal tax = relation.getBigDecimal("tax");
        BigDecimal num = relation.getBigDecimal("num");
        String zeroPushFlag = "1";
        if (isValid != redPush) {
            amount = amount.negate();
            tax = tax.negate();
            num = num.negate();
            zeroPushFlag = "0";
        }
        if (IssuedInvoiceWriteBackHelper.isNoWriteBack(isValid, redPush, invoiceOrRedInfo)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u53f7\u7801\uff1a[%s]\u6570\u636e\u6765\u6e90\u7cfb\u7edf\u662f[%s]\uff0c\u7ea2\u51b2\u64cd\u4f5c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", invoiceOrRedInfo.getString("invoiceno"), invoiceOrRedInfo.getString("systemsource")));
            }
            return;
        }
        if (!billItem.getBoolean("gift") && billItem.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) {
            billItem.set("zeropushflag", (Object)zeroPushFlag);
        }
        writeJson.put("beforeRemainValidAmount", (Object)billItem.getBigDecimal("remainvalidamount").setScale(2, 4));
        writeJson.put("beforeRemainValidTax", (Object)billItem.getBigDecimal("remainvalidtax").setScale(2, 4));
        writeJson.put("beforeRemainValidNum", (Object)billItem.getBigDecimal("remainvalidnum").stripTrailingZeros());
        billItem.set("remainvalidtax", (Object)billItem.getBigDecimal("remainvalidtax").subtract(tax));
        billItem.set("remainvalidnum", (Object)billItem.getBigDecimal("remainvalidnum").subtract(num));
        BigDecimal remainValidAmount = billItem.getBigDecimal("remainvalidamount").subtract(amount);
        BigDecimal confirmAmount = bill.getBigDecimal("confirmamount").add(amount);
        if ("1".equals(bill.getString("hsbz"))) {
            remainValidAmount = remainValidAmount.subtract(tax);
            confirmAmount = confirmAmount.add(tax);
        }
        billItem.set("remainvalidamount", (Object)remainValidAmount);
        bill.set("confirmamount", (Object)confirmAmount);
        BigDecimal taxDeviation = billItem.getBigDecimal("taxdeviation");
        billItem.set("remainvalidtax", (Object)billItem.getBigDecimal("remainvalidtax").add(taxDeviation));
        if (!"1".equals(bill.getString("hsbz"))) {
            billItem.set("remainvalidamount", (Object)billItem.getBigDecimal("remainvalidamount").subtract(taxDeviation));
        }
        billItem.set("taxdeviation", (Object)BigDecimal.ZERO);
        billItem.set("numdeviation", (Object)BigDecimal.ZERO);
        billItem.set("amountdeviation", (Object)BigDecimal.ZERO);
        bill.set("maintaxdeviation", (Object)bill.getBigDecimal("maintaxdeviation").subtract(taxDeviation));
        writeJson.put("afterRemainValidAmount", (Object)billItem.getBigDecimal("remainvalidamount").setScale(2, 4));
        writeJson.put("afterRemainValidTax", (Object)billItem.getBigDecimal("remainvalidtax").setScale(2, 4));
        writeJson.put("afterRemainValidNum", (Object)billItem.getBigDecimal("remainvalidnum").stripTrailingZeros());
    }

    private static Map<Long, DynamicObject> getBillMapByBillIds(Object[] billIds) {
        DynamicObject[] bills = IssuedInvoiceWriteBackHelper.loadOriginalBill(billIds, writeback_fields);
        return Stream.of(bills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
    }

    public static void fillInInvoiceWriteBack2OriginalBill(DynamicObject[] bills, FillInInvoiceResponseDTO response, String fillInBatchNo, boolean isCancelRelateInv) {
        HashMap<Long, DynamicObject> itemPkMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items2) {
                itemPkMap.put(item.getLong("id"), item);
            }
        }
        Map<String, List<ArBillRelationExtensionDTO>> relationMap = response.getRelationMap();
        HashMap<String, Map<Long, ArBillRelationExtensionDTO>> invoiceNoRelationMap = new HashMap<String, Map<Long, ArBillRelationExtensionDTO>>(bills.length);
        for (Map.Entry<String, List<ArBillRelationExtensionDTO>> entry : relationMap.entrySet()) {
            List<ArBillRelationExtensionDTO> relations = entry.getValue();
            String key = entry.getKey();
            HashMap<Long, ArBillRelationExtensionDTO> arIssuedRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>(relationMap.size());
            for (ArBillRelationExtensionDTO relation : relations) {
                Long sDetailId = relation.getsDetailId();
                DynamicObject item = (DynamicObject)itemPkMap.get(sDetailId);
                item.set("issuedtax", (Object)item.getBigDecimal("issuedtax").add(relation.getTax()));
                item.set("issuedamount", (Object)item.getBigDecimal("issuedamount").add(relation.getAmount()));
                BigDecimal issuedTaxAmount = relation.getTax().add(relation.getAmount());
                item.set("issuedtotaltaxamount", (Object)item.getBigDecimal("issuedtotaltaxamount").add(issuedTaxAmount));
                item.set("issuednum", item.get("num"));
                relation.setMergeLabel("1");
                arIssuedRelationMap.put(relation.getsDetailId(), relation);
            }
            for (DynamicObject bill : bills) {
                IssuedInvoiceWriteBackHelper.foreignCurrencyWriteBack(bill, arIssuedRelationMap);
            }
            invoiceNoRelationMap.put(key, arIssuedRelationMap);
        }
        if (isCancelRelateInv) {
            return;
        }
        for (DynamicObject bill : bills) {
            BigDecimal countItemTaxAmount = BigDecimal.ZERO;
            BigDecimal countItemTax = BigDecimal.ZERO;
            BigDecimal countItemAmount = BigDecimal.ZERO;
            BigDecimal countItemFromTaxAmount = BigDecimal.ZERO;
            BigDecimal countItemFromTax = BigDecimal.ZERO;
            DynamicObjectCollection items3 = bill.getDynamicObjectCollection("sim_original_bill_item");
            BigDecimal remainAmount = BigDecimal.ZERO;
            boolean isFrom = CurrencyHelper.isFrom((Object)bill.getDynamicObject("fromcurr"));
            for (DynamicObject item : items3) {
                BigDecimal issuedTaxAmount = item.getBigDecimal("issuedtotaltaxamount");
                BigDecimal issuedAmount = item.getBigDecimal("issuedamount");
                BigDecimal issuedTax = item.getBigDecimal("issuedtax");
                item.set("remainvalidnum", (Object)0);
                item.set("remainvalidamount", (Object)0);
                item.set("remainvalidtax", (Object)0);
                remainAmount = remainAmount.add(item.getBigDecimal("remainvalidamount"));
                BigDecimal issuedFromTax = item.getBigDecimal("fromissuedtax");
                BigDecimal issuedFromTaxAmount = item.getBigDecimal("fromissuedtaxamount");
                BigDecimal itemTax = item.getBigDecimal("tax");
                BigDecimal itemAmount = item.getBigDecimal("amount");
                BigDecimal itemFromTax = item.getBigDecimal("fromtax");
                item.set("taxdeviation", (Object)itemTax.subtract(issuedTax));
                item.set("amountdeviation", (Object)itemAmount.subtract(issuedAmount));
                item.set("fromtaxdeviation", (Object)itemFromTax.subtract(issuedFromTax));
                countItemTaxAmount = countItemTaxAmount.add(issuedTaxAmount);
                countItemTax = countItemTax.add(issuedTax);
                countItemAmount = countItemAmount.add(issuedAmount);
                countItemFromTaxAmount = countItemFromTaxAmount.add(issuedFromTaxAmount);
                countItemFromTax = countItemFromTax.add(issuedFromTax);
            }
            String hsbz = bill.getString("hsbz");
            BigDecimal totalAmount = bill.getBigDecimal("totalamount");
            BigDecimal totalDeviation = totalAmount.subtract(countItemTaxAmount);
            BigDecimal invoiceAmount = bill.getBigDecimal("invoiceamount");
            if ("1".equals(hsbz)) {
                bill.set("confirmamount", (Object)totalAmount);
            } else {
                bill.set("confirmamount", (Object)invoiceAmount);
            }
            BigDecimal totalTax = bill.getBigDecimal("totaltax");
            BigDecimal totalFromTaxAmount = bill.getBigDecimal("foreigntotalamount");
            BigDecimal totalFromTax = bill.getBigDecimal("foreigntax");
            if (isFrom) {
                bill.set("foreigntotaldifference", (Object)totalFromTaxAmount.subtract(countItemFromTaxAmount));
                bill.set("foreigntaxdifference", (Object)totalFromTax.subtract(countItemFromTax));
            }
            BigDecimal totalTaxDeviation = totalTax.subtract(countItemTax);
            bill.set("totalamountdeviation", (Object)totalDeviation);
            bill.set("maintaxdeviation", (Object)totalTaxDeviation);
            bill.set("mainissuedamount", (Object)countItemAmount);
            bill.set("mainissuedtax", (Object)countItemTax);
            bill.set("surplusamount", (Object)BigDecimal.ZERO);
            bill.set("surplustax", (Object)BigDecimal.ZERO);
        }
        IssuedInvoiceWriteBackHelper.saveRelation(invoiceNoRelationMap, fillInBatchNo, "3");
    }

    public static void saveRelation(Map<String, Map<Long, ArBillRelationExtensionDTO>> invoiceNoRelationMap, String fillInBatchNo) {
        IssuedInvoiceWriteBackHelper.saveRelation(invoiceNoRelationMap, fillInBatchNo, "2");
    }

    public static void saveRelation(Map<String, Map<Long, ArBillRelationExtensionDTO>> invoiceNoRelationMap, String fillInBatchNo, String business) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        for (Map.Entry<String, Map<Long, ArBillRelationExtensionDTO>> entry : invoiceNoRelationMap.entrySet()) {
            String invoiceCodeNo = entry.getKey();
            Map<Long, ArBillRelationExtensionDTO> relationMap = entry.getValue();
            Collection<ArBillRelationExtensionDTO> values = relationMap.values();
            String mergeKey = BotpHelper.getFillInMergeKey((String)invoiceCodeNo, (String)fillInBatchNo);
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"invsm_botp_callback_log");
            log.set("createtime", (Object)new Date());
            log.set("business", (Object)business);
            log.set("param_tag", (Object)JSONObject.toJSONString(values));
            log.set("invoiceno", (Object)mergeKey);
            logs.add(log);
        }
        ImcSaveServiceHelper.save(logs);
    }

    public static void cancelFillInInvoice(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
            String hsbz = bill.getString("hsbz");
            boolean isIncludeTax = "1".equals(hsbz);
            for (DynamicObject item : items2) {
                item.set("issuedtax", (Object)BigDecimal.ZERO);
                item.set("issuedamount", (Object)BigDecimal.ZERO);
                item.set("issuedtotaltaxamount", (Object)BigDecimal.ZERO);
                item.set("issuednum", (Object)BigDecimal.ZERO);
                item.set("fromissuedamount", (Object)BigDecimal.ZERO);
                item.set("fromissuedtax", (Object)BigDecimal.ZERO);
                item.set("fromissuedtaxamount", (Object)BigDecimal.ZERO);
                item.set("taxdeviation", (Object)BigDecimal.ZERO);
                item.set("amountdeviation", (Object)BigDecimal.ZERO);
                item.set("fromtaxdeviation", (Object)BigDecimal.ZERO);
                item.set("remainvalidtax", item.get("tax"));
                if (isIncludeTax) {
                    item.set("remainvalidamount", item.get("taxamount"));
                    item.set("remainvalidnum", item.get("num"));
                    continue;
                }
                item.set("remainvalidamount", item.get("amount"));
                item.set("remainvalidnum", item.get("num"));
            }
            bill.set("foreigntotaldifference", (Object)BigDecimal.ZERO);
            bill.set("foreigntaxdifference", (Object)BigDecimal.ZERO);
            bill.set("totalamountdeviation", (Object)BigDecimal.ZERO);
            bill.set("maintaxdeviation", (Object)BigDecimal.ZERO);
            bill.set("mainissuedamount", (Object)BigDecimal.ZERO);
            bill.set("mainissuedtax", (Object)BigDecimal.ZERO);
            bill.set("foreignissuedamount", (Object)BigDecimal.ZERO);
            bill.set("foreignissuedtotalamount", (Object)BigDecimal.ZERO);
            bill.set("foreignissuedtax", (Object)BigDecimal.ZERO);
            bill.set("confirmamount", (Object)BigDecimal.ZERO);
            bill.set("surplusamount", bill.get("invoiceamount"));
            bill.set("surplustax", bill.get("totaltax"));
            bill.set("confirmstate", (Object)"0");
            bill.set("validstate", (Object)"0");
            bill.set("issuetime", null);
        }
    }

    public static Map<String, Map<Long, ArBillRelationExtensionDTO>> getInvoiceNoRelationMap(DynamicObject[] bills, FillInInvoiceResponseDTO response) {
        HashMap<String, Map<Long, ArBillRelationExtensionDTO>> invoiceNoRelationMap = new HashMap<String, Map<Long, ArBillRelationExtensionDTO>>(bills.length);
        Map<String, List<ArBillRelationExtensionDTO>> relationMap = response.getRelationMap();
        for (Map.Entry<String, List<ArBillRelationExtensionDTO>> entry : relationMap.entrySet()) {
            List<ArBillRelationExtensionDTO> relations = entry.getValue();
            String key = entry.getKey();
            HashMap<Long, ArBillRelationExtensionDTO> arIssuedRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>(relationMap.size());
            for (ArBillRelationExtensionDTO relation : relations) {
                arIssuedRelationMap.put(relation.getsDetailId(), relation);
                relation.setTax(relation.getTax().negate());
                relation.setAmount(relation.getAmount().negate());
                relation.setFromTaxAmount(relation.getFromTaxAmount().negate());
                relation.setFromTax(relation.getFromTax().negate());
                relation.setFromAmount(relation.getFromAmount().negate());
                relation.setNum(relation.getNum().negate());
                relation.setMergeLabel("1");
            }
            invoiceNoRelationMap.put(key, arIssuedRelationMap);
        }
        return invoiceNoRelationMap;
    }
}

