/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice.writeback;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.issueinvoice.writeback.AbstractIssueInvoiceWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.InvalidInvoiceWriteBackHelper;
import org.apache.commons.lang3.tuple.Triple;

public class MatchBillWriteBackHelper
extends AbstractIssueInvoiceWriteBackHelper {
    private static final Log LOG = LogFactory.getLog(InvalidInvoiceWriteBackHelper.class);

    static void issueWriteback(DynamicObject invoice, DynamicObject invoiceOrRedconfirm) {
        DynamicObject[] bills;
        ArrayList<DynamicObject> writeBackLogList = new ArrayList<DynamicObject>(4);
        DynamicObject[] invRelations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_match_inv_relation"), (QFilter[])new QFilter("tbillid", "=", invoiceOrRedconfirm.getPkValue()).toArray());
        Map<Object, List<DynamicObject>> relationMap = Arrays.stream(invRelations).collect(Collectors.groupingBy(relation -> relation.get("tdetailid")));
        HashMap<Object, Triple> matchBillAmountMap = new HashMap<Object, Triple>(invRelations.length);
        DynamicObjectCollection redConfirmItems = invoiceOrRedconfirm.getDynamicObjectCollection("items");
        boolean isManualedInvOrConfirm = false;
        if (invRelations.length > 0) {
            String matchTarget = invRelations[0].getString("matchtarget");
            isManualedInvOrConfirm = "2".equals(matchTarget) || "3".equals(matchTarget);
        }
        for (DynamicObject redConfirmItem : redConfirmItems) {
            List<DynamicObject> relations = relationMap.get(redConfirmItem.getPkValue());
            if (null == relations) continue;
            for (DynamicObject relation2 : relations) {
                Triple amountTriple = matchBillAmountMap.computeIfAbsent(relation2.getLong("sdetailid"), k -> Triple.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                Triple newTriple = Triple.of((Object)((BigDecimal)amountTriple.getLeft()).add(redConfirmItem.getBigDecimal("amount")), (Object)((BigDecimal)amountTriple.getMiddle()).add(redConfirmItem.getBigDecimal("tax")), (Object)((BigDecimal)amountTriple.getRight()).add(redConfirmItem.getBigDecimal("num")));
                matchBillAmountMap.put(relation2.getLong("sdetailid"), newTriple);
            }
        }
        Set<Long> matchBillIdSet = Arrays.stream(invRelations).map(o -> o.getLong("sbillid")).collect(Collectors.toSet());
        DynamicObject matchBill = MatchBillWriteBackHelper.updateMatchBillIssueStatus(matchBillIdSet, invoiceOrRedconfirm);
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_matchbill_relation"), (QFilter[])new QFilter("tbillid", "in", (Object)Arrays.stream(invRelations).map(relation -> relation.get("sbillid")).toArray()).toArray());
        ArrayList<Long> pkList = new ArrayList<Long>(billRelations.length);
        Set<Object> billIdArr = isManualedInvOrConfirm ? Arrays.stream(billRelations).map(relation -> relation.get("sbillid")).collect(Collectors.toSet()) : Arrays.stream(billRelations).filter(relation -> matchBillAmountMap.containsKey(relation.get("tdetailid"))).map(relation -> relation.get("sbillid")).collect(Collectors.toSet());
        billIdArr.forEach(obj -> pkList.add(BigDecimalUtil.transDecimal((Object)obj).longValue()));
        HashMap<Object, DynamicObject> billItemIdMaps = new HashMap<Object, DynamicObject>(billRelations.length);
        HashMap<Object, DynamicObject> itemId2Bill = new HashMap<Object, DynamicObject>(billRelations.length);
        for (DynamicObject bill : bills = MatchBillWriteBackHelper.loadOriginalBill(pkList, writeback_fields)) {
            DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject billItem : billItems) {
                billItemIdMaps.put(billItem.getPkValue(), billItem);
                itemId2Bill.put(billItem.getPkValue(), bill);
            }
        }
        Map<Object, List<DynamicObject>> matchItemId2BillItemIdMap = Arrays.stream(billRelations).filter(relation -> matchBillAmountMap.containsKey(relation.get("tdetailid"))).collect(Collectors.groupingBy(relation -> relation.get("tdetailid")));
        Set entries = matchBillAmountMap.entrySet();
        DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((Object)invoiceOrRedconfirm.getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_confirm_bill"));
        HashMap<Long, ArBillRelationExtensionDTO> arIssuedRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>(8);
        if (isManualedInvOrConfirm) {
            matchItemId2BillItemIdMap = Arrays.stream(billRelations).collect(Collectors.groupingBy(relation -> relation.get("tdetailid")));
            if (null != matchBill) {
                DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                BigDecimal totalAmount = redConfirm.getBigDecimal("totalamount");
                BigDecimal matchBillTotalAmount = matchBill.getBigDecimal("applytotalamount");
                BigDecimal issueProportion = totalAmount.divide(matchBillTotalAmount, 8, RoundingMode.HALF_UP);
                for (DynamicObject item : items2) {
                    long itemPk = item.getLong("id");
                    List<DynamicObject> billItems = matchItemId2BillItemIdMap.get(itemPk);
                    for (DynamicObject bill2MatchBillRelation : billItems) {
                        DynamicObject bill = (DynamicObject)itemId2Bill.get(bill2MatchBillRelation.getLong("sdetailid"));
                        DynamicObject billItem = (DynamicObject)billItemIdMaps.get(bill2MatchBillRelation.getLong("sdetailid"));
                        DynamicObject writeBackLog = MatchBillWriteBackHelper.createWriteBackLog(bill, invoice);
                        JSONObject writeJson = new JSONObject();
                        writeJson.put("sDetailId", (Object)billItem.getLong("id"));
                        writeJson.put("desc", (Object)"\u8d1f\u6570\u5339\u84dd\u7968\u56de\u5199");
                        MatchBillWriteBackHelper.updateBefore(writeJson, billItem);
                        BigDecimal issuedAmount = billItem.getBigDecimal("amount").multiply(issueProportion).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal issuedTax = billItem.getBigDecimal("tax").multiply(issueProportion).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal issuedNum = billItem.getBigDecimal("num").multiply(issueProportion).setScale(2, RoundingMode.HALF_UP);
                        billItem.set("issuedamount", (Object)billItem.getBigDecimal("issuedamount").add(issuedAmount));
                        billItem.set("issuedtax", (Object)billItem.getBigDecimal("issuedtax").add(issuedTax));
                        billItem.set("issuednum", (Object)billItem.getBigDecimal("issuednum").add(issuedNum));
                        billItem.set("issuedtotaltaxamount", (Object)billItem.getBigDecimal("issuedamount").add(billItem.getBigDecimal("issuedtax")));
                        MatchBillWriteBackHelper.updateAfter(writeJson, billItem);
                        writeBackLog.set("param", (Object)writeJson.toJSONString());
                        writeBackLogList.add(writeBackLog);
                        MatchBillWriteBackHelper.writeBillIssued(bill, issuedAmount, issuedTax);
                        if (!BotpHelper.isFromAr((Object)bill.getString("systemsource"))) continue;
                        MatchBillWriteBackHelper.addArIssuedRelation(bill, billItem, arIssuedRelationMap, issuedAmount, issuedTax, issuedNum);
                    }
                }
            }
        } else {
            for (Map.Entry entry : entries) {
                Triple issueTriple = (Triple)entry.getValue();
                if (((BigDecimal)issueTriple.getLeft()).compareTo(BigDecimal.ZERO) == 0) continue;
                List<DynamicObject> billItemIds = matchItemId2BillItemIdMap.get(entry.getKey());
                for (DynamicObject relation3 : billItemIds) {
                    BigDecimal num;
                    BigDecimal tax;
                    BigDecimal amount;
                    DynamicObject billItem = (DynamicObject)billItemIdMaps.get(relation3.get("sdetailid"));
                    BigDecimal remainIssuedAmount = billItem.getBigDecimal("amount").subtract(billItem.getBigDecimal("issuedamount"));
                    if (remainIssuedAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                    DynamicObject bill = (DynamicObject)itemId2Bill.get(billItem.getPkValue());
                    DynamicObject writeBackLog = MatchBillWriteBackHelper.createWriteBackLog(bill, invoice);
                    JSONObject writeJson = new JSONObject();
                    writeJson.put("sDetailId", (Object)relation3.getLong("sdetailid"));
                    writeJson.put("desc", (Object)"\u8d1f\u6570\u5339\u84dd\u7968\u56de\u5199");
                    MatchBillWriteBackHelper.updateBefore(writeJson, billItem);
                    if (remainIssuedAmount.abs().compareTo(((BigDecimal)issueTriple.getLeft()).abs()) < 0) {
                        BigDecimal remainIssuedTax;
                        amount = remainIssuedAmount;
                        BigDecimal remainIssuedNum = billItem.getBigDecimal("num").subtract(billItem.getBigDecimal("issuednum"));
                        tax = remainIssuedTax = billItem.getBigDecimal("tax").subtract(billItem.getBigDecimal("issuedtax"));
                        num = remainIssuedNum;
                        issueTriple = Triple.of((Object)((BigDecimal)issueTriple.getLeft()).subtract(remainIssuedAmount), (Object)((BigDecimal)issueTriple.getMiddle()).subtract(remainIssuedTax), (Object)((BigDecimal)issueTriple.getRight()).subtract(remainIssuedNum));
                    } else {
                        amount = (BigDecimal)issueTriple.getLeft();
                        tax = (BigDecimal)issueTriple.getMiddle();
                        num = (BigDecimal)issueTriple.getRight();
                    }
                    billItem.set("issuedamount", (Object)billItem.getBigDecimal("issuedamount").add(amount));
                    billItem.set("issuedtax", (Object)billItem.getBigDecimal("issuedtax").add(tax));
                    billItem.set("issuednum", (Object)billItem.getBigDecimal("issuednum").add(num));
                    billItem.set("issuedtotaltaxamount", (Object)billItem.getBigDecimal("issuedamount").add(billItem.getBigDecimal("issuedtax")));
                    MatchBillWriteBackHelper.updateAfter(writeJson, billItem);
                    if (BotpHelper.isFromAr((Object)bill.getString("systemsource"))) {
                        MatchBillWriteBackHelper.addArIssuedRelation(bill, billItem, arIssuedRelationMap, amount, tax, num);
                    }
                    writeBackLog.set("param", (Object)writeJson.toJSONString());
                    writeBackLogList.add(writeBackLog);
                    MatchBillWriteBackHelper.writeBillIssued(bill, amount, tax);
                }
            }
        }
        try {
            TXHandle txHandle = TX.requiresNew();
            Object object = null;
            try {
                ImcSaveServiceHelper.save(writeBackLogList);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (txHandle != null) {
                    if (object != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("\u4fdd\u5b58\u5f00\u7968\u56de\u5199\u6570\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        MatchBillWriteBackHelper.updateBillState(bills, invoice, false, false, arIssuedRelationMap);
    }

    private static void addArIssuedRelation(DynamicObject bill, DynamicObject billItem, Map<Long, ArBillRelationExtensionDTO> map, BigDecimal amount, BigDecimal tax, BigDecimal num) {
        ArBillRelationExtensionDTO arBillRelation;
        String closeStatus = bill.getString("closestatus");
        boolean isClosed = "1".equals(closeStatus);
        String rowType = billItem.getString("rowtype");
        DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
        DynamicObject lastRow = null;
        for (int i = 0; i < items2.size(); ++i) {
            DynamicObject currentItem = (DynamicObject)items2.get(i);
            if (billItem.getPkValue() != currentItem.getPkValue() || i == 0) continue;
            lastRow = (DynamicObject)items2.get(i - 1);
            break;
        }
        Long sDetailPk = billItem.getLong("id");
        if ("1".equals(rowType) && null != lastRow) {
            sDetailPk = lastRow.getLong("id");
        }
        if (null == (arBillRelation = map.get(sDetailPk))) {
            arBillRelation = new ArBillRelationExtensionDTO();
            map.put(sDetailPk, arBillRelation);
            if ("1".equals(rowType) && null != lastRow) {
                arBillRelation.setDeducatedRow(Boolean.valueOf(true));
            }
            arBillRelation.setsDetailId(sDetailPk);
        }
        arBillRelation.setsBillId(Long.valueOf(bill.getLong("id")));
        arBillRelation.setAmount(arBillRelation.getAmount().add(amount));
        arBillRelation.setTax(arBillRelation.getTax().add(tax));
        BigDecimal beforeRateNum = BotpHelper.getNumBeforeNumRate((BigDecimal)num, (DynamicObject)billItem);
        arBillRelation.setNum(arBillRelation.getNum().add(beforeRateNum));
        arBillRelation.setClosed(Boolean.valueOf(isClosed));
        arBillRelation.setFrom(Boolean.valueOf(CurrencyHelper.isFrom((Object)bill.getDynamicObject("fromcurr"))));
    }

    private static DynamicObject updateMatchBillIssueStatus(Set<Long> matchBillIdSet, DynamicObject invoiceOrRedconfirm) {
        long redConfirmPk = invoiceOrRedconfirm.getLong("id");
        DynamicObject[] matchBills = BusinessDataServiceHelper.load((Object[])matchBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        if (matchBills.length > 0) {
            for (DynamicObject matchBill : matchBills) {
                DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items2) {
                    DynamicObjectCollection matchItems = item.getDynamicObjectCollection("confirmsubentryentity");
                    for (DynamicObject matchItem : matchItems) {
                        if (matchItem.getLong("redconfirmpk") != redConfirmPk) continue;
                        matchItem.set("confirmissuestatus", (Object)"0");
                    }
                }
            }
            ImcSaveServiceHelper.save((DynamicObject[])matchBills);
            return matchBills[0];
        }
        return null;
    }
}

