/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;

public class ImcPushInvoiceToIsmcService {
    private static final Log LOGGER = LogFactory.getLog(ImcPushInvoiceToIsmcService.class);

    public static void excuseUploadInvoiceToIsmcTask() {
        try {
            DynamicObject[] unUploadISMCInvoiceList = ImcPushInvoiceToIsmcService.queryUnUploadIsmcInvoiceList();
            if (unUploadISMCInvoiceList.length > 0) {
                LOGGER.info("ImcPushInvoiceToIsmcService \u6700\u8fd12\u5c0f\u65f6,\u6ca1\u6709\u6210\u529f\u4e0a\u4f20\u7a0e\u63a7\u7cfb\u7edf\u4e91\u7684\u53d1\u7968_size\uff1a", (Object)unUploadISMCInvoiceList.length);
                for (DynamicObject invoiceDynamicObject : unUploadISMCInvoiceList) {
                    ImcPushInvoiceToIsmcService.componentInvoicePushToISMCRequest(invoiceDynamicObject, true);
                }
            }
            LOGGER.info("ImcPushInvoiceToIsmcService \u6700\u8fd12\u5c0f\u65f6, \u6ca1\u6709\u6210\u529f\u4e0a\u4f20\u7a0e\u63a7\u7cfb\u7edf\u4e91\u7684\u53d1\u7968 \u6279\u91cf\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("ImcPushInvoiceToIsmcService \u7ec4\u4ef6\u5f00\u7968\u5f02\u6b65\u4e0a\u4f20\u7a0e\u63a7\u7cfb\u7edf\u4e91\u53d1\u7968\u5931\u8d25", (Throwable)e);
        }
    }

    private static DynamicObject[] queryUnUploadIsmcInvoiceList() {
        QFilter qFilter = new QFilter("uploadismcstatus", "=", (Object)"0");
        qFilter.and("buyertype", "!=", (Object)"8");
        qFilter.and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        int defaultHour = -2;
        if (StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SYNC_ISMC_HOUR))) {
            try {
                defaultHour = Integer.parseInt(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SYNC_ISMC_HOUR));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        qFilter.and("createtime", ">=", (Object)DateUtils.addHour((Date)new Date(), (int)defaultHour));
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])qFilter.toArray());
    }

    public static void componentInvoicePushToISMCRequest(DynamicObject invoiceDynamicObject, boolean isCreatePDF) {
        try {
            if ("2".equals(invoiceDynamicObject.getString("uploadismcstatus"))) {
                return;
            }
            if (invoiceDynamicObject.get("orgid") instanceof DynamicObject) {
                invoiceDynamicObject.set("orgid", invoiceDynamicObject.getDynamicObject("orgid").get("id"));
            }
            if (StringUtils.isEmpty((CharSequence)invoiceDynamicObject.getString("taxedtype"))) {
                invoiceDynamicObject.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
            }
            HashMap requestParam = Maps.newHashMapWithExpectedSize((int)2);
            requestParam.put("invoiceList", Collections.singletonList(invoiceDynamicObject));
            requestParam.put("isCreatePDF", isCreatePDF);
            MsgResponse msgResponse = RequestUtils.doRequest((String)invoiceDynamicObject.getString("orderno"), (String)"SimSyncVatInvoice", (Object)requestParam);
            if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
                LOGGER.info("ImcPushInvoiceToIsmcService success: " + invoiceDynamicObject.getString("invoiceno"));
                invoiceDynamicObject.set("uploadismcstatus", (Object)"1");
                SaveServiceHelper.update((DynamicObject)invoiceDynamicObject);
            }
        }
        catch (Exception e) {
            LOGGER.error("ImcPushInvoiceToIsmcService Exception", (Throwable)e);
        }
    }
}

