/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.file;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.AwsFpyConstant;
import kd.imc.bdm.common.dto.aws.AwsConfigDTO;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.sim.common.service.file.InvoiceFileUploadService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceFileUploadS3Service
extends InvoiceFileUploadService {
    private static final Log log = LogFactory.getLog(InvoiceFileUploadS3Service.class);

    @Override
    public Pair<String, String> upload(byte[] fileBytes, String localUrl, String orgTaxNo, String type, String fileName, boolean testFlag, String remoteUrl) {
        try {
            String keyPrefix = testFlag ? "simeinvtest" : "simeinv";
            AwsFpyService awsFpyService = AwsFpyService.newInstance();
            String accessToken = this.getAccessToken(awsFpyService, orgTaxNo);
            if (StringUtils.isNotEmpty((CharSequence)remoteUrl)) {
                this.deleteS3(awsFpyService, remoteUrl, accessToken);
            }
            String url = awsFpyService.getBaseUrl() + AwsFpyConstant.getUrl((String)type) + "?keyPrefix=" + keyPrefix + "&access_token=" + accessToken;
            if (log.isInfoEnabled()) {
                log.info(String.format("\u4e0a\u4f20S3\u5f00\u59cb\uff0c\u8bf7\u6c42\u5730\u5740:[%s]", url));
            }
            JSONObject jsonObject = HttpUtil.uploadInvoiceFile2S3((String)url, (String)awsFpyService.getProxy(), (InputStream)new ByteArrayInputStream(fileBytes), (String)fileName);
            String snapShotUrl = "";
            JSONArray snapshotPreUrls = jsonObject.getJSONArray("snapshotPreUrls");
            if (snapshotPreUrls != null && snapshotPreUrls.size() > 0) {
                snapShotUrl = snapshotPreUrls.getString(0);
            }
            return Pair.of((Object)jsonObject.getString("storageUrl"), (Object)snapShotUrl);
        }
        catch (Exception e) {
            log.error(String.format("\u4e0a\u4f20S3\u5931\u8d25\uff0c\u4f01\u4e1a\u7a0e\u53f7[%s]\uff0c\u53d1\u7968\u6570\u636e[%s]", orgTaxNo, fileName), (Throwable)e);
            return Pair.of((Object)"", (Object)"");
        }
    }

    private String getAccessToken(AwsFpyService awsFpyService, String orgTaxNo) throws IOException {
        String key = "bdm_aws_fpy_token_" + orgTaxNo;
        String accessToken = CacheHelper.get((String)key);
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            return accessToken;
        }
        AwsConfigDTO awsConfig = AwsFpyService.getAwsConfigByTaxNo((Object)orgTaxNo);
        accessToken = awsFpyService.getAccessToken(awsConfig.getClientId(), awsConfig.getClientSecret());
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            CacheHelper.put((String)key, (String)accessToken, (int)1800);
        }
        return accessToken;
    }

    private void deleteS3(AwsFpyService awsFpyService, String fileUrl, String accessToken) {
        try {
            String awsUrl = awsFpyService.getBaseUrl() + "s3_file_delete" + "?access_token=" + accessToken + "&url=" + fileUrl;
            log.info(String.format("\u5220\u9664S3\u6587\u4ef6\u5f00\u59cb\uff0c\u8bf7\u6c42\u5730\u5740:[%s]", awsUrl));
            String deleteResp = HttpUtil.doGet((String)awsUrl, (String)awsFpyService.getProxy(), null, null);
            log.info(String.format("\u5220\u9664S3\u6587\u4ef6\u7ed3\u675f\uff0c\u7ed3\u679c:[%s]", deleteResp));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

