/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.invoice.ReduceOnePoint5Helper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.dto.FillInInvoiceDTO;
import kd.imc.sim.common.dto.FillInInvoiceRequestDTO;
import kd.imc.sim.common.dto.FillInInvoiceResponseDTO;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.FillInInvoiceService;
import org.apache.commons.lang3.tuple.MutableTriple;

public class InvoiceFillinServiceImpl
implements FillInInvoiceService {
    @Override
    public boolean support(FillInInvoiceRequestDTO request) {
        return true;
    }

    @Override
    public FillInInvoiceResponseDTO fillInInvoice2Original(FillInInvoiceRequestDTO request) {
        List<FillInInvoiceDTO> invs = request.getInvs();
        List<DynamicObject> bills = request.getBills();
        HashMap<String, List<ArBillRelationExtensionDTO>> relationMap = new HashMap<String, List<ArBillRelationExtensionDTO>>();
        boolean isEqualsTotalAmount = this.isEqualsTotalAmount(request);
        for (FillInInvoiceDTO inv : invs) {
            this.allocateBillAmount(bills, inv, relationMap, isEqualsTotalAmount);
        }
        if ("1".equals(ImcConfigUtil.getValue((String)"fillInInvoice2Original", (String)"adjustDifference"))) {
            this.adjustDifference(invs, relationMap);
        }
        FillInInvoiceResponseDTO response = new FillInInvoiceResponseDTO();
        response.setRelationMap(relationMap);
        return response;
    }

    private void adjustDifference(List<FillInInvoiceDTO> invs, Map<String, List<ArBillRelationExtensionDTO>> relationMap) {
        MutableTriple triple;
        String invoiceNo;
        ArrayList<ArBillRelationExtensionDTO> invoiceNoRelations;
        HashMap<String, MutableTriple> matchBillAmountMap = new HashMap<String, MutableTriple>(relationMap.size());
        HashMap<String, ArrayList<ArBillRelationExtensionDTO>> invoiceNoRelationMap = new HashMap<String, ArrayList<ArBillRelationExtensionDTO>>();
        for (Map.Entry<String, List<ArBillRelationExtensionDTO>> entry : relationMap.entrySet()) {
            List<ArBillRelationExtensionDTO> relations = entry.getValue();
            for (ArBillRelationExtensionDTO relation : relations) {
                String invoiceNo2 = relation.getInvoiceNo();
                MutableTriple triple2 = (MutableTriple)matchBillAmountMap.get(invoiceNo2);
                if (null == triple2) {
                    triple2 = new MutableTriple((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO);
                    matchBillAmountMap.put(invoiceNo2, triple2);
                }
                triple2.setLeft((Object)((BigDecimal)triple2.getLeft()).add(relation.getAmount()));
                triple2.setMiddle((Object)((BigDecimal)triple2.getMiddle()).add(relation.getTax()));
                triple2.setRight((Object)((BigDecimal)triple2.getRight()).add(relation.getNum()));
                invoiceNoRelations = (List)invoiceNoRelationMap.get(invoiceNo2);
                if (null == invoiceNoRelations) {
                    invoiceNoRelations = new ArrayList<ArBillRelationExtensionDTO>();
                    invoiceNoRelationMap.put(invoiceNo2, invoiceNoRelations);
                }
                invoiceNoRelations.add(relation);
            }
        }
        for (FillInInvoiceDTO fillInInvoiceDTO : invs) {
            invoiceNo = fillInInvoiceDTO.getInvoiceNo();
            triple = (MutableTriple)matchBillAmountMap.get(invoiceNo);
            if (null == triple) continue;
            triple.setLeft((Object)((BigDecimal)triple.getLeft()).subtract(fillInInvoiceDTO.getInvoiceAmount()));
            triple.setMiddle((Object)((BigDecimal)triple.getMiddle()).subtract(fillInInvoiceDTO.getTotalTax()));
        }
        for (Map.Entry entry : matchBillAmountMap.entrySet()) {
            invoiceNo = (String)entry.getKey();
            triple = (MutableTriple)entry.getValue();
            if (BigDecimalUtil.compareZero((BigDecimal)((BigDecimal)triple.getLeft()))) continue;
            BigDecimal amountAdded = (BigDecimal)triple.getLeft();
            BigDecimal copyAmountAdded = new BigDecimal(amountAdded.toPlainString());
            BigDecimal oneItemAmountDifference = BigDecimalUtil.greaterZero((BigDecimal)amountAdded) ? new BigDecimal("0.01") : new BigDecimal("0.01").negate();
            block4: while (!BigDecimalUtil.compareZero((BigDecimal)copyAmountAdded)) {
                invoiceNoRelations = (ArrayList<ArBillRelationExtensionDTO>)invoiceNoRelationMap.get(invoiceNo);
                for (ArBillRelationExtensionDTO relation : invoiceNoRelations) {
                    relation.setAmount(relation.getAmount().subtract(oneItemAmountDifference));
                    relation.setTax(relation.getTax().add(oneItemAmountDifference));
                    if (!BigDecimalUtil.compareZero((BigDecimal)(copyAmountAdded = copyAmountAdded.subtract(oneItemAmountDifference)))) continue;
                    continue block4;
                }
            }
        }
    }

    private boolean isEqualsTotalAmount(FillInInvoiceRequestDTO request) {
        List<FillInInvoiceDTO> invs = request.getInvs();
        List<DynamicObject> bills = request.getBills();
        BigDecimal allInvTotalAmount = BigDecimal.ZERO;
        BigDecimal allBillTotalAmount = BigDecimal.ZERO;
        for (FillInInvoiceDTO inv : invs) {
            allInvTotalAmount = allInvTotalAmount.add(inv.getTotalAmount());
        }
        for (DynamicObject bill : bills) {
            allBillTotalAmount = allBillTotalAmount.add(bill.getBigDecimal("totalamount"));
        }
        return allInvTotalAmount.compareTo(allBillTotalAmount) == 0 && invs.size() == 1;
    }

    private void allocateBillAmount(List<DynamicObject> bills, FillInInvoiceDTO inv, Map<String, List<ArBillRelationExtensionDTO>> relationMap, boolean isEqualsTotalAmount) {
        BigDecimal invTotalAmount;
        BigDecimal remainAmount = invTotalAmount = inv.getTotalAmount();
        BigDecimal allTotalAmount = BigDecimal.ZERO;
        for (DynamicObject bill : bills) {
            BigDecimal totalAmount = bill.getBigDecimal("totalamount");
            allTotalAmount = allTotalAmount.add(totalAmount);
        }
        int size = bills.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject bill = bills.get(i);
            BigDecimal totalAmount = bill.getBigDecimal("totalamount");
            BigDecimal currentBillFilledTotalAmount = i == size - 1 ? remainAmount : totalAmount.divide(allTotalAmount, 40, RoundingMode.HALF_UP).multiply(invTotalAmount).setScale(2, RoundingMode.HALF_UP);
            remainAmount = remainAmount.subtract(currentBillFilledTotalAmount);
            String invoiceCode = inv.getInvoiceCode() == null ? "" : inv.getInvoiceCode();
            String invoiceNo = inv.getInvoiceNo();
            String key = invoiceCode + invoiceNo;
            if (isEqualsTotalAmount) {
                currentBillFilledTotalAmount = totalAmount;
            }
            List<ArBillRelationExtensionDTO> relations = this.allocateBillDetailAmount(bill, currentBillFilledTotalAmount, inv, isEqualsTotalAmount);
            List<ArBillRelationExtensionDTO> invRelations = relationMap.get(key);
            if (null == invRelations) {
                invRelations = new ArrayList<ArBillRelationExtensionDTO>();
                relationMap.put(key, invRelations);
            }
            invRelations.addAll(relations);
        }
    }

    private List<ArBillRelationExtensionDTO> allocateBillDetailAmount(DynamicObject bill, BigDecimal currentBillFilledTotalAmount, FillInInvoiceDTO inv, boolean isEqualsTotalAmount) {
        DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal totalAmount = bill.getBigDecimal("totalamount");
        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
        boolean isFrom = CurrencyHelper.isFrom((Object)fromCurr);
        BigDecimal remainAmount = currentBillFilledTotalAmount;
        int size = items2.size();
        String taxAtionStyle = bill.getString("taxationstyle");
        BigDecimal deduction = bill.getBigDecimal("deduction");
        ArrayList<ArBillRelationExtensionDTO> relations = new ArrayList<ArBillRelationExtensionDTO>();
        for (int i = 0; i < items2.size(); ++i) {
            BigDecimal amount;
            BigDecimal tax;
            DynamicObject item = (DynamicObject)items2.get(i);
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            BigDecimal currentItemFilledTotalAmount = i == size - 1 ? remainAmount : taxAmount.divide(totalAmount, 40, RoundingMode.HALF_UP).multiply(currentBillFilledTotalAmount).setScale(2, RoundingMode.HALF_UP);
            remainAmount = remainAmount.subtract(currentItemFilledTotalAmount);
            ArBillRelationExtensionDTO relation = new ArBillRelationExtensionDTO();
            relation.setsBillId(Long.valueOf(bill.getLong("id")));
            relation.setsDetailId(Long.valueOf(item.getLong("id")));
            relation.setNum(item.getBigDecimal("num"));
            relation.setMergeLabel("1");
            relation.setFrom(Boolean.valueOf(isFrom));
            String taxRate = item.getString("taxrate");
            String policyConstant = item.getString("policycontants");
            BigDecimal taxRateValue = new BigDecimal(taxRate);
            if (!TaxedTypeEnum.normal.getValue().equals(taxAtionStyle)) {
                tax = ReducedHelper.calcTaxWithTax((Object)policyConstant, (BigDecimal)currentItemFilledTotalAmount);
                amount = currentItemFilledTotalAmount.subtract(tax);
            } else if (TaxedTypeEnum.deduction.getValue().equals(taxAtionStyle) || TaxedTypeEnum.alleTaxedTypeDeduction(taxAtionStyle)) {
                if (!"1".equals(item.get("rowtype"))) {
                    BigDecimal subtract = currentItemFilledTotalAmount.subtract(deduction);
                    tax = BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRateValue), 15, RoundingMode.HALF_UP).multiply(taxRateValue).multiply(subtract).setScale(2, RoundingMode.HALF_UP);
                } else {
                    BigDecimal zkAmount;
                    DynamicObject lastRow = (DynamicObject)items2.get(i - 1);
                    BigDecimal bzkTax = this.getBzkTax(relations, lastRow);
                    if (bzkTax.add(tax = currentItemFilledTotalAmount.subtract(zkAmount = currentItemFilledTotalAmount.divide(BigDecimal.ONE.add(taxRateValue), 2, RoundingMode.HALF_UP))).compareTo(BigDecimal.ZERO) < 0) {
                        tax = bzkTax.negate();
                    }
                }
                amount = currentItemFilledTotalAmount.subtract(tax);
            } else if (TaxedTypeEnum.all_e_reduced_tax.getValue().equals(taxAtionStyle) && "0.015".equals(taxRate)) {
                tax = ReduceOnePoint5Helper.rpaGetTaxAmountHS((BigDecimal)currentItemFilledTotalAmount, (BigDecimal)new BigDecimal(taxRate));
                amount = currentItemFilledTotalAmount.subtract(tax);
            } else {
                amount = currentItemFilledTotalAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(new BigDecimal(taxRate)), 8, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
                tax = currentItemFilledTotalAmount.subtract(amount);
            }
            relation.setAmount(amount);
            relation.setTax(tax);
            if (isEqualsTotalAmount) {
                relation.setAmount(item.getBigDecimal("amount"));
                relation.setTax(item.getBigDecimal("tax"));
            }
            relation.setInvoiceCode(inv.getInvoiceCode());
            relation.setInvoiceNo(inv.getInvoiceNo());
            relation.setsBillNo(bill.getString("billno"));
            relations.add(relation);
        }
        return relations;
    }

    private BigDecimal getBzkTax(ArrayList<ArBillRelationExtensionDTO> relations, DynamicObject lastRow) {
        long lastRowPk = lastRow.getLong("id");
        for (ArBillRelationExtensionDTO relation : relations) {
            Long sDetailId = relation.getsDetailId();
            if (lastRowPk != sDetailId) continue;
            return relation.getTax();
        }
        return BigDecimal.ZERO;
    }
}

