/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateUtils {
    public static final DateTimeFormatter FORMATTER_MONTH = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final DateTimeFormatter FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter FORMATTER_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static ZoneOffset defaultZoneOffset = OffsetDateTime.now().getOffset();

    public static long nowInSeconds() {
        return LocalDateTime.now().toEpochSecond(defaultZoneOffset);
    }

    public static String getFirstTimeStrByYear(String yearStr) {
        LocalDateTime firstDay = DateUtils.getFirstTimeByYear(yearStr);
        return firstDay.format(FORMATTER_TIME);
    }

    public static LocalDateTime getFirstTimeByYear(String yearStr) {
        int year = Integer.parseInt(yearStr);
        return LocalDate.of(year, 1, 1).atStartOfDay();
    }

    public static String getLastDateTimeByYear(String yearStr) {
        LocalDate date;
        int year = Integer.parseInt(yearStr);
        if (year <= (date = LocalDate.now()).getYear()) {
            date = LocalDate.of(year, 12, 31);
        }
        LocalDateTime lastDay = date.atTime(23, 59, 59);
        return lastDay.format(FORMATTER_TIME);
    }

    public static String formatDate(Date date, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(formatter);
    }

    public static String getLastMonth() {
        YearMonth lastMonth = YearMonth.now().minusMonths(1L);
        return lastMonth.format(FORMATTER_MONTH);
    }
}

